/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx.agd;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.HasDbAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.agd.Agd;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.agd.AgdAccessionNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.agd.AgdDescription;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DatabaseCrossReferenceImpl;

public class AgdImpl
extends DatabaseCrossReferenceImpl
implements Agd,
PersistentObject,
HasDbAccession {
    private DatabaseType databaseType = DatabaseType.AGD;
    private long id = 0L;
    private AgdAccessionNumber agdAccessionNumber = DefaultXRefFactory.getInstance().buildAgdAccessionNumber("");
    private AgdDescription agdDescription = DefaultXRefFactory.getInstance().buildAgdDescription("");

    public AgdImpl() {
    }

    @Override
    public String getDbAccession() {
        return this.getAgdAccessionNumber().getValue();
    }

    @Override
    public DatabaseType getDatabase() {
        return this.databaseType;
    }

    public AgdImpl(AgdImpl toCopy) {
        this();
        this.databaseType = toCopy.getDatabase();
        if (toCopy.hasAgdAccessionNumber()) {
            this.setAgdAccessionNumber(toCopy.getAgdAccessionNumber());
        }
        if (toCopy.hasAgdDescription()) {
            this.setAgdDescription(toCopy.getAgdDescription());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgdImpl)) {
            return false;
        }
        AgdImpl myClass = (AgdImpl)o;
        if (!this.agdAccessionNumber.equals(myClass.getAgdAccessionNumber())) {
            return false;
        }
        return this.agdDescription.equals(myClass.getAgdDescription());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = this.databaseType != null ? this.databaseType.hashCode() : 0;
        result = 29 * result + (this.agdAccessionNumber != null ? this.agdAccessionNumber.hashCode() : 0);
        result = 29 * result + (this.agdDescription != null ? this.agdDescription.hashCode() : 0);
        result = 29 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return this.agdAccessionNumber + ":" + this.agdDescription + ";";
    }

    @Override
    public AgdAccessionNumber getAgdAccessionNumber() {
        return this.agdAccessionNumber;
    }

    @Override
    public void setAgdAccessionNumber(AgdAccessionNumber agdAccessionNumber) {
        if (agdAccessionNumber == null) {
            throw new IllegalArgumentException();
        }
        this.agdAccessionNumber = agdAccessionNumber;
    }

    @Override
    public boolean hasAgdAccessionNumber() {
        return !this.agdAccessionNumber.getValue().equals("");
    }

    @Override
    public AgdDescription getAgdDescription() {
        return this.agdDescription;
    }

    @Override
    public void setAgdDescription(AgdDescription agdDescription) {
        if (agdDescription == null) {
            throw new IllegalArgumentException();
        }
        this.agdDescription = agdDescription;
    }

    @Override
    public boolean hasAgdDescription() {
        return !this.agdDescription.getValue().equals("");
    }
}

