/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.model.uniprot.dbx.aarhusghent.AarhusghentImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.agd.AgdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.allergome.AllergomeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.anu2dpage.Anu2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.arachnoserver.ArachnoServerImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.arrayexpress.ArrayExpressImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.bgee.BgeeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.bindingdb.BindingDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.biocyc.BioCycImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.brenda.BrendaImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.burulist.BuruListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.carbbank.CarbBankImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.cazy.CazyImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.cgd.CgdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.cleanex.CleanExImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.compluyeast2dpage.Compluyeast2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.conoserver.ConoServerImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.cornea2dpage.Cornea2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ctd.CtdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.cygd.CygdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.dictybase.DictyBaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.dip.DIPImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.disprot.DisProtImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.dmdm.DMDMImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.dosaccobs2dpage.DosacCobs2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.drugbank.DrugBankImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.echobase.EchoBASEImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.eco2dbase.Eco2dbaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ecogene.EcoGeneImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.eggnog.EggNOGImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.embl.EmblImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensembl.EnsemblImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensemblbacteria.EnsemblBacteriaImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensemblfungi.EnsemblFungiImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensemblmetazoa.EnsemblMetazoaImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensemblplants.EnsemblPlantsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ensemblprotists.EnsemblProtistsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.euhcvdb.EuHCVdbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.eupathdb.EuPathDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.flybase.FlyBaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.gcrdb.GcrdbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.gene3d.Gene3DImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genecards.GeneCardsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genedbspombe.GeneDBSpombeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genefarm.GeneFarmImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.geneid.GeneIdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genetree.GeneTreeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genevestigator.GenevestigatorImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genew.GenewImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genolist.GenoListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.genomereviews.GenomeReviewsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.germonline.GermOnlineImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.gk.GkImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.glycosuitedb.GlycoSuiteDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.go.GoImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.gramene.GrameneImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hamap.HamapImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hgnc.HgncImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hinvdb.HinvdbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hiv.HivImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hogenom.HogenomImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hovergen.HovergenImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hpa.HPAImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hsc2dpage.Hsc2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.hssp.HsspImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.inparanoid.InParanoidImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.intact.IntActImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.interpro.InterProImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ipi.IpiImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.kegg.KeggImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ko.KOImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.legiolist.LegioListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.leproma.LepromaImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.linkhub.LinkHubImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.listilist.ListiListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.maize2dpage.Maize2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.maizedb.MaizeDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.maizegdb.MaizeGDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mendel.MendelImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.merops.MeropsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mgd.MgdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mgi.MgiImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mim.MimImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mint.MintImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.mypulist.MypuListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.nextbio.NextBioImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.nextprot.neXtProtImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.nmpdr.NmpdrImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ogp.OgpImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.oma.OmaImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.orphanet.OrphanetImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.orthodb.OrthoDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.panther.PantherImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pathwayinteractiondb.PathwayInteractionDbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.patric.PATRICImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pdb.PdbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pdbsum.PDBsumImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.peptideatlas.PeptideAtlasImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.peroxibase.PeroxiBaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pfam.PfamImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pharmgkb.PharmGKBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.phci2dpage.Phci2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.phosphosite.PhosphoSiteImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.phossite.PhosSiteImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.photolist.PhotoListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.phylomedb.PhylomeDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pir.PirImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pirsf.PirsfImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pmapcutdb.PMAPCutDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pmma2dpage.Pmma2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pptasedb.PptaseDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pride.PrideImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.prints.PrintsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.prodom.ProDomImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.promex.ProMEXImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.prosite.PrositeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.protclustdb.ProtClustDBImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.proteinmodelportal.ProteinModelPortalImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.pseudocap.PseudoCAPImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ratheart2dpage.RatHeart2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.reactome.ReactomeImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.rebase.RebaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.refseq.RefSeqImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.reproduction2dpage.Reproduction2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.rgd.RgdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.rzpdprotexp.RzpdProtExpImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.sagalist.SagaListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.sgd.SgdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.siena2dpage.Siena2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.smart.SmartImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.smr.SmrImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.stringxref.StringXrefImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.stygene.StyGeneImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.subtilist.SubtiListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.supfam.SUPFAMImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.swiss2dpage.Swiss2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.tair.TairImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.tcdb.TcdbImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.tigr.TigrImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.tigrfams.TigrfamsImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.transfac.TransfacImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.tuberculist.TubercuListImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.twodbaseecoli.TwoDBaseEcoliImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ucd2dpage.Ucd2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.ucsc.UcscImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.unigene.UniGeneImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.unipep.UniPepImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.vectorbase.VectorBaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.world2dpage.World2dpageImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.wormbase.WormBaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.wormpep.WormPepImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.xenbase.XenbaseImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.yepd.YepdImpl;
import uk.ac.ebi.kraken.model.uniprot.dbx.zfin.ZfinImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.container.CollectionVisitor;
import uk.ac.ebi.kraken.util.container.MapValueCollection;

public class DatabaseCrossReferences
implements Serializable {
    private EnumMap<DatabaseType, List<? extends DatabaseCrossReference>> drMap = new EnumMap(DatabaseType.class);

    public Collection<DatabaseCrossReference> getDatabaseCrossReferences() {
        return new MapValueCollection(new CollectionVisitor<DatabaseCrossReference>(){

            @Override
            public void accept(DatabaseCrossReference dbx) {
                DatabaseCrossReferences.this.addDatabaseCrossReference(dbx);
            }
        }, this.drMap.values());
    }

    public <T extends DatabaseCrossReference> void setDatabaseCrossReferences(DatabaseType type, List<T> dbxs) {
        this.drMap.put(type, dbxs);
    }

    public <T extends DatabaseCrossReference> List<T> getDatabaseCrossReferences(DatabaseType type) {
        List<? extends DatabaseCrossReference> retVal = this.drMap.get((Object)type);
        if (retVal == null) {
            retVal = new NoNullElementsList<DatabaseCrossReference>(new ArrayList());
            this.drMap.put(type, retVal);
        }
        return retVal;
    }

    public void setDatabaseCrossReferences(List<DatabaseCrossReference> dbxs) {
        for (DatabaseCrossReference dbx : dbxs) {
            this.addDatabaseCrossReference(dbx);
        }
    }

    private <T extends DatabaseCrossReference> void addDatabaseCrossReference(T o) {
        if (o == null) {
            throw new IllegalArgumentException("comment is null");
        }
        List<T> list = this.getDatabaseCrossReferences(o.getDatabase());
        if (list == null) {
            ArrayList<T> newList = new ArrayList<T>();
            newList.add(o);
            this.setDatabaseCrossReferences(o.getDatabase(), newList);
        } else {
            list.add(o);
        }
    }

    private List<EmblImpl> getEmbl() {
        return this.getDatabaseCrossReferences(DatabaseType.EMBL);
    }

    private void setEmbl(List<EmblImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.EMBL, xrefs);
    }

    private List<PirImpl> getPir() {
        return this.getDatabaseCrossReferences(DatabaseType.PIR);
    }

    private void setPir(List<PirImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PIR, xrefs);
    }

    private List<RefSeqImpl> getRefSeq() {
        return this.getDatabaseCrossReferences(DatabaseType.REFSEQ);
    }

    private void setRefSeq(List<RefSeqImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.REFSEQ, xrefs);
    }

    private List<UniGeneImpl> getUniGene() {
        return this.getDatabaseCrossReferences(DatabaseType.UNIGENE);
    }

    private void setUniGene(List<UniGeneImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.UNIGENE, xrefs);
    }

    private List<PdbImpl> getPdb() {
        return this.getDatabaseCrossReferences(DatabaseType.PDB);
    }

    private void setPdb(List<PdbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PDB, xrefs);
    }

    private List<HsspImpl> getHssp() {
        return this.getDatabaseCrossReferences(DatabaseType.HSSP);
    }

    private void setHssp(List<HsspImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HSSP, xrefs);
    }

    private List<SmrImpl> getSmr() {
        return this.getDatabaseCrossReferences(DatabaseType.SMR);
    }

    private void setSmr(List<SmrImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SMR, xrefs);
    }

    private List<DisProtImpl> getDisProt() {
        return this.getDatabaseCrossReferences(DatabaseType.DISPROT);
    }

    private void setDisProt(List<DisProtImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DISPROT, xrefs);
    }

    private List<DIPImpl> getDIP() {
        return this.getDatabaseCrossReferences(DatabaseType.DIP);
    }

    private void setDIP(List<DIPImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DIP, xrefs);
    }

    private List<IntActImpl> getIntAct() {
        return this.getDatabaseCrossReferences(DatabaseType.INTACT);
    }

    private void setIntAct(List<IntActImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.INTACT, xrefs);
    }

    private List<MeropsImpl> getMerops() {
        return this.getDatabaseCrossReferences(DatabaseType.MEROPS);
    }

    private void setMerops(List<MeropsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MEROPS, xrefs);
    }

    private List<PeroxiBaseImpl> getPeroxiBase() {
        return this.getDatabaseCrossReferences(DatabaseType.PEROXIBASE);
    }

    private void setPeroxiBase(List<PeroxiBaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PEROXIBASE, xrefs);
    }

    private List<PptaseDBImpl> getPptaseDB() {
        return this.getDatabaseCrossReferences(DatabaseType.PPTASEDB);
    }

    private void setPptaseDB(List<PptaseDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PPTASEDB, xrefs);
    }

    private List<RebaseImpl> getRebase() {
        return this.getDatabaseCrossReferences(DatabaseType.REBASE);
    }

    private void setRebase(List<RebaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.REBASE, xrefs);
    }

    private List<TransfacImpl> getTransfac() {
        return this.getDatabaseCrossReferences(DatabaseType.TRANSFAC);
    }

    private void setTransfac(List<TransfacImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TRANSFAC, xrefs);
    }

    private List<GlycoSuiteDBImpl> getGlycoSuiteDB() {
        return this.getDatabaseCrossReferences(DatabaseType.GLYCOSUITEDB);
    }

    private void setGlycoSuiteDB(List<GlycoSuiteDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GLYCOSUITEDB, xrefs);
    }

    private List<PhosSiteImpl> getPhosSite() {
        return this.getDatabaseCrossReferences(DatabaseType.PHOSSITE);
    }

    private void setPhosSite(List<PhosSiteImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHOSSITE, xrefs);
    }

    private List<Swiss2dpageImpl> getSwiss2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.SWISS2DPAGE);
    }

    private void setSwiss2dpage(List<Swiss2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SWISS2DPAGE, xrefs);
    }

    private List<AarhusghentImpl> getAarhusghent() {
        return this.getDatabaseCrossReferences(DatabaseType.AARHUSGHENT);
    }

    private void setAarhusghent(List<AarhusghentImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.AARHUSGHENT, xrefs);
    }

    private List<Anu2dpageImpl> getAnu2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.ANU2DPAGE);
    }

    private void setAnu2dpage(List<Anu2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ANU2DPAGE, xrefs);
    }

    private List<Compluyeast2dpageImpl> getCompluyeast2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.COMPLUYEAST2DPAGE);
    }

    private void setCompluyeast2dpage(List<Compluyeast2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.COMPLUYEAST2DPAGE, xrefs);
    }

    private List<Cornea2dpageImpl> getCornea2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.CORNEA2DPAGE);
    }

    private void setCornea2dpage(List<Cornea2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CORNEA2DPAGE, xrefs);
    }

    private List<DosacCobs2dpageImpl> getDosacCobs2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.DOSACCOBS2DPAGE);
    }

    private void setDosacCobs2dpage(List<DosacCobs2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DOSACCOBS2DPAGE, xrefs);
    }

    private List<Eco2dbaseImpl> getEco2dbase() {
        return this.getDatabaseCrossReferences(DatabaseType.ECO2DBASE);
    }

    private void setEco2dbase(List<Eco2dbaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ECO2DBASE, xrefs);
    }

    private List<Hsc2dpageImpl> getHsc2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.HSC2DPAGE);
    }

    private void setHsc2dpage(List<Hsc2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HSC2DPAGE, xrefs);
    }

    private List<OgpImpl> getOgp() {
        return this.getDatabaseCrossReferences(DatabaseType.OGP);
    }

    private void setOgp(List<OgpImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.OGP, xrefs);
    }

    private List<Phci2dpageImpl> getPhci2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.PHCI2DPAGE);
    }

    private void setPhci2dpage(List<Phci2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHCI2DPAGE, xrefs);
    }

    private List<Pmma2dpageImpl> getPmma2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.PMMA2DPAGE);
    }

    private void setPmma2dpage(List<Pmma2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PMMA2DPAGE, xrefs);
    }

    private List<RatHeart2dpageImpl> getRatHeart2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.RATHEART2DPAGE);
    }

    private void setRatHeart2dpage(List<RatHeart2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.RATHEART2DPAGE, xrefs);
    }

    private List<Reproduction2dpageImpl> getReproduction2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.REPRODUCTION2DPAGE);
    }

    private void setReproduction2dpage(List<Reproduction2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.REPRODUCTION2DPAGE, xrefs);
    }

    private List<Siena2dpageImpl> getSiena2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.SIENA2DPAGE);
    }

    private void setSiena2dpage(List<Siena2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SIENA2DPAGE, xrefs);
    }

    private List<PeptideAtlasImpl> getPeptideAtlas() {
        return this.getDatabaseCrossReferences(DatabaseType.PEPTIDEATLAS);
    }

    private void setPeptideAtlas(List<PeptideAtlasImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PEPTIDEATLAS, xrefs);
    }

    private List<EnsemblImpl> getEnsembl() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBL);
    }

    private void setEnsembl(List<EnsemblImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBL, xrefs);
    }

    private List<GeneIdImpl> getGeneId() {
        return this.getDatabaseCrossReferences(DatabaseType.GENEID);
    }

    private void setGeneId(List<GeneIdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENEID, xrefs);
    }

    private List<GenomeReviewsImpl> getGenomeReviews() {
        return this.getDatabaseCrossReferences(DatabaseType.GENOMEREVIEWS);
    }

    private void setGenomeReviews(List<GenomeReviewsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENOMEREVIEWS, xrefs);
    }

    private List<KeggImpl> getKegg() {
        return this.getDatabaseCrossReferences(DatabaseType.KEGG);
    }

    private void setKegg(List<KeggImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.KEGG, xrefs);
    }

    private List<TigrImpl> getTigr() {
        return this.getDatabaseCrossReferences(DatabaseType.TIGR);
    }

    private void setTigr(List<TigrImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TIGR, xrefs);
    }

    private List<AgdImpl> getAgd() {
        return this.getDatabaseCrossReferences(DatabaseType.AGD);
    }

    private void setAgd(List<AgdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.AGD, xrefs);
    }

    private List<BuruListImpl> getBuruList() {
        return this.getDatabaseCrossReferences(DatabaseType.BURULIST);
    }

    private void setBuruList(List<BuruListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.BURULIST, xrefs);
    }

    private List<CygdImpl> getCygd() {
        return this.getDatabaseCrossReferences(DatabaseType.CYGD);
    }

    private void setCygd(List<CygdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CYGD, xrefs);
    }

    private List<DictyBaseImpl> getDictyBase() {
        return this.getDatabaseCrossReferences(DatabaseType.DICTYBASE);
    }

    private void setDictyBase(List<DictyBaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DICTYBASE, xrefs);
    }

    private List<EchoBASEImpl> getEchoBASE() {
        return this.getDatabaseCrossReferences(DatabaseType.ECHOBASE);
    }

    private void setEchoBASE(List<EchoBASEImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ECHOBASE, xrefs);
    }

    private List<EcoGeneImpl> getEcoGene() {
        return this.getDatabaseCrossReferences(DatabaseType.ECOGENE);
    }

    private void setEcoGene(List<EcoGeneImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ECOGENE, xrefs);
    }

    private List<EuHCVdbImpl> getEuHCVdb() {
        return this.getDatabaseCrossReferences(DatabaseType.EUHCVDB);
    }

    private void setEuHCVdb(List<EuHCVdbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.EUHCVDB, xrefs);
    }

    private List<FlyBaseImpl> getFlyBase() {
        return this.getDatabaseCrossReferences(DatabaseType.FLYBASE);
    }

    private void setFlyBase(List<FlyBaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.FLYBASE, xrefs);
    }

    private List<GeneDBSpombeImpl> getGeneDBSpombe() {
        return this.getDatabaseCrossReferences(DatabaseType.GENEDBSPOMBE);
    }

    private void setGeneDBSpombe(List<GeneDBSpombeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENEDBSPOMBE, xrefs);
    }

    private List<GeneFarmImpl> getGeneFarm() {
        return this.getDatabaseCrossReferences(DatabaseType.GENEFARM);
    }

    private void setGeneFarm(List<GeneFarmImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENEFARM, xrefs);
    }

    private List<GrameneImpl> getGramene() {
        return this.getDatabaseCrossReferences(DatabaseType.GRAMENE);
    }

    private void setGramene(List<GrameneImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GRAMENE, xrefs);
    }

    private List<HinvdbImpl> getHinvdb() {
        return this.getDatabaseCrossReferences(DatabaseType.HINVDB);
    }

    private void setHinvdb(List<HinvdbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HINVDB, xrefs);
    }

    private List<HgncImpl> getHgnc() {
        return this.getDatabaseCrossReferences(DatabaseType.HGNC);
    }

    private void setHgnc(List<HgncImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HGNC, xrefs);
    }

    private List<HivImpl> getHiv() {
        return this.getDatabaseCrossReferences(DatabaseType.HIV);
    }

    private void setHiv(List<HivImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HIV, xrefs);
    }

    private List<HPAImpl> getHPA() {
        return this.getDatabaseCrossReferences(DatabaseType.HPA);
    }

    private void setHPA(List<HPAImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HPA, xrefs);
    }

    private List<LegioListImpl> getLegioList() {
        return this.getDatabaseCrossReferences(DatabaseType.LEGIOLIST);
    }

    private void setLegioList(List<LegioListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.LEGIOLIST, xrefs);
    }

    private List<LepromaImpl> getLeproma() {
        return this.getDatabaseCrossReferences(DatabaseType.LEPROMA);
    }

    private void setLeproma(List<LepromaImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.LEPROMA, xrefs);
    }

    private List<ListiListImpl> getListiList() {
        return this.getDatabaseCrossReferences(DatabaseType.LISTILIST);
    }

    private void setListiList(List<ListiListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.LISTILIST, xrefs);
    }

    private List<MaizeGDBImpl> getMaizeGDB() {
        return this.getDatabaseCrossReferences(DatabaseType.MAIZEGDB);
    }

    private void setMaizeGDB(List<MaizeGDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MAIZEGDB, xrefs);
    }

    private List<MimImpl> getMim() {
        return this.getDatabaseCrossReferences(DatabaseType.MIM);
    }

    private void setMim(List<MimImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MIM, xrefs);
    }

    private List<MgiImpl> getMgi() {
        return this.getDatabaseCrossReferences(DatabaseType.MGI);
    }

    private void setMgi(List<MgiImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MGI, xrefs);
    }

    private List<MypuListImpl> getMypuList() {
        return this.getDatabaseCrossReferences(DatabaseType.MYPULIST);
    }

    private void setMypuList(List<MypuListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MYPULIST, xrefs);
    }

    private List<OrphanetImpl> getOrphanet() {
        return this.getDatabaseCrossReferences(DatabaseType.ORPHANET);
    }

    private void setOrphanet(List<OrphanetImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ORPHANET, xrefs);
    }

    private List<PharmGKBImpl> getPharmGKB() {
        return this.getDatabaseCrossReferences(DatabaseType.PHARMGKB);
    }

    private void setPharmGKB(List<PharmGKBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHARMGKB, xrefs);
    }

    private List<PhotoListImpl> getPhotoList() {
        return this.getDatabaseCrossReferences(DatabaseType.PHOTOLIST);
    }

    private void setPhotoList(List<PhotoListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHOTOLIST, xrefs);
    }

    private List<PseudoCAPImpl> getPseudoCAP() {
        return this.getDatabaseCrossReferences(DatabaseType.PSEUDOCAP);
    }

    private void setPseudoCAP(List<PseudoCAPImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PSEUDOCAP, xrefs);
    }

    private List<RgdImpl> getRgd() {
        return this.getDatabaseCrossReferences(DatabaseType.RGD);
    }

    private void setRgd(List<RgdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.RGD, xrefs);
    }

    private List<SagaListImpl> getSagaList() {
        return this.getDatabaseCrossReferences(DatabaseType.SAGALIST);
    }

    private void setSagaList(List<SagaListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SAGALIST, xrefs);
    }

    private List<SgdImpl> getSgd() {
        return this.getDatabaseCrossReferences(DatabaseType.SGD);
    }

    private void setSgd(List<SgdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SGD, xrefs);
    }

    private List<StyGeneImpl> getStyGene() {
        return this.getDatabaseCrossReferences(DatabaseType.STYGENE);
    }

    private void setStyGene(List<StyGeneImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.STYGENE, xrefs);
    }

    private List<SubtiListImpl> getSubtiList() {
        return this.getDatabaseCrossReferences(DatabaseType.SUBTILIST);
    }

    private void setSubtiList(List<SubtiListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SUBTILIST, xrefs);
    }

    private List<TairImpl> getTair() {
        return this.getDatabaseCrossReferences(DatabaseType.TAIR);
    }

    private void setTair(List<TairImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TAIR, xrefs);
    }

    private List<TubercuListImpl> getTubercuList() {
        return this.getDatabaseCrossReferences(DatabaseType.TUBERCULIST);
    }

    private void setTubercuList(List<TubercuListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TUBERCULIST, xrefs);
    }

    private List<WormBaseImpl> getWormBase() {
        return this.getDatabaseCrossReferences(DatabaseType.WORMBASE);
    }

    private void setWormBase(List<WormBaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.WORMBASE, xrefs);
    }

    private List<WormPepImpl> getWormPep() {
        return this.getDatabaseCrossReferences(DatabaseType.WORMPEP);
    }

    private void setWormPep(List<WormPepImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.WORMPEP, xrefs);
    }

    private List<ZfinImpl> getZfin() {
        return this.getDatabaseCrossReferences(DatabaseType.ZFIN);
    }

    private void setZfin(List<ZfinImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ZFIN, xrefs);
    }

    private List<BioCycImpl> getBioCyc() {
        return this.getDatabaseCrossReferences(DatabaseType.BIOCYC);
    }

    private void setBioCyc(List<BioCycImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.BIOCYC, xrefs);
    }

    private List<ReactomeImpl> getReactome() {
        return this.getDatabaseCrossReferences(DatabaseType.REACTOME);
    }

    private void setReactome(List<ReactomeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.REACTOME, xrefs);
    }

    private List<DrugBankImpl> getDrugBank() {
        return this.getDatabaseCrossReferences(DatabaseType.DRUGBANK);
    }

    private void setDrugBank(List<DrugBankImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DRUGBANK, xrefs);
    }

    private List<LinkHubImpl> getLinkHub() {
        return this.getDatabaseCrossReferences(DatabaseType.LINKHUB);
    }

    private void setLinkHub(List<LinkHubImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.LINKHUB, xrefs);
    }

    private List<ArrayExpressImpl> getArrayExpress() {
        return this.getDatabaseCrossReferences(DatabaseType.ARRAYEXPRESS);
    }

    private void setArrayExpress(List<ArrayExpressImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ARRAYEXPRESS, xrefs);
    }

    private List<CleanExImpl> getCleanEx() {
        return this.getDatabaseCrossReferences(DatabaseType.CLEANEX);
    }

    private void setCleanEx(List<CleanExImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CLEANEX, xrefs);
    }

    private List<GermOnlineImpl> getGermOnline() {
        return this.getDatabaseCrossReferences(DatabaseType.GERMONLINE);
    }

    private void setGermOnline(List<GermOnlineImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GERMONLINE, xrefs);
    }

    private List<GoImpl> getGo() {
        return this.getDatabaseCrossReferences(DatabaseType.GO);
    }

    private void setGo(List<GoImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GO, xrefs);
    }

    private List<HamapImpl> getHamap() {
        return this.getDatabaseCrossReferences(DatabaseType.HAMAP);
    }

    private void setHamap(List<HamapImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HAMAP, xrefs);
    }

    private List<InterProImpl> getInterPro() {
        return this.getDatabaseCrossReferences(DatabaseType.INTERPRO);
    }

    private void setInterPro(List<InterProImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.INTERPRO, xrefs);
    }

    private List<Gene3DImpl> getGene3D() {
        return this.getDatabaseCrossReferences(DatabaseType.GENE3D);
    }

    private void setGene3D(List<Gene3DImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENE3D, xrefs);
    }

    private List<PantherImpl> getPanther() {
        return this.getDatabaseCrossReferences(DatabaseType.PANTHER);
    }

    private void setPanther(List<PantherImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PANTHER, xrefs);
    }

    private List<PfamImpl> getPfam() {
        return this.getDatabaseCrossReferences(DatabaseType.PFAM);
    }

    private void setPfam(List<PfamImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PFAM, xrefs);
    }

    private List<PirsfImpl> getPirsf() {
        return this.getDatabaseCrossReferences(DatabaseType.PIRSF);
    }

    private void setPirsf(List<PirsfImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PIRSF, xrefs);
    }

    private List<PrintsImpl> getPrints() {
        return this.getDatabaseCrossReferences(DatabaseType.PRINTS);
    }

    private void setPrints(List<PrintsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PRINTS, xrefs);
    }

    private List<ProDomImpl> getProDom() {
        return this.getDatabaseCrossReferences(DatabaseType.PRODOM);
    }

    private void setProDom(List<ProDomImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PRODOM, xrefs);
    }

    private List<SmartImpl> getSmart() {
        return this.getDatabaseCrossReferences(DatabaseType.SMART);
    }

    private void setSmart(List<SmartImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SMART, xrefs);
    }

    private List<TigrfamsImpl> getTigrfams() {
        return this.getDatabaseCrossReferences(DatabaseType.TIGRFAMS);
    }

    private void setTigrfams(List<TigrfamsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TIGRFAMS, xrefs);
    }

    private List<PrositeImpl> getProsite() {
        return this.getDatabaseCrossReferences(DatabaseType.PROSITE);
    }

    private void setProsite(List<PrositeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PROSITE, xrefs);
    }

    private List<Maize2dpageImpl> getMaize2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.MAIZE2DPAGE);
    }

    private void setMaize2dpage(List<Maize2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MAIZE2DPAGE, xrefs);
    }

    private List<RzpdProtExpImpl> getRzpdProtExp() {
        return this.getDatabaseCrossReferences(DatabaseType.RZPDPROTEXP);
    }

    private void setRzpdProtExp(List<RzpdProtExpImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.RZPDPROTEXP, xrefs);
    }

    private List<UniPepImpl> getUniPep() {
        return this.getDatabaseCrossReferences(DatabaseType.UNIPEP);
    }

    private void setUniPep(List<UniPepImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.UNIPEP, xrefs);
    }

    private List<PDBsumImpl> getPDBsum() {
        return this.getDatabaseCrossReferences(DatabaseType.PDBSUM);
    }

    private void setPDBsum(List<PDBsumImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PDBSUM, xrefs);
    }

    private List<GcrdbImpl> getGcrdb() {
        return this.getDatabaseCrossReferences(DatabaseType.GCRDB);
    }

    private void setGcrdb(List<GcrdbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GCRDB, xrefs);
    }

    private List<CarbBankImpl> getCarbBank() {
        return this.getDatabaseCrossReferences(DatabaseType.CARBBANK);
    }

    private void setCarbBank(List<CarbBankImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CARBBANK, xrefs);
    }

    private List<GenewImpl> getGenew() {
        return this.getDatabaseCrossReferences(DatabaseType.GENEW);
    }

    private void setGenew(List<GenewImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENEW, xrefs);
    }

    private List<GkImpl> getGk() {
        return this.getDatabaseCrossReferences(DatabaseType.GK);
    }

    private void setGk(List<GkImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GK, xrefs);
    }

    private List<MaizeDBImpl> getMaizeDB() {
        return this.getDatabaseCrossReferences(DatabaseType.MAIZEDB);
    }

    private void setMaizeDB(List<MaizeDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MAIZEDB, xrefs);
    }

    private List<MendelImpl> getMendel() {
        return this.getDatabaseCrossReferences(DatabaseType.MENDEL);
    }

    private void setMendel(List<MendelImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MENDEL, xrefs);
    }

    private List<MgdImpl> getMgd() {
        return this.getDatabaseCrossReferences(DatabaseType.MGD);
    }

    private void setMgd(List<MgdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MGD, xrefs);
    }

    private List<YepdImpl> getYepd() {
        return this.getDatabaseCrossReferences(DatabaseType.YEPD);
    }

    private void setYepd(List<YepdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.YEPD, xrefs);
    }

    private List<VectorBaseImpl> getVectorBase() {
        return this.getDatabaseCrossReferences(DatabaseType.VECTORBASE);
    }

    private void setVectorBase(List<VectorBaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.VECTORBASE, xrefs);
    }

    private List<World2dpageImpl> getWorld2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.WORLD2DPAGE);
    }

    private void setWorld2dpage(List<World2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.WORLD2DPAGE, xrefs);
    }

    private List<PhosphoSiteImpl> getPhosphoSite() {
        return this.getDatabaseCrossReferences(DatabaseType.PHOSPHOSITE);
    }

    private void setPhosphoSite(List<PhosphoSiteImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHOSPHOSITE, xrefs);
    }

    private List<TwoDBaseEcoliImpl> getTwoDBaseEcoli() {
        return this.getDatabaseCrossReferences(DatabaseType.TWODBASEECOLI);
    }

    private void setTwoDBaseEcoli(List<TwoDBaseEcoliImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TWODBASEECOLI, xrefs);
    }

    private List<ProMEXImpl> getProMEX() {
        return this.getDatabaseCrossReferences(DatabaseType.PROMEX);
    }

    private void setProMEX(List<ProMEXImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PROMEX, xrefs);
    }

    private List<NmpdrImpl> getNmpdr() {
        return this.getDatabaseCrossReferences(DatabaseType.NMPDR);
    }

    private void setNmpdr(List<NmpdrImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.NMPDR, xrefs);
    }

    private List<CgdImpl> getCgd() {
        return this.getDatabaseCrossReferences(DatabaseType.CGD);
    }

    private void setCgd(List<CgdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CGD, xrefs);
    }

    private List<HogenomImpl> getHogenom() {
        return this.getDatabaseCrossReferences(DatabaseType.HOGENOM);
    }

    private void setHogenom(List<HogenomImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HOGENOM, xrefs);
    }

    private List<HovergenImpl> getHovergen() {
        return this.getDatabaseCrossReferences(DatabaseType.HOVERGEN);
    }

    private void setHovergen(List<HovergenImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.HOVERGEN, xrefs);
    }

    private List<BindingDBImpl> getBindingDB() {
        return this.getDatabaseCrossReferences(DatabaseType.BINDINGDB);
    }

    private void setBindingDB(List<BindingDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.BINDINGDB, xrefs);
    }

    private List<NextBioImpl> getNextBio() {
        return this.getDatabaseCrossReferences(DatabaseType.NEXTBIO);
    }

    private void setNextBio(List<NextBioImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.NEXTBIO, xrefs);
    }

    private List<XenbaseImpl> getXenbase() {
        return this.getDatabaseCrossReferences(DatabaseType.XENBASE);
    }

    private void setXenbase(List<XenbaseImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.XENBASE, xrefs);
    }

    private List<GeneCardsImpl> getGeneCards() {
        return this.getDatabaseCrossReferences(DatabaseType.GENECARDS);
    }

    private void setGeneCards(List<GeneCardsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENECARDS, xrefs);
    }

    private List<PrideImpl> getPride() {
        return this.getDatabaseCrossReferences(DatabaseType.PRIDE);
    }

    private void setPride(List<PrideImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PRIDE, xrefs);
    }

    private List<BrendaImpl> getBrenda() {
        return this.getDatabaseCrossReferences(DatabaseType.BRENDA);
    }

    private void setBrenda(List<BrendaImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.BRENDA, xrefs);
    }

    private List<BgeeImpl> getBgee() {
        return this.getDatabaseCrossReferences(DatabaseType.BGEE);
    }

    private void setBgee(List<BgeeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.BGEE, xrefs);
    }

    private List<IpiImpl> getIpi() {
        return this.getDatabaseCrossReferences(DatabaseType.IPI);
    }

    private void setIpi(List<IpiImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.IPI, xrefs);
    }

    private List<TcdbImpl> getTcdb() {
        return this.getDatabaseCrossReferences(DatabaseType.TCDB);
    }

    private void setTcdb(List<TcdbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.TCDB, xrefs);
    }

    private List<PathwayInteractionDbImpl> getPathwayInteractionDb() {
        return this.getDatabaseCrossReferences(DatabaseType.PATHWAYINTERACTIONDB);
    }

    private void setPathwayInteractionDb(List<PathwayInteractionDbImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PATHWAYINTERACTIONDB, xrefs);
    }

    private List<CazyImpl> getCazy() {
        return this.getDatabaseCrossReferences(DatabaseType.CAZY);
    }

    private void setCazy(List<CazyImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CAZY, xrefs);
    }

    private List<OmaImpl> getOma() {
        return this.getDatabaseCrossReferences(DatabaseType.OMA);
    }

    private void setOma(List<OmaImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.OMA, xrefs);
    }

    private List<PMAPCutDBImpl> getPMAPCutDB() {
        return this.getDatabaseCrossReferences(DatabaseType.PMAPCUTDB);
    }

    private void setPMAPCutDB(List<PMAPCutDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PMAPCUTDB, xrefs);
    }

    private List<UcscImpl> getUcsc() {
        return this.getDatabaseCrossReferences(DatabaseType.UCSC);
    }

    private void setUcsc(List<UcscImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.UCSC, xrefs);
    }

    private List<CtdImpl> getCtd() {
        return this.getDatabaseCrossReferences(DatabaseType.CTD);
    }

    private void setCtd(List<CtdImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CTD, xrefs);
    }

    private List<StringXrefImpl> getStringXref() {
        return this.getDatabaseCrossReferences(DatabaseType.STRINGXREF);
    }

    private void setStringXref(List<StringXrefImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.STRINGXREF, xrefs);
    }

    private List<GenevestigatorImpl> getGenevestigator() {
        return this.getDatabaseCrossReferences(DatabaseType.GENEVESTIGATOR);
    }

    private void setGenevestigator(List<GenevestigatorImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENEVESTIGATOR, xrefs);
    }

    private List<PhylomeDBImpl> getPhylomeDB() {
        return this.getDatabaseCrossReferences(DatabaseType.PHYLOMEDB);
    }

    private void setPhylomeDB(List<PhylomeDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PHYLOMEDB, xrefs);
    }

    private List<OrthoDBImpl> getOrthoDB() {
        return this.getDatabaseCrossReferences(DatabaseType.ORTHODB);
    }

    private void setOrthoDB(List<OrthoDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ORTHODB, xrefs);
    }

    private List<EggNOGImpl> getEggNOG() {
        return this.getDatabaseCrossReferences(DatabaseType.EGGNOG);
    }

    private void setEggNOG(List<EggNOGImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.EGGNOG, xrefs);
    }

    private List<InParanoidImpl> getInParanoid() {
        return this.getDatabaseCrossReferences(DatabaseType.INPARANOID);
    }

    private void setInParanoid(List<InParanoidImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.INPARANOID, xrefs);
    }

    private List<ArachnoServerImpl> getArachnoServer() {
        return this.getDatabaseCrossReferences(DatabaseType.ARACHNOSERVER);
    }

    private void setArachnoServer(List<ArachnoServerImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ARACHNOSERVER, xrefs);
    }

    private List<EuPathDBImpl> getEuPathDB() {
        return this.getDatabaseCrossReferences(DatabaseType.EUPATHDB);
    }

    private void setEuPathDB(List<EuPathDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.EUPATHDB, xrefs);
    }

    private List<ProtClustDBImpl> getProtClustDB() {
        return this.getDatabaseCrossReferences(DatabaseType.PROTCLUSTDB);
    }

    private void setProtClustDB(List<ProtClustDBImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PROTCLUSTDB, xrefs);
    }

    private List<SUPFAMImpl> getSUPFAM() {
        return this.getDatabaseCrossReferences(DatabaseType.SUPFAM);
    }

    private void setSUPFAM(List<SUPFAMImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.SUPFAM, xrefs);
    }

    private List<GenoListImpl> getGenoList() {
        return this.getDatabaseCrossReferences(DatabaseType.GENOLIST);
    }

    private void setGenoList(List<GenoListImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENOLIST, xrefs);
    }

    private List<MintImpl> getMint() {
        return this.getDatabaseCrossReferences(DatabaseType.MINT);
    }

    private void setMint(List<MintImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.MINT, xrefs);
    }

    private List<ConoServerImpl> getConoServer() {
        return this.getDatabaseCrossReferences(DatabaseType.CONOSERVER);
    }

    private void setConoServer(List<ConoServerImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.CONOSERVER, xrefs);
    }

    private List<Ucd2dpageImpl> getUcd2dpage() {
        return this.getDatabaseCrossReferences(DatabaseType.UCD2DPAGE);
    }

    private void setUcd2dpage(List<Ucd2dpageImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.UCD2DPAGE, xrefs);
    }

    private List<EnsemblBacteriaImpl> getEnsemblBacteria() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBLBACTERIA);
    }

    private void setEnsemblBacteria(List<EnsemblBacteriaImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBLBACTERIA, xrefs);
    }

    private List<EnsemblFungiImpl> getEnsemblFungi() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBLFUNGI);
    }

    private void setEnsemblFungi(List<EnsemblFungiImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBLFUNGI, xrefs);
    }

    private List<EnsemblMetazoaImpl> getEnsemblMetazoa() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBLMETAZOA);
    }

    private void setEnsemblMetazoa(List<EnsemblMetazoaImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBLMETAZOA, xrefs);
    }

    private List<EnsemblPlantsImpl> getEnsemblPlants() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBLPLANTS);
    }

    private void setEnsemblPlants(List<EnsemblPlantsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBLPLANTS, xrefs);
    }

    private List<EnsemblProtistsImpl> getEnsemblProtists() {
        return this.getDatabaseCrossReferences(DatabaseType.ENSEMBLPROTISTS);
    }

    private void setEnsemblProtists(List<EnsemblProtistsImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ENSEMBLPROTISTS, xrefs);
    }

    private List<ProteinModelPortalImpl> getProteinModelPortal() {
        return this.getDatabaseCrossReferences(DatabaseType.PROTEINMODELPORTAL);
    }

    private void setProteinModelPortal(List<ProteinModelPortalImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PROTEINMODELPORTAL, xrefs);
    }

    private List<AllergomeImpl> getAllergome() {
        return this.getDatabaseCrossReferences(DatabaseType.ALLERGOME);
    }

    private void setAllergome(List<AllergomeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.ALLERGOME, xrefs);
    }

    private List<neXtProtImpl> getneXtProt() {
        return this.getDatabaseCrossReferences(DatabaseType.NEXTPROT);
    }

    private void setneXtProt(List<neXtProtImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.NEXTPROT, xrefs);
    }

    private List<GeneTreeImpl> getGeneTree() {
        return this.getDatabaseCrossReferences(DatabaseType.GENETREE);
    }

    private void setGeneTree(List<GeneTreeImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.GENETREE, xrefs);
    }

    private List<KOImpl> getKO() {
        return this.getDatabaseCrossReferences(DatabaseType.KO);
    }

    private void setKO(List<KOImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.KO, xrefs);
    }

    private List<DMDMImpl> getDMDM() {
        return this.getDatabaseCrossReferences(DatabaseType.DMDM);
    }

    private void setDMDM(List<DMDMImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.DMDM, xrefs);
    }

    private List<PATRICImpl> getPATRIC() {
        return this.getDatabaseCrossReferences(DatabaseType.PATRIC);
    }

    private void setPATRIC(List<PATRICImpl> xrefs) {
        this.setDatabaseCrossReferences(DatabaseType.PATRIC, xrefs);
    }
}

