/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseFTP;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseURL;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.util.test.NullAble;

public class WebResourceCommentImpl
extends CommentImpl
implements WebResourceComment {
    private DatabaseName name = DefaultCommentFactory.getInstance().buildDatabaseName();
    private DatabaseNote note = DefaultCommentFactory.getInstance().buildDatabaseNote();
    private DatabaseURL url = DefaultCommentFactory.getInstance().buildDatabaseURL();
    private DatabaseFTP ftp = DefaultCommentFactory.getInstance().buildDatabaseFTP();

    public WebResourceCommentImpl() {
        this.setCommentType(CommentType.WEBRESOURCE);
    }

    public WebResourceCommentImpl(WebResourceComment copy) {
        if (copy.getDatabaseName() != null) {
            this.name = DefaultCommentFactory.getInstance().buildDatabaseName(copy.getDatabaseName());
        }
        if (copy.getDatabaseNote() != null) {
            this.note = DefaultCommentFactory.getInstance().buildDatabaseNote(copy.getDatabaseNote());
        }
        if (copy.getDatabaseURL() != null) {
            this.url = DefaultCommentFactory.getInstance().buildDatabaseURL(copy.getDatabaseURL());
        }
        if (copy.getDatabaseFTP() != null) {
            this.ftp = DefaultCommentFactory.getInstance().buildDatabaseFTP(copy.getDatabaseFTP());
        }
        this.setCommentType(CommentType.WEBRESOURCE);
    }

    @Override
    @NullAble
    public DatabaseName getDatabaseName() {
        return this.name;
    }

    @Override
    @NullAble
    public void setDatabaseName(DatabaseName name) {
        this.name = name;
    }

    @Override
    public boolean hasDatabaseName() {
        return this.name != null && !this.name.getValue().equals("");
    }

    @Override
    @NullAble
    public DatabaseNote getDatabaseNote() {
        return this.note;
    }

    @Override
    @NullAble
    public void setDatabaseNote(DatabaseNote note) {
        this.note = note;
    }

    @Override
    public boolean hasDatabaseNote() {
        return this.note != null && !this.note.getValue().equals("");
    }

    @Override
    @NullAble
    public DatabaseURL getDatabaseURL() {
        return this.url;
    }

    @Override
    @NullAble
    public void setDatabaseFTP(DatabaseFTP databaseFTP) {
        this.ftp = databaseFTP;
    }

    @Override
    public boolean hasDatabaseURL() {
        return this.url != null && !this.url.getValue().equals("");
    }

    @Override
    @NullAble
    public DatabaseFTP getDatabaseFTP() {
        return this.ftp;
    }

    @Override
    @NullAble
    public void setDatabaseURL(DatabaseURL databaseURL) {
        this.url = databaseURL;
    }

    @Override
    public boolean hasDatabaseFTP() {
        return this.ftp != null && !this.ftp.getValue().equals("");
    }

    @Override
    public void setUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        if (uri.startsWith("ftp")) {
            this.setDatabaseFTP(DefaultCommentFactory.getInstance().buildDatabaseFTP(uri));
        } else {
            this.setDatabaseURL(DefaultCommentFactory.getInstance().buildDatabaseURL(uri));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WebResourceCommentImpl that = (WebResourceCommentImpl)o;
        if (this.ftp != null ? !this.ftp.equals(that.ftp) : that.ftp != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.note != null ? this.note.hashCode() : 0);
        result = 29 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 29 * result + (this.ftp != null ? this.ftp.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("\n");
        WebResourceCommentImpl dbComment = this;
        sb.append("CC   -!- ");
        sb.append(dbComment.getCommentType().toDisplayName());
        sb.append(": NAME=");
        sb.append(dbComment.getDatabaseName().getValue());
        sb.append(";");
        if (dbComment.getDatabaseNote() != null && sb.length() + dbComment.getDatabaseNote().getValue().length() > 75) {
            if (dbComment.getDatabaseNote() != null && dbComment.getDatabaseNote().getValue().length() > 0) {
                sb.append("\nCC       NOTE=");
                sb.append(dbComment.getDatabaseNote().getValue());
                sb.append(";");
            }
        } else if (dbComment.getDatabaseNote() != null && dbComment.getDatabaseNote().getValue().length() > 0) {
            sb.append(" NOTE=");
            sb.append(dbComment.getDatabaseNote().getValue());
            sb.append(";");
        }
        if (dbComment.getDatabaseURL() != null && !dbComment.getDatabaseURL().getValue().equals("")) {
            sb.append("\nCC       WWW=\"");
            sb.append(dbComment.getDatabaseURL().getValue());
            sb.append("\".");
        }
        if (dbComment.getDatabaseFTP() != null && !dbComment.getDatabaseFTP().getValue().equals("")) {
            sb.append("\nCC       FTP=\"");
            sb.append(dbComment.getDatabaseFTP().getValue());
            sb.append("\".");
        }
        return sb.toString();
    }
}

