/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.model.common.ValueImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationValueImpl;

public class SubcellularLocationImpl
implements SubcellularLocation {
    private SubcellularLocationValue location = new SubcellularLocationValueImpl();
    private SubcellularLocationValue topology = new SubcellularLocationValueImpl();
    private SubcellularLocationValue orientation = new SubcellularLocationValueImpl();

    @Override
    public SubcellularLocationValue getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(SubcellularLocationValue value) {
        this.location = value;
    }

    @Override
    public SubcellularLocationValue getTopology() {
        return this.topology;
    }

    @Override
    public void setTopology(SubcellularLocationValue value) {
        this.topology = value;
    }

    @Override
    public SubcellularLocationValue getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(SubcellularLocationValue value) {
        this.orientation = value;
    }

    @Override
    public Value toValue() {
        StringBuilder builder = new StringBuilder();
        if (this.location != null && this.location.getValue().length() > 0) {
            if (this.location.getValue() != null) {
                builder.append(this.location.getValue());
            }
            if (this.location.getCommentStatus() != null && this.location.getCommentStatus() != CommentStatus.NONE && this.location.getCommentStatus() != CommentStatus.EXPERIMENTAL && this.location.getCommentStatus() != CommentStatus.OTHER) {
                builder.append(" (").append(this.location.getCommentStatus().getValue()).append(")");
            }
        }
        if (this.topology != null && this.topology.getValue().length() > 0) {
            builder.append("; ");
            if (this.topology.getValue() != null) {
                builder.append(this.topology.getValue());
            }
            if (this.topology.getCommentStatus() != null && this.topology.getCommentStatus() != CommentStatus.NONE && this.topology.getCommentStatus() != CommentStatus.EXPERIMENTAL && this.topology.getCommentStatus() != CommentStatus.OTHER) {
                builder.append(" (").append(this.topology.getCommentStatus().getValue()).append(")");
            }
        }
        if (this.orientation != null && this.orientation.getValue().length() > 0) {
            builder.append("; ");
            if (this.orientation.getValue() != null) {
                builder.append(this.orientation.getValue());
            }
            if (this.orientation.getCommentStatus() != null && this.orientation.getCommentStatus() != CommentStatus.NONE && this.orientation.getCommentStatus() != CommentStatus.EXPERIMENTAL && this.orientation.getCommentStatus() != CommentStatus.OTHER) {
                builder.append(" (").append(this.orientation.getCommentStatus().getValue()).append(")");
            }
        }
        ValueImpl value = new ValueImpl();
        value.setValue(builder.toString());
        return value;
    }

    public int hashCode() {
        int result = 7;
        result += result * this.location.hashCode();
        result += result * this.topology.hashCode();
        result += result * this.orientation.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubcellularLocation objCast = (SubcellularLocation)obj;
        return (this.location == null ? objCast.getLocation() == null : this.location.equals(objCast.getLocation()) && (this.orientation == null ? objCast.getOrientation() == null : this.orientation.equals(objCast.getOrientation()))) && (this.topology == null ? objCast.getTopology() == null : objCast.getTopology() != null);
    }

    public String toString() {
        return "location=" + this.location + "; topology=" + this.topology + "; orientation=" + this.orientation;
    }

    @Override
    public boolean hasLocation() {
        return this.location != null && !this.location.getValue().equals("");
    }

    @Override
    public boolean hasTopology() {
        return this.topology != null && !this.topology.getValue().equals("");
    }

    @Override
    public boolean hasOrientation() {
        return this.orientation != null && !this.orientation.getValue().equals("");
    }
}

