/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularMolecule;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationValueImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularMoleculeImpl;

public class SubcellularLocationCommentImpl
extends CommentImpl
implements SubcellularLocationComment,
PersistentObject {
    private SubcellularMolecule molecule;
    private SubcellularLocationValue note;
    private List<SubcellularLocation> locations;

    public SubcellularLocationCommentImpl() {
        this.setCommentType(CommentType.SUBCELLULAR_LOCATION);
        this.molecule = new SubcellularMoleculeImpl();
        this.note = new SubcellularLocationValueImpl();
        this.locations = new ArrayList<SubcellularLocation>();
    }

    @Override
    public SubcellularLocationValue getSubcellularLocationNote() {
        return this.note;
    }

    public SubcellularLocationCommentImpl(SubcellularLocationComment copy) {
        super(copy);
        this.setCommentType(CommentType.SUBCELLULAR_LOCATION);
        this.locations = copy.getSubcellularLocations();
        this.molecule = copy.getSubcellularMolecule();
        this.note = copy.getSubcellularLocationNote();
    }

    @Override
    public void setSubcellularMolecule(SubcellularMolecule subcellularMolecule) {
        this.molecule = subcellularMolecule;
    }

    @Override
    public void setSubcellularLocationNote(SubcellularLocationValue subcellularLocationNote) {
        this.note = subcellularLocationNote;
    }

    @Override
    public SubcellularMolecule getSubcellularMolecule() {
        return this.molecule;
    }

    @Override
    public void setSubcellularLocations(List<SubcellularLocation> locations) {
        this.locations = locations;
    }

    @Override
    public List<SubcellularLocation> getSubcellularLocations() {
        return this.locations;
    }

    @Override
    public void setCommentStatus(CommentStatus newStatus) {
    }

    @Override
    public CommentStatus getCommentStatus() {
        return CommentStatus.NONE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubcellularLocationComment oComment = (SubcellularLocationComment)o;
        return (this.molecule == null ? oComment.getSubcellularMolecule() == null : this.molecule.equals(oComment.getSubcellularMolecule())) && (this.locations == null ? oComment.getSubcellularLocations() == null : ((Object)this.locations).equals(oComment.getSubcellularLocations())) && (this.note == null ? oComment.getSubcellularLocationNote() == null : this.note.equals(oComment.getSubcellularLocationNote()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 17 * this.molecule.hashCode() + result;
        result = 17 * ((Object)this.locations).hashCode() + result;
        result = 17 * this.note.hashCode() + result;
        return result;
    }

    public String toString() {
        String toString = new String();
        toString = toString + "CC   -!- ";
        toString = toString + this.getCommentType().toDisplayName();
        toString = toString + ": ";
        if (this.molecule.getValue().length() > 0) {
            toString = toString + this.molecule + ": ";
        }
        for (SubcellularLocation subcellularLocation : this.locations) {
            if (subcellularLocation.hasLocation()) {
                SubcellularLocationValue location = subcellularLocation.getLocation();
                toString = toString + location.getValue() + (location.getCommentStatus() == CommentStatus.NONE ? "" : " (" + location.getCommentStatus().getValue() + ")") + ";";
            }
            if (subcellularLocation.hasTopology()) {
                SubcellularLocationValue topology = subcellularLocation.getTopology();
                toString = toString + topology.getValue() + (topology.getCommentStatus() == CommentStatus.NONE ? "" : " (" + topology.getCommentStatus().getValue() + ")") + ";";
            }
            if (subcellularLocation.hasOrientation()) {
                SubcellularLocationValue orientation = subcellularLocation.getOrientation();
                toString = toString + orientation.getValue() + (orientation.getCommentStatus() == CommentStatus.NONE ? "" : " (" + orientation.getCommentStatus().getValue() + ")") + ";";
            }
            toString = toString.substring(0, toString.length() - 1) + ". ";
        }
        if (this.note.getValue().length() > 0) {
            toString = toString + "Note=" + this.note.getValue();
            if (this.note.getCommentStatus() != CommentStatus.NONE) {
                toString = toString + " (" + this.note.getCommentStatus().getValue() + ")";
            }
            toString = toString + ".";
        }
        return toString;
    }
}

