/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionPosition;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class SequenceCautionCommentImpl
extends CommentImpl
implements SequenceCautionComment {
    private String sequence;
    private SequenceCautionCommentNote sequenceCautionCommentNote;
    private SequenceCautionType sequenceCautionType;
    private List<SequenceCautionPosition> sequenceCautionPositions;

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public SequenceCautionCommentImpl() {
        this.sequenceCautionCommentNote = DefaultUniProtFactory.getCommentFactory().buildSequenceCautionCommentNote("");
        this.sequence = "";
        this.sequenceCautionType = SequenceCautionType.UNKNOWN;
        this.sequenceCautionPositions = new NoNullElementsList<SequenceCautionPosition>(new ArrayList());
        this.setCommentType(CommentType.SEQUENCE_CAUTION);
    }

    public SequenceCautionCommentImpl(SequenceCautionComment copy) {
        this.sequence = copy.getSequence();
        this.sequenceCautionCommentNote = copy.getNote();
        this.sequenceCautionType = copy.getType();
        this.sequenceCautionPositions = copy.getPositions();
        this.setCommentType(CommentType.SEQUENCE_CAUTION);
    }

    @Override
    public boolean hasNote() {
        return this.sequenceCautionCommentNote != null && this.sequenceCautionCommentNote.getValue().length() > 0;
    }

    @Override
    public SequenceCautionCommentNote getNote() {
        return this.sequenceCautionCommentNote;
    }

    @Override
    public void setNote(SequenceCautionCommentNote note) {
        this.sequenceCautionCommentNote = note;
    }

    @Override
    public SequenceCautionType getType() {
        return this.sequenceCautionType;
    }

    @Override
    public void setType(SequenceCautionType note) {
        this.sequenceCautionType = note;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SequenceCautionCommentImpl that = (SequenceCautionCommentImpl)o;
        if (this.sequence != null ? !this.sequence.equals(that.sequence) : that.sequence != null) {
            return false;
        }
        if (this.sequenceCautionCommentNote != null ? !this.sequenceCautionCommentNote.equals(that.sequenceCautionCommentNote) : that.sequenceCautionCommentNote != null) {
            return false;
        }
        if (this.sequenceCautionPositions != null ? !((Object)this.sequenceCautionPositions).equals(that.sequenceCautionPositions) : that.sequenceCautionPositions != null) {
            return false;
        }
        return this.sequenceCautionType == that.sequenceCautionType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
        result = 31 * result + (this.sequenceCautionCommentNote != null ? this.sequenceCautionCommentNote.hashCode() : 0);
        result = 31 * result + (this.sequenceCautionType != null ? this.sequenceCautionType.hashCode() : 0);
        result = 31 * result + (this.sequenceCautionPositions != null ? ((Object)this.sequenceCautionPositions).hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.sequence != null ? "Sequence=" + this.sequence + ";" : "");
        result.append(this.sequenceCautionType != null ? " Type=" + this.sequenceCautionType.toDisplayName() + ";" : "");
        if (this.sequenceCautionPositions != null && this.sequenceCautionPositions.size() > 0) {
            result.append(" Positions=");
            for (int i = 0; i < this.sequenceCautionPositions.size(); ++i) {
                result.append(this.sequenceCautionPositions.get(i).getValue());
                if (i + 1 == this.sequenceCautionPositions.size()) {
                    result.append(";");
                    continue;
                }
                result.append(", ");
            }
        }
        result.append(this.sequenceCautionCommentNote != null && this.sequenceCautionCommentNote.getValue().length() > 0 ? " Note=" + this.sequenceCautionCommentNote.getValue() + ";" : "");
        return result.toString();
    }

    @Override
    public List<SequenceCautionPosition> getPositions() {
        return this.sequenceCautionPositions;
    }

    @Override
    public void setPositions(List<SequenceCautionPosition> positions) {
        this.sequenceCautionPositions = positions;
    }
}

