/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingNoteImpl;

public class RnaEditingCommentImpl
extends CommentImpl
implements RnaEditingComment,
PersistentObject {
    private List<Position> positions;
    private RnaEditingNote note;
    private RnaEditingLocationType locationType;

    public RnaEditingCommentImpl() {
        this.setCommentType(CommentType.RNA_EDITING);
        this.positions = new ArrayList<Position>();
        this.note = new RnaEditingNoteImpl();
        this.locationType = RnaEditingLocationType.Undetermined;
    }

    public RnaEditingCommentImpl(RnaEditingComment copy) {
        super(copy);
        this.setCommentType(CommentType.RNA_EDITING);
        this.positions = copy.getPositionsWithEvidences();
        this.note = copy.getRnaEditingNote();
        this.locationType = copy.getLocationType();
    }

    @Override
    public RnaEditingNote getRnaEditingNote() {
        return this.note;
    }

    @Override
    public void setRnaEditingNote(RnaEditingNote note) {
        this.note = note;
    }

    @Override
    public RnaEditingLocationType getLocationType() {
        return this.locationType;
    }

    @Override
    public void setLocationType(RnaEditingLocationType locationType) {
        this.locationType = locationType;
    }

    @Override
    public List<Position> getPositionsWithEvidences() {
        return this.positions;
    }

    @Override
    public void setPositions(List<Position> positionList) {
        this.positions = positionList;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RnaEditingComment)) {
            return false;
        }
        RnaEditingComment comparator = (RnaEditingComment)o;
        return (this.positions == null ? comparator.getPositionsWithEvidences() == null : ((Object)this.positions).equals(comparator.getPositionsWithEvidences())) && (this.note == null ? comparator.getRnaEditingNote() == null : this.note.equals(comparator.getRnaEditingNote())) && (this.locationType == null ? comparator.getLocationType() == null : this.locationType.equals((Object)comparator.getLocationType())) && (this.getCommentStatus() == null ? comparator.getCommentStatus() == null : this.getCommentStatus().equals((Object)comparator.getCommentStatus())) && (this.getCommentType() == null ? comparator.getCommentType() == null : this.getCommentType().equals((Object)comparator.getCommentType())) && (this.getEvidenceIds() == null ? comparator.getEvidenceIds() == null : ((Object)this.getEvidenceIds()).equals(comparator.getEvidenceIds()));
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 7 * this.getCommentStatus().hashCode() + result;
        result = 7 * this.getCommentType().hashCode() + result;
        result = 7 * ((Object)this.getEvidenceIds()).hashCode() + result;
        result = 7 * this.note.hashCode() + result;
        result = 7 * ((Object)this.positions).hashCode() + result;
        result = 7 * this.locationType.hashCode() + result;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RnaEditingComment:");
        boolean positionCounter = false;
        for (Position aPosition : this.positions) {
            builder.append(" ");
            builder.append(aPosition.toString());
        }
        builder.append("; ");
        builder.append(this.note.toString());
        builder.append("; ");
        builder.append("RnaEditingLocationType=").append((Object)this.locationType);
        return builder.toString();
    }
}

