/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;

public class PositionImpl
implements Position {
    String position;
    List<EvidenceId> evidences;

    public PositionImpl() {
        this.position = "";
        this.evidences = new ArrayList<EvidenceId>();
    }

    public PositionImpl(String position, List<EvidenceId> evidenceList) {
        this.position = position;
        this.evidences = evidenceList;
    }

    @Override
    public String getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidences;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(this instanceof Position)) {
            return false;
        }
        Position comparator = (Position)obj;
        return (this.position == null ? comparator.getPosition() == null : this.position.equals(comparator.getPosition())) && (this.getEvidenceIds() == null ? comparator.getEvidenceIds() == null : ((Object)this.getEvidenceIds()).equals(comparator.getEvidenceIds()));
    }

    public int hashCode() {
        int result = 17;
        result = 17 * (this.position.hashCode() + result);
        result = 17 * (((Object)this.evidences).hashCode() + result);
        return result;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidences = evidences;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Position=").append(this.getPosition()).append(";");
        int evidenceCounter = 0;
        for (EvidenceId anEvidenceId : this.evidences) {
            builder.append(" Evidence[").append(evidenceCounter++).append("]=");
            builder.append(anEvidenceId.toString());
        }
        return builder.toString();
    }
}

