/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Substrate;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class MichaelisConstantImpl
implements MichaelisConstant,
PersistentObject {
    private long id;
    private float constant;
    private MichaelisConstantUnit unit;
    private Substrate substrate;
    private List<EvidenceId> evidenceIds;

    public MichaelisConstantImpl() {
        this.constant = -1.0f;
        this.unit = MichaelisConstant.NORMALIZED_UNIT;
        this.substrate = DefaultUniProtFactory.getCommentFactory().buildSubstrate("");
    }

    public MichaelisConstantImpl(MichaelisConstant copy) {
        if (copy.getSubstrate() != null) {
            this.substrate = DefaultUniProtFactory.getCommentFactory().buildSubstrate(copy.getSubstrate());
        }
        this.constant = copy.getConstant();
        if (copy.getUnit() != null) {
            this.unit = copy.getUnit();
        }
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId id : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getEvidenceFactory().buildEvidenceId(id.getValue()));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setConstant(float constant) {
        this.constant = constant;
    }

    @Override
    public float getConstant() {
        return this.constant;
    }

    @Override
    public void setUnit(MichaelisConstantUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.unit = unit;
    }

    @Override
    public MichaelisConstantUnit getUnit() {
        return this.unit;
    }

    @Override
    public void setSubstrate(Substrate substrate) {
        if (substrate == null) {
            throw new IllegalArgumentException();
        }
        this.substrate = substrate;
    }

    @Override
    public Substrate getSubstrate() {
        return this.substrate;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MichaelisConstantImpl that = (MichaelisConstantImpl)o;
        if (Float.compare(that.constant, this.constant) != 0) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.evidenceIds != null && this.evidenceIds.size() > 0 ? !((Object)this.evidenceIds).equals(that.evidenceIds) : that.evidenceIds != null && that.evidenceIds.size() > 0) {
            return false;
        }
        if (this.substrate != null ? !this.substrate.equals(that.substrate) : that.substrate != null) {
            return false;
        }
        return this.unit == that.unit;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = (float)(31 * result) + this.constant != 0.0f ? Float.floatToIntBits(this.constant) : 0;
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.substrate != null ? this.substrate.hashCode() : 0);
        result = 31 * result + (this.evidenceIds != null && this.evidenceIds.size() > 0 ? ((Object)this.evidenceIds).hashCode() : 0);
        return result;
    }
}

