/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryIsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRangeNote;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.util.test.NullAble;

public class MassSpectrometryRangeImpl
implements MassSpectrometryRange,
PersistentObject {
    private int start;
    private int end;
    private MassSpectrometryIsoformId isformId;
    private long id;

    public MassSpectrometryRangeImpl() {
        this.start = -1;
        this.end = -1;
        this.isformId = DefaultCommentFactory.getInstance().buildMassSpectrometryIsoformId();
    }

    public MassSpectrometryRangeImpl(MassSpectrometryRange copy) {
        this.start = copy.getStart();
        this.end = copy.getEnd();
        this.isformId = copy.getIsoformId();
        if (copy.hasIsoformId()) {
            this.isformId = DefaultCommentFactory.getInstance().buildMassSpectrometryIsoformId(copy.getIsoformId());
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setStart(int i) {
        this.start = i;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public boolean isStartUnknown() {
        return this.start == -1;
    }

    @Override
    public void setEnd(int i) {
        this.end = i;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public boolean isEndUnknown() {
        return this.end == -1;
    }

    @Override
    public boolean hasNote() {
        return this.isformId != null && !this.isformId.getValue().equals("");
    }

    @Override
    @NullAble
    public void setNote(MassSpectrometryRangeNote note) {
        this.isformId.setValue(note.getValue());
    }

    @Override
    @NullAble
    public MassSpectrometryRangeNote getNote() {
        return DefaultCommentFactory.getInstance().buildMassSpectrometryRangeNote(this.isformId.getValue());
    }

    @Override
    public boolean hasIsoformId() {
        return this.isformId != null && !this.isformId.getValue().equals("");
    }

    @Override
    @NullAble
    public MassSpectrometryIsoformId getIsoformId() {
        return this.isformId;
    }

    @Override
    @NullAble
    public void setIsoformId(MassSpectrometryIsoformId isoformId) {
        this.isformId = isoformId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MassSpectrometryRangeImpl that = (MassSpectrometryRangeImpl)o;
        if (this.end != that.end) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.start != that.start) {
            return false;
        }
        return !(this.isformId != null ? !this.isformId.equals(that.isformId) : that.isformId != null);
    }

    public int hashCode() {
        int result = this.start;
        result = 31 * result + this.end;
        result = 31 * result + (this.isformId != null ? this.isformId.hashCode() : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }
}

