/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class MassSpectrometryCommentImpl
extends CommentImpl
implements MassSpectrometryComment {
    private List<MassSpectrometryRange> ranges;
    private MassSpectrometryCommentNote note;
    private float molWeight;
    private float molWeightError;
    private MassSpectrometryMethod method;
    private List<MassSpectrometryCommentSource> massSpectrometryCommentSources;

    public MassSpectrometryCommentImpl() {
        this.setCommentType(CommentType.MASS_SPECTROMETRY);
        this.ranges = new ArrayList<MassSpectrometryRange>();
        this.massSpectrometryCommentSources = new ArrayList<MassSpectrometryCommentSource>();
        this.note = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryCommentNote("");
        this.molWeight = 0.0f;
        this.molWeightError = 0.0f;
        this.method = MassSpectrometryMethod.UNKNOWN;
    }

    public MassSpectrometryCommentImpl(MassSpectrometryComment copy) {
        this();
        this.setCommentType(CommentType.MASS_SPECTROMETRY);
        this.ranges = new NoNullElementsList<MassSpectrometryRange>(new ArrayList());
        this.note = DefaultUniProtFactory.getCommentFactory().buildMassSpectrometryCommentNote("");
        this.molWeight = 0.0f;
        this.molWeightError = 0.0f;
        this.method = MassSpectrometryMethod.UNKNOWN;
        for (MassSpectrometryRange range : copy.getRanges()) {
            this.ranges.add(DefaultCommentFactory.getInstance().buildMassSpectrometryRange(range));
        }
        for (MassSpectrometryCommentSource massSpectrometryCommentSource : copy.getSources()) {
            MassSpectrometryCommentSource o = DefaultCommentFactory.getInstance().buildMassSpectrometryCommentSource(massSpectrometryCommentSource);
            this.massSpectrometryCommentSources.add(o);
        }
        if (copy.getNote() != null) {
            this.note = DefaultCommentFactory.getInstance().buildMassSpectrometryCommentNote(copy.getNote());
        }
        this.molWeight = copy.getMolWeight();
        this.molWeightError = copy.getMolWeightError();
        if (copy.getMethod() != null) {
            this.method = copy.getMethod();
        }
    }

    @Override
    public float getMolWeightError() {
        return this.molWeightError;
    }

    @Override
    public void setMolWeightError(float molWeightError) {
        this.molWeightError = molWeightError;
    }

    @Override
    public float getMolWeight() {
        return this.molWeight;
    }

    @Override
    public void setMolWeight(float molWeight) {
        this.molWeight = molWeight;
    }

    @Override
    public MassSpectrometryCommentNote getNote() {
        return this.note;
    }

    @Override
    public boolean hasNote() {
        return this.note != null;
        {
        }
    }

    @Override
    public void setNote(MassSpectrometryCommentNote note) {
        if (note == null) {
            throw new IllegalArgumentException();
        }
        this.note = note;
    }

    @Override
    public List<MassSpectrometryRange> getRanges() {
        return this.ranges;
    }

    @Override
    public void setRanges(List<MassSpectrometryRange> ranges) {
        if (ranges == null) {
            throw new IllegalArgumentException();
        }
        this.ranges = ranges;
    }

    @Override
    public MassSpectrometryMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(MassSpectrometryMethod method) {
        if (method == null) {
            throw new IllegalArgumentException();
        }
        this.method = method;
    }

    @Override
    public List<MassSpectrometryCommentSource> getSources() {
        return this.massSpectrometryCommentSources;
    }

    @Override
    public void setSources(List<MassSpectrometryCommentSource> source) {
        this.massSpectrometryCommentSources = source;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MassSpectrometryCommentImpl that = (MassSpectrometryCommentImpl)o;
        if (Float.compare(that.molWeight, this.molWeight) != 0) {
            return false;
        }
        if (Float.compare(that.molWeightError, this.molWeightError) != 0) {
            return false;
        }
        if (this.massSpectrometryCommentSources != null ? !((Object)this.massSpectrometryCommentSources).equals(that.massSpectrometryCommentSources) : that.massSpectrometryCommentSources != null) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        return !(this.ranges != null ? !((Object)this.ranges).equals(that.ranges) : that.ranges != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.ranges != null ? ((Object)this.ranges).hashCode() : 0);
        result = 31 * result + (this.note != null ? this.note.hashCode() : 0);
        result = 31 * result + (this.molWeight != 0.0f ? Float.floatToIntBits(this.molWeight) : 0);
        result = 31 * result + (this.molWeightError != 0.0f ? Float.floatToIntBits(this.molWeightError) : 0);
        result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
        result = 31 * result + (this.massSpectrometryCommentSources != null ? ((Object)this.massSpectrometryCommentSources).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MassSpectrometryCommentImpl[ranges=" + this.ranges + ", note=" + this.note + ", molWeight=" + this.molWeight + ", molWeightError=" + this.molWeightError + ", method=" + (Object)((Object)this.method) + ", massSpectrometryCommentSources=" + this.massSpectrometryCommentSources + ']';
    }
}

