/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

public class KineticParametersImpl
implements KineticParameters {
    private List<MichaelisConstant> michaelisConstants = new ArrayList<MichaelisConstant>();
    private List<MaximumVelocity> maximumVelocities = new ArrayList<MaximumVelocity>();
    private KineticParameterNote kineticParameterNote = DefaultCommentFactory.getInstance().buildKineticParameterNote();

    public KineticParametersImpl() {
    }

    public KineticParametersImpl(KineticParameters copy) {
        this();
        this.michaelisConstants = new NoNullElementsList<MichaelisConstant>(new ArrayList());
        this.maximumVelocities = new NoNullElementsList<MaximumVelocity>(new ArrayList());
        this.kineticParameterNote = DefaultCommentFactory.getInstance().buildKineticParameterNote();
        if (copy.getMichaelisConstants() != null) {
            for (MichaelisConstant michaelisConstant : copy.getMichaelisConstants()) {
                this.michaelisConstants.add(DefaultCommentFactory.getInstance().buildMichaelisConstant(michaelisConstant));
            }
        }
        if (copy.getMaximumVelocities() != null) {
            for (MaximumVelocity maximumVelocity : copy.getMaximumVelocities()) {
                this.maximumVelocities.add(DefaultCommentFactory.getInstance().buildMaximumVelocity(maximumVelocity));
            }
        }
        if (copy.getNote() != null && copy.getNote() != null) {
            this.kineticParameterNote = DefaultCommentFactory.getInstance().buildKineticParameterNote(copy.getNote());
        }
    }

    @Override
    public void setMichaelisConstants(List<MichaelisConstant> michaelisConstants) {
        if (michaelisConstants == null) {
            throw new IllegalArgumentException();
        }
        this.michaelisConstants = michaelisConstants;
    }

    @Override
    public List<MichaelisConstant> getMichaelisConstants() {
        return this.michaelisConstants;
    }

    @Override
    public void setMaximumVelocities(List<MaximumVelocity> maximumVelocities) {
        if (maximumVelocities == null) {
            throw new IllegalArgumentException();
        }
        this.maximumVelocities = maximumVelocities;
    }

    @Override
    public List<MaximumVelocity> getMaximumVelocities() {
        return this.maximumVelocities;
    }

    @Override
    @NullAble
    public void setNote(KineticParameterNote note) {
        this.kineticParameterNote = note;
    }

    @Override
    @NullAble
    public KineticParameterNote getNote() {
        return this.kineticParameterNote;
    }

    @Override
    public boolean hasKineticParameterNote() {
        return this.kineticParameterNote != null && !this.kineticParameterNote.getValue().equals("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KineticParametersImpl that = (KineticParametersImpl)o;
        if (this.kineticParameterNote != null ? !this.kineticParameterNote.equals(that.kineticParameterNote) : that.kineticParameterNote != null) {
            return false;
        }
        if (!((Object)this.maximumVelocities).equals(that.maximumVelocities)) {
            return false;
        }
        return ((Object)this.michaelisConstants).equals(that.michaelisConstants);
    }

    public int hashCode() {
        int result = ((Object)this.michaelisConstants).hashCode();
        result = 29 * result + ((Object)this.maximumVelocities).hashCode();
        result = 29 * result + (this.kineticParameterNote != null ? this.kineticParameterNote.hashCode() : 0);
        return result;
    }
}

