/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionGeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorUniProtAccession;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionGeneNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorUniProtAccessionImpl;
import uk.ac.ebi.kraken.util.test.NullAble;

public class InteractionImpl
extends CommentImpl
implements Interaction,
PersistentObject {
    public long id;
    private InteractionType interactionType;
    private InteractorUniProtAccession interactorUniProtAccession;
    private InteractionGeneName interactionGeneName;
    private int numberOfExperiments;
    private InteractorAccession firstInteractor;
    private InteractorAccession secondInteractor;

    public InteractionImpl() {
        this.interactionType = InteractionType.UNKNOWN;
        this.interactorUniProtAccession = new InteractorUniProtAccessionImpl();
        this.interactionGeneName = new InteractionGeneNameImpl();
        this.numberOfExperiments = -1;
        this.firstInteractor = new InteractorAccessionImpl();
        this.secondInteractor = new InteractorAccessionImpl();
    }

    public InteractionImpl(Interaction copy) {
        this.interactionType = copy.getInteractionType();
        this.interactorUniProtAccession = new InteractorUniProtAccessionImpl();
        this.interactionGeneName = new InteractionGeneNameImpl();
        this.numberOfExperiments = -1;
        this.firstInteractor = new InteractorAccessionImpl();
        this.secondInteractor = new InteractorAccessionImpl();
        if (copy.getInteractorUniProtAccession() != null) {
            this.interactorUniProtAccession = DefaultCommentFactory.getInstance().buildInteractorUniProtAccession(copy.getInteractorUniProtAccession());
        }
        if (copy.getInteractionGeneName() != null) {
            this.interactionGeneName = DefaultCommentFactory.getInstance().buildInteractionGeneName(copy.getInteractionGeneName());
        }
        if (copy.getFirstInteractor() != null) {
            this.firstInteractor = DefaultCommentFactory.getInstance().buildIntActAccession(copy.getFirstInteractor());
        }
        if (copy.getSecondInteractor() != null) {
            this.secondInteractor = DefaultCommentFactory.getInstance().buildIntActAccession(copy.getSecondInteractor());
        }
        this.numberOfExperiments = copy.getNumberOfExperiments();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return "INTERACTION: " + this.firstInteractor + "-" + this.secondInteractor;
    }

    @Override
    @NullAble
    public void setInteractionType(InteractionType interactionType) {
        this.interactionType = interactionType;
    }

    @Override
    @NullAble
    public void setFirstInteractor(InteractorAccession acc) {
        this.firstInteractor = acc;
    }

    @Override
    public InteractorAccession getFirstInteractor() {
        return this.firstInteractor;
    }

    @Override
    @NullAble
    public void setSecondInteractor(InteractorAccession acc) {
        this.secondInteractor = acc;
    }

    @Override
    public InteractorAccession getSecondInteractor() {
        return this.secondInteractor;
    }

    @Override
    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    @Override
    @NullAble
    public void setInteractorUniProtAccession(InteractorUniProtAccession acc) {
        this.interactorUniProtAccession = acc;
    }

    @Override
    public InteractorUniProtAccession getInteractorUniProtAccession() {
        return this.interactorUniProtAccession;
    }

    @Override
    @NullAble
    public void setInteractionGeneName(InteractionGeneName interactionGeneName) {
        this.interactionGeneName = interactionGeneName;
    }

    @Override
    public InteractionGeneName getInteractionGeneName() {
        return this.interactionGeneName;
    }

    @Override
    @NullAble
    public void setNumberOfExperiments(int number) {
        this.numberOfExperiments = number;
    }

    @Override
    public int getNumberOfExperiments() {
        return this.numberOfExperiments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InteractionImpl that = (InteractionImpl)o;
        if (this.numberOfExperiments != that.numberOfExperiments) {
            return false;
        }
        if (!this.firstInteractor.equals(that.firstInteractor)) {
            return false;
        }
        if (!this.interactionGeneName.equals(that.interactionGeneName)) {
            return false;
        }
        if (this.interactionType != that.interactionType) {
            return false;
        }
        if (!this.secondInteractor.equals(that.secondInteractor)) {
            return false;
        }
        return this.interactorUniProtAccession.equals(that.interactorUniProtAccession);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.interactionType.hashCode();
        result = 29 * result + this.interactorUniProtAccession.hashCode();
        result = 29 * result + this.interactionGeneName.hashCode();
        result = 29 * result + this.numberOfExperiments;
        result = 29 * result + this.firstInteractor.hashCode();
        result = 29 * result + this.secondInteractor.hashCode();
        return result;
    }

    @Override
    public CommentType getCommentType() {
        return CommentType.INTERACTION;
    }
}

