/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class InteractionCommentImpl
extends CommentImpl
implements InteractionComment {
    private List<Interaction> interactions = new ArrayList<Interaction>();

    public InteractionCommentImpl() {
        this.setCommentType(CommentType.INTERACTION);
    }

    public InteractionCommentImpl(InteractionComment copy) {
        this();
        for (Interaction interaction : copy.getInteractions()) {
            this.interactions.add(DefaultCommentFactory.getInstance().buildInteraction(interaction));
        }
    }

    @Override
    public List<Interaction> getInteractions() {
        return this.interactions;
    }

    @Override
    public void setInteractions(List<Interaction> interactions) {
        if (interactions == null) {
            throw new IllegalArgumentException();
        }
        this.interactions = interactions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InteractionCommentImpl that = (InteractionCommentImpl)o;
        return ((Object)this.interactions).equals(that.interactions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + ((Object)this.interactions).hashCode();
        return result;
    }
}

