/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AllergenComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.util.container.CollectionVisitor;
import uk.ac.ebi.kraken.util.container.MapValueCollection;

public class Comments
implements Serializable {
    private EnumMap<CommentType, List<? extends Comment>> commentMap = new EnumMap(CommentType.class);

    public Collection<Comment> getComments() {
        return new MapValueCollection(new CollectionVisitor<Comment>(){

            @Override
            public void accept(Comment comment) {
                Comments.this.addComment(comment);
            }
        }, this.commentMap.values());
    }

    public <T extends Comment> void setComments(CommentType type, List<T> comments) {
        this.commentMap.put(type, comments);
    }

    public <T extends Comment> List<T> getComments(CommentType type) {
        List<? extends Comment> retVal = this.commentMap.get((Object)type);
        if (retVal == null) {
            retVal = new ArrayList<Comment>();
            this.commentMap.put(type, retVal);
        }
        return retVal;
    }

    public void setComments(List<Comment> comments) {
        this.commentMap = new EnumMap(CommentType.class);
        for (Comment comment : comments) {
            this.addComment(comment);
        }
    }

    public void setComments(Collection<Comment> comments) {
        this.commentMap = new EnumMap(CommentType.class);
        for (Comment comment : comments) {
            this.addComment(comment);
        }
    }

    private <T extends Comment> void addComment(T o) {
        if (o == null) {
            throw new IllegalArgumentException("comment is null");
        }
        List<T> list = this.getComments(o.getCommentType());
        if (list == null) {
            ArrayList<T> newList = new ArrayList<T>();
            newList.add(o);
            this.setComments(o.getCommentType(), newList);
        } else {
            list.add(o);
        }
    }

    private List<AllergenComment> getAllergen() {
        return this.getComments(CommentType.ALLERGEN);
    }

    private void setAllergen(List<Comment> comments) {
        this.setComments(CommentType.ALLERGEN, comments);
    }

    private List<Comment> getAlternativeProduct() {
        return this.getComments(CommentType.ALTERNATIVE_PRODUCTS);
    }

    private void setAlternativeProduct(List<Comment> comments) {
        this.setComments(CommentType.ALTERNATIVE_PRODUCTS, comments);
    }

    private List<Comment> getBioPhysicoChemical() {
        return this.getComments(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES);
    }

    private void setBioPhysicoChemical(List<Comment> comments) {
        this.setComments(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES, comments);
    }

    private List<Comment> getBiotechnology() {
        return this.getComments(CommentType.BIOTECHNOLOGY);
    }

    private void setBiotechnology(List<Comment> comments) {
        this.setComments(CommentType.BIOTECHNOLOGY, comments);
    }

    private List<Comment> getCatalyticActivity() {
        return this.getComments(CommentType.CATALYTIC_ACTIVITY);
    }

    private void setCatalyticActivity(List<Comment> comments) {
        this.setComments(CommentType.CATALYTIC_ACTIVITY, comments);
    }

    private List<Comment> getCaution() {
        return this.getComments(CommentType.CAUTION);
    }

    private void setCaution(List<Comment> comments) {
        this.setComments(CommentType.CAUTION, comments);
    }

    private List<Comment> getCofactor() {
        return this.getComments(CommentType.COFACTOR);
    }

    private void setCofactor(List<Comment> comments) {
        this.setComments(CommentType.COFACTOR, comments);
    }

    private List<Comment> getWebResource() {
        return this.getComments(CommentType.WEBRESOURCE);
    }

    private void setWebResource(List<Comment> comments) {
        this.setComments(CommentType.WEBRESOURCE, comments);
    }

    private List<Comment> getDevelopmentalStage() {
        return this.getComments(CommentType.DEVELOPMENTAL_STAGE);
    }

    private void setDevelopmentalStage(List<Comment> comments) {
        this.setComments(CommentType.DEVELOPMENTAL_STAGE, comments);
    }

    private List<Comment> getDisease() {
        return this.getComments(CommentType.DISEASE);
    }

    private void setDisease(List<Comment> comments) {
        this.setComments(CommentType.DISEASE, comments);
    }

    private List<Comment> getDomain() {
        return this.getComments(CommentType.DOMAIN);
    }

    private void setDomain(List<Comment> comments) {
        this.setComments(CommentType.DOMAIN, comments);
    }

    private List<Comment> getEnzymeRegulation() {
        return this.getComments(CommentType.ENZYME_REGULATION);
    }

    private void setEnzymeRegulation(List<Comment> comments) {
        this.setComments(CommentType.ENZYME_REGULATION, comments);
    }

    private List<Comment> getFunction() {
        return this.getComments(CommentType.FUNCTION);
    }

    private void setFunction(List<Comment> comments) {
        this.setComments(CommentType.FUNCTION, comments);
    }

    private List<Comment> getInduction() {
        return this.getComments(CommentType.INDUCTION);
    }

    private void setInduction(List<Comment> comments) {
        this.setComments(CommentType.INDUCTION, comments);
    }

    private List<Comment> getInteraction() {
        return this.getComments(CommentType.INTERACTION);
    }

    private void setInteraction(List<Comment> comments) {
        this.setComments(CommentType.INTERACTION, comments);
    }

    private List<Comment> getMassSpectrometry() {
        return this.getComments(CommentType.MASS_SPECTROMETRY);
    }

    private void setMassSpectrometry(List<Comment> comments) {
        this.setComments(CommentType.MASS_SPECTROMETRY, comments);
    }

    private List<Comment> getMiscellaneous() {
        return this.getComments(CommentType.MISCELLANEOUS);
    }

    private void setMiscellaneous(List<Comment> comments) {
        this.setComments(CommentType.MISCELLANEOUS, comments);
    }

    private List<Comment> getPathway() {
        return this.getComments(CommentType.PATHWAY);
    }

    private void setPathway(List<Comment> comments) {
        this.setComments(CommentType.PATHWAY, comments);
    }

    private List<Comment> getPharaceutical() {
        return this.getComments(CommentType.PHARMACEUTICAL);
    }

    private void setPharaceutical(List<Comment> comments) {
        this.setComments(CommentType.PHARMACEUTICAL, comments);
    }

    private List<Comment> getPolymorphism() {
        return this.getComments(CommentType.POLYMORPHISM);
    }

    private void setPolymorphism(List<Comment> comments) {
        this.setComments(CommentType.POLYMORPHISM, comments);
    }

    private List<Comment> getPTM() {
        return this.getComments(CommentType.PTM);
    }

    private void setPTM(List<Comment> comments) {
        this.setComments(CommentType.PTM, comments);
    }

    private List<Comment> getRNA() {
        return this.getComments(CommentType.RNA_EDITING);
    }

    private void setRNA(List<Comment> comments) {
        this.setComments(CommentType.RNA_EDITING, comments);
    }

    private List<Comment> getSimilarity() {
        return this.getComments(CommentType.SIMILARITY);
    }

    private void setSimilarity(List<Comment> comments) {
        this.setComments(CommentType.SIMILARITY, comments);
    }

    private List<Comment> getSubcellularLocation() {
        return this.getComments(CommentType.SUBCELLULAR_LOCATION);
    }

    private void setSubcellularLocation(List<Comment> comments) {
        this.setComments(CommentType.SUBCELLULAR_LOCATION, comments);
    }

    private List<Comment> getSubunit() {
        return this.getComments(CommentType.SUBUNIT);
    }

    private void setSubunit(List<Comment> comments) {
        this.setComments(CommentType.SUBUNIT, comments);
    }

    private List<Comment> getTissueSpecificity() {
        return this.getComments(CommentType.TISSUE_SPECIFICITY);
    }

    private void setTissueSpecificity(List<Comment> comments) {
        this.setComments(CommentType.TISSUE_SPECIFICITY, comments);
    }

    private List<Comment> getToxicDose() {
        return this.getComments(CommentType.TOXIC_DOSE);
    }

    private void setToxicDose(List<Comment> comments) {
        this.setComments(CommentType.TOXIC_DOSE, comments);
    }
}

