/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.util.test.NullAble;

public class BioPhysicoChemicalPropertiesCommentImpl
extends CommentImpl
implements BioPhysicoChemicalPropertiesComment {
    private Absorption absorption;
    private PHDependence phDependence;
    private RedoxPotential redoxPotential;
    private TemperatureDependence temperatureDependence;
    private KineticParameters kineticParameters;

    public BioPhysicoChemicalPropertiesCommentImpl() {
        this.setCommentType(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES);
        this.absorption = DefaultCommentFactory.getInstance().buildAbsorption();
        this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential();
        this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence();
        this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters();
        this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence();
    }

    public BioPhysicoChemicalPropertiesCommentImpl(BioPhysicoChemicalPropertiesComment copy) {
        this();
        this.absorption = DefaultCommentFactory.getInstance().buildAbsorption();
        this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential();
        this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence();
        this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters();
        this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence();
        if (copy.getPHDependence() != null) {
            this.phDependence = DefaultCommentFactory.getInstance().buildPHDependence(copy.getPHDependence());
        }
        if (copy.getAbsorption() != null) {
            this.absorption = DefaultCommentFactory.getInstance().buildAbsorption(copy.getAbsorption());
        }
        if (copy.getRedoxPotential() != null) {
            this.redoxPotential = DefaultCommentFactory.getInstance().buildRedoxPotential(copy.getRedoxPotential());
        }
        if (copy.getTemperatureDependence() != null) {
            this.temperatureDependence = DefaultCommentFactory.getInstance().buildTemperatureDependence(copy.getTemperatureDependence());
        }
        if (copy.getKineticParameters() != null) {
            this.kineticParameters = DefaultCommentFactory.getInstance().buildKineticParameters(copy.getKineticParameters());
        }
    }

    @Override
    @NullAble
    public Absorption getAbsorption() {
        return this.absorption;
    }

    @Override
    @NullAble
    public void setAbsorption(Absorption absorption) {
        this.absorption = absorption;
    }

    @Override
    public boolean hasAbsorptionProperty() {
        return this.absorption != null && !this.absorption.equals(DefaultCommentFactory.getInstance().buildAbsorption());
    }

    @Override
    @NullAble
    public PHDependence getPHDependence() {
        return this.phDependence;
    }

    @Override
    @NullAble
    public void setPHDepencence(PHDependence phDependence) {
        this.phDependence = phDependence;
    }

    @Override
    public boolean hasPHDependenceProperty() {
        return this.phDependence != null && !this.phDependence.equals(DefaultCommentFactory.getInstance().buildPHDependence());
    }

    @Override
    @NullAble
    public RedoxPotential getRedoxPotential() {
        return this.redoxPotential;
    }

    @Override
    public boolean hasRedoxPotentialProperty() {
        return this.redoxPotential != null && !this.redoxPotential.equals(DefaultCommentFactory.getInstance().buildRedoxPotential());
    }

    @Override
    @NullAble
    public void setRedoxPotential(RedoxPotential redoxPotential) {
        this.redoxPotential = redoxPotential;
    }

    @Override
    @NullAble
    public TemperatureDependence getTemperatureDependence() {
        return this.temperatureDependence;
    }

    @Override
    public boolean hasTemperatureDependenceProperty() {
        return this.temperatureDependence != null && !this.temperatureDependence.equals(DefaultCommentFactory.getInstance().buildTemperatureDependence());
    }

    @Override
    @NullAble
    public void setTemperatureDependence(TemperatureDependence temperatureDependence) {
        this.temperatureDependence = temperatureDependence;
    }

    @Override
    @NullAble
    public void setKineticParameters(KineticParameters kineticParameters) {
        this.kineticParameters = kineticParameters;
    }

    @Override
    @NullAble
    public KineticParameters getKineticParameters() {
        return this.kineticParameters;
    }

    @Override
    public boolean hasKineticParametersProperty() {
        return this.kineticParameters != null && !this.kineticParameters.equals(DefaultCommentFactory.getInstance().buildKineticParameters());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BioPhysicoChemicalPropertiesCommentImpl that = (BioPhysicoChemicalPropertiesCommentImpl)o;
        if (this.absorption != null ? !this.absorption.equals(that.absorption) : that.absorption != null) {
            return false;
        }
        if (this.kineticParameters != null ? !this.kineticParameters.equals(that.kineticParameters) : that.kineticParameters != null) {
            return false;
        }
        if (this.phDependence != null ? !this.phDependence.equals(that.phDependence) : that.phDependence != null) {
            return false;
        }
        if (this.redoxPotential != null ? !this.redoxPotential.equals(that.redoxPotential) : that.redoxPotential != null) {
            return false;
        }
        return !(this.temperatureDependence != null ? !this.temperatureDependence.equals(that.temperatureDependence) : that.temperatureDependence != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.absorption != null ? this.absorption.hashCode() : 0);
        result = 29 * result + (this.phDependence != null ? this.phDependence.hashCode() : 0);
        result = 29 * result + (this.redoxPotential != null ? this.redoxPotential.hashCode() : 0);
        result = 29 * result + (this.temperatureDependence != null ? this.temperatureDependence.hashCode() : 0);
        result = 29 * result + (this.kineticParameters != null ? this.kineticParameters.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("\n");
        BioPhysicoChemicalPropertiesCommentImpl bioPCPropComment = this;
        sb.append("CC   -!- ");
        sb.append(bioPCPropComment.getCommentType().toDisplayName());
        sb.append(":");
        if (bioPCPropComment.hasAbsorptionProperty()) {
            sb.append("\nCC       Absorption:\n");
            Absorption absorption = bioPCPropComment.getAbsorption();
            sb.append("CC         Abs(max)=");
            if (absorption.isApproximation()) {
                sb.append("~");
            }
            sb.append(absorption.getMax());
            sb.append(" nm;");
            if (absorption.hasNote()) {
                sb.append("\nCC         Note=").append(absorption.getNote().getValue()).append(";");
            }
        }
        if (bioPCPropComment.hasKineticParametersProperty()) {
            sb.append("\nCC       Kinetic parameters:");
            if (null != bioPCPropComment.getKineticParameters().getMichaelisConstants()) {
                List<MichaelisConstant> michaelisConstants = bioPCPropComment.getKineticParameters().getMichaelisConstants();
                System.err.println("michaelisConstants.size() = " + michaelisConstants.size());
                for (MichaelisConstant michaelisConstant : michaelisConstants) {
                    StringBuilder temp = sb;
                    temp.append("\nCC         KM=");
                    temp.append(michaelisConstant.getConstant());
                    temp.append(" ");
                    temp.append(michaelisConstant.getUnit().toDisplayNameString());
                    temp.append(" for ");
                    temp.append(michaelisConstant.getSubstrate().getValue());
                    temp.append(";");
                    sb.append("\n");
                }
            }
            if (null != bioPCPropComment.getKineticParameters().getMaximumVelocities() && !bioPCPropComment.getKineticParameters().getMaximumVelocities().isEmpty()) {
                List<MaximumVelocity> maximumVelocities = bioPCPropComment.getKineticParameters().getMaximumVelocities();
                for (MaximumVelocity maximumVelocity : maximumVelocities) {
                    sb.append("CC         Vmax=" + maximumVelocity.getVelocity() + " " + maximumVelocity.getUnit().toDisplayNameString() + " " + maximumVelocity.getEnzyme().getValue() + ";");
                    sb.append("\n");
                }
            }
            if (bioPCPropComment.getKineticParameters().hasKineticParameterNote()) {
                String temp = "CC         Note=" + bioPCPropComment.getKineticParameters().getNote().getValue() + ";";
                sb.append("\n");
            }
        }
        if (bioPCPropComment.hasPHDependenceProperty()) {
            sb.append("\nCC       pH dependence:\nCC         ");
            sb.append(bioPCPropComment.getPHDependence().getValue());
            sb.append(";");
        }
        if (bioPCPropComment.hasRedoxPotentialProperty()) {
            sb.append("\nCC       Redox potential:\nCC         ");
            sb.append(bioPCPropComment.getRedoxPotential().getValue());
            sb.append(";");
        }
        if (bioPCPropComment.hasTemperatureDependenceProperty()) {
            sb.append("\nCC       Temperature dependence:\n");
            sb.append("CC         " + bioPCPropComment.getTemperatureDependence().getValue() + ";");
        }
        return sb.toString();
    }
}

