/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;

public class AlternativeProductsCommentImpl
extends CommentImpl
implements AlternativeProductsComment,
Comment,
PersistentObject {
    private List<AlternativeProductsEvent> events;
    private List<AlternativeProductsIsoform> isoforms;
    private AlternativeProductsCommentComment comment;
    private long id;

    public AlternativeProductsCommentImpl() {
        this.setCommentType(CommentType.ALTERNATIVE_PRODUCTS);
        this.events = new ArrayList<AlternativeProductsEvent>();
        this.isoforms = new ArrayList<AlternativeProductsIsoform>();
        this.comment = DefaultCommentFactory.getInstance().buildAlternativeProductsCommentComment();
    }

    public AlternativeProductsCommentImpl(AlternativeProductsComment copy) {
        this();
        for (AlternativeProductsEvent event : copy.getEvents()) {
            this.events.add(DefaultCommentFactory.getInstance().buildAlternativeProductsEvent(event));
        }
        for (AlternativeProductsIsoform isoform : copy.getIsoforms()) {
            this.isoforms.add(DefaultCommentFactory.getInstance().buildAlternativeProductsIsoform(isoform));
        }
    }

    @Override
    public AlternativeProductsCommentComment getComment() {
        return this.comment;
    }

    @Override
    public void setComment(AlternativeProductsCommentComment comment) {
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        this.comment = comment;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setEvents(List<AlternativeProductsEvent> events) {
        this.events = events;
    }

    @Override
    public List<AlternativeProductsEvent> getEvents() {
        return this.events;
    }

    @Override
    public List<AlternativeProductsIsoform> getIsoforms() {
        return this.isoforms;
    }

    @Override
    public void setIsoforms(List<AlternativeProductsIsoform> isoforms) {
        this.isoforms = isoforms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlternativeProductsCommentImpl that = (AlternativeProductsCommentImpl)o;
        if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) {
            return false;
        }
        if (this.events != null ? !((Object)this.events).equals(that.events) : that.events != null) {
            return false;
        }
        return !(this.isoforms != null ? !((Object)this.isoforms).equals(that.isoforms) : that.isoforms != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.events != null ? ((Object)this.events).hashCode() : 0);
        result = 29 * result + (this.isoforms != null ? ((Object)this.isoforms).hashCode() : 0);
        result = 29 * result + (this.comment != null ? this.comment.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder cc = new StringBuilder();
        return cc.toString();
    }
}

