/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.util.test.NullAble;

public class AbsorptionImpl
implements Absorption {
    private int max;
    private AbsorptionNote absorptionNote = DefaultCommentFactory.getInstance().buildAbsorptionNote();
    private boolean approximate;
    private List<EvidenceId> evidenceIds;

    public AbsorptionImpl() {
    }

    public AbsorptionImpl(Absorption copy) {
        this();
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.max = copy.getMax();
        if (copy.hasNote()) {
            this.absorptionNote = DefaultCommentFactory.getInstance().buildAbsorptionNote(copy.getNote());
        }
        this.approximate = copy.isApproximation();
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId id : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getEvidenceFactory().buildEvidenceId(id.getValue()));
        }
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    @Override
    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    @NullAble
    public void setNote(AbsorptionNote note) {
        this.absorptionNote = note;
    }

    @Override
    @NullAble
    public AbsorptionNote getNote() {
        return this.absorptionNote;
    }

    @Override
    public boolean hasNote() {
        return this.absorptionNote != null && !this.absorptionNote.getValue().equals("");
    }

    @Override
    public void setApproximation(boolean isApproximate) {
        this.approximate = isApproximate;
    }

    @Override
    public boolean isApproximation() {
        return this.approximate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbsorptionImpl that = (AbsorptionImpl)o;
        if (this.approximate != that.approximate) {
            return false;
        }
        if (this.max != that.max) {
            return false;
        }
        if (this.absorptionNote != null ? !this.absorptionNote.equals(that.absorptionNote) : that.absorptionNote != null) {
            return false;
        }
        return !(this.evidenceIds != null && this.evidenceIds.size() > 0 ? !((Object)this.evidenceIds).equals(that.evidenceIds) : that.evidenceIds != null && that.evidenceIds.size() > 0);
    }

    public int hashCode() {
        int result = this.max;
        result = 31 * result + (this.absorptionNote != null ? this.absorptionNote.hashCode() : 0);
        result = 31 * result + (this.approximate ? 1 : 0);
        result = 31 * result + (this.evidenceIds != null && this.evidenceIds.size() > 0 ? ((Object)this.evidenceIds).hashCode() : 0);
        return result;
    }
}

