/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Country;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Institute;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class ThesisImpl
extends CitationImpl
implements Thesis {
    private Institute institute;
    private Country country;
    private City city;

    public ThesisImpl() {
        super(CitationTypeEnum.THESIS);
        this.institute = DefaultCitationNewFactory.getInstance().buildInstitute();
        this.country = DefaultCitationNewFactory.getInstance().buildCountry();
        this.city = DefaultCitationNewFactory.getInstance().buildCity();
    }

    public ThesisImpl(Thesis copy) {
        super(copy);
        this.institute = DefaultCitationNewFactory.getInstance().buildInstitute(copy.getInstitute());
        this.country = DefaultCitationNewFactory.getInstance().buildCountry(copy.getCountry());
        this.city = DefaultCitationNewFactory.getInstance().buildCity(copy.getCity());
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.THESIS;
    }

    @Override
    public Institute getInstitute() {
        return this.institute;
    }

    @Override
    public void setInstitute(Institute institute) {
        if (institute == null) {
            throw new IllegalArgumentException();
        }
        this.institute = institute;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        if (country == null) {
            throw new IllegalArgumentException();
        }
        this.country = country;
    }

    @Override
    public City getCity() {
        return this.city;
    }

    @Override
    public void setCity(City city) {
        if (city == null) {
            throw new IllegalArgumentException();
        }
        this.city = city;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ThesisImpl thesis = (ThesisImpl)o;
        if (this.city != null ? !this.city.equals(thesis.city) : thesis.city != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(thesis.country) : thesis.country != null) {
            return false;
        }
        return !(this.institute != null ? !this.institute.equals(thesis.institute) : thesis.institute != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.institute != null ? this.institute.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ThesisImpl{institute=" + this.institute + ", country=" + this.country + ", city=" + this.city + '}';
    }
}

