/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Locator;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.CitationImpl;

public class ElectronicArticleImpl
extends CitationImpl
implements ElectronicArticle {
    private Locator locator;
    private JournalName journalName;

    public ElectronicArticleImpl() {
        super(CitationTypeEnum.ELECTRONIC_ARTICLE);
        this.locator = DefaultCitationNewFactory.getInstance().buildLocator();
        this.journalName = DefaultCitationNewFactory.getInstance().buildJournalName();
    }

    public ElectronicArticleImpl(ElectronicArticle copy) {
        super(copy);
        this.locator = DefaultCitationNewFactory.getInstance().buildLocator(copy.getLocator());
        this.journalName = DefaultCitationNewFactory.getInstance().buildJournalName(copy.getJournalName());
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.ELECTRONIC_ARTICLE;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setLocator(Locator locator) {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        this.locator = locator;
    }

    @Override
    public JournalName getJournalName() {
        return this.journalName;
    }

    @Override
    public void setJournalName(JournalName journalName) {
        if (journalName == null) {
            throw new IllegalArgumentException();
        }
        this.journalName = journalName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElectronicArticleImpl that = (ElectronicArticleImpl)o;
        if (this.journalName != null ? !this.journalName.equals(that.journalName) : that.journalName != null) {
            return false;
        }
        return !(this.locator != null ? !this.locator.equals(that.locator) : that.locator != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.locator != null ? this.locator.hashCode() : 0);
        result = 31 * result + (this.journalName != null ? this.journalName.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ElectronicArticleImpl{locator=" + this.locator + ", journalName=" + this.journalName + '}';
    }
}

