/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class Citations
implements Serializable {
    private List<Citation> citations;

    public Citations() {
        this.citations = new ArrayList<Citation>();
    }

    public Citations(Citations copy) {
        this.citations = new NoNullElementsList<Citation>(new ArrayList());
        block9: for (Citation citation : copy.citations) {
            switch (citation.getCitationType()) {
                case JOURNAL_ARTICLE: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildJournalArticle((JournalArticle)citation));
                    continue block9;
                }
                case BOOK: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildBook((Book)citation));
                    continue block9;
                }
                case ELECTRONIC_ARTICLE: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildElectronicArticle((ElectronicArticle)citation));
                    continue block9;
                }
                case SUBMISSION: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildSubmission((Submission)citation));
                    continue block9;
                }
                case THESIS: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildThesis((Thesis)citation));
                    continue block9;
                }
                case PATENT: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildPatent((Patent)citation));
                    continue block9;
                }
                case UNPUBLISHED_OBSERVATIONS: {
                    this.citations.add(DefaultCitationNewFactory.getInstance().buildUnpublishedObservations((UnpublishedObservations)citation));
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Citation type unknown: " + (Object)((Object)citation.getCitationType()));
        }
    }

    public List<Citation> getCitations() {
        return this.citations;
    }

    public void setCitations(List<Citation> citationList) {
        this.citations = citationList;
    }

    public boolean hasCitations() {
        return this.citations != null && this.citations.size() != 0;
    }
}

