/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.DOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.MedlineId;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PubMedId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class CitationXrefsImpl
implements CitationXrefs {
    private PubMedId pubMedId;
    private MedlineId medlineId;
    private DOI doi;
    private AgricolaId agricolaId;

    public CitationXrefsImpl() {
        this.pubMedId = DefaultUniProtFactory.getNewCitationFactory().buildPubMedId();
        this.medlineId = DefaultUniProtFactory.getNewCitationFactory().buildMedlineId();
        this.doi = DefaultUniProtFactory.getNewCitationFactory().buildDOI();
        this.agricolaId = DefaultUniProtFactory.getNewCitationFactory().buildAgricolaId();
    }

    public CitationXrefsImpl(CitationXrefs copy) {
        this.pubMedId = DefaultUniProtFactory.getNewCitationFactory().buildPubMedId(copy.getPubmedId());
        this.medlineId = DefaultUniProtFactory.getNewCitationFactory().buildMedlineId(copy.getMedlineId());
        this.doi = DefaultUniProtFactory.getNewCitationFactory().buildDOI(copy.getDOI());
        this.agricolaId = DefaultUniProtFactory.getNewCitationFactory().buildAgricolaId(copy.getAgricolaId());
    }

    @Override
    public PubMedId getPubmedId() {
        return this.pubMedId;
    }

    @Override
    public MedlineId getMedlineId() {
        return this.medlineId;
    }

    @Override
    public DOI getDOI() {
        return this.doi;
    }

    @Override
    public AgricolaId getAgricolaId() {
        return this.agricolaId;
    }

    @Override
    public void setPubMedId(PubMedId pubMedId) {
        if (pubMedId == null) {
            throw new IllegalArgumentException();
        }
        this.pubMedId = pubMedId;
    }

    @Override
    public void setPubMedId(String id) {
        this.setPubMedId(DefaultUniProtFactory.getNewCitationFactory().buildPubMedId(id));
    }

    @Override
    public void setMedlineId(MedlineId medlineId) {
        if (medlineId == null) {
            throw new IllegalArgumentException();
        }
        this.medlineId = medlineId;
    }

    @Override
    public void setMedlineId(String id) {
        this.setMedlineId(DefaultUniProtFactory.getNewCitationFactory().buildMedlineId(id));
    }

    @Override
    public void setDOI(DOI doi) {
        if (doi == null) {
            throw new IllegalArgumentException();
        }
        this.doi = doi;
    }

    @Override
    public void setDOI(String id) {
        this.setDOI(DefaultUniProtFactory.getNewCitationFactory().buildDOI(id));
    }

    @Override
    public void setAgricolaId(AgricolaId agricolaId) {
        if (agricolaId == null) {
            throw new IllegalArgumentException();
        }
        this.agricolaId = agricolaId;
    }

    @Override
    public void setAgricolaId(String id) {
        this.setAgricolaId(DefaultUniProtFactory.getNewCitationFactory().buildAgricolaId(id));
    }

    @Override
    public boolean hasPubmedId() {
        return this.pubMedId != null && !this.pubMedId.getValue().equals("");
    }

    @Override
    public boolean hasMedlineId() {
        return this.medlineId != null && !this.medlineId.getValue().equals("");
    }

    @Override
    public boolean hasDOI() {
        return this.doi != null && !this.doi.getValue().equals("");
    }

    @Override
    public boolean hasAgricolaId() {
        return this.agricolaId != null && !this.agricolaId.getValue().equals("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitationXrefsImpl that = (CitationXrefsImpl)o;
        if (this.agricolaId != null ? !this.agricolaId.equals(that.agricolaId) : that.agricolaId != null) {
            return false;
        }
        if (this.doi != null ? !this.doi.equals(that.doi) : that.doi != null) {
            return false;
        }
        if (this.medlineId != null ? !this.medlineId.equals(that.medlineId) : that.medlineId != null) {
            return false;
        }
        return !(this.pubMedId != null ? !this.pubMedId.equals(that.pubMedId) : that.pubMedId != null);
    }

    public int hashCode() {
        int result = this.pubMedId != null ? this.pubMedId.hashCode() : 0;
        result = 31 * result + (this.medlineId != null ? this.medlineId.hashCode() : 0);
        result = 31 * result + (this.doi != null ? this.doi.hashCode() : 0);
        result = 31 * result + (this.agricolaId != null ? this.agricolaId.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RX   ");
        if (this.hasMedlineId()) {
            stringBuilder.append(String.format("Medline=%s; ", this.medlineId.getValue()));
        }
        if (this.hasPubmedId()) {
            stringBuilder.append(String.format("PubMed=%s; ", this.pubMedId.getValue()));
        }
        if (this.hasDOI()) {
            stringBuilder.append(String.format("DOI=%s; ", this.doi.getValue()));
        }
        if (this.hasAgricolaId()) {
            stringBuilder.append(String.format("Agricola=%s; ", this.agricolaId.getValue()));
        }
        return stringBuilder.toString().trim();
    }
}

