/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citationsNew;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationSummary;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.PublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Title;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;

public abstract class CitationImpl
implements Citation {
    protected CitationTypeEnum citationType;
    protected List<EvidenceId> evidenceIds;
    protected List<CitationSummary> citationSummaries;
    protected List<Author> authors;
    protected List<AuthoringGroup> authoringGroup;
    protected List<SampleSource> sampleSources;
    protected CitationXrefs citationXrefs;
    protected Title title;
    protected PublicationDate publicationDate;

    public CitationImpl(CitationTypeEnum citationtype) {
        this.citationType = citationtype;
        this.evidenceIds = new ArrayList<EvidenceId>();
        this.citationSummaries = new ArrayList<CitationSummary>();
        this.authors = new ArrayList<Author>();
        this.authoringGroup = new ArrayList<AuthoringGroup>();
        this.sampleSources = new ArrayList<SampleSource>();
        this.citationXrefs = DefaultCitationNewFactory.getInstance().buildCitationXrefs();
        this.title = DefaultCitationNewFactory.getInstance().buildTitle();
        this.publicationDate = DefaultCitationNewFactory.getInstance().buildPublicationDate();
    }

    public CitationImpl(Citation copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.citationType = copy.getCitationType();
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
        this.citationSummaries = new ArrayList<CitationSummary>();
        for (CitationSummary citationSummary : copy.getCitationSummary()) {
            this.citationSummaries.add(DefaultCitationNewFactory.getInstance().buildCitationSummary(citationSummary));
        }
        this.authors = new ArrayList<Author>();
        for (Author author : copy.getAuthors()) {
            this.authors.add(DefaultCitationNewFactory.getInstance().buildAuthor(author));
        }
        this.authoringGroup = new ArrayList<AuthoringGroup>();
        for (AuthoringGroup authoringGroup : copy.getAuthoringGroup()) {
            this.authoringGroup.add(DefaultCitationNewFactory.getInstance().buildAuthoringGroup(authoringGroup));
        }
        this.sampleSources = new ArrayList<SampleSource>();
        for (SampleSource source : copy.getSampleSources()) {
            this.sampleSources.add(DefaultCitationNewFactory.getInstance().buildSampleSource(source));
        }
        this.citationXrefs = DefaultCitationNewFactory.getInstance().buildCitationXrefs(copy.getCitationXrefs());
        this.title = DefaultCitationNewFactory.getInstance().buildTitle(copy.getTitle());
        this.publicationDate = DefaultCitationNewFactory.getInstance().buildPublicationDate(copy.getPublicationDate());
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIdList) {
        this.evidenceIds = evidenceIdList;
    }

    @Override
    public List<SampleSource> getSampleSources() {
        return this.sampleSources;
    }

    @Override
    public List<SampleSource> getSampleSources(SampleSourceType sampleSourceType) {
        ArrayList<SampleSource> sampleSourceList = new ArrayList<SampleSource>();
        for (SampleSource source : this.sampleSources) {
            if (!source.getType().equals((Object)sampleSourceType)) continue;
            sampleSourceList.add(source);
        }
        return sampleSourceList;
    }

    @Override
    public void setSampleSources(List<SampleSource> sampleSources) {
        if (sampleSources == null) {
            throw new IllegalArgumentException();
        }
        this.sampleSources = sampleSources;
    }

    @Override
    public boolean hasCitationXrefs() {
        return this.citationXrefs.hasDOI() || this.citationXrefs.hasAgricolaId() || this.citationXrefs.hasMedlineId() || this.citationXrefs.hasPubmedId();
    }

    @Override
    public CitationXrefs getCitationXrefs() {
        return this.citationXrefs;
    }

    @Override
    public void setCitationsXrefs(CitationXrefs citationsXrefs) {
        if (citationsXrefs == null) {
            throw new IllegalArgumentException();
        }
        this.citationXrefs = citationsXrefs;
    }

    @Override
    public List<CitationSummary> getCitationSummary() {
        return this.citationSummaries;
    }

    @Override
    public void setCitationSummary(List<CitationSummary> citationSummaryList) {
        if (citationSummaryList == null) {
            throw new IllegalArgumentException();
        }
        this.citationSummaries = citationSummaryList;
    }

    @Override
    public void setCitationSummary(CitationSummary citationSummary) {
        if (citationSummary == null) {
            throw new IllegalArgumentException();
        }
        this.citationSummaries.add(citationSummary);
    }

    @Override
    public List<AuthoringGroup> getAuthoringGroup() {
        return this.authoringGroup;
    }

    @Override
    public void setAuthoringGroup(List<AuthoringGroup> authorGroupList) {
        this.authoringGroup = authorGroupList;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public void setAuthors(List<Author> authorList) {
        this.authors = authorList;
    }

    @Override
    public abstract CitationTypeEnum getCitationType();

    @Override
    public Title getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Title title) {
        this.title = title;
    }

    @Override
    public void setTitle(String title) {
        this.setTitle(DefaultCitationNewFactory.getInstance().buildTitle(title));
    }

    @Override
    public boolean hasTitle() {
        if (this.title == null) {
            return false;
        }
        return !this.title.getValue().equals("-.");
    }

    @Override
    public PublicationDate getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public void setPublicationDate(PublicationDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitationImpl citation = (CitationImpl)o;
        if (this.authoringGroup != null ? !((Object)this.authoringGroup).equals(citation.authoringGroup) : citation.authoringGroup != null) {
            return false;
        }
        if (this.authors != null ? !((Object)this.authors).equals(citation.authors) : citation.authors != null) {
            return false;
        }
        if (this.citationSummaries != null ? !((Object)this.citationSummaries).equals(citation.citationSummaries) : citation.citationSummaries != null) {
            return false;
        }
        if (this.citationType != citation.citationType) {
            return false;
        }
        if (this.citationXrefs != null ? !this.citationXrefs.equals(citation.citationXrefs) : citation.citationXrefs != null) {
            return false;
        }
        if (this.evidenceIds != null ? !((Object)this.evidenceIds).equals(citation.evidenceIds) : citation.evidenceIds != null) {
            return false;
        }
        if (this.publicationDate != null ? !this.publicationDate.equals(citation.publicationDate) : citation.publicationDate != null) {
            return false;
        }
        if (this.sampleSources != null ? !((Object)this.sampleSources).equals(citation.sampleSources) : citation.sampleSources != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(citation.title) : citation.title != null);
    }

    public int hashCode() {
        int result = this.citationType != null ? this.citationType.hashCode() : 0;
        result = 31 * result + (this.evidenceIds != null ? ((Object)this.evidenceIds).hashCode() : 0);
        result = 31 * result + (this.citationSummaries != null ? ((Object)this.citationSummaries).hashCode() : 0);
        result = 31 * result + (this.authors != null ? ((Object)this.authors).hashCode() : 0);
        result = 31 * result + (this.authoringGroup != null ? ((Object)this.authoringGroup).hashCode() : 0);
        result = 31 * result + (this.sampleSources != null ? ((Object)this.sampleSources).hashCode() : 0);
        result = 31 * result + (this.citationXrefs != null ? this.citationXrefs.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.publicationDate != null ? this.publicationDate.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CitationImpl{citationType=" + (Object)((Object)this.citationType) + ", evidenceIds=" + this.evidenceIds + ", citationSummaries=" + this.citationSummaries + ", authors=" + this.authors + ", authoringGroup=" + this.authoringGroup + ", sampleSources=" + this.sampleSources + ", citationXrefs=" + this.citationXrefs + ", title=" + this.title + ", publicationDate=" + this.publicationDate + '}';
    }
}

