/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citations;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.AgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.BookName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Country;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.DOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Institute;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Locator;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.MedlineId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PatentNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PubMedId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Publisher;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequencingExperiment;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Title;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedResults;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Volume;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCitationFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

@Deprecated
public abstract class CitationAbstr
implements PersistentObject,
Citation {
    private List<EvidenceId> evidenceIds;
    private long id;
    private List<Author> authors = new ArrayList<Author>();
    private AuthoringGroup authoringGroup = DefaultUniProtFactory.getCitationFactory().buildAuthoringGroup();
    private BookName bookName = DefaultUniProtFactory.getCitationFactory().buildBookName();
    private City city = DefaultUniProtFactory.getCitationFactory().buildCity();
    private Country country = DefaultUniProtFactory.getCitationFactory().buildCountry();
    private SubmissionDatabase submissionDatabase = SubmissionDatabase.UNKNOWN;
    private DOI dOI = DefaultUniProtFactory.getCitationFactory().buildDOI();
    private List<Editor> editors = new NoNullElementsList<Editor>(new ArrayList());
    private Institute institute = DefaultUniProtFactory.getCitationFactory().buildInstitute();
    private JournalName journalName = DefaultUniProtFactory.getCitationFactory().buildJournalName();
    private Locator locator = DefaultUniProtFactory.getCitationFactory().buildLocator();
    private MedlineId medLineId = DefaultUniProtFactory.getCitationFactory().buildMedlineId();
    private AgricolaId agricolaId = DefaultUniProtFactory.getCitationFactory().buildAgricolaId();
    private Page firstPage = DefaultUniProtFactory.getCitationFactory().buildPage();
    private Page lastPage = DefaultUniProtFactory.getCitationFactory().buildPage();
    private PatentNumber patentNumber = DefaultUniProtFactory.getCitationFactory().buildPatentNumber();
    private Volume volume = DefaultUniProtFactory.getCitationFactory().buildVolume();
    private Publisher publisher = DefaultUniProtFactory.getCitationFactory().buildPublisher();
    private Citation referingCitation;
    private PubMedId pubMedId = DefaultUniProtFactory.getCitationFactory().buildPubMedId();
    private Title title = DefaultUniProtFactory.getCitationFactory().buildTitle();
    private PublicationDate publicationDate = DefaultUniProtFactory.getCitationFactory().buildPublicationDate();
    private List<SequenceSampleSource> sequenceSampleSources = new ArrayList<SequenceSampleSource>();
    private List<SequencingExperiment> sequencingExperiments = new ArrayList<SequencingExperiment>();

    public CitationAbstr() {
    }

    public CitationAbstr(UnpublishedResults copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        if (copy.getReferringCitation() != null) {
            this.referingCitation = DefaultCitationFactory.getInstance().buildCitation(copy.getReferringCitation());
        }
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(Book copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.bookName.setValue(copy.getBookName().getValue());
        this.city.setValue(copy.getCity().getValue());
        this.firstPage.setValue(copy.getFirstPage().getValue());
        this.lastPage.setValue(copy.getLastPage().getValue());
        this.volume.setValue(copy.getVolume().getValue());
        this.publisher.setValue(copy.getPublisher().getValue());
        this.title.setValue(copy.getTitle().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Editor ed : copy.getEditors()) {
            this.editors.add(ed);
        }
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(JournalArticle copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.dOI.setValue(copy.getDOI().getValue());
        this.journalName.setValue(copy.getJournalName().getValue());
        this.medLineId.setValue(copy.getMedlineId().getValue());
        this.agricolaId.setValue(copy.getAgricolaId().getValue());
        this.firstPage.setValue(copy.getFirstPage().getValue());
        this.lastPage.setValue(copy.getLastPage().getValue());
        this.volume.setValue(copy.getVolume().getValue());
        this.pubMedId.setValue(copy.getPubMedId().getValue());
        this.title.setValue(copy.getTitle().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(ElectronicArticle copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.dOI.setValue(copy.getDOI().getValue());
        this.journalName.setValue(copy.getJournalName().getValue());
        this.locator.setValue(copy.getLocator().getValue());
        this.medLineId.setValue(copy.getMedlineId().getValue());
        this.pubMedId.setValue(copy.getPubMedId().getValue());
        this.title.setValue(copy.getTitle().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(Patent copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.patentNumber.setValue(copy.getPatentNumber().getValue());
        this.title.setValue(copy.getTitle().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(Thesis copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.country.setValue(copy.getCountry().getValue());
        this.institute.setValue(copy.getInstitute().getValue());
        this.title.setValue(copy.getTitle().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(UnpublishedObservations copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public CitationAbstr(Submission copy) {
        this();
        this.authoringGroup.setValue(copy.getAuthoringGroup().getValue());
        this.submissionDatabase = copy.getSubmittedToDatabase();
        this.title.setValue(copy.getTitle().getValue());
        this.publicationDate.setValue(copy.getPublicationDate().getValue());
        for (Author auth : copy.getAuthors()) {
            this.authors.add(auth);
        }
        for (SequenceSampleSource source : copy.getSequenceSampleSources()) {
            this.sequenceSampleSources.add(source);
        }
        for (SequencingExperiment exp : copy.getSequencingExperiments()) {
            this.sequencingExperiments.add(exp);
        }
        this.copyEvidences(copy);
    }

    public void reset() {
        this.authors = new NoNullElementsList<Author>(new ArrayList());
        this.authoringGroup = DefaultUniProtFactory.getCitationFactory().buildAuthoringGroup();
        this.bookName = DefaultUniProtFactory.getCitationFactory().buildBookName();
        this.city = DefaultUniProtFactory.getCitationFactory().buildCity();
        this.country = DefaultUniProtFactory.getCitationFactory().buildCountry();
        this.submissionDatabase = SubmissionDatabase.UNKNOWN;
        this.dOI = DefaultUniProtFactory.getCitationFactory().buildDOI();
        this.editors = new NoNullElementsList<Editor>(new ArrayList());
        this.institute = DefaultUniProtFactory.getCitationFactory().buildInstitute();
        this.journalName = DefaultUniProtFactory.getCitationFactory().buildJournalName();
        this.locator = DefaultUniProtFactory.getCitationFactory().buildLocator();
        this.medLineId = DefaultUniProtFactory.getCitationFactory().buildMedlineId();
        this.agricolaId = DefaultUniProtFactory.getCitationFactory().buildAgricolaId();
        this.firstPage = DefaultUniProtFactory.getCitationFactory().buildPage();
        this.lastPage = DefaultUniProtFactory.getCitationFactory().buildPage();
        this.patentNumber = DefaultUniProtFactory.getCitationFactory().buildPatentNumber();
        this.volume = DefaultUniProtFactory.getCitationFactory().buildVolume();
        this.publisher = DefaultUniProtFactory.getCitationFactory().buildPublisher();
        this.pubMedId = DefaultUniProtFactory.getCitationFactory().buildPubMedId();
        this.title = DefaultUniProtFactory.getCitationFactory().buildTitle();
        this.publicationDate = DefaultUniProtFactory.getCitationFactory().buildPublicationDate();
        this.sequenceSampleSources = new NoNullElementsList<SequenceSampleSource>(new ArrayList());
        this.sequencingExperiments = new NoNullElementsList<SequencingExperiment>(new ArrayList());
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.LITERATURE_EXPERIMENTS})
    public List<SequencingExperiment> getSequencingExperiments() {
        return this.sequencingExperiments;
    }

    @Override
    public void setSequencingExperiments(List<SequencingExperiment> sequencingExperiments) {
        if (sequencingExperiments == null) {
            throw new IllegalArgumentException();
        }
        this.sequencingExperiments = sequencingExperiments;
    }

    @Override
    @IndexThisField(fieldName={IndexField.LITERATURE_SAMPLE_SOURCE}, helperClass="uk.ac.ebi.kraken.ffwriter.RCLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSource")
    public List<SequenceSampleSource> getSequenceSampleSources() {
        return this.sequenceSampleSources;
    }

    @Override
    public List<SequenceSampleSource> getSequenceSampleSources(SequenceSampleSourceType type) {
        ArrayList<SequenceSampleSource> ret = new ArrayList<SequenceSampleSource>();
        for (SequenceSampleSource source : this.sequenceSampleSources) {
            if (!source.getType().equals((Object)type)) continue;
            ret.add(source);
        }
        return ret;
    }

    @Override
    public void setSequenceSampleSources(List<SequenceSampleSource> sequenceSampleSources) {
        if (sequenceSampleSources == null) {
            throw new IllegalArgumentException();
        }
        this.sequenceSampleSources = sequenceSampleSources;
    }

    @Override
    public abstract CitationTypeEnum getCitationType();

    public boolean hasAuthorNames() {
        return this.authors != null && !this.authors.isEmpty();
    }

    @IndexThisField(fieldName={IndexField.LITERATURE_AUTHORS})
    public List<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<Author> authors) {
        if (authors == null) {
            throw new IllegalArgumentException();
        }
        this.authors = authors;
    }

    public boolean hasAuthoringGroupName() {
        return this.authoringGroup != null && this.authoringGroup.getValue().trim().length() > 0;
    }

    public AuthoringGroup getAuthoringGroup() {
        return this.authoringGroup;
    }

    public void setAuthoringGroup(AuthoringGroup authoringGroup) {
        if (authoringGroup == null) {
            throw new IllegalArgumentException();
        }
        this.authoringGroup = authoringGroup;
    }

    public BookName getBookName() {
        return this.bookName;
    }

    public void setBookName(BookName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.bookName = name;
    }

    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        if (city == null) {
            throw new IllegalArgumentException();
        }
        this.city = city;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        if (country == null) {
            throw new IllegalArgumentException();
        }
        this.country = country;
    }

    public SubmissionDatabase getSubmittedToDatabase() {
        return this.submissionDatabase;
    }

    public void setSubmittedToDatabase(SubmissionDatabase name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.submissionDatabase = name;
    }

    public DOI getDOI() {
        return this.dOI;
    }

    public void setDOI(DOI doi) {
        if (doi == null) {
            throw new IllegalArgumentException();
        }
        this.dOI = doi;
    }

    public void setDOI(String id) {
        this.setDOI(DefaultUniProtFactory.getCitationFactory().buildDOI(id));
    }

    public List<Editor> getEditors() {
        return this.editors;
    }

    public void setEditors(List<Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException();
        }
        this.editors = editors;
    }

    public void setInstitute(Institute institute) {
        if (institute == null) {
            throw new IllegalArgumentException();
        }
        this.institute = institute;
    }

    public Institute getInstitute() {
        return this.institute;
    }

    public JournalName getJournalName() {
        return this.journalName;
    }

    public void setJournalName(JournalName journalName) {
        if (journalName == null) {
            throw new IllegalArgumentException();
        }
        this.journalName = journalName;
    }

    public void setJournalName(String journalName) {
        this.setJournalName(DefaultCitationFactory.getInstance().buildJournalName(journalName));
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void setLocator(Locator locator) {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        this.locator = locator;
    }

    public void setLocator(String locator) {
        this.setLocator(DefaultCitationFactory.getInstance().buildLocator(locator));
    }

    @IndexThisField(fieldName={IndexField.LITERATURE_MEDLINE})
    public MedlineId getMedlineId() {
        return this.medLineId;
    }

    public void setMedlineId(MedlineId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.medLineId = id;
    }

    public void setMedlineId(String id) {
        this.setMedlineId(DefaultUniProtFactory.getCitationFactory().buildMedlineId(id));
    }

    public AgricolaId getAgricolaId() {
        return this.agricolaId;
    }

    public void setAgricolaId(AgricolaId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.agricolaId = id;
    }

    public void setAgricolaId(String id) {
        this.setAgricolaId(DefaultUniProtFactory.getCitationFactory().buildAgricolaId(id));
    }

    public Page getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.firstPage = page;
    }

    public void setFirstPage(String page) {
        this.setFirstPage(DefaultCitationFactory.getInstance().buildPage(page));
    }

    public Page getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.lastPage = page;
    }

    public void setLastPage(String page) {
        this.setLastPage(DefaultCitationFactory.getInstance().buildPage(page));
    }

    public PatentNumber getPatentNumber() {
        return this.patentNumber;
    }

    public void setPatentNumber(PatentNumber patentNumber) {
        if (patentNumber == null) {
            throw new IllegalArgumentException();
        }
        this.patentNumber = patentNumber;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        if (publisher == null) {
            throw new IllegalArgumentException();
        }
        this.publisher = publisher;
    }

    public boolean hasReferringCitation() {
        return this.referingCitation != null;
    }

    @NullAble
    public Citation getReferringCitation() {
        return this.referingCitation;
    }

    @NullAble
    public void setReferringCitation(Citation referringCitation) {
        if (referringCitation == null) {
            throw new IllegalArgumentException();
        }
        this.referingCitation = referringCitation;
    }

    @IndexThisField(fieldName={IndexField.LITERATURE_PUBMED})
    public PubMedId getPubMedId() {
        return this.pubMedId;
    }

    public void setPubMedId(PubMedId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.pubMedId = id;
    }

    public void setPubMedId(String id) {
        this.setPubMedId(DefaultUniProtFactory.getCitationFactory().buildPubMedId(id));
    }

    public Title getTitle() {
        return this.title;
    }

    public void setTitle(Title title) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.title = title;
    }

    public void setTitle(String title) {
        this.setTitle(DefaultCitationFactory.getInstance().buildTitle(title));
    }

    public Volume getVolume() {
        return this.volume;
    }

    public void setVolume(Volume volume) {
        if (volume == null) {
            throw new IllegalArgumentException();
        }
        this.volume = volume;
    }

    public void setVolume(String volume) {
        this.setVolume(DefaultCitationFactory.getInstance().buildVolume(volume));
    }

    public void setPublicationDate(PublicationDate date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.publicationDate = date;
    }

    @IndexThisField(fieldName={IndexField.LITERATURE_YEAR})
    public PublicationDate getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidenceIds = evidences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CitationAbstr that = (CitationAbstr)o;
        if (!this.getCitationType().equals((Object)that.getCitationType())) {
            return false;
        }
        if (this.authoringGroup != null ? !this.authoringGroup.equals(that.authoringGroup) : that.authoringGroup != null) {
            return false;
        }
        if (this.authors != null ? !((Object)this.authors).equals(that.authors) : that.authors != null) {
            return false;
        }
        if (this.bookName != null ? !this.bookName.equals(that.bookName) : that.bookName != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(that.city) : that.city != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals(that.country) : that.country != null) {
            return false;
        }
        if (this.dOI != null ? !this.dOI.equals(that.dOI) : that.dOI != null) {
            return false;
        }
        if (this.editors != null ? !((Object)this.editors).equals(that.editors) : that.editors != null) {
            return false;
        }
        if (this.firstPage != null ? !this.firstPage.equals(that.firstPage) : that.firstPage != null) {
            return false;
        }
        if (this.institute != null ? !this.institute.equals(that.institute) : that.institute != null) {
            return false;
        }
        if (this.journalName != null ? !this.journalName.equals(that.journalName) : that.journalName != null) {
            return false;
        }
        if (this.lastPage != null ? !this.lastPage.equals(that.lastPage) : that.lastPage != null) {
            return false;
        }
        if (this.locator != null ? !this.locator.equals(that.locator) : that.locator != null) {
            return false;
        }
        if (this.medLineId != null ? !this.medLineId.equals(that.medLineId) : that.medLineId != null) {
            return false;
        }
        if (this.agricolaId != null ? !this.agricolaId.equals(that.agricolaId) : that.agricolaId != null) {
            return false;
        }
        if (this.patentNumber != null ? !this.patentNumber.equals(that.patentNumber) : that.patentNumber != null) {
            return false;
        }
        if (this.pubMedId != null ? !this.pubMedId.equals(that.pubMedId) : that.pubMedId != null) {
            return false;
        }
        if (this.publicationDate != null ? !this.publicationDate.equals(that.publicationDate) : that.publicationDate != null) {
            return false;
        }
        if (this.publisher != null ? !this.publisher.equals(that.publisher) : that.publisher != null) {
            return false;
        }
        if (this.referingCitation != null ? !this.referingCitation.equals(that.referingCitation) : that.referingCitation != null) {
            return false;
        }
        if (this.sequenceSampleSources != null ? !((Object)this.sequenceSampleSources).equals(that.sequenceSampleSources) : that.sequenceSampleSources != null) {
            return false;
        }
        if (this.sequencingExperiments != null ? !((Object)this.sequencingExperiments).equals(that.sequencingExperiments) : that.sequencingExperiments != null) {
            return false;
        }
        if (this.submissionDatabase != that.submissionDatabase) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.volume != null ? !this.volume.equals(that.volume) : that.volume != null) {
            return false;
        }
        return !(this.evidenceIds != null && this.evidenceIds.size() > 0 ? !((Object)this.evidenceIds).equals(that.evidenceIds) : that.evidenceIds != null && that.evidenceIds.size() > 0);
    }

    public int hashCode() {
        int result = this.authors != null ? ((Object)this.authors).hashCode() : 0;
        result = 29 * result + this.getCitationType().hashCode();
        result = 29 * result + (this.authoringGroup != null ? this.authoringGroup.hashCode() : 0);
        result = 29 * result + (this.bookName != null ? this.bookName.hashCode() : 0);
        result = 29 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 29 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 29 * result + (this.submissionDatabase != null ? this.submissionDatabase.hashCode() : 0);
        result = 29 * result + (this.dOI != null ? this.dOI.hashCode() : 0);
        result = 29 * result + (this.editors != null ? ((Object)this.editors).hashCode() : 0);
        result = 29 * result + (this.institute != null ? this.institute.hashCode() : 0);
        result = 29 * result + (this.journalName != null ? this.journalName.hashCode() : 0);
        result = 29 * result + (this.locator != null ? this.locator.hashCode() : 0);
        result = 29 * result + (this.medLineId != null ? this.medLineId.hashCode() : 0);
        result = 29 * result + (this.agricolaId != null ? this.agricolaId.hashCode() : 0);
        result = 29 * result + (this.firstPage != null ? this.firstPage.hashCode() : 0);
        result = 29 * result + (this.lastPage != null ? this.lastPage.hashCode() : 0);
        result = 29 * result + (this.patentNumber != null ? this.patentNumber.hashCode() : 0);
        result = 29 * result + (this.volume != null ? this.volume.hashCode() : 0);
        result = 29 * result + (this.publisher != null ? this.publisher.hashCode() : 0);
        result = 29 * result + (this.referingCitation != null ? this.referingCitation.hashCode() : 0);
        result = 29 * result + (this.pubMedId != null ? this.pubMedId.hashCode() : 0);
        result = 29 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 29 * result + (this.publicationDate != null ? this.publicationDate.hashCode() : 0);
        result = 29 * result + (this.sequenceSampleSources != null ? ((Object)this.sequenceSampleSources).hashCode() : 0);
        result = 29 * result + (this.sequencingExperiments != null ? ((Object)this.sequencingExperiments).hashCode() : 0);
        result = 29 * result + (this.evidenceIds != null && this.evidenceIds.size() > 0 ? ((Object)this.evidenceIds).hashCode() : 0);
        return result;
    }

    private void copyEvidences(Citation copy) {
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    public String toString() {
        return this.getClass().getName() + "{" + "authoringGroup=" + this.authoringGroup + ", evidenceIds=" + this.evidenceIds + ", id=" + this.id + ", authors=" + this.authors + ", bookName=" + this.bookName + ", city=" + this.city + ", country=" + this.country + ", submissionDatabase=" + (Object)((Object)this.submissionDatabase) + ", dOI=" + this.dOI + ", editors=" + this.editors + ", institute=" + this.institute + ", journalName=" + this.journalName + ", locator=" + this.locator + ", medLineId=" + this.medLineId + ", agricolaId=" + this.agricolaId + ", firstPage=" + this.firstPage + ", lastPage=" + this.lastPage + ", patentNumber=" + this.patentNumber + ", volume=" + this.volume + ", publisher=" + this.publisher + ", referingCitation=" + this.referingCitation + ", pubMedId=" + this.pubMedId + ", title=" + this.title + ", publicationDate=" + this.publicationDate + ", sequenceSampleSources=" + this.sequenceSampleSources + ", sequencingExperiments=" + this.sequencingExperiments + '}';
    }
}

