/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.citations;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.AgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.BookName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.City;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Country;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.DOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasAgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasAuthors;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasBookName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasCity;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasCountry;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasDOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasDatabaseName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasEditors;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasInstitute;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasJournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasLocator;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasMedlineId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPages;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPatentNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPubMedId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPublisher;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasReferringCitation;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasTitle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasVolume;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Institute;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Locator;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.MedlineId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Page;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PatentNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PubMedId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.PublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Publisher;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequencingExperiment;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Title;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedResults;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Volume;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCitationFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

@Deprecated
public class AllroundCitation
implements Citation,
HasTitle,
HasAuthors,
HasBookName,
HasCity,
HasCountry,
HasDatabaseName,
HasDOI,
HasEditors,
HasInstitute,
HasJournalName,
HasLocator,
HasMedlineId,
HasPages,
HasPatentNumber,
HasPublisher,
HasReferringCitation,
HasPubMedId,
HasVolume,
HasAgricolaId {
    private List<Author> authors = new ArrayList<Author>();
    private AuthoringGroup authoringGroup = DefaultUniProtFactory.getCitationFactory().buildAuthoringGroup();
    private BookName bookName = DefaultUniProtFactory.getCitationFactory().buildBookName();
    private City city = DefaultUniProtFactory.getCitationFactory().buildCity();
    private Country country = DefaultUniProtFactory.getCitationFactory().buildCountry();
    private SubmissionDatabase submissionDatabase = SubmissionDatabase.UNKNOWN;
    private DOI dOI = DefaultUniProtFactory.getCitationFactory().buildDOI();
    private AgricolaId agricolaId = DefaultUniProtFactory.getCitationFactory().buildAgricolaId();
    private List<Editor> editors = new ArrayList<Editor>();
    private Institute institute = DefaultUniProtFactory.getCitationFactory().buildInstitute();
    private JournalName journalName = DefaultUniProtFactory.getCitationFactory().buildJournalName();
    private Locator locator = DefaultUniProtFactory.getCitationFactory().buildLocator();
    private MedlineId medLineId = DefaultUniProtFactory.getCitationFactory().buildMedlineId();
    private Page firstPage = DefaultUniProtFactory.getCitationFactory().buildPage();
    private Page lastPage = DefaultUniProtFactory.getCitationFactory().buildPage();
    private PatentNumber patentNumber = DefaultUniProtFactory.getCitationFactory().buildPatentNumber();
    private Volume volume = DefaultUniProtFactory.getCitationFactory().buildVolume();
    private Publisher publisher = DefaultUniProtFactory.getCitationFactory().buildPublisher();
    private Citation referingCitation;
    private PubMedId pubMedId = DefaultUniProtFactory.getCitationFactory().buildPubMedId();
    private Title title = DefaultUniProtFactory.getCitationFactory().buildTitle();
    private PublicationDate publicationDate = DefaultUniProtFactory.getCitationFactory().buildPublicationDate();
    private List<SequenceSampleSource> sequenceSampleSources = new ArrayList<SequenceSampleSource>();
    private List<SequencingExperiment> sequencingExperiments = new ArrayList<SequencingExperiment>();
    private List<EvidenceId> evidenceIds;

    public void reset() {
        this.authors = new NoNullElementsList<Author>(new ArrayList());
        this.authoringGroup = DefaultUniProtFactory.getCitationFactory().buildAuthoringGroup();
        this.bookName = DefaultUniProtFactory.getCitationFactory().buildBookName();
        this.city = DefaultUniProtFactory.getCitationFactory().buildCity();
        this.country = DefaultUniProtFactory.getCitationFactory().buildCountry();
        this.submissionDatabase = SubmissionDatabase.UNKNOWN;
        this.dOI = DefaultUniProtFactory.getCitationFactory().buildDOI();
        this.agricolaId = DefaultUniProtFactory.getCitationFactory().buildAgricolaId();
        this.editors = new NoNullElementsList<Editor>(new ArrayList());
        this.institute = DefaultUniProtFactory.getCitationFactory().buildInstitute();
        this.journalName = DefaultUniProtFactory.getCitationFactory().buildJournalName();
        this.locator = DefaultUniProtFactory.getCitationFactory().buildLocator();
        this.medLineId = DefaultUniProtFactory.getCitationFactory().buildMedlineId();
        this.firstPage = DefaultUniProtFactory.getCitationFactory().buildPage();
        this.lastPage = DefaultUniProtFactory.getCitationFactory().buildPage();
        this.patentNumber = DefaultUniProtFactory.getCitationFactory().buildPatentNumber();
        this.volume = DefaultUniProtFactory.getCitationFactory().buildVolume();
        this.publisher = DefaultUniProtFactory.getCitationFactory().buildPublisher();
        this.pubMedId = DefaultUniProtFactory.getCitationFactory().buildPubMedId();
        this.title = DefaultUniProtFactory.getCitationFactory().buildTitle();
        this.publicationDate = DefaultUniProtFactory.getCitationFactory().buildPublicationDate();
        this.sequenceSampleSources = new ArrayList<SequenceSampleSource>();
        this.sequencingExperiments = new ArrayList<SequencingExperiment>();
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    @Override
    public List<SequencingExperiment> getSequencingExperiments() {
        return this.sequencingExperiments;
    }

    @Override
    public void setSequencingExperiments(List<SequencingExperiment> sequencingExperiments) {
        if (sequencingExperiments == null) {
            throw new IllegalArgumentException();
        }
        this.sequencingExperiments = sequencingExperiments;
    }

    @Override
    public List<SequenceSampleSource> getSequenceSampleSources() {
        return this.sequenceSampleSources;
    }

    @Override
    public List<SequenceSampleSource> getSequenceSampleSources(SequenceSampleSourceType type) {
        ArrayList<SequenceSampleSource> ret = new ArrayList<SequenceSampleSource>();
        for (SequenceSampleSource source : this.sequenceSampleSources) {
            if (!source.getType().equals((Object)type)) continue;
            ret.add(source);
        }
        return ret;
    }

    @Override
    public void setSequenceSampleSources(List<SequenceSampleSource> sequenceSampleSources) {
        if (sequenceSampleSources == null) {
            throw new IllegalArgumentException();
        }
        this.sequenceSampleSources = sequenceSampleSources;
    }

    @Override
    public CitationTypeEnum getCitationType() {
        return CitationTypeEnum.UNKNOWN;
    }

    @Override
    public boolean hasAuthorNames() {
        return this.authors != null;
    }

    @Override
    public List<Author> getAuthors() {
        return this.authors;
    }

    @Override
    public void setAuthors(List<Author> authors) {
        if (authors == null) {
            throw new IllegalArgumentException();
        }
        this.authors = authors;
    }

    @Override
    public boolean hasAuthoringGroupName() {
        return this.authoringGroup != null;
    }

    @Override
    public AuthoringGroup getAuthoringGroup() {
        return this.authoringGroup;
    }

    @Override
    public void setAuthoringGroup(AuthoringGroup authoringGroup) {
        if (authoringGroup == null) {
            throw new IllegalArgumentException();
        }
        this.authoringGroup = authoringGroup;
    }

    @Override
    public BookName getBookName() {
        return this.bookName;
    }

    @Override
    public void setBookName(BookName name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.bookName = name;
    }

    @Override
    public City getCity() {
        return this.city;
    }

    @Override
    public void setCity(City city) {
        if (city == null) {
            throw new IllegalArgumentException();
        }
        this.city = city;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        if (country == null) {
            throw new IllegalArgumentException();
        }
        this.country = country;
    }

    @Override
    public SubmissionDatabase getSubmittedToDatabase() {
        return this.submissionDatabase;
    }

    @Override
    public void setSubmittedToDatabase(SubmissionDatabase name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.submissionDatabase = name;
    }

    @Override
    public DOI getDOI() {
        return this.dOI;
    }

    @Override
    public void setDOI(DOI doi) {
        if (doi == null) {
            throw new IllegalArgumentException();
        }
        this.dOI = doi;
    }

    public void setDOI(String id) {
        this.setDOI(DefaultUniProtFactory.getCitationFactory().buildDOI(id));
    }

    @Override
    public AgricolaId getAgricolaId() {
        return this.agricolaId;
    }

    @Override
    public void setAgricolaId(AgricolaId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.agricolaId = id;
    }

    public void setAgricolaId(String id) {
        this.setAgricolaId(DefaultUniProtFactory.getCitationFactory().buildAgricolaId(id));
    }

    @Override
    public List<Editor> getEditors() {
        return this.editors;
    }

    @Override
    public void setEditors(List<Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException();
        }
        this.editors = editors;
    }

    @Override
    public void setInstitute(Institute institute) {
        if (institute == null) {
            throw new IllegalArgumentException();
        }
        this.institute = institute;
    }

    @Override
    public Institute getInstitute() {
        return this.institute;
    }

    @Override
    public JournalName getJournalName() {
        return this.journalName;
    }

    @Override
    public void setJournalName(JournalName journalName) {
        if (journalName == null) {
            throw new IllegalArgumentException();
        }
        this.journalName = journalName;
    }

    public void setJournalName(String journalName) {
        this.setJournalName(DefaultCitationFactory.getInstance().buildJournalName(journalName));
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    @Override
    public void setLocator(Locator locator) {
        if (locator == null) {
            throw new IllegalArgumentException();
        }
        this.locator = locator;
    }

    public void setLocator(String locator) {
        this.setLocator(DefaultCitationFactory.getInstance().buildLocator(locator));
    }

    @Override
    public MedlineId getMedlineId() {
        return this.medLineId;
    }

    @Override
    public void setMedlineId(MedlineId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.medLineId = id;
    }

    public void setMedlineId(String id) {
        this.setMedlineId(DefaultUniProtFactory.getCitationFactory().buildMedlineId(id));
    }

    @Override
    public Page getFirstPage() {
        return this.firstPage;
    }

    @Override
    public void setFirstPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.firstPage = page;
    }

    public void setFirstPage(String page) {
        this.setFirstPage(DefaultCitationFactory.getInstance().buildPage(page));
    }

    @Override
    public Page getLastPage() {
        return this.lastPage;
    }

    @Override
    public void setLastPage(Page page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.lastPage = page;
    }

    public void setLastPage(String page) {
        this.setLastPage(DefaultCitationFactory.getInstance().buildPage(page));
    }

    @Override
    public PatentNumber getPatentNumber() {
        return this.patentNumber;
    }

    @Override
    public void setPatentNumber(PatentNumber patentNumber) {
        if (patentNumber == null) {
            throw new IllegalArgumentException();
        }
        this.patentNumber = patentNumber;
    }

    @Override
    public Publisher getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(Publisher publisher) {
        if (publisher == null) {
            throw new IllegalArgumentException();
        }
        this.publisher = publisher;
    }

    public boolean hasReferringCitation() {
        return this.referingCitation != null;
    }

    @Override
    @NullAble
    public Citation getReferringCitation() {
        return this.referingCitation;
    }

    @Override
    @NullAble
    public void setReferringCitation(Citation referringCitation) {
        if (referringCitation == null) {
            throw new IllegalArgumentException();
        }
        this.referingCitation = referringCitation;
    }

    @Override
    public PubMedId getPubMedId() {
        return this.pubMedId;
    }

    @Override
    public void setPubMedId(PubMedId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.pubMedId = id;
    }

    public void setPubMedId(String id) {
        this.setPubMedId(DefaultUniProtFactory.getCitationFactory().buildPubMedId(id));
    }

    @Override
    public Title getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(Title title) {
        if (title == null) {
            throw new IllegalArgumentException();
        }
        this.title = title;
    }

    public void setTitle(String title) {
        this.setTitle(DefaultCitationFactory.getInstance().buildTitle(title));
    }

    @Override
    public Volume getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(Volume volume) {
        if (volume == null) {
            throw new IllegalArgumentException();
        }
        this.volume = volume;
    }

    public void setVolume(String volume) {
        this.setVolume(DefaultCitationFactory.getInstance().buildVolume(volume));
    }

    public void setPublicationDate(PublicationDate date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.publicationDate = date;
    }

    public PublicationDate getPublicationDate() {
        return this.publicationDate;
    }

    public JournalArticle toJournalArticle() {
        JournalArticle result = DefaultCitationFactory.getInstance().buildJournalArticle();
        result.setAuthors(this.getAuthors());
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setDOI(this.getDOI());
        result.setAgricolaId(this.getAgricolaId());
        result.setFirstPage(this.getFirstPage());
        result.setJournalName(this.getJournalName());
        result.setLastPage(this.getLastPage());
        result.setMedlineId(this.getMedlineId());
        result.setPubMedId(this.getPubMedId());
        result.setVolume(this.getVolume());
        result.setTitle(this.getTitle());
        result.setPublicationDate(this.getPublicationDate());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public void fromJournalArticle(JournalArticle article) {
        this.setAuthoringGroup(article.getAuthoringGroup());
        this.setAuthors(article.getAuthors());
        this.setDOI(article.getDOI());
        this.setAgricolaId(article.getAgricolaId());
        this.setFirstPage(article.getFirstPage());
        this.setLastPage(article.getLastPage());
        this.setJournalName(article.getJournalName());
        this.setMedlineId(article.getMedlineId());
        this.setPubMedId(article.getPubMedId());
        this.setVolume(article.getVolume());
        this.setTitle(article.getTitle());
        this.setPublicationDate(article.getPublicationDate());
        this.setSequenceSampleSources(article.getSequenceSampleSources());
        this.setSequencingExperiments(article.getSequencingExperiments());
        this.setEvidenceIds(article.getEvidenceIds());
    }

    public Book toBook() {
        Book result = DefaultCitationFactory.getInstance().buildBook();
        result.setAuthoringGroup(this.authoringGroup);
        result.setAuthors(this.authors);
        result.setBookName(this.bookName);
        result.setCity(this.city);
        result.setEditors(this.editors);
        result.setFirstPage(this.firstPage);
        result.setLastPage(this.lastPage);
        result.setPublisher(this.publisher);
        result.setVolume(this.volume);
        result.setTitle(this.title);
        result.setPublicationDate(this.publicationDate);
        result.setSequenceSampleSources(this.sequenceSampleSources);
        result.setSequencingExperiments(this.sequencingExperiments);
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public void fromBook(Book book) {
        this.setAuthoringGroup(book.getAuthoringGroup());
        this.setAuthors(book.getAuthors());
        this.setBookName(book.getBookName());
        this.setCity(book.getCity());
        this.setEditors(book.getEditors());
        this.setFirstPage(book.getFirstPage());
        this.setLastPage(book.getLastPage());
        this.setPublisher(book.getPublisher());
        this.setVolume(book.getVolume());
        this.setTitle(book.getTitle());
        this.setPublicationDate(book.getPublicationDate());
        this.setSequenceSampleSources(book.getSequenceSampleSources());
        this.setSequencingExperiments(book.getSequencingExperiments());
        this.setEvidenceIds(book.getEvidenceIds());
    }

    public ElectronicArticle toElectronicArticle() {
        ElectronicArticle result = DefaultCitationFactory.getInstance().buildElectronicArticle();
        result.setDOI(this.getDOI());
        result.setJournalName(this.getJournalName());
        result.setMedlineId(this.getMedlineId());
        result.setPubMedId(this.getPubMedId());
        result.setLocator(this.getLocator());
        result.setTitle(this.getTitle());
        result.setAuthors(this.getAuthors());
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public Patent toPatent() {
        Patent result = DefaultCitationFactory.getInstance().buildPatent();
        result.setAuthors(this.getAuthors());
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setPatentNumber(this.getPatentNumber());
        result.setTitle(this.getTitle());
        result.setPublicationDate(this.getPublicationDate());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public Submission toSubmission() {
        Submission result = DefaultCitationFactory.getInstance().buildSubmission();
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setAuthors(this.getAuthors());
        result.setPublicationDate(this.getPublicationDate());
        result.setSubmittedToDatabase(this.getSubmittedToDatabase());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setTitle(this.getTitle());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public Thesis toThesis() {
        Thesis result = DefaultCitationFactory.getInstance().buildThesis();
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setAuthors(this.getAuthors());
        result.setCountry(this.getCountry());
        result.setInstitute(this.getInstitute());
        result.setCity(this.getCity());
        result.setTitle(this.getTitle());
        result.setPublicationDate(this.getPublicationDate());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public void fromThesis(Thesis thesis) {
        this.setAuthoringGroup(thesis.getAuthoringGroup());
        this.setAuthors(thesis.getAuthors());
        this.setCountry(thesis.getCountry());
        this.setInstitute(thesis.getInstitute());
        this.setTitle(thesis.getTitle());
        this.setPublicationDate(thesis.getPublicationDate());
        this.setSequenceSampleSources(thesis.getSequenceSampleSources());
        this.setSequencingExperiments(thesis.getSequencingExperiments());
        this.setEvidenceIds(thesis.getEvidenceIds());
    }

    public UnpublishedResults toUnpublishedResults() {
        UnpublishedResults result = DefaultCitationFactory.getInstance().buildUnpublishedResults();
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setAuthors(this.getAuthors());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        if (this.getReferringCitation() != null) {
            result.setReferringCitation(this.getReferringCitation());
        }
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    public UnpublishedObservations toUnpublishedObservations() {
        UnpublishedObservations result = DefaultCitationFactory.getInstance().buildUnpublishedObservations();
        result.setAuthoringGroup(this.getAuthoringGroup());
        result.setAuthors(this.getAuthors());
        result.setPublicationDate(this.getPublicationDate());
        result.setSequenceSampleSources(this.getSequenceSampleSources());
        result.setSequencingExperiments(this.getSequencingExperiments());
        result.setTitle(this.getTitle());
        result.setEvidenceIds(this.getEvidenceIds());
        return result;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidenceIds = evidences;
    }
}

