/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.Description;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.SecondaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.Go;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalSection;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultCitationFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultUniProtEntryImplSerializer;
import uk.ac.ebi.kraken.model.serialize.UniProtEntryImplSerializer;
import uk.ac.ebi.kraken.model.uniprot.accessions.UniProtAccessions;
import uk.ac.ebi.kraken.model.uniprot.citationsNew.Citations;
import uk.ac.ebi.kraken.model.uniprot.comments.Comments;
import uk.ac.ebi.kraken.model.uniprot.dbx.DatabaseCrossReferences;
import uk.ac.ebi.kraken.model.uniprot.features.Features;
import uk.ac.ebi.kraken.model.uniprot.genename.Genes;
import uk.ac.ebi.kraken.model.uniprot.internalsection.InternalSectionImpl;
import uk.ac.ebi.kraken.model.uniprot.keywords.Keywords;
import uk.ac.ebi.kraken.model.uniprot.organelles.Organelles;
import uk.ac.ebi.kraken.model.uniprot.organism.Organisms;
import uk.ac.ebi.kraken.model.uniprot.taxons.Taxonomies;
import uk.ac.ebi.kraken.model.uniprot.util.SplicedSequenceCalculator;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsList;
import uk.ac.ebi.kraken.util.test.NullAble;

public class UniProtEntryImpl
implements PersistentObject,
UniProtEntry,
Externalizable {
    public static final int serialVersionUID = 1;
    private static final boolean debug = false;
    private UniProtEntryType entryType;
    private UniProtId uniProtId;
    private UniProtAccessions uniProtAccessions;
    private Comments comments;
    private Sequence sequence;
    private Keywords keywords;
    private Taxonomies taxons;
    private Features features;
    private EntryAudit entryAudit;
    private Organism organism;
    private DatabaseCrossReferences databaseCrossReferences;
    private Organelles organelles;
    private uk.ac.ebi.kraken.model.uniprot.citations.Citations citations;
    private Genes genes;
    private List<OrganismHost> organismHosts;
    private ProteinDescription newDescription;
    private Citations newCitations;
    private List<NcbiTaxonomyId> ncbiTaxonomyIds;
    private List<Evidence> evidences;
    private UniParcEntry uniParcEntry;
    private String difference = "";
    private InternalSection internalSection;
    private List<OrganismHost> hosts;
    private ProteinExistence proteinExistence;
    private Organisms organisms;
    private Description description;
    private UniProtEntryImplSerializer serializer = new DefaultUniProtEntryImplSerializer();
    public long id;
    public static final Pattern pattern = Pattern.compile("[A-Z][0-9][A-Z0-9]{3}[0-9]");

    public UniProtEntryImpl() {
        this.init();
    }

    @Override
    public Evidence getEvidence(EvidenceId id) {
        for (Evidence ev : this.getEvidences()) {
            if (!ev.getEvidenceId().equals(id)) continue;
            return ev;
        }
        return DefaultUniProtFactory.getEvidenceFactory().buildEvidence();
    }

    @Override
    public String getSplicedSequence(String isoformName) {
        return SplicedSequenceCalculator.getSplicedSequence(this, isoformName);
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.ORGANISM_HOST}, helperClass="uk.ac.ebi.kraken.ffwriter.OHLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost")
    public List<OrganismHost> getOrganismHosts() {
        return this.organismHosts;
    }

    @Override
    public void setOrganismHosts(List<OrganismHost> hosts) {
        if (hosts == null) {
            throw new IllegalArgumentException();
        }
        this.hosts = hosts;
        this.organismHosts = hosts;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serializer.writeObject(this, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.serializer.readObject(this, in);
    }

    private void init() {
        this.entryType = UniProtEntryType.UNKNOWN;
        this.uniProtId = DefaultUniProtFactory.getInstance().buildUniProtId("");
        this.uniProtAccessions = new UniProtAccessions();
        this.entryAudit = DefaultUniProtFactory.getInstance().buildEntryAudit();
        this.comments = new Comments();
        this.sequence = new SequenceImpl();
        this.keywords = new Keywords();
        this.taxons = new Taxonomies();
        this.features = new Features();
        this.genes = new Genes();
        this.organism = DefaultUniProtFactory.getInstance().buildOrganism();
        this.organelles = new Organelles();
        this.databaseCrossReferences = new DatabaseCrossReferences();
        this.internalSection = new InternalSectionImpl();
        this.newDescription = DefaultUniProtFactory.getInstance().buildProteinDescription();
        this.newCitations = new Citations();
        this.ncbiTaxonomyIds = new ArrayList<NcbiTaxonomyId>();
        this.difference = "";
        this.evidences = new ArrayList<Evidence>();
        this.organismHosts = new ArrayList<OrganismHost>();
        this.proteinExistence = ProteinExistence.UNKNOWN;
        this.description = DefaultUniProtFactory.getInstance().buildDescription();
        this.organisms = new Organisms();
        this.citations = new uk.ac.ebi.kraken.model.uniprot.citations.Citations();
    }

    public UniProtEntryImpl(UniProtEntry copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.entryType = copy.getType();
        this.uniProtId = DefaultUniProtFactory.getInstance().buildUniProtId(copy.getUniProtId());
        this.uniProtAccessions = new UniProtAccessions();
        this.uniProtAccessions.setPrimaryUniProtAccession(DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(copy.getPrimaryUniProtAccession()));
        for (SecondaryUniProtAccession secondaryUniProtAccession : copy.getSecondaryUniProtAccessions()) {
            this.uniProtAccessions.getSecondaryUniProtAccessions().add(DefaultUniProtFactory.getInstance().buildSecondaryUniProtAccession(secondaryUniProtAccession));
        }
        this.entryAudit = DefaultUniProtFactory.getInstance().buildEntryAudit(copy.getEntryAudit());
        this.comments = new Comments();
        for (Comment comment : copy.getComments()) {
            this.comments.getComments(comment.getCommentType()).add(DefaultCommentFactory.getInstance().buildComment(comment));
        }
        this.sequence = DefaultUniProtFactory.getInstance().buildSequence(copy.getSequence());
        this.keywords = new Keywords();
        for (Keyword keyword : copy.getKeywords()) {
            this.keywords.getKeywords().add(DefaultUniProtFactory.getInstance().buildKeyword(keyword));
        }
        this.taxons = new Taxonomies();
        for (NcbiTaxon ncbiTaxon : copy.getTaxonomy()) {
            this.taxons.getTaxonomy().add(DefaultUniProtFactory.getInstance().buildNcbiTaxon(ncbiTaxon));
        }
        this.features = new Features();
        for (Feature feature : copy.getFeatures()) {
            this.getFeatures().add((Feature)DefaultFeatureFactory.getInstance().buildFeature(feature));
        }
        this.genes = new Genes();
        for (Gene gene : copy.getGenes()) {
            this.getGenes().add(DefaultUniProtFactory.getInstance().buildGene(gene));
        }
        this.organism = DefaultUniProtFactory.getInstance().buildOrganism(copy.getOrganism());
        this.organelles = new Organelles();
        for (Organelle organelle : copy.getOrganelles()) {
            this.organelles.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(organelle));
        }
        this.databaseCrossReferences = new DatabaseCrossReferences();
        for (DatabaseCrossReference databaseCrossReference : copy.getDatabaseCrossReferences()) {
            this.databaseCrossReferences.getDatabaseCrossReferences().add((DatabaseCrossReference)DefaultXRefFactory.getInstance().buildDatabaseCrossReference(databaseCrossReference));
        }
        this.citations = new uk.ac.ebi.kraken.model.uniprot.citations.Citations();
        for (Citation citation : copy.getCitations()) {
            this.citations.getCitations().add(DefaultCitationFactory.getInstance().buildCitation(citation));
        }
        this.newDescription = DefaultUniProtFactory.getInstance().buildProteinDescription(copy.getProteinDescription());
        this.newCitations = new Citations();
        for (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation : copy.getCitationsNew()) {
            this.newCitations.getCitations().add(DefaultCitationNewFactory.getInstance().buildCitation(citation));
        }
        this.ncbiTaxonomyIds = new NoNullElementsList<NcbiTaxonomyId>(new ArrayList());
        for (NcbiTaxonomyId ncbiTaxonomyId : copy.getNcbiTaxonomyIds()) {
            this.ncbiTaxonomyIds.add(DefaultUniProtFactory.getInstance().buildNcbiTaxonomyId(ncbiTaxonomyId));
        }
        this.evidences = new NoNullElementsList<Evidence>(new ArrayList());
        for (Evidence evidence : copy.getEvidences()) {
            this.evidences.add(DefaultEvidenceFactory.getInstance().buildEvidence(evidence));
        }
        this.organismHosts = new NoNullElementsList<OrganismHost>(new ArrayList());
        for (OrganismHost organismHost : copy.getOrganismHosts()) {
            this.organismHosts.add(DefaultUniProtFactory.getInstance().buildOrganismHost(organismHost));
        }
        this.internalSection = DefaultUniProtFactory.getInstance().buildInternalSection(copy.getInternalSection());
        this.proteinExistence = copy.getProteinExistence();
        this.organisms = new Organisms();
        for (Organism organism : copy.getOrganisms()) {
            this.organisms.getOrganisms().add(DefaultUniProtFactory.getInstance().buildOrganism(organism));
        }
        this.description = DefaultUniProtFactory.getInstance().buildDescription(copy.getDescription());
    }

    @Override
    @IndexThisField(fieldName={IndexField.HID})
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @NullAble
    public void setType(UniProtEntryType type) {
        if (type != null) {
            this.entryType = type;
        }
    }

    @Override
    @NullAble
    @IndexThisField(fieldName={IndexField.REVIEWED}, helperClass="uk.ac.ebi.kraken.ffwriter.helpers.LuceneObjectHelper")
    public UniProtEntryType getType() {
        return this.entryType;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIPROT_ID, IndexField.NAME_ANNOTATION, IndexField.UNIPROT_IDENTIFIER})
    public UniProtId getUniProtId() {
        return this.uniProtId;
    }

    @Override
    public void setUniProtId(UniProtId uniProtId) {
        if (uniProtId == null) {
            throw new IllegalArgumentException();
        }
        this.uniProtId = uniProtId;
    }

    @Override
    public void setUniProtId(String uniProtIdStr) {
        if (this.uniProtId == null) {
            throw new IllegalArgumentException();
        }
        this.setUniProtId(DefaultUniProtFactory.getInstance().buildUniProtId(uniProtIdStr));
    }

    @Override
    @IndexThisField(fieldName={IndexField.NAME_ANNOTATION, IndexField.UNIPROT_IDENTIFIER, IndexField.UNIPROT_EXPIRED_IDENTIFIER})
    public List<SecondaryUniProtAccession> getSecondaryUniProtAccessions() {
        return this.uniProtAccessions.getSecondaryUniProtAccessions();
    }

    @Override
    @IndexThisField(fieldName={IndexField.PRIMARY_ACCESSION, IndexField.NAME_ANNOTATION, IndexField.UNIPROT_IDENTIFIER, IndexField.PRIMARY_ACCESSION_EXACT})
    public PrimaryUniProtAccession getPrimaryUniProtAccession() {
        return this.uniProtAccessions.getPrimaryUniProtAccession();
    }

    @IndexThisField(fieldName={IndexField.UNIPROT_IDENTIFIER})
    public List<IsoformId> getAllNonExternalEntryIsoFormIds() {
        ArrayList<IsoformId> retVal = new ArrayList<IsoformId>();
        List var = this.getComments(CommentType.ALTERNATIVE_PRODUCTS);
        for (AlternativeProductsComment comment : var) {
            for (AlternativeProductsIsoform isoForm : comment.getIsoforms()) {
                if (isoForm.getIsoformSequenceStatus() == IsoformSequenceStatus.EXTERNAL) continue;
                retVal.addAll(isoForm.getIds());
            }
        }
        return retVal;
    }

    public List<IsoformId> getAllEntryIsoFormIds() {
        ArrayList<IsoformId> retVal = new ArrayList<IsoformId>();
        List var = this.getComments(CommentType.ALTERNATIVE_PRODUCTS);
        for (AlternativeProductsComment comment : var) {
            for (AlternativeProductsIsoform isoForm : comment.getIsoforms()) {
                retVal.addAll(isoForm.getIds());
            }
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public void setSecondaryUniProtAccessions(List<SecondaryUniProtAccession> uniProtAccessions) {
        this.uniProtAccessions.setSecondaryUniProtAccessions(uniProtAccessions);
    }

    @Override
    public void setPrimaryUniProtAccession(PrimaryUniProtAccession uniProtAccession) {
        this.uniProtAccessions.setPrimaryUniProtAccession(uniProtAccession);
    }

    @Override
    @IndexThisField
    public EntryAudit getEntryAudit() {
        return this.entryAudit;
    }

    @Override
    public void setEntryAudit(EntryAudit entryAudit) {
        if (entryAudit == null) {
            throw new IllegalArgumentException();
        }
        this.entryAudit = entryAudit;
    }

    @Override
    @IndexThisField(fieldName={IndexField.KEYWORD, IndexField.KEYWORD_EXACT})
    public List<Keyword> getKeywords() {
        return this.keywords.getKeywords();
    }

    @Override
    public void setTaxonomy(List<NcbiTaxon> taxonomy) {
        this.taxons.setTaxonomy(taxonomy);
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.TAXONOMY_NAME})
    public List<NcbiTaxon> getTaxonomy() {
        return this.taxons.getTaxonomy();
    }

    @Override
    public void setKeywords(List<Keyword> keywords) {
        this.keywords.setKeywords(keywords);
    }

    @Override
    @NullAble
    @Deprecated
    public UniParcEntry getUniParcEntry() {
        return this.uniParcEntry;
    }

    @Override
    @NullAble
    @Deprecated
    public void setUniParcEntry(UniParcEntry uniParcEntry) {
        if (uniParcEntry != null) {
            this.uniParcEntry = uniParcEntry;
        }
    }

    @Override
    public void setSequence(Sequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException();
        }
        this.sequence = sequence;
    }

    @Override
    @IndexThisField(fieldName={IndexField.TEXT_COMMENTS}, helperClass="uk.ac.ebi.kraken.ffwriter.CCLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment", fieldNameByType="getCommentType")
    public Collection<Comment> getComments() {
        return this.comments.getComments();
    }

    @IndexThisField(fieldName={IndexField.TEXT_COMMENTS_NO_STATUS}, helperClass="uk.ac.ebi.kraken.ffwriter.CCLine", helperMethod="exportWithNoStatus", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment", fieldNameByType="getCommentType")
    public Collection<Comment> getCommentsNoStatus() {
        Collection<Comment> commentCollection = this.comments.getComments();
        ArrayList<Comment> commentWithoutStatusCollection = new ArrayList<Comment>();
        for (Comment comment : commentCollection) {
            Object newComment = DefaultCommentFactory.getInstance().buildComment(comment);
            newComment.setCommentStatus(CommentStatus.NONE);
            commentWithoutStatusCollection.add((Comment)newComment);
        }
        return commentWithoutStatusCollection;
    }

    @Override
    public void setComments(Collection<Comment> comments) {
        this.comments.setComments(comments);
    }

    @Override
    public <T extends Comment> List<T> getComments(CommentType type) {
        return this.comments.getComments(type);
    }

    @Override
    @IndexThisField
    public Sequence getSequence() {
        if (this.sequence == null) {
            DefaultUniProtFactory factory = DefaultUniProtFactory.getInstance();
            this.sequence = factory.buildSequence();
        }
        return this.sequence;
    }

    @Override
    @IndexThisField(fieldName={IndexField.POSITIONAL_SPECIFIC}, helperClass="uk.ac.ebi.kraken.ffwriter.FTLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.features.Feature", fieldNameByType="getType")
    public List<Feature> getFeatures() {
        return (List)this.features.getFeatures();
    }

    @IndexThisField
    public Features getFeatureContainer() {
        return this.features;
    }

    @Override
    public void setFeatures(Collection<Feature> features) {
        this.features.setFeatures(features);
    }

    @Override
    public void setFeatures(List<Feature> features) {
        this.features.setFeatures(features);
    }

    public <X extends Feature> Collection<X> getFeatures(FeatureType type) {
        return this.features.getFeatures(type);
    }

    @Override
    public <T extends DatabaseCrossReference> List<T> getDatabaseCrossReferences(DatabaseType type) {
        return this.databaseCrossReferences.getDatabaseCrossReferences(type);
    }

    @Override
    public void setDatabaseCrossReferences(List<DatabaseCrossReference> databaseCrossReferences) {
        this.databaseCrossReferences.setDatabaseCrossReferences(databaseCrossReferences);
    }

    @Override
    @IndexThisField(fieldName={IndexField.DATABASE_CROSSREFERENCES}, helperClass="uk.ac.ebi.kraken.ffwriter.DRLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference", fieldNameByType="getDatabase")
    public Collection<DatabaseCrossReference> getDatabaseCrossReferences() {
        return this.databaseCrossReferences.getDatabaseCrossReferences();
    }

    @Override
    @IndexThisField(fieldName={IndexField.GO_TERMS}, helperClass="uk.ac.ebi.kraken.ffwriter.DRLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference")
    public List<Go> getGoTerms() {
        return this.databaseCrossReferences.getDatabaseCrossReferences(DatabaseType.GO);
    }

    @Override
    @Deprecated
    public void setDescription(Description description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.description = description;
    }

    @Override
    @Deprecated
    public Description getDescription() {
        return this.description;
    }

    @IndexThisField(fieldName={IndexField.EC_NUMBER}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine", helperParameterClass="java.lang.String")
    public List<String> getECNumbers() {
        return this.newDescription.getEcNumbers();
    }

    @IndexThisField(fieldName={IndexField.REC_EC_NUMBER}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine", helperParameterClass="java.lang.String")
    public List<String> getRecEcNumber() {
        ArrayList<String> ecNumbers = new ArrayList<String>();
        List<Field> fields = this.newDescription.getRecommendedName().getFieldsByType(FieldType.EC);
        for (Field field : fields) {
            ecNumbers.add(field.getValue());
        }
        return ecNumbers;
    }

    @IndexThisField(fieldName={IndexField.PROTEIN_FRAGMENTATION})
    public List<FlagType> getFlags() {
        ArrayList<FlagType> types = new ArrayList<FlagType>();
        for (Flag flag : this.newDescription.getFlags()) {
            types.add(flag.getFlagType());
        }
        return Collections.unmodifiableList(types);
    }

    @Override
    public void setNcbiTaxonomyIds(List<NcbiTaxonomyId> id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.ncbiTaxonomyIds = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.ORGANISM_SPECIFIC, IndexField.NCBI_TAXON_ID})
    public List<NcbiTaxonomyId> getNcbiTaxonomyIds() {
        return this.ncbiTaxonomyIds;
    }

    @Override
    public void setGenes(List<Gene> genes) {
        this.genes.setGenes(genes);
    }

    @Override
    @IndexThisField
    public List<Gene> getGenes() {
        return this.genes.getGenes();
    }

    @Override
    public void setOrganisms(List<Organism> organisms) {
        this.organisms.setOrganisms(organisms);
    }

    @Override
    public List<Organism> getOrganisms() {
        return this.organisms.getOrganisms();
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    @IndexThisField
    public Organism getOrganism() {
        return this.organism;
    }

    @Override
    @IndexThisField(fieldName={IndexField.NAME_ANNOTATION, IndexField.ORGANELLE_EXACT, IndexField.ORGANELLE}, helperClass="uk.ac.ebi.kraken.ffwriter.OGLine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.Organelle")
    public List<Organelle> getOrganelles() {
        return this.organelles.getOrganelles();
    }

    @Override
    public void setOrganelles(List<Organelle> organelles) {
        this.organelles.setOrganelles(organelles);
    }

    @Override
    @Deprecated
    public boolean hasCitations() {
        return this.citations.hasCitations();
    }

    @Override
    @Deprecated
    public List<Citation> getCitations() {
        return this.citations.getCitations();
    }

    @IndexThisField
    public uk.ac.ebi.kraken.model.uniprot.citations.Citations getCitationContainer() {
        return this.citations;
    }

    @Override
    @Deprecated
    public <T extends Citation> List<T> getCitations(uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum type) {
        ArrayList<Citation> result = new ArrayList<Citation>();
        for (Citation citation : this.citations.getCitations()) {
            if (citation.getCitationType() != type) continue;
            result.add(citation);
        }
        return result;
    }

    @Override
    @Deprecated
    public void setCitations(List<Citation> citation) {
        this.citations.setCitations(citation);
    }

    @Override
    @IndexThisField(fieldName={IndexField.LITERATURE}, helperClass="uk.ac.ebi.kraken.ffwriter.newRLines.RLineNew", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation", fieldNameByType="getCitationType")
    public List<uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation> getCitationsNew() {
        return this.newCitations.getCitations();
    }

    @Override
    public <T extends uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation> List<T> getCitationsNew(CitationTypeEnum citationType) {
        ArrayList<uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation> result = new ArrayList<uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation>();
        for (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation : this.newCitations.getCitations()) {
            if (citation.getCitationType() != citationType) continue;
            result.add(citation);
        }
        return result;
    }

    @Override
    public void setCitationsNew(List<uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation> citation) {
        this.newCitations.setCitations(citation);
    }

    @Override
    public boolean hasCitationsNew() {
        return this.newCitations.hasCitations();
    }

    @Override
    public void setInternalSection(InternalSection internalSection) {
        if (internalSection == null) {
            throw new IllegalArgumentException();
        }
        this.internalSection = internalSection;
    }

    @Override
    public InternalSection getInternalSection() {
        return this.internalSection;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PROTEIN_EXISTANCE})
    public ProteinExistence getProteinExistence() {
        return this.proteinExistence;
    }

    @Override
    public void setProteinExistence(ProteinExistence proteinExistence) {
        this.proteinExistence = proteinExistence;
    }

    @Override
    public void setProteinDescription(ProteinDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.newDescription = description;
    }

    @Override
    @IndexThisField(fieldName={IndexField.NAME_ANNOTATION, IndexField.PROTEIN_NAME}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine")
    public ProteinDescription getProteinDescription() {
        return this.newDescription;
    }

    @Override
    public List<Evidence> getEvidences() {
        return this.evidences;
    }

    @Override
    public void setEvidences(List<Evidence> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidences = evidences;
    }

    public int hashCode() {
        int result = 17;
        if (this.getType() != null) {
            result += this.getType().hashCode();
        }
        result += this.getUniProtId().hashCode();
        result += this.getPrimaryUniProtAccession().hashCode();
        for (SecondaryUniProtAccession accession : this.uniProtAccessions.getSecondaryUniProtAccessions()) {
            result += accession.hashCode();
        }
        result += this.getEntryAudit().hashCode();
        result += this.getDescription().hashCode();
        result += this.getProteinDescription().hashCode();
        result += ((Object)this.getTaxonomy()).hashCode();
        result += ((Object)this.getOrganisms()).hashCode();
        result += ((Object)this.getOrganelles()).hashCode();
        HashSet<Comment> c1 = new HashSet<Comment>(this.getComments());
        result += ((Object)c1).hashCode();
        HashSet<Feature> f1 = new HashSet<Feature>(this.getFeatures());
        result += ((Object)f1).hashCode();
        result += ((Object)this.getKeywords()).hashCode();
        result += this.internalSection.hashCode();
        result += this.sequence.hashCode();
        result += ((Object)this.ncbiTaxonomyIds).hashCode();
        HashSet<Citation> cits = new HashSet<Citation>(this.getCitations());
        result += ((Object)cits).hashCode();
        HashSet<DatabaseCrossReference> r1 = new HashSet<DatabaseCrossReference>(this.getDatabaseCrossReferences());
        result += ((Object)r1).hashCode();
        HashSet<OrganismHost> hosts = new HashSet<OrganismHost>(this.getOrganismHosts());
        result += ((Object)hosts).hashCode();
        return result += this.proteinExistence.hashCode();
    }

    public boolean equals(Object obj) {
        HashSet<DatabaseCrossReference> r2;
        HashSet<Citation> cit2;
        HashSet<Feature> f2;
        HashSet<Comment> c2;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UniProtEntry)) {
            return false;
        }
        UniProtEntry copy = (UniProtEntry)obj;
        if (this.getType() != copy.getType()) {
            return false;
        }
        if (this.getProteinExistence() != copy.getProteinExistence()) {
            return false;
        }
        if (!this.getUniProtId().equals(copy.getUniProtId())) {
            return false;
        }
        if (!this.getPrimaryUniProtAccession().equals(copy.getPrimaryUniProtAccession())) {
            return false;
        }
        if (!((Object)this.getSecondaryUniProtAccessions()).equals(copy.getSecondaryUniProtAccessions())) {
            return false;
        }
        if (!this.getEntryAudit().equals(copy.getEntryAudit())) {
            return false;
        }
        if (!this.getDescription().equals(copy.getDescription())) {
            return false;
        }
        if (!this.getProteinDescription().equals(copy.getProteinDescription())) {
            return false;
        }
        if (!((Object)this.getGenes()).equals(copy.getGenes())) {
            return false;
        }
        if (!((Object)this.getTaxonomy()).equals(copy.getTaxonomy())) {
            return false;
        }
        if (!((Object)this.getOrganisms()).equals(copy.getOrganisms())) {
            return false;
        }
        if (!((Object)this.getOrganelles()).equals(copy.getOrganelles())) {
            return false;
        }
        HashSet<Comment> c1 = new HashSet<Comment>(this.getComments());
        if (!((Object)c1).equals(c2 = new HashSet<Comment>(copy.getComments()))) {
            for (CommentType commentType : CommentType.values()) {
                List comments;
                boolean i = false;
                List ccomments = copy.getComments(commentType);
                if (((Object)ccomments).equals(comments = this.getComments(commentType))) continue;
                return false;
            }
            return false;
        }
        HashSet<Feature> f1 = new HashSet<Feature>(this.getFeatures());
        if (!((Object)f1).equals(f2 = new HashSet<Feature>(copy.getFeatures()))) {
            return false;
        }
        HashSet<Citation> cit1 = new HashSet<Citation>(this.getCitations());
        if (!((Object)cit1).equals(cit2 = new HashSet<Citation>(copy.getCitations()))) {
            return false;
        }
        if (!this.getInternalSection().equals(copy.getInternalSection())) {
            return false;
        }
        if (!((Object)this.getKeywords()).equals(copy.getKeywords())) {
            return false;
        }
        if (!this.sequence.equals(copy.getSequence())) {
            return false;
        }
        if (!((Object)this.ncbiTaxonomyIds).equals(copy.getNcbiTaxonomyIds())) {
            return false;
        }
        HashSet<DatabaseCrossReference> r1 = new HashSet<DatabaseCrossReference>(this.getDatabaseCrossReferences());
        if (!((Object)r1).equals(r2 = new HashSet<DatabaseCrossReference>(copy.getDatabaseCrossReferences()))) {
            return false;
        }
        if (!((Object)this.getOrganismHosts()).equals(copy.getOrganismHosts())) {
            return false;
        }
        return this.proteinExistence.equals((Object)copy.getProteinExistence());
    }

    public static long toLong(String id) {
        long l = 0L;
        if (id.length() != 6 && (id.length() <= 7 || id.charAt(6) != '-')) {
            throw new IllegalArgumentException("Invalid id: " + id);
        }
        for (int i = 0; i < 6; ++i) {
            l *= 256L;
            l += (long)id.charAt(i);
        }
        int isoform = 0;
        if (id.length() > 7) {
            isoform = Integer.parseInt(id.substring(7));
        }
        l *= 256L;
        return l += (long)isoform;
    }

    public static String toString(long id) {
        if (id == 0L) {
            return null;
        }
        char[] chars = new char[6];
        int isoform = (int)(id % 256L);
        id /= 256L;
        for (int i = 5; i >= 0; --i) {
            chars[i] = (char)(id % 256L);
            id /= 256L;
        }
        String s = String.valueOf(chars);
        if (isoform != 0) {
            s = s + "-" + isoform;
        }
        return s;
    }

    public static boolean isValid(String id) {
        return pattern.matcher(id).matches();
    }

    @Override
    @IndexThisField(fieldName={IndexField.FRAGMENT}, helperClass="uk.ac.ebi.kraken.ffwriter.helpers.LuceneObjectHelper")
    public Boolean isFragment() {
        for (Flag flag : this.newDescription.getFlags()) {
            if (flag.getFlagType() != FlagType.FRAGMENT && flag.getFlagType() != FlagType.FRAGMENTS) continue;
            return true;
        }
        return false;
    }

    @IndexThisField(fieldName={IndexField.REC_NAME}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine")
    public Name getRecommendedName() {
        return this.newDescription.getRecommendedName();
    }

    @IndexThisField(fieldName={IndexField.ALT_NAME}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.description.Name")
    public List<Name> getAlternativeNames() {
        return this.newDescription.getAlternativeNames();
    }

    @IndexThisField(fieldName={IndexField.INCLUDES_SECTION}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.description.Section")
    public List<Section> getIncludesSection() {
        return this.newDescription.getIncludes();
    }

    @IndexThisField(fieldName={IndexField.CONTAINS_SECTION}, helperClass="uk.ac.ebi.kraken.ffwriter.DELine", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniprot.description.Section")
    public List<Section> getContainsSection() {
        return this.newDescription.getContains();
    }
}

