/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class OrganismHostImpl
implements OrganismHost,
PersistentObject {
    private Organism organism;
    private NcbiTaxonomyId ncbiTaxonomyId;
    private long id;

    public OrganismHostImpl() {
        this.organism = DefaultUniProtFactory.getInstance().buildOrganism();
        this.ncbiTaxonomyId = DefaultUniProtFactory.getInstance().buildNcbiTaxonomyId();
    }

    public OrganismHostImpl(OrganismHost copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.organism = DefaultUniProtFactory.getInstance().buildOrganism(copy.getOrganism());
        this.ncbiTaxonomyId = DefaultUniProtFactory.getInstance().buildNcbiTaxonomyId(copy.getNcbiTaxonomyId());
    }

    @Override
    public Organism getOrganism() {
        return this.organism;
    }

    @Override
    public void setOrganism(Organism organism) {
        this.organism = organism;
    }

    @Override
    public NcbiTaxonomyId getNcbiTaxonomyId() {
        return this.ncbiTaxonomyId;
    }

    @Override
    public void setNcbiTaxonomyId(NcbiTaxonomyId ncbiTaxonomyId) {
        this.ncbiTaxonomyId = ncbiTaxonomyId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganismHostImpl that = (OrganismHostImpl)o;
        if (this.ncbiTaxonomyId != null ? !this.ncbiTaxonomyId.equals(that.ncbiTaxonomyId) : that.ncbiTaxonomyId != null) {
            return false;
        }
        return !(this.organism != null ? !this.organism.equals(that.organism) : that.organism != null);
    }

    public int hashCode() {
        int result = this.organism != null ? this.organism.hashCode() : 0;
        result = 29 * result + (this.ncbiTaxonomyId != null ? this.ncbiTaxonomyId.hashCode() : 0);
        return result;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

