/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.Description;
import uk.ac.ebi.kraken.interfaces.uniprot.description.DescriptionModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.description.DescriptionVersion;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FragmentationType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FunctionalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinName;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinNameType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.uniprot.description.FunctionalSectionImpl;
import uk.ac.ebi.kraken.util.NoNullElementsList;

@Deprecated
public class DescriptionImpl
implements Description {
    private DescriptionModifier modifier;
    private FragmentationType fragmentationType;
    private DescriptionVersion version;
    private List<FunctionalSection> containsSection;
    private List<FunctionalSection> includesSection;
    private FunctionalSection descrptionSection;
    private List<EvidenceId> evidenceIds;
    private long id;

    public DescriptionImpl() {
        this.modifier = DescriptionModifier.VERIFIED;
        this.fragmentationType = FragmentationType.FULL_SEQUENCE;
        this.version = DescriptionVersion.NO_VERSION;
        this.containsSection = new ArrayList<FunctionalSection>();
        this.includesSection = new ArrayList<FunctionalSection>();
        this.descrptionSection = DefaultUniProtFactory.getInstance().buildMultifunctionalSection();
    }

    public DescriptionImpl(Description copy) {
        FunctionalSectionImpl newSection;
        this.modifier = copy.getDescriptionModifier();
        this.fragmentationType = copy.getFragmentationType();
        this.version = copy.getVersion();
        this.containsSection = new ArrayList<FunctionalSection>();
        for (FunctionalSection functionalSection : copy.getContainsSection()) {
            newSection = new FunctionalSectionImpl();
            this.containsSection.add(newSection);
            for (ProteinName name : functionalSection.getProteinNames()) {
                newSection.getProteinNames().add(DefaultUniProtFactory.getInstance().buildProteinName(name));
            }
        }
        this.includesSection = new ArrayList<FunctionalSection>();
        for (FunctionalSection functionalSection : copy.getIncludesSection()) {
            newSection = new FunctionalSectionImpl();
            this.includesSection.add(newSection);
            for (ProteinName name : functionalSection.getProteinNames()) {
                newSection.getProteinNames().add(DefaultUniProtFactory.getInstance().buildProteinName(name));
            }
        }
        this.descrptionSection = DefaultUniProtFactory.getInstance().buildMultifunctionalSection();
        for (ProteinName name : copy.getProteinNames()) {
            this.getProteinNames().add(DefaultUniProtFactory.getInstance().buildProteinName(name.getValue(), name.getProteinNameType()));
        }
        this.evidenceIds = new NoNullElementsList<EvidenceId>(new ArrayList());
        for (EvidenceId evidenceId : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultEvidenceFactory.getInstance().buildEvidenceId(evidenceId.getValue()));
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public boolean hasDescriptionModifier() {
        return this.modifier != DescriptionModifier.VERIFIED;
    }

    @Override
    public DescriptionModifier getDescriptionModifier() {
        return this.modifier;
    }

    @Override
    public void setDescriptionModifier(DescriptionModifier modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException();
        }
        this.modifier = modifier;
    }

    @Override
    public boolean hasFragmentation() {
        return this.fragmentationType != FragmentationType.FULL_SEQUENCE;
    }

    @Override
    public FragmentationType getFragmentationType() {
        return this.fragmentationType;
    }

    @Override
    public void setFragmentationType(FragmentationType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.fragmentationType = type;
    }

    @Override
    public boolean hasVersion() {
        return this.version != DescriptionVersion.NO_VERSION;
    }

    @Override
    public void setVersion(DescriptionVersion version) {
        if (version == null) {
            throw new IllegalArgumentException();
        }
        this.version = version;
    }

    @Override
    public DescriptionVersion getVersion() {
        return this.version;
    }

    @Override
    public void setContainsSection(List<FunctionalSection> sections) {
        if (sections == null) {
            throw new IllegalArgumentException();
        }
        this.containsSection = sections;
    }

    @Override
    public List<FunctionalSection> getContainsSection() {
        return this.containsSection;
    }

    @Override
    public void setIncludesSection(List<FunctionalSection> sections) {
        if (sections == null) {
            throw new IllegalArgumentException();
        }
        this.includesSection = sections;
    }

    @Override
    public List<FunctionalSection> getIncludesSection() {
        return this.includesSection;
    }

    @Override
    public List<ProteinName> getProteinNames() {
        return this.descrptionSection.getProteinNames();
    }

    @Override
    public void setProteinNames(List<ProteinName> proteinNames) {
        if (proteinNames == null) {
            throw new IllegalArgumentException();
        }
        this.descrptionSection.setProteinNames(proteinNames);
    }

    @Override
    public List<ProteinName> getECNumbers() {
        ArrayList<ProteinName> retVal = new ArrayList<ProteinName>();
        for (ProteinName name : this.descrptionSection.getProteinNames()) {
            if (!name.getProteinNameType().equals((Object)ProteinNameType.EC)) continue;
            retVal.add(name);
        }
        for (FunctionalSection section : this.includesSection) {
            for (ProteinName name : section.getProteinNames()) {
                if (!name.getProteinNameType().equals((Object)ProteinNameType.EC)) continue;
                retVal.add(name);
            }
        }
        for (FunctionalSection section : this.containsSection) {
            for (ProteinName name : section.getProteinNames()) {
                if (!name.getProteinNameType().equals((Object)ProteinNameType.EC)) continue;
                retVal.add(name);
            }
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescriptionImpl that = (DescriptionImpl)o;
        if (this.containsSection != null ? !((Object)this.containsSection).equals(that.containsSection) : that.containsSection != null) {
            return false;
        }
        if (this.descrptionSection != null ? !this.descrptionSection.equals(that.descrptionSection) : that.descrptionSection != null) {
            return false;
        }
        if (this.evidenceIds != null && this.evidenceIds.size() > 0 ? !((Object)this.evidenceIds).equals(that.evidenceIds) : that.evidenceIds != null && that.evidenceIds.size() > 0) {
            return false;
        }
        if (this.fragmentationType != that.fragmentationType) {
            return false;
        }
        if (this.includesSection != null ? !((Object)this.includesSection).equals(that.includesSection) : that.includesSection != null) {
            return false;
        }
        if (this.modifier != that.modifier) {
            return false;
        }
        return this.version == that.version;
    }

    public int hashCode() {
        int result = this.modifier != null ? this.modifier.hashCode() : 0;
        result = 29 * result + (this.fragmentationType != null ? this.fragmentationType.hashCode() : 0);
        result = 29 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 29 * result + (this.containsSection != null ? ((Object)this.containsSection).hashCode() : 0);
        result = 29 * result + (this.includesSection != null ? ((Object)this.includesSection).hashCode() : 0);
        result = 29 * result + (this.descrptionSection != null ? this.descrptionSection.hashCode() : 0);
        result = 29 * result + (this.evidenceIds != null && this.evidenceIds.size() > 0 ? ((Object)this.evidenceIds).hashCode() : 0);
        return result;
    }
}

