/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public class CommentImpl
implements PersistentObject,
Comment {
    private CommentType type;
    private List<EvidenceId> evidences;
    private CommentStatus commentStatus;
    public long id;

    public CommentImpl() {
        this.type = null;
        this.evidences = new ArrayList<EvidenceId>();
        this.commentStatus = CommentStatus.NONE;
    }

    public CommentImpl(Comment copy) {
        this.type = copy.getCommentType();
        this.commentStatus = copy.getCommentStatus();
        this.evidences = copy.getEvidenceIds();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidences == null) {
            this.evidences = new ArrayList<EvidenceId>();
        }
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        if (evidences == null) {
            throw new IllegalArgumentException();
        }
        this.evidences = evidences;
    }

    @Override
    public CommentType getCommentType() {
        return this.type;
    }

    @Override
    public void setCommentType(CommentType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentImpl comment = (CommentImpl)o;
        if (this.commentStatus != comment.commentStatus) {
            return false;
        }
        if (this.evidences != null && this.evidences.size() > 0 ? !((Object)this.evidences).equals(comment.evidences) : comment.evidences != null && comment.evidences.size() > 0) {
            return false;
        }
        return this.type == comment.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 29 * result + (this.evidences != null && this.evidences.size() > 0 ? ((Object)this.evidences).hashCode() : 0);
        result = 29 * result + (this.commentStatus != null ? this.commentStatus.hashCode() : 0);
        return result;
    }

    @Override
    public CommentStatus getCommentStatus() {
        return this.commentStatus;
    }

    @Override
    public void setCommentStatus(CommentStatus newStatus) {
        if (newStatus == null) {
            throw new IllegalArgumentException();
        }
        this.commentStatus = newStatus;
    }
}

