/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniparc;

import java.util.HashSet;
import java.util.Set;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrEntry;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcId;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.uniparc.UniParcIdImpl;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsSet;

public class UniParcEntryImpl
implements PersistentObject,
UniParcEntry {
    private Sequence sq;
    private Set<DatabaseCrossReference> drs;
    private UniParcId uniParcId;
    private Set<UniProtEntry> uids;
    private Set<ClustrEntry> clustrs;
    private UniProtAccession exclusionAccession;
    public long id;

    public UniParcEntryImpl() {
        this.sq = new SequenceImpl();
        this.uniParcId = new UniParcIdImpl();
        this.drs = new NoNullElementsSet<DatabaseCrossReference>(new HashSet());
        this.uids = new NoNullElementsSet<UniProtEntry>(new HashSet());
        this.clustrs = new NoNullElementsSet<ClustrEntry>(new HashSet());
        this.exclusionAccession = DefaultUniRefFactory.getInstance().buildMemberUniProtAccession();
    }

    public UniParcEntryImpl(UniParcEntry copy) {
        this.sq = DefaultUniParcFactory.getInstance().buildSequence(copy.getSequence());
        this.uniParcId = DefaultUniParcFactory.getInstance().buildUniParcId(copy.getUniParcId().getValue());
        this.drs = new NoNullElementsSet<DatabaseCrossReference>(new HashSet());
        for (DatabaseCrossReference xref : copy.getDatabaseCrossReferences()) {
            this.drs.add(DefaultUniParcFactory.getInstance().buildDatabaseCrossReference(xref));
        }
        this.uids = new NoNullElementsSet<UniProtEntry>(new HashSet());
        this.clustrs = new NoNullElementsSet<ClustrEntry>(new HashSet());
        this.exclusionAccession = DefaultUniRefFactory.getInstance().buildMemberUniProtAccession(copy.getUniProtExclusion().getValue());
    }

    @Override
    @IndexThisField(fieldName={IndexField.HID})
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @IndexThisField
    public Sequence getSequence() {
        return this.sq;
    }

    @Override
    public void setSequence(Sequence sq) {
        if (sq == null) {
            throw new IllegalArgumentException();
        }
        this.sq = sq;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIPARC_ACCESSION}, includeInContent=true)
    public UniParcId getUniParcId() {
        return this.uniParcId;
    }

    @Override
    public void setUniParcId(UniParcId id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.uniParcId = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIPARC_DATABASE_CROSSREFERENCES}, helperClass="uk.ac.ebi.kraken.ffwriter.helpers.LuceneObjectHelper", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference", includeInContent=true)
    public Set<DatabaseCrossReference> getDatabaseCrossReferences() {
        return this.drs;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIPARC_UNIPROT_CROSSREFERENCES}, helperClass="uk.ac.ebi.kraken.ffwriter.helpers.LuceneObjectHelper", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference", includeInContent=true)
    public Set<DatabaseCrossReference> getUniProtDatabaseCrossReferences() {
        HashSet<DatabaseCrossReference> retVal = new HashSet<DatabaseCrossReference>();
        for (DatabaseCrossReference xref : this.drs) {
            if (!DatabaseType.typeOf(xref.getDatabase().getName()).equals((Object)DatabaseType.SWISSPROT) && !DatabaseType.typeOf(xref.getDatabase().getName()).equals((Object)DatabaseType.TREMBL) || !xref.isActive()) continue;
            retVal.add(xref);
        }
        return retVal;
    }

    @Override
    public void setDatabaseCrossReferences(Set<DatabaseCrossReference> dbXRefs) {
        if (dbXRefs == null) {
            throw new IllegalArgumentException();
        }
        this.drs = dbXRefs;
    }

    @Override
    @Deprecated
    public Set<DatabaseCrossReference> getActiveDatabseCrossReferences() {
        return this.getActiveDatabaseCrossReferences();
    }

    @Override
    @IndexThisField(fieldName={IndexField.UNIPARC_ACTIVE_CROSSREFERENCES}, helperClass="uk.ac.ebi.kraken.ffwriter.helpers.LuceneObjectHelper", helperParameterClass="uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference", includeInContent=true)
    public Set<DatabaseCrossReference> getActiveDatabaseCrossReferences() {
        HashSet<DatabaseCrossReference> retVal = new HashSet<DatabaseCrossReference>();
        for (DatabaseCrossReference xref : this.drs) {
            if (!xref.isActive()) continue;
            retVal.add(xref);
        }
        return retVal;
    }

    @Override
    public UniProtAccession getUniProtExclusion() {
        return this.exclusionAccession;
    }

    @Override
    public void setUniProtExclusion(UniProtAccession accession) {
        if (accession == null) {
            throw new IllegalArgumentException("Please set a non-null accession");
        }
        this.exclusionAccession = accession;
    }

    @Override
    @Deprecated
    public void setUniProtEntries(Set<UniProtEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException();
        }
        this.uids = entries;
    }

    @Override
    @Deprecated
    public Set<ClustrEntry> getClustrEntries() {
        return this.clustrs;
    }

    @Override
    @Deprecated
    public void setClustrEntries(Set<ClustrEntry> clustr) {
        if (clustr == null) {
            throw new IllegalArgumentException();
        }
        this.clustrs = clustr;
    }

    @Override
    @Deprecated
    public Set<UniProtEntry> getUniProtEntries() {
        return this.uids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniParcEntryImpl that = (UniParcEntryImpl)o;
        if (this.clustrs != null ? !((Object)this.clustrs).equals(that.clustrs) : that.clustrs != null) {
            return false;
        }
        if (!((Object)this.drs).equals(that.drs)) {
            return false;
        }
        if (!this.sq.equals(that.sq)) {
            return false;
        }
        if (this.uids != null ? !((Object)this.uids).equals(that.uids) : that.uids != null) {
            return false;
        }
        return this.uniParcId.equals(that.uniParcId);
    }

    public int hashCode() {
        int result = this.sq.hashCode();
        result = 29 * result + ((Object)this.drs).hashCode();
        result = 29 * result + this.uniParcId.hashCode();
        result = 29 * result + (this.uids != null ? ((Object)this.uids).hashCode() : 0);
        result = 29 * result + (this.clustrs != null ? ((Object)this.clustrs).hashCode() : 0);
        return result;
    }
}

