/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.uniprot.Citation;
import uk.ac.ebi.kraken.interfaces.uniprot.CommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.Description;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.HasCommentStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.HasEvidences;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinExistence;
import uk.ac.ebi.kraken.interfaces.uniprot.SecondaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntryType;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Book;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.ElectronicArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasAgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasAuthors;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasDOI;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasJournalName;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasMedlineId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPages;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPubMedId;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasPublicationDate;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasTitle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.HasVolume;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Patent;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequenceSampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SequencingExperiment;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.Submission;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.SubmissionDatabase;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedJournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedResults;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Author;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AuthoringGroup;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationSummary;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationTypeEnum;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Editor;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.JournalArticle;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSource;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SampleSourceType;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Thesis;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.UnpublishedObservations;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocityUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionPosition;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TextOnlyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.interfaces.uniprot.description.DescriptionModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.description.DescriptionVersion;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FragmentationType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FunctionalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinName;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinNameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCategory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceCode;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.CarbohydLinkType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.ConflictReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.Feature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureLocationModifier;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.FeatureType;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasAlternativeSequence;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureId;
import uk.ac.ebi.kraken.interfaces.uniprot.features.HasFeatureStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.features.MutagenFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarSeqFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantFeature;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VariantReport;
import uk.ac.ebi.kraken.interfaces.uniprot.features.VarsplicIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.model.factories.DefaultCitationFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultCommonSerializer;
import uk.ac.ebi.kraken.model.serialize.DefaultDatabaseCrossReferencesSerializer;
import uk.ac.ebi.kraken.model.serialize.UniProtEntryImplSerializer;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationValueImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularMoleculeImpl;
import uk.ac.ebi.kraken.util.StopWatch;

public class DefaultUniProtEntryImplSerializer
extends DefaultCommonSerializer
implements Serializable,
UniProtEntryImplSerializer {
    private static transient Logger logger = Logger.getLogger(DefaultUniProtEntryImplSerializer.class);
    private byte EO_ACCESSION = 0;
    private byte EO_ENTRY_AUDIT = 1;
    private byte EO_DESCRIPTION = (byte)2;
    private byte EO_GENE = (byte)3;
    private byte EO_ORGANISM = (byte)4;
    private byte EO_TAXIDS = (byte)5;
    private byte EO_ORGANELLES = (byte)6;
    private byte EO_TAXONOMY = (byte)7;
    private byte EO_CITATION = (byte)8;
    private byte EO_FEATUREs = (byte)9;
    private byte EO_KEYWORDS = (byte)10;
    private byte EO_SEQUENCE = (byte)11;
    private byte EO_COMMENTS = (byte)12;
    private byte EO_DRXREF = (byte)13;
    private byte EO_HID = (byte)14;
    private byte EO_IS = (byte)15;
    private byte EO_PAGEDATA = (byte)16;
    private byte EO_JOURNAL = (byte)17;
    private byte EO_ORGANISM_HOST = (byte)18;
    private byte EO_PE = (byte)19;
    private byte EO_EVIDENCES = (byte)20;
    private byte EO_TYPE = (byte)21;
    private byte EO_UNIPROT_ID = (byte)22;

    @Override
    public void writeObject(UniProtEntry entry, ObjectOutput out) throws IOException {
        StopWatch sw = null;
        if (logger.isDebugEnabled()) {
            sw = new StopWatch();
            sw.start();
        }
        this.writeType(entry, out);
        this.writeUniProtId(out, entry);
        this.writeUniProtAccessions(out, entry);
        this.writeEntryAudit(out, entry);
        this.writeProteinDescription(entry, out);
        this.writeGenes(out, entry);
        this.writeOrganisms(out, entry);
        this.writeTaxIds(out, entry);
        this.writeOrganelles(out, entry);
        this.writeTaxonomy(entry, out);
        this.writeCitations(out, entry);
        this.writeCitationsNew(out, entry);
        this.writeFeatures(entry, out);
        this.writeKeywords(out, entry);
        this.writeSequence(out, entry.getSequence());
        this.writeComments(out, entry);
        this.writeDatabaseCrossReferences(out, entry);
        this.writeId(out, entry);
        this.writeInternalSection(out, entry);
        this.writeUnpublishedJournal(out, entry);
        this.writeOrganismHost(out, entry);
        this.writeProteinExistence(out, entry);
        this.writeEvidences(out, entry);
        if (logger.isDebugEnabled()) {
            sw.stop();
            logger.debug("writeObject " + entry.getUniProtId() + " in " + sw.getElapsedTime() + "ms");
        }
    }

    @Override
    public void readObject(UniProtEntry entry, ObjectInput in) throws IOException, ClassNotFoundException {
        StopWatch sw = null;
        if (logger.isDebugEnabled()) {
            sw = new StopWatch();
            sw.start();
        }
        this.readType(in, entry);
        this.readUniProtId(entry, in);
        this.readUniProtAccessions(entry, in);
        this.readEntryAudit(entry, in);
        this.readProteinDescription(in, entry);
        this.readGenes(in, entry);
        this.readOrganisms(in, entry);
        this.readTaxIds(in, entry);
        this.readOrganelles(in, entry);
        this.readTaxonomy(in, entry);
        this.readCitations(in, entry);
        this.readCitationsNew(in, entry);
        this.readFeatures(in, entry);
        this.readKeywords(in, entry);
        this.readSequence(in, entry.getSequence());
        this.readComments(in, entry);
        this.readDatabaseCrossReferences(in, entry);
        this.readId(in, entry);
        this.readIntenalSection(in, entry);
        this.readUnpublishedJournal(in, entry);
        this.readOrganismHost(in, entry);
        this.readProteinExistence(in, entry);
        this.readEvidences(in, entry);
        if (logger.isDebugEnabled()) {
            sw.stop();
            logger.debug("readObject " + entry.getUniProtId() + " in " + sw.getElapsedTime() + "ms");
        }
    }

    public void readOrganismHost(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        try {
            int size = in.readInt();
            for (int iii = 0; iii < size; ++iii) {
                OrganismHost host = DefaultUniProtFactory.getInstance().buildOrganismHost();
                host.setNcbiTaxonomyId(DefaultUniProtFactory.getInstance().buildNcbiTaxonomyId((String)in.readObject()));
                Organism org = DefaultUniProtFactory.getInstance().buildOrganism();
                org.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName((String)in.readObject()));
                org.setSynonym(DefaultUniProtFactory.getInstance().buildOrganismSynonym((String)in.readObject()));
                org.setCommonName(DefaultUniProtFactory.getInstance().buildOrganismCommonName((String)in.readObject()));
                host.setOrganism(org);
                entry.getOrganismHosts().add(host);
            }
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void writeOrganismHost(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getOrganismHosts().size());
        for (OrganismHost organismHost : entry.getOrganismHosts()) {
            out.writeObject(organismHost.getNcbiTaxonomyId().getValue());
            out.writeObject(organismHost.getOrganism().getScientificName().getValue());
            out.writeObject(organismHost.getOrganism().getSynonym().getValue());
            out.writeObject(organismHost.getOrganism().getCommonName().getValue());
        }
    }

    public void readProteinExistence(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        byte status = in.readByte();
        switch (status) {
            case 1: {
                entry.setProteinExistence(ProteinExistence.HOMOLOGY);
                break;
            }
            case 2: {
                entry.setProteinExistence(ProteinExistence.PREDICTED);
                break;
            }
            case 3: {
                entry.setProteinExistence(ProteinExistence.PROTEIN_LEVEL);
                break;
            }
            case 4: {
                entry.setProteinExistence(ProteinExistence.TRANSCRIPT_LEVEL);
                break;
            }
            case 5: {
                entry.setProteinExistence(ProteinExistence.UNCERTAIN);
                break;
            }
            case 6: {
                entry.setProteinExistence(ProteinExistence.UNKNOWN);
                break;
            }
        }
    }

    public void writeProteinExistence(ObjectOutput out, UniProtEntry entry) throws IOException {
        switch (entry.getProteinExistence()) {
            case HOMOLOGY: {
                out.writeByte(1);
                break;
            }
            case PREDICTED: {
                out.writeByte(2);
                break;
            }
            case PROTEIN_LEVEL: {
                out.writeByte(3);
                break;
            }
            case TRANSCRIPT_LEVEL: {
                out.writeByte(4);
                break;
            }
            case UNCERTAIN: {
                out.writeByte(5);
                break;
            }
            case UNKNOWN: {
                out.writeByte(6);
                break;
            }
        }
    }

    public void writeUnpublishedJournal(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getCitations(uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum.UNPUBLISHED_JOURNAL_ARTICLE).size());
        for (Citation citation : entry.getCitations(uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum.UNPUBLISHED_JOURNAL_ARTICLE)) {
            this.writeJournalArticle(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle)citation, entry);
        }
    }

    public void readUnpublishedJournal(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        try {
            int size = in.readInt();
            for (int iii = 0; iii < size; ++iii) {
                UnpublishedJournalArticle citation = DefaultCitationFactory.getInstance().buildUnpublishedJournalArticle();
                this.readJournalArticle(in, citation, entry);
                entry.getCitations().add(citation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readType(ObjectInput in, UniProtEntry entry) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                entry.setType(UniProtEntryType.SWISSPROT);
                break;
            }
            case 2: {
                entry.setType(UniProtEntryType.TREMBL);
                break;
            }
            case 3: {
                entry.setType(UniProtEntryType.UNKNOWN);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void writeType(UniProtEntry entry, ObjectOutput out) throws IOException {
        switch (entry.getType()) {
            case SWISSPROT: {
                out.writeByte(1);
                break;
            }
            case TREMBL: {
                out.writeByte(2);
                break;
            }
            case UNKNOWN: {
                out.writeByte(3);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void readTaxIds(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            NcbiTaxonomyId id = DefaultUniProtFactory.getInstance().buildNcbiTaxonomyId((String)in.readObject());
            this.readEvidenceIds(in, id);
            entry.getNcbiTaxonomyIds().add(id);
        }
    }

    private void writeTaxIds(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeByte(entry.getNcbiTaxonomyIds().size());
        for (NcbiTaxonomyId id : entry.getNcbiTaxonomyIds()) {
            out.writeObject(id.getValue());
            this.writeEvidenceIds(out, id.getEvidenceIds());
        }
    }

    private void writeComments(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeByte(entry.getComments().size());
        for (Comment comment : entry.getComments()) {
            this.writeComment(comment, out);
        }
    }

    public void writeComment(Comment comment, ObjectOutput out) throws IOException {
        switch (comment.getCommentType()) {
            case ALLERGEN: {
                out.writeByte(1);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                out.writeByte(2);
                this.writeAlternativeProductsComment(out, (AlternativeProductsComment)comment);
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                out.writeByte(3);
                this.writeBioPhysComment(out, (BioPhysicoChemicalPropertiesComment)comment);
                break;
            }
            case BIOTECHNOLOGY: {
                out.writeByte(4);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case CATALYTIC_ACTIVITY: {
                out.writeByte(5);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case CAUTION: {
                out.writeByte(6);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case COFACTOR: {
                out.writeByte(7);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case WEBRESOURCE: {
                out.writeByte(8);
                this.writeDatabaseComment(out, (WebResourceComment)comment);
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                out.writeByte(9);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case DISEASE: {
                out.writeByte(10);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case DOMAIN: {
                out.writeByte(11);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case ENZYME_REGULATION: {
                out.writeByte(12);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case FUNCTION: {
                out.writeByte(13);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case INDUCTION: {
                out.writeByte(14);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case INTERACTION: {
                out.writeByte(15);
                this.writeInteractionComment(out, (InteractionComment)comment);
                break;
            }
            case MASS_SPECTROMETRY: {
                out.writeByte(16);
                this.writeMassspecComment(out, (MassSpectrometryComment)comment);
                break;
            }
            case MISCELLANEOUS: {
                out.writeByte(17);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case PATHWAY: {
                out.writeByte(18);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case PHARMACEUTICAL: {
                out.writeByte(19);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case POLYMORPHISM: {
                out.writeByte(20);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case PTM: {
                out.writeByte(21);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case RNA_EDITING: {
                out.writeByte(22);
                this.writeRnaEditingComment(out, (RnaEditingComment)comment);
                break;
            }
            case SIMILARITY: {
                out.writeByte(23);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case SUBCELLULAR_LOCATION: {
                out.writeByte(24);
                this.writeSubcellularLocationComment(out, (SubcellularLocationComment)comment);
                break;
            }
            case SUBUNIT: {
                out.writeByte(25);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case TISSUE_SPECIFICITY: {
                out.writeByte(26);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case TOXIC_DOSE: {
                out.writeByte(27);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            case SEQUENCE_CAUTION: {
                out.writeByte(28);
                this.writeSequenceCautionComment(out, (SequenceCautionComment)comment);
                break;
            }
            case PAGE: {
                out.writeByte(29);
                this.writePageDataComment(out, (PAGEDataComment)comment);
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                out.writeByte(30);
                this.writeTextOnlyComment(out, (TextOnlyComment)comment);
                break;
            }
            default: {
                return;
            }
        }
        switch (comment.getCommentStatus()) {
            case BY_SIMILARITY: {
                out.writeByte(1);
                break;
            }
            case EXPERIMENTAL: {
                out.writeByte(2);
                break;
            }
            case NONE: {
                out.writeByte(3);
                break;
            }
            case OTHER: {
                out.writeByte(4);
                break;
            }
            case PROBABLE: {
                out.writeByte(5);
                break;
            }
            case POTENTIAL: {
                out.writeByte(6);
            }
        }
    }

    private void writeRnaEditingComment(ObjectOutput out, RnaEditingComment rnaEditingComment) throws IOException {
        out.writeInt(rnaEditingComment.getPositionsWithEvidences().size());
        for (Position aPosition : rnaEditingComment.getPositionsWithEvidences()) {
            out.writeObject(aPosition.getPosition());
            this.writeEvidenceIds(out, aPosition.getEvidenceIds());
        }
        out.writeObject(rnaEditingComment.getLocationType().toString());
        out.writeObject(rnaEditingComment.getRnaEditingNote().getValue());
        out.writeObject(rnaEditingComment.getCommentStatus().getValue());
        this.writeEvidenceIds(out, rnaEditingComment.getEvidenceIds());
    }

    private void readRnaEditingComment(ObjectInput in, RnaEditingComment rnaEditingComment) throws IOException, ClassNotFoundException {
        ArrayList<Position> positionList = new ArrayList<Position>();
        for (int i = in.readInt(); i > 0; --i) {
            Position position = DefaultCommentFactory.getInstance().buildRnaEditingPosition();
            position.setPosition((String)in.readObject());
            this.readEvidenceIds(in, position);
            positionList.add(position);
        }
        rnaEditingComment.setPositions(positionList);
        rnaEditingComment.setLocationType(RnaEditingLocationType.getType((String)in.readObject()));
        RnaEditingNote note = DefaultCommentFactory.getInstance().buildRnaEditingNote();
        note.setValue((String)in.readObject());
        rnaEditingComment.setRnaEditingNote(note);
        rnaEditingComment.setCommentStatus(CommentStatus.toType((String)in.readObject()));
        this.readEvidenceIds(in, rnaEditingComment);
    }

    private void writePageDataComment(ObjectOutput out, PAGEDataComment pageDataComment) throws IOException {
        out.writeObject(pageDataComment.getMolecularWeight().getValue());
        out.writeObject(pageDataComment.getPl().getValue());
    }

    private void readPAGEDataComment(ObjectInput in, PAGEDataComment pageDataComment) throws IOException, ClassNotFoundException {
        pageDataComment.setMolecularWeight(DefaultCommentFactory.getInstance().buildPAGEDataMolecularWeight((String)in.readObject()));
        pageDataComment.setPl(DefaultCommentFactory.getInstance().buildPAGEDataPl((String)in.readObject()));
    }

    private void readComments(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            Comment comment = this.readComment(in);
            entry.getComments(comment.getCommentType()).add(comment);
        }
    }

    public Comment readComment(ObjectInput in) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        HasCommentStatus comment = null;
        switch (type) {
            case 1: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.ALLERGEN);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 2: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.ALTERNATIVE_PRODUCTS);
                this.readAlternativeProductsComment(in, (AlternativeProductsComment)comment);
                break;
            }
            case 3: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.BIOPHYSICOCHEMICAL_PROPERTIES);
                this.readBioPhysComment(in, (BioPhysicoChemicalPropertiesComment)comment);
                break;
            }
            case 4: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.BIOTECHNOLOGY);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 5: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.CATALYTIC_ACTIVITY);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 6: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.CAUTION);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 7: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.COFACTOR);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 8: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.WEBRESOURCE);
                this.readDatabaseComment(in, (WebResourceComment)comment);
                break;
            }
            case 9: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.DEVELOPMENTAL_STAGE);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 10: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.DISEASE);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 11: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.DOMAIN);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 12: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.ENZYME_REGULATION);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 13: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.FUNCTION);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 14: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.INDUCTION);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 15: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.INTERACTION);
                this.readInteractionComment(in, (InteractionComment)comment);
                break;
            }
            case 16: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.MASS_SPECTROMETRY);
                this.readMassSpecComment(in, (MassSpectrometryComment)comment);
                break;
            }
            case 17: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.MISCELLANEOUS);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 18: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.PATHWAY);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 19: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.PHARMACEUTICAL);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 20: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.POLYMORPHISM);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 21: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.PTM);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 22: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.RNA_EDITING);
                this.readRnaEditingComment(in, (RnaEditingComment)comment);
                break;
            }
            case 23: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.SIMILARITY);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 24: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.SUBCELLULAR_LOCATION);
                this.readSubcellularLocationComment(in, (SubcellularLocationComment)comment);
                break;
            }
            case 25: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.SUBUNIT);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 26: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.TISSUE_SPECIFICITY);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 27: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.TOXIC_DOSE);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            case 28: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.SEQUENCE_CAUTION);
                this.readSequenceCautionComment(in, (SequenceCautionComment)comment);
                break;
            }
            case 29: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.PAGE);
                this.readPAGEDataComment(in, (PAGEDataComment)comment);
                break;
            }
            case 30: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.DISRUPTION_PHENOTYPE);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
                break;
            }
            default: {
                comment = (HasCommentStatus)DefaultCommentFactory.getInstance().buildComment(CommentType.UNKNOWN);
                this.readTextOnlyComment(in, (TextOnlyComment)comment);
            }
        }
        byte status = in.readByte();
        switch (status) {
            case 1: {
                comment.setCommentStatus(CommentStatus.BY_SIMILARITY);
                break;
            }
            case 2: {
                comment.setCommentStatus(CommentStatus.EXPERIMENTAL);
                break;
            }
            case 3: {
                comment.setCommentStatus(CommentStatus.NONE);
                break;
            }
            case 4: {
                comment.setCommentStatus(CommentStatus.OTHER);
                break;
            }
            case 5: {
                comment.setCommentStatus(CommentStatus.PROBABLE);
                break;
            }
            case 6: {
                comment.setCommentStatus(CommentStatus.POTENTIAL);
            }
        }
        return comment;
    }

    private void readMassSpecComment(ObjectInput in, MassSpectrometryComment comment) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                comment.setMethod(MassSpectrometryMethod.ELECTROSPRAY);
                break;
            }
            case 2: {
                comment.setMethod(MassSpectrometryMethod.FAB);
                break;
            }
            case 3: {
                comment.setMethod(MassSpectrometryMethod.LSI);
                break;
            }
            case 4: {
                comment.setMethod(MassSpectrometryMethod.MALDI);
                break;
            }
            case 5: {
                comment.setMethod(MassSpectrometryMethod.PLASMA_DESORPTION);
                break;
            }
            case 6: {
                comment.setMethod(MassSpectrometryMethod.SELDI);
                break;
            }
            case 7: {
                comment.setMethod(MassSpectrometryMethod.UNKNOWN);
            }
        }
        comment.setMolWeight(in.readFloat());
        comment.setMolWeightError(in.readFloat());
        String noteString = (String)in.readObject();
        String[] strings = noteString.split(";");
        if (strings.length > 0) {
            String note = strings[0];
            comment.setNote(DefaultCommentFactory.getInstance().buildMassSpectrometryCommentNote(note));
            if (strings.length > 1) {
                String[] sources;
                for (String source : sources = strings[1].split(",")) {
                    comment.getSources().add(DefaultCommentFactory.getInstance().buildMassSpectrometryCommentSource(source.trim()));
                }
            }
        }
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            MassSpectrometryRange range = DefaultCommentFactory.getInstance().buildMassSpectrometryRange();
            range.setStart(in.readInt());
            range.setEnd(in.readInt());
            range.setNote(DefaultCommentFactory.getInstance().buildMassSpectrometryRangeNote((String)in.readObject()));
            comment.getRanges().add(range);
        }
    }

    private void writeMassspecComment(ObjectOutput out, MassSpectrometryComment comment) throws IOException {
        switch (comment.getMethod()) {
            case ELECTROSPRAY: {
                out.writeByte(1);
                break;
            }
            case FAB: {
                out.writeByte(2);
                break;
            }
            case LSI: {
                out.writeByte(3);
                break;
            }
            case MALDI: {
                out.writeByte(4);
                break;
            }
            case PLASMA_DESORPTION: {
                out.writeByte(5);
                break;
            }
            case SELDI: {
                out.writeByte(6);
                break;
            }
            case UNKNOWN: {
                out.writeByte(7);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        out.writeFloat(comment.getMolWeight());
        out.writeFloat(comment.getMolWeightError());
        StringBuilder stringBuilder = new StringBuilder(comment.getNote().getValue());
        stringBuilder.append(";");
        Iterator<MassSpectrometryCommentSource> iterator = comment.getSources().iterator();
        while (iterator.hasNext()) {
            MassSpectrometryCommentSource o = iterator.next();
            stringBuilder.append(o.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        out.writeObject(stringBuilder.toString());
        out.writeByte(comment.getRanges().size());
        for (MassSpectrometryRange range : comment.getRanges()) {
            out.writeInt(range.getStart());
            out.writeInt(range.getEnd());
            out.writeObject(range.getIsoformId().getValue());
        }
    }

    private void writeSequenceCautionComment(ObjectOutput out, SequenceCautionComment comment) throws IOException {
        switch (comment.getType()) {
            case ERRONEOUS_INITIATION: {
                out.writeByte(1);
                break;
            }
            case ERRONEOUS_PREDICTION: {
                out.writeByte(2);
                break;
            }
            case ERRONEOUS_TERMIINATION: {
                out.writeByte(3);
                break;
            }
            case ERRONEOUS_TRANSLATION: {
                out.writeByte(4);
                break;
            }
            case FRAMESHIFT: {
                out.writeByte(5);
                break;
            }
            case MISCELLANEOUS_DISCREPANCY: {
                out.writeByte(6);
                break;
            }
            case UNKNOWN: {
                out.writeByte(7);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        out.writeObject(comment.getNote().getValue());
        out.writeObject(comment.getSequence());
        out.writeByte(comment.getPositions().size());
        for (SequenceCautionPosition position : comment.getPositions()) {
            out.writeObject(position.getValue());
        }
    }

    private void readSequenceCautionComment(ObjectInput in, SequenceCautionComment comment) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        switch (type) {
            case 1: {
                comment.setType(SequenceCautionType.ERRONEOUS_INITIATION);
                break;
            }
            case 2: {
                comment.setType(SequenceCautionType.ERRONEOUS_PREDICTION);
                break;
            }
            case 3: {
                comment.setType(SequenceCautionType.ERRONEOUS_TERMIINATION);
                break;
            }
            case 4: {
                comment.setType(SequenceCautionType.ERRONEOUS_TRANSLATION);
                break;
            }
            case 5: {
                comment.setType(SequenceCautionType.FRAMESHIFT);
                break;
            }
            case 6: {
                comment.setType(SequenceCautionType.MISCELLANEOUS_DISCREPANCY);
                break;
            }
            case 7: {
                comment.setType(SequenceCautionType.UNKNOWN);
            }
        }
        comment.setNote(DefaultCommentFactory.getInstance().buildSequenceCautionCommentNote((String)in.readObject()));
        comment.setSequence((String)in.readObject());
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            SequenceCautionPosition position = DefaultCommentFactory.getInstance().buildSequenceCautionPosition();
            position.setValue((String)in.readObject());
            comment.getPositions().add(position);
        }
    }

    private void readInteractionComment(ObjectInput in, InteractionComment comment) throws ClassNotFoundException, IOException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            Interaction interaction = DefaultCommentFactory.getInstance().buildInteraction();
            interaction.setFirstInteractor(DefaultCommentFactory.getInstance().buildIntActAccession((String)in.readObject()));
            interaction.setSecondInteractor(DefaultCommentFactory.getInstance().buildIntActAccession((String)in.readObject()));
            interaction.setInteractionGeneName(DefaultCommentFactory.getInstance().buildInteractionGeneName((String)in.readObject()));
            interaction.setInteractorUniProtAccession(DefaultCommentFactory.getInstance().buildInteractorUniProtAccession((String)in.readObject()));
            interaction.setNumberOfExperiments(in.readInt());
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    interaction.setInteractionType(InteractionType.BINARY);
                    break;
                }
                case 2: {
                    interaction.setInteractionType(InteractionType.SELF);
                    break;
                }
                case 3: {
                    interaction.setInteractionType(InteractionType.UNKNOWN);
                    break;
                }
                case 4: {
                    interaction.setInteractionType(InteractionType.XENO);
                }
            }
            comment.getInteractions().add(interaction);
        }
    }

    private void writeInteractionComment(ObjectOutput out, InteractionComment comment) throws IOException {
        out.writeInt(comment.getInteractions().size());
        block6: for (Interaction interaction : comment.getInteractions()) {
            out.writeObject(interaction.getFirstInteractor().getValue());
            out.writeObject(interaction.getSecondInteractor().getValue());
            out.writeObject(interaction.getInteractionGeneName().getValue());
            out.writeObject(interaction.getInteractorUniProtAccession().getValue());
            out.writeInt(interaction.getNumberOfExperiments());
            switch (interaction.getInteractionType()) {
                case BINARY: {
                    out.writeByte(1);
                    continue block6;
                }
                case SELF: {
                    out.writeByte(2);
                    continue block6;
                }
                case UNKNOWN: {
                    out.writeByte(3);
                    continue block6;
                }
                case XENO: {
                    out.writeByte(4);
                    continue block6;
                }
            }
            throw new IOException();
        }
    }

    private void writeBioPhysComment(ObjectOutput out, BioPhysicoChemicalPropertiesComment comment) throws IOException {
        out.writeBoolean(comment.hasRedoxPotentialProperty());
        if (comment.hasRedoxPotentialProperty()) {
            out.writeObject(comment.getRedoxPotential().getValue());
        }
        out.writeBoolean(comment.hasTemperatureDependenceProperty());
        if (comment.hasTemperatureDependenceProperty()) {
            out.writeObject(comment.getTemperatureDependence().getValue());
        }
        out.writeBoolean(comment.hasAbsorptionProperty());
        if (comment.hasAbsorptionProperty()) {
            out.writeInt(comment.getAbsorption().getMax());
            out.writeObject(comment.getAbsorption().getNote().getValue());
            out.writeBoolean(comment.getAbsorption().isApproximation());
        }
        out.writeBoolean(comment.hasPHDependenceProperty());
        if (comment.hasPHDependenceProperty()) {
            out.writeObject(comment.getPHDependence().getValue());
        }
        this.writeKineticParameters(out, comment);
    }

    private void readBioPhysComment(ObjectInput in, BioPhysicoChemicalPropertiesComment comment) throws ClassNotFoundException, IOException {
        if (in.readBoolean()) {
            RedoxPotential redox = DefaultCommentFactory.getInstance().buildRedoxPotential();
            redox.setValue((String)in.readObject());
            comment.setRedoxPotential(redox);
        }
        if (in.readBoolean()) {
            TemperatureDependence tempdep = DefaultCommentFactory.getInstance().buildTemperatureDependence();
            tempdep.setValue((String)in.readObject());
            comment.setTemperatureDependence(tempdep);
        }
        if (in.readBoolean()) {
            Absorption absorption = DefaultCommentFactory.getInstance().buildAbsorption();
            absorption.setMax(in.readInt());
            absorption.setNote(DefaultCommentFactory.getInstance().buildAbsorptionNote((String)in.readObject()));
            absorption.setApproximation(in.readBoolean());
            comment.setAbsorption(absorption);
        }
        if (in.readBoolean()) {
            PHDependence phDependence = DefaultCommentFactory.getInstance().buildPHDependence();
            phDependence.setValue((String)in.readObject());
            comment.setPHDepencence(phDependence);
        }
        this.readKineticParameters(in, comment);
    }

    private void writeKineticParameters(ObjectOutput out, BioPhysicoChemicalPropertiesComment comment) throws IOException {
        out.writeBoolean(comment.hasKineticParametersProperty());
        if (comment.hasKineticParametersProperty()) {
            out.writeObject(comment.getKineticParameters().getNote().getValue());
            out.writeByte(comment.getKineticParameters().getMaximumVelocities().size());
            for (MaximumVelocity vmax : comment.getKineticParameters().getMaximumVelocities()) {
                out.writeObject(vmax.getEnzyme().getValue());
                out.writeFloat(vmax.getVelocity());
                out.writeByte(vmax.getUnit().getStorageValue());
            }
            out.writeByte(comment.getKineticParameters().getMichaelisConstants().size());
            block7: for (MichaelisConstant constant : comment.getKineticParameters().getMichaelisConstants()) {
                out.writeFloat(constant.getConstant());
                out.writeObject(constant.getSubstrate().getValue());
                switch (constant.getUnit()) {
                    case MICRO_MOL: {
                        out.writeByte(1);
                        continue block7;
                    }
                    case MILLI_MOL: {
                        out.writeByte(2);
                        continue block7;
                    }
                    case NANO_MOL: {
                        out.writeByte(3);
                        continue block7;
                    }
                    case MOL: {
                        out.writeByte(4);
                        continue block7;
                    }
                }
                throw new IOException();
            }
        }
    }

    private void readKineticParameters(ObjectInput in, BioPhysicoChemicalPropertiesComment comment) throws IOException, ClassNotFoundException {
        if (in.readBoolean()) {
            int jjj;
            KineticParameters kp = DefaultCommentFactory.getInstance().buildKineticParameters((String)in.readObject());
            comment.setKineticParameters(kp);
            int s = in.readByte();
            for (jjj = 0; jjj < s; ++jjj) {
                MaximumVelocity mv = DefaultCommentFactory.getInstance().buildMaximumVelocity();
                mv.setEnzyme(DefaultCommentFactory.getInstance().buildEnzyme((String)in.readObject()));
                mv.setVelocity(in.readFloat());
                mv.setUnit(MaximumVelocityUnit.convert(in.readByte()));
                kp.getMaximumVelocities().add(mv);
            }
            s = in.readByte();
            for (jjj = 0; jjj < s; ++jjj) {
                MichaelisConstant mc = DefaultCommentFactory.getInstance().buildMichaelisConstant();
                mc.setConstant(in.readFloat());
                mc.setSubstrate(DefaultCommentFactory.getInstance().buildSubstrate((String)in.readObject()));
                byte type = in.readByte();
                switch (type) {
                    case 1: {
                        mc.setUnit(MichaelisConstantUnit.MICRO_MOL);
                        break;
                    }
                    case 2: {
                        mc.setUnit(MichaelisConstantUnit.MILLI_MOL);
                        break;
                    }
                    case 3: {
                        mc.setUnit(MichaelisConstantUnit.NANO_MOL);
                        break;
                    }
                    case 4: {
                        mc.setUnit(MichaelisConstantUnit.MOL);
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
                kp.getMichaelisConstants().add(mc);
            }
        }
    }

    private void readAlternativeProductsComment(ObjectInput in, AlternativeProductsComment comment) throws ClassNotFoundException, IOException {
        int eventsize = in.readInt();
        for (int iii = 0; iii < eventsize; ++iii) {
            comment.getEvents().add(DefaultCommentFactory.getInstance().buildAlternativeProductsEvent((String)in.readObject()));
        }
        AlternativeProductsCommentComment c = DefaultCommentFactory.getInstance().buildAlternativeProductsCommentComment((String)in.readObject());
        this.readEvidenceIds(in, c);
        comment.setComment(c);
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            int jjj;
            AlternativeProductsIsoform isoform = DefaultCommentFactory.getInstance().buildAlternativeProductsIsoform();
            int s = in.readInt();
            for (jjj = 0; jjj < s; ++jjj) {
                isoform.getIds().add(DefaultCommentFactory.getInstance().buildIsoformId((String)in.readObject()));
            }
            s = in.readInt();
            for (jjj = 0; jjj < s; ++jjj) {
                isoform.getSequenceIds().add(DefaultCommentFactory.getInstance().buildIsoformSequenceId((String)in.readObject()));
            }
            s = in.readInt();
            for (jjj = 0; jjj < s; ++jjj) {
                IsoformSynonym sy = DefaultCommentFactory.getInstance().buildIsoformSynonym((String)in.readObject());
                this.readEvidenceIds(in, sy);
                isoform.getSynonyms().add(sy);
            }
            IsoformName name = DefaultCommentFactory.getInstance().buildIsoformName((String)in.readObject());
            this.readEvidenceIds(in, name);
            isoform.setName(name);
            IsoformNote note = DefaultCommentFactory.getInstance().buildIsoformNote((String)in.readObject());
            this.readEvidenceIds(in, note);
            isoform.setNote(note);
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    isoform.setIsoformSequenceStatus(IsoformSequenceStatus.DESCRIBED);
                    break;
                }
                case 2: {
                    isoform.setIsoformSequenceStatus(IsoformSequenceStatus.DISPLAYED);
                    break;
                }
                case 3: {
                    isoform.setIsoformSequenceStatus(IsoformSequenceStatus.EXTERNAL);
                    break;
                }
                case 4: {
                    isoform.setIsoformSequenceStatus(IsoformSequenceStatus.NOT_DESCRIBED);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            comment.getIsoforms().add(isoform);
        }
    }

    private void writeAlternativeProductsComment(ObjectOutput out, AlternativeProductsComment comment) throws IOException {
        out.writeInt(comment.getEvents().size());
        for (AlternativeProductsEvent event : comment.getEvents()) {
            out.writeObject(event.getValue());
        }
        out.writeObject(comment.getComment().getValue());
        this.writeEvidenceIds(out, comment.getComment().getEvidenceIds());
        out.writeInt(comment.getIsoforms().size());
        for (AlternativeProductsIsoform isoform : comment.getIsoforms()) {
            out.writeInt(isoform.getIds().size());
            for (IsoformId isoformId : isoform.getIds()) {
                out.writeObject(isoformId.getValue());
            }
            out.writeInt(isoform.getSequenceIds().size());
            for (IsoformSequenceId isoformSequenceId : isoform.getSequenceIds()) {
                out.writeObject(isoformSequenceId.getValue());
            }
            out.writeInt(isoform.getSynonyms().size());
            for (IsoformSynonym isoformSynonym : isoform.getSynonyms()) {
                out.writeObject(isoformSynonym.getValue());
                this.writeEvidenceIds(out, isoformSynonym.getEvidenceIds());
            }
            out.writeObject(isoform.getName().getValue());
            this.writeEvidenceIds(out, isoform.getName().getEvidenceIds());
            out.writeObject(isoform.getNote().getValue());
            this.writeEvidenceIds(out, isoform.getNote().getEvidenceIds());
            switch (isoform.getIsoformSequenceStatus()) {
                case DESCRIBED: {
                    out.writeByte(1);
                    break;
                }
                case DISPLAYED: {
                    out.writeByte(2);
                    break;
                }
                case EXTERNAL: {
                    out.writeByte(3);
                    break;
                }
                case NOT_DESCRIBED: {
                    out.writeByte(4);
                }
            }
        }
    }

    private void readTextOnlyComment(ObjectInput in, TextOnlyComment comment) throws ClassNotFoundException, IOException {
        comment.setValue((String)in.readObject());
        this.readEvidenceIds(in, comment);
    }

    private void writeDatabaseComment(ObjectOutput out, WebResourceComment comment) throws IOException {
        out.writeObject(comment.getDatabaseFTP().getValue());
        out.writeObject(comment.getDatabaseName().getValue());
        out.writeObject(comment.getDatabaseNote().getValue());
        out.writeObject(comment.getDatabaseURL().getValue());
    }

    private void readDatabaseComment(ObjectInput in, WebResourceComment webResourceComment) throws IOException, ClassNotFoundException {
        webResourceComment.setDatabaseFTP(DefaultCommentFactory.getInstance().buildDatabaseFTP((String)in.readObject()));
        webResourceComment.setDatabaseName(DefaultCommentFactory.getInstance().buildDatabaseName((String)in.readObject()));
        webResourceComment.setDatabaseNote(DefaultCommentFactory.getInstance().buildDatabaseNote((String)in.readObject()));
        webResourceComment.setDatabaseURL(DefaultCommentFactory.getInstance().buildDatabaseURL((String)in.readObject()));
    }

    private void readSubcellularLocationComment(ObjectInput in, SubcellularLocationComment comment) throws ClassNotFoundException, IOException {
        SubcellularMoleculeImpl subcellularMolecule = new SubcellularMoleculeImpl();
        subcellularMolecule.setValue((String)in.readObject());
        comment.setSubcellularMolecule(subcellularMolecule);
        ArrayList<SubcellularLocation> locationList = new ArrayList<SubcellularLocation>();
        for (int size = in.readInt(); size > 0; --size) {
            SubcellularLocationValueImpl cellLocation = new SubcellularLocationValueImpl();
            cellLocation.setValue((String)in.readObject());
            cellLocation.setCommentStatus(CommentStatus.toType((String)in.readObject()));
            SubcellularLocationValueImpl topology = new SubcellularLocationValueImpl();
            topology.setValue((String)in.readObject());
            topology.setCommentStatus(CommentStatus.toType((String)in.readObject()));
            SubcellularLocationValueImpl orientation = new SubcellularLocationValueImpl();
            orientation.setValue((String)in.readObject());
            orientation.setCommentStatus(CommentStatus.toType((String)in.readObject()));
            SubcellularLocationImpl location = new SubcellularLocationImpl();
            location.setLocation(cellLocation);
            location.setTopology(topology);
            location.setOrientation(orientation);
            locationList.add(location);
        }
        comment.setSubcellularLocations(locationList);
        SubcellularLocationValueImpl note = new SubcellularLocationValueImpl();
        note.setValue((String)in.readObject());
        note.setCommentStatus(CommentStatus.toType((String)in.readObject()));
        comment.setSubcellularLocationNote(note);
        this.readEvidenceIds(in, comment);
    }

    private void writeSubcellularLocationComment(ObjectOutput out, SubcellularLocationComment comment) throws IOException {
        out.writeObject(comment.getSubcellularMolecule().getValue());
        List<SubcellularLocation> locationList = comment.getSubcellularLocations();
        out.writeInt(locationList.size());
        for (SubcellularLocation aSubcellularLocation : locationList) {
            out.writeObject(aSubcellularLocation.getLocation().getValue());
            out.writeObject(aSubcellularLocation.getLocation().getCommentStatus().getValue());
            out.writeObject(aSubcellularLocation.getTopology().getValue());
            out.writeObject(aSubcellularLocation.getTopology().getCommentStatus().getValue());
            out.writeObject(aSubcellularLocation.getOrientation().getValue());
            out.writeObject(aSubcellularLocation.getOrientation().getCommentStatus().getValue());
        }
        out.writeObject(comment.getSubcellularLocationNote().getValue());
        out.writeObject(comment.getSubcellularLocationNote().getCommentStatus().getValue());
        this.writeEvidenceIds(out, comment.getEvidenceIds());
    }

    private void writeTextOnlyComment(ObjectOutput out, TextOnlyComment comment) throws IOException {
        out.writeObject(comment.getValue());
        this.writeEvidenceIds(out, comment.getEvidenceIds());
    }

    private void readDatabaseCrossReferences(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        new DefaultDatabaseCrossReferencesSerializer().readDatabaseCrossReferences(in, entry);
    }

    private void writeDatabaseCrossReferences(ObjectOutput out, UniProtEntry entry) throws IOException {
        new DefaultDatabaseCrossReferencesSerializer().writeDatabaseCrossReferences(out, entry);
    }

    private void writeCitations(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getCitations().size() - entry.getCitations(uk.ac.ebi.kraken.interfaces.uniprot.citations.CitationTypeEnum.UNPUBLISHED_JOURNAL_ARTICLE).size());
        for (Citation citation : entry.getCitations()) {
            boolean unpub = false;
            switch (citation.getCitationType()) {
                case BOOK: {
                    out.writeByte(1);
                    this.writeBook(out, (Book)citation, entry);
                    break;
                }
                case ELECTRONIC_ARTICLE: {
                    out.writeByte(2);
                    this.writeElectronicArticle(out, (ElectronicArticle)citation, entry);
                    break;
                }
                case JOURNAL_ARTICLE: {
                    out.writeByte(3);
                    this.writeJournalArticle(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle)citation, entry);
                    break;
                }
                case PATENT: {
                    out.writeByte(4);
                    this.writePatent(out, (Patent)citation, entry);
                    break;
                }
                case SUBMISSION: {
                    out.writeByte(5);
                    this.writeSubmission(out, (Submission)citation, entry);
                    break;
                }
                case THESIS: {
                    out.writeByte(6);
                    this.writeThesis(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis)citation, entry);
                    break;
                }
                case UNKNOWN: {
                    out.writeByte(7);
                    break;
                }
                case UNPUBLISHED_OBSERVATIONS: {
                    out.writeByte(8);
                    this.writeUnpublishedObservations(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations)citation, entry);
                    break;
                }
                case UNPUBLISHED_RESULTS: {
                    out.writeByte(9);
                    this.writeUnpublishedResults(out, (UnpublishedResults)citation, entry);
                    break;
                }
                case UNPUBLISHED_JOURNAL_ARTICLE: {
                    unpub = true;
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            if (unpub) continue;
            this.writeEvidenceIds(out, citation.getEvidenceIds());
        }
    }

    private void readCitations(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            byte type = in.readByte();
            Citation citation = null;
            switch (type) {
                case 1: {
                    citation = DefaultCitationFactory.getInstance().buildBook();
                    this.readBook(in, (Book)citation, entry);
                    break;
                }
                case 2: {
                    citation = DefaultCitationFactory.getInstance().buildElectronicArticle();
                    this.readElectronicArticle(in, (ElectronicArticle)citation, entry);
                    break;
                }
                case 3: {
                    citation = DefaultCitationFactory.getInstance().buildJournalArticle();
                    this.readJournalArticle(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle)citation, entry);
                    break;
                }
                case 4: {
                    citation = DefaultCitationFactory.getInstance().buildPatent();
                    this.readPatent(in, (Patent)citation, entry);
                    break;
                }
                case 5: {
                    citation = DefaultCitationFactory.getInstance().buildSubmission();
                    this.readSubmission(in, (Submission)citation, entry);
                    break;
                }
                case 6: {
                    citation = DefaultCitationFactory.getInstance().buildThesis();
                    this.readThesis(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis)citation, entry);
                    break;
                }
                case 7: {
                    throw new IOException();
                }
                case 8: {
                    citation = DefaultCitationFactory.getInstance().buildUnpublishedObservations();
                    this.readUnpublishedObservations(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations)citation, entry);
                    break;
                }
                case 9: {
                    citation = DefaultCitationFactory.getInstance().buildUnpublishedResults();
                    this.readUnpublishedResults(in, (UnpublishedResults)citation, entry);
                    break;
                }
                default: {
                    System.out.println("xxx " + type);
                    throw new IOException();
                }
            }
            this.readEvidenceIds(in, citation);
            if (citation == null) continue;
            entry.getCitations().add(citation);
        }
    }

    private void writeCitationsNew(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getCitationsNew().size() - entry.getCitationsNew(CitationTypeEnum.UNPUBLISHED_JOURNAL_ARTICLE).size());
        for (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation : entry.getCitationsNew()) {
            boolean unpub = false;
            switch (citation.getCitationType()) {
                case BOOK: {
                    out.writeByte(1);
                    this.writeBookNew(out, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book)citation, entry);
                    break;
                }
                case ELECTRONIC_ARTICLE: {
                    out.writeByte(2);
                    this.writeElectronicArticleNew(out, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle)citation, entry);
                    break;
                }
                case JOURNAL_ARTICLE: {
                    out.writeByte(3);
                    this.writeJournalArticleNew(out, (JournalArticle)citation, entry);
                    break;
                }
                case PATENT: {
                    out.writeByte(4);
                    this.writePatentNew(out, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent)citation, entry);
                    break;
                }
                case SUBMISSION: {
                    out.writeByte(5);
                    this.writeSubmissionNew(out, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission)citation, entry);
                    break;
                }
                case THESIS: {
                    out.writeByte(6);
                    this.writeThesisNew(out, (Thesis)citation, entry);
                    break;
                }
                case UNKNOWN: {
                    out.writeByte(7);
                    break;
                }
                case UNPUBLISHED_OBSERVATIONS: {
                    out.writeByte(8);
                    this.writeUnpublishedObservationsNew(out, (UnpublishedObservations)citation, entry);
                    break;
                }
                case UNPUBLISHED_JOURNAL_ARTICLE: {
                    unpub = true;
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            if (unpub) continue;
            this.writeEvidenceIds(out, citation.getEvidenceIds());
        }
    }

    private void readCitationsNew(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            byte type = in.readByte();
            uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation = null;
            switch (type) {
                case 1: {
                    citation = DefaultCitationNewFactory.getInstance().buildBook();
                    this.readBookNew(in, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book)citation, entry);
                    break;
                }
                case 2: {
                    citation = DefaultCitationNewFactory.getInstance().buildElectronicArticle();
                    this.readElectronicArticleNew(in, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle)citation, entry);
                    break;
                }
                case 3: {
                    citation = DefaultCitationNewFactory.getInstance().buildJournalArticle();
                    this.readJournalArticleNew(in, (JournalArticle)citation, entry);
                    break;
                }
                case 4: {
                    citation = DefaultCitationNewFactory.getInstance().buildPatent();
                    this.readPatentNew(in, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent)citation, entry);
                    break;
                }
                case 5: {
                    citation = DefaultCitationNewFactory.getInstance().buildSubmission();
                    this.readSubmissionNew(in, (uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission)citation, entry);
                    break;
                }
                case 6: {
                    citation = DefaultCitationNewFactory.getInstance().buildThesis();
                    this.readThesisNew(in, (Thesis)citation, entry);
                    break;
                }
                case 7: {
                    throw new IOException();
                }
                case 8: {
                    citation = DefaultCitationNewFactory.getInstance().buildUnpublishedObservations();
                    this.readUnpublishedObservationsNew(in, (UnpublishedObservations)citation, entry);
                    break;
                }
                default: {
                    System.out.println("xxx " + type);
                    throw new IOException();
                }
            }
            this.readEvidenceIds(in, citation);
            if (citation == null) continue;
            entry.getCitationsNew().add(citation);
        }
    }

    private void readUnpublishedResults(ObjectInput in, UnpublishedResults ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        Citation citation;
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        byte type = in.readByte();
        switch (type) {
            case 1: {
                citation = DefaultCitationFactory.getInstance().buildBook();
                this.readBook(in, (Book)citation, entry);
                break;
            }
            case 2: {
                citation = DefaultCitationFactory.getInstance().buildElectronicArticle();
                this.readElectronicArticle(in, (ElectronicArticle)citation, entry);
                break;
            }
            case 3: {
                citation = DefaultCitationFactory.getInstance().buildJournalArticle();
                this.readJournalArticle(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle)citation, entry);
                break;
            }
            case 4: {
                citation = DefaultCitationFactory.getInstance().buildPatent();
                this.readPatent(in, (Patent)citation, entry);
                break;
            }
            case 5: {
                citation = DefaultCitationFactory.getInstance().buildSubmission();
                this.readSubmission(in, (Submission)citation, entry);
                break;
            }
            case 6: {
                citation = DefaultCitationFactory.getInstance().buildThesis();
                this.readThesis(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis)citation, entry);
                break;
            }
            case 7: {
                throw new IOException();
            }
            case 8: {
                citation = DefaultCitationFactory.getInstance().buildUnpublishedObservations();
                this.readUnpublishedObservations(in, (uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations)citation, entry);
                break;
            }
            case 9: {
                citation = DefaultCitationFactory.getInstance().buildUnpublishedResults();
                this.readUnpublishedResults(in, (UnpublishedResults)citation, entry);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        ea.setReferringCitation(citation);
    }

    private void writeUnpublishedResults(ObjectOutput out, UnpublishedResults ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        switch (ea.getReferringCitation().getCitationType()) {
            case BOOK: {
                out.writeByte(1);
                this.writeBook(out, (Book)ea.getReferringCitation(), entry);
                break;
            }
            case ELECTRONIC_ARTICLE: {
                out.writeByte(2);
                this.writeElectronicArticle(out, (ElectronicArticle)ea.getReferringCitation(), entry);
                break;
            }
            case JOURNAL_ARTICLE: {
                out.writeByte(3);
                this.writeJournalArticle(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle)ea.getReferringCitation(), entry);
                break;
            }
            case PATENT: {
                out.writeByte(4);
                this.writePatent(out, (Patent)ea.getReferringCitation(), entry);
                break;
            }
            case SUBMISSION: {
                out.writeByte(5);
                this.writeSubmission(out, (Submission)ea.getReferringCitation(), entry);
                break;
            }
            case THESIS: {
                out.writeByte(6);
                this.writeThesis(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis)ea.getReferringCitation(), entry);
                break;
            }
            case UNKNOWN: {
                out.writeByte(7);
                break;
            }
            case UNPUBLISHED_OBSERVATIONS: {
                out.writeByte(8);
                this.writeUnpublishedObservations(out, (uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations)ea.getReferringCitation(), entry);
                break;
            }
            case UNPUBLISHED_RESULTS: {
                out.writeByte(9);
                this.writeUnpublishedResults(out, (UnpublishedResults)ea.getReferringCitation(), entry);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void readUnpublishedObservations(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readPublicationDate(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
    }

    private void writeUnpublishedObservations(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citations.UnpublishedObservations ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writePublicationDate(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
    }

    private void writeUnpublishedObservationsNew(ObjectOutput out, UnpublishedObservations ua, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, ua, entry);
        this.writeAuthorsNew(out, ua, entry);
        this.writeCitationXrefsNew(out, ua, entry);
        this.writePublicationDateNew(out, ua, entry);
        this.writeSampleSourcesNew(out, ua, entry);
        this.writeCitationSummariesNew(out, ua, entry);
        this.writeTitleNew(out, ua, entry);
    }

    private void readUnpublishedObservationsNew(ObjectInput in, UnpublishedObservations uo, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, uo, entry);
        this.readAuthorsNew(in, uo, entry);
        this.readCitationsXrefsNew(in, uo, entry);
        this.readPublicationDateNew(in, uo, entry);
        this.readSampleSourcesNew(in, uo, entry);
        this.readCitationSummariesNew(in, uo, entry);
        this.readTitleNew(in, uo, entry);
    }

    private void readThesis(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readPublicationDate(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        this.readTitle(in, ea, entry);
        String country = (String)in.readObject();
        String institute = (String)in.readObject();
        ea.setCountry(DefaultCitationFactory.getInstance().buildCountry(country));
        ea.setInstitute(DefaultCitationFactory.getInstance().buildInstitute(institute));
    }

    private void writeThesis(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citations.Thesis ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writePublicationDate(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        this.writeTitle(out, ea, entry);
        out.writeObject(ea.getCountry().getValue());
        out.writeObject(ea.getInstitute().getValue());
    }

    private void writeThesisNew(ObjectOutput out, Thesis thesis, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, thesis, entry);
        this.writeAuthorsNew(out, thesis, entry);
        this.writeCitationXrefsNew(out, thesis, entry);
        this.writePublicationDateNew(out, thesis, entry);
        this.writeSampleSourcesNew(out, thesis, entry);
        this.writeCitationSummariesNew(out, thesis, entry);
        this.writeTitleNew(out, thesis, entry);
        out.writeObject(thesis.getCountry().getValue());
        out.writeObject(thesis.getCity().getValue());
        out.writeObject(thesis.getInstitute().getValue());
    }

    private void readThesisNew(ObjectInput in, Thesis thesis, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, thesis, entry);
        this.readAuthorsNew(in, thesis, entry);
        this.readCitationsXrefsNew(in, thesis, entry);
        this.readPublicationDateNew(in, thesis, entry);
        this.readSampleSourcesNew(in, thesis, entry);
        this.readCitationSummariesNew(in, thesis, entry);
        this.readTitleNew(in, thesis, entry);
        String country = (String)in.readObject();
        thesis.setCountry(DefaultCitationNewFactory.getInstance().buildCountry(country));
        String city = (String)in.readObject();
        thesis.setCity(DefaultCitationNewFactory.getInstance().buildCity(city));
        String institute = (String)in.readObject();
        thesis.setInstitute(DefaultCitationNewFactory.getInstance().buildInstitute(institute));
    }

    private void readSubmission(ObjectInput in, Submission ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readPublicationDate(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        this.readTitle(in, ea, entry);
        Byte type = in.readByte();
        switch (type.intValue()) {
            case 1: {
                ea.setSubmittedToDatabase(SubmissionDatabase.EMBL_GENBANK_DDBJ);
                break;
            }
            case 2: {
                ea.setSubmittedToDatabase(SubmissionDatabase.PDB);
                break;
            }
            case 3: {
                ea.setSubmittedToDatabase(SubmissionDatabase.PIR);
                break;
            }
            case 4: {
                ea.setSubmittedToDatabase(SubmissionDatabase.SWISS_PROT);
                break;
            }
            case 5: {
                ea.setSubmittedToDatabase(SubmissionDatabase.UNKNOWN);
                break;
            }
            case 6: {
                ea.setSubmittedToDatabase(SubmissionDatabase.UNIPROTKB);
                break;
            }
        }
    }

    private void writeSubmission(ObjectOutput out, Submission ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writePublicationDate(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        this.writeTitle(out, ea, entry);
        switch (ea.getSubmittedToDatabase()) {
            case EMBL_GENBANK_DDBJ: {
                out.writeByte(1);
                break;
            }
            case PDB: {
                out.writeByte(2);
                break;
            }
            case PIR: {
                out.writeByte(3);
                break;
            }
            case SWISS_PROT: {
                out.writeByte(4);
                break;
            }
            case UNKNOWN: {
                out.writeByte(5);
                break;
            }
            case UNIPROTKB: {
                out.writeByte(6);
            }
        }
    }

    private void writeSubmissionNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission submission, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, submission, entry);
        this.writeAuthorsNew(out, submission, entry);
        this.writeCitationXrefsNew(out, submission, entry);
        this.writePublicationDateNew(out, submission, entry);
        this.writeSampleSourcesNew(out, submission, entry);
        this.writeCitationSummariesNew(out, submission, entry);
        this.writeTitleNew(out, submission, entry);
        switch (submission.getSubmittedToDatabase()) {
            case EMBL_GENBANK_DDBJ: {
                out.writeByte(1);
                break;
            }
            case PDB: {
                out.writeByte(2);
                break;
            }
            case PIR: {
                out.writeByte(3);
                break;
            }
            case SWISS_PROT: {
                out.writeByte(4);
                break;
            }
            case UNKNOWN: {
                out.writeByte(5);
                break;
            }
            case UNIPROTKB: {
                out.writeByte(6);
            }
        }
    }

    private void readSubmissionNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Submission submission, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, submission, entry);
        this.readAuthorsNew(in, submission, entry);
        this.readCitationsXrefsNew(in, submission, entry);
        this.readPublicationDateNew(in, submission, entry);
        this.readSampleSourcesNew(in, submission, entry);
        this.readCitationSummariesNew(in, submission, entry);
        this.readTitleNew(in, submission, entry);
        Byte type = in.readByte();
        switch (type.intValue()) {
            case 1: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.EMBL_GENBANK_DDBJ);
                break;
            }
            case 2: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.PDB);
                break;
            }
            case 3: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.PIR);
                break;
            }
            case 4: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.SWISS_PROT);
                break;
            }
            case 5: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.UNKNOWN);
                break;
            }
            case 6: {
                submission.setSubmittedToDatabase(uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.SubmissionDatabase.UNIPROTKB);
                break;
            }
        }
    }

    private void readPatent(ObjectInput in, Patent ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readPublicationDate(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        this.readTitle(in, ea, entry);
        String pn = (String)in.readObject();
        ea.setPatentNumber(DefaultCitationFactory.getInstance().buildPatentNumber(pn));
    }

    private void writePatent(ObjectOutput out, Patent ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writePublicationDate(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        this.writeTitle(out, ea, entry);
        out.writeObject(ea.getPatentNumber().getValue());
    }

    private void writePatentNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent patent, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, patent, entry);
        this.writeAuthorsNew(out, patent, entry);
        this.writeCitationXrefsNew(out, patent, entry);
        this.writePublicationDateNew(out, patent, entry);
        this.writeSampleSourcesNew(out, patent, entry);
        this.writeCitationSummariesNew(out, patent, entry);
        this.writeTitleNew(out, patent, entry);
        out.writeObject(patent.getPatentNumber().getValue());
    }

    private void readPatentNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Patent patent, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, patent, entry);
        this.readAuthorsNew(in, patent, entry);
        this.readCitationsXrefsNew(in, patent, entry);
        this.readPublicationDateNew(in, patent, entry);
        this.readSampleSourcesNew(in, patent, entry);
        this.readCitationSummariesNew(in, patent, entry);
        this.readTitleNew(in, patent, entry);
        String pn = (String)in.readObject();
        patent.setPatentNumber(DefaultCitationNewFactory.getInstance().buildPatentNumber(pn));
    }

    private void readJournalArticle(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readDOI(in, ea, entry);
        this.readAgricola(in, ea, entry);
        this.readJournalName(in, ea, entry);
        this.readPubmedId(in, ea, entry);
        this.readMedlineId(in, ea, entry);
        this.readPublicationDate(in, ea, entry);
        this.readPages(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        this.readTitle(in, ea, entry);
        this.readVolume(in, ea, entry);
    }

    private void writeJournalArticle(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citations.JournalArticle ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writeDOI(out, ea, entry);
        this.writeAgricola(out, ea, entry);
        this.writeJournalName(out, ea, entry);
        this.writePubmedId(out, ea, entry);
        this.writeMedlineId(out, ea, entry);
        this.writePublicationDate(out, ea, entry);
        this.writePages(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        this.writeTitle(out, ea, entry);
        this.writeVolume(out, ea, entry);
    }

    private void writeJournalArticleNew(ObjectOutput out, JournalArticle ja, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, ja, entry);
        this.writeAuthorsNew(out, ja, entry);
        this.writeCitationXrefsNew(out, ja, entry);
        this.writePublicationDateNew(out, ja, entry);
        this.writeSampleSourcesNew(out, ja, entry);
        this.writeCitationSummariesNew(out, ja, entry);
        this.writeTitleNew(out, ja, entry);
        out.writeObject(ja.getJournalName().getValue());
        out.writeObject(ja.getFirstPage().getValue());
        out.writeObject(ja.getLastPage().getValue());
        out.writeObject(ja.getVolume().getValue());
    }

    private void readJournalArticleNew(ObjectInput in, JournalArticle ja, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, ja, entry);
        this.readAuthorsNew(in, ja, entry);
        this.readCitationsXrefsNew(in, ja, entry);
        this.readPublicationDateNew(in, ja, entry);
        this.readSampleSourcesNew(in, ja, entry);
        this.readCitationSummariesNew(in, ja, entry);
        this.readTitleNew(in, ja, entry);
        String jn = (String)in.readObject();
        ja.setJournalName(DefaultCitationNewFactory.getInstance().buildJournalName(jn));
        String startPage = (String)in.readObject();
        ja.setFirstPage(DefaultCitationNewFactory.getInstance().buildPage(startPage));
        String endPage = (String)in.readObject();
        ja.setLastPage(DefaultCitationNewFactory.getInstance().buildPage(endPage));
        String volume = (String)in.readObject();
        ja.setVolume(DefaultCitationNewFactory.getInstance().buildVolume(volume));
    }

    private void readElectronicArticle(ObjectInput in, ElectronicArticle ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, ea, entry);
        this.readAuthors(in, ea, entry);
        this.readDOI(in, ea, entry);
        this.readJournalName(in, ea, entry);
        String locator = (String)in.readObject();
        ea.setLocator(DefaultCitationFactory.getInstance().buildLocator(locator));
        this.readPubmedId(in, ea, entry);
        this.readMedlineId(in, ea, entry);
        this.readSequenceSampleSources(in, ea, entry);
        this.readSequencingExperiments(in, ea, entry);
        this.readTitle(in, ea, entry);
    }

    private void writeElectronicArticle(ObjectOutput out, ElectronicArticle ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, ea, entry);
        this.writeAuthors(out, ea, entry);
        this.writeDOI(out, ea, entry);
        this.writeJournalName(out, ea, entry);
        out.writeObject(ea.getLocator().getValue());
        this.writePubmedId(out, ea, entry);
        this.writeMedlineId(out, ea, entry);
        this.writeSequenceSampleSources(out, ea, entry);
        this.writeSequencingExperiments(out, ea, entry);
        this.writeTitle(out, ea, entry);
    }

    private void writeElectronicArticleNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle ea, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, ea, entry);
        this.writeAuthorsNew(out, ea, entry);
        this.writeCitationXrefsNew(out, ea, entry);
        this.writePublicationDateNew(out, ea, entry);
        this.writeSampleSourcesNew(out, ea, entry);
        this.writeCitationSummariesNew(out, ea, entry);
        this.writeTitleNew(out, ea, entry);
        out.writeObject(ea.getJournalName().getValue());
        out.writeObject(ea.getLocator().getValue());
    }

    private void readElectronicArticleNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.ElectronicArticle ea, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, ea, entry);
        this.readAuthorsNew(in, ea, entry);
        this.readCitationsXrefsNew(in, ea, entry);
        this.readPublicationDateNew(in, ea, entry);
        this.readSampleSourcesNew(in, ea, entry);
        this.readCitationSummariesNew(in, ea, entry);
        this.readTitleNew(in, ea, entry);
        String jn = (String)in.readObject();
        ea.setJournalName(DefaultCitationNewFactory.getInstance().buildJournalName(jn));
        String locator = (String)in.readObject();
        ea.setLocator(DefaultCitationNewFactory.getInstance().buildLocator(locator));
    }

    private void readBook(ObjectInput in, Book book, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroup(in, book, entry);
        this.readAuthors(in, book, entry);
        String bn = (String)in.readObject();
        book.setBookName(DefaultCitationFactory.getInstance().buildBookName(bn));
        String city = (String)in.readObject();
        book.setCity(DefaultCitationFactory.getInstance().buildCity(city));
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            String editor = (String)in.readObject();
            book.getEditors().add(DefaultCitationFactory.getInstance().buildEditor(editor));
        }
        this.readPages(in, book, entry);
        this.readPublicationDate(in, book, entry);
        String publisher = (String)in.readObject();
        book.setPublisher(DefaultCitationFactory.getInstance().buildPublisher(publisher));
        this.readSequenceSampleSources(in, book, entry);
        this.readSequencingExperiments(in, book, entry);
        this.readTitle(in, book, entry);
        this.readVolume(in, book, entry);
    }

    private void writeBook(ObjectOutput out, Book book, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroup(out, book, entry);
        this.writeAuthors(out, book, entry);
        out.writeObject(book.getBookName().getValue());
        out.writeObject(book.getCity().getValue());
        out.writeByte(book.getEditors().size());
        for (uk.ac.ebi.kraken.interfaces.uniprot.citations.Editor editor : book.getEditors()) {
            out.writeObject(editor.getValue());
        }
        this.writePages(out, book, entry);
        this.writePublicationDate(out, book, entry);
        out.writeObject(book.getPublisher().getValue());
        this.writeSequenceSampleSources(out, book, entry);
        this.writeSequencingExperiments(out, book, entry);
        this.writeTitle(out, book, entry);
        this.writeVolume(out, book, entry);
    }

    private void writeBookNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book book, UniProtEntry entry) throws IOException {
        this.writeAuthoringGroupNew(out, book, entry);
        this.writeAuthorsNew(out, book, entry);
        this.writeCitationXrefsNew(out, book, entry);
        this.writePublicationDateNew(out, book, entry);
        this.writeSampleSourcesNew(out, book, entry);
        this.writeCitationSummariesNew(out, book, entry);
        this.writeTitleNew(out, book, entry);
        out.writeObject(book.getBookName().getValue());
        out.writeObject(book.getCity().getValue());
        out.writeByte(book.getEditors().size());
        for (Editor editor : book.getEditors()) {
            out.writeObject(editor.getValue());
        }
        out.writeObject(book.getFirstPage().getValue());
        out.writeObject(book.getLastPage().getValue());
        out.writeObject(book.getPublisher().getValue());
        out.writeObject(book.getVolume().getValue());
    }

    private void readBookNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Book book, UniProtEntry entry) throws IOException, ClassNotFoundException {
        this.readAuthoringGroupNew(in, book, entry);
        this.readAuthorsNew(in, book, entry);
        this.readCitationsXrefsNew(in, book, entry);
        this.readPublicationDateNew(in, book, entry);
        this.readSampleSourcesNew(in, book, entry);
        this.readCitationSummariesNew(in, book, entry);
        this.readTitleNew(in, book, entry);
        String bn = (String)in.readObject();
        book.setBookName(DefaultCitationNewFactory.getInstance().buildBookName(bn));
        String city = (String)in.readObject();
        book.setCity(DefaultCitationNewFactory.getInstance().buildCity(city));
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            String editor = (String)in.readObject();
            book.getEditors().add(DefaultCitationNewFactory.getInstance().buildEditor(editor));
        }
        String startPage = (String)in.readObject();
        book.setFirstPage(DefaultCitationNewFactory.getInstance().buildPage(startPage));
        String endPage = (String)in.readObject();
        book.setLastPage(DefaultCitationNewFactory.getInstance().buildPage(endPage));
        String publisher = (String)in.readObject();
        book.setPublisher(DefaultCitationNewFactory.getInstance().buildPublisher(publisher));
        String volume = (String)in.readObject();
        book.setVolume(DefaultCitationNewFactory.getInstance().buildVolume(volume));
    }

    private void writeMedlineId(ObjectOutput out, HasMedlineId citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getMedlineId().getValue());
    }

    private void readMedlineId(ObjectInput in, HasMedlineId ea, UniProtEntry entry) throws ClassNotFoundException, IOException {
        String medline = (String)in.readObject();
        ea.setMedlineId(DefaultCitationFactory.getInstance().buildMedlineId(medline));
    }

    private void writePubmedId(ObjectOutput out, HasPubMedId citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getPubMedId().getValue());
    }

    private void readPubmedId(ObjectInput in, HasPubMedId ea, UniProtEntry entry) throws ClassNotFoundException, IOException {
        String pubmed = (String)in.readObject();
        ea.setPubMedId(DefaultCitationFactory.getInstance().buildPubMedId(pubmed));
    }

    private void writeCitationXrefsNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getCitationXrefs().getDOI().getValue());
        out.writeObject(citation.getCitationXrefs().getAgricolaId().getValue());
        out.writeObject(citation.getCitationXrefs().getPubmedId().getValue());
        out.writeObject(citation.getCitationXrefs().getMedlineId().getValue());
    }

    private void readCitationsXrefsNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String doi = (String)in.readObject();
        citation.getCitationXrefs().setDOI(DefaultCitationNewFactory.getInstance().buildDOI(doi));
        String agricola = (String)in.readObject();
        citation.getCitationXrefs().setAgricolaId(DefaultCitationNewFactory.getInstance().buildAgricolaId(agricola));
        String pubmed = (String)in.readObject();
        citation.getCitationXrefs().setPubMedId(DefaultCitationNewFactory.getInstance().buildPubMedId(pubmed));
        String medline = (String)in.readObject();
        citation.getCitationXrefs().setMedlineId(DefaultCitationNewFactory.getInstance().buildMedlineId(medline));
    }

    private void writeJournalName(ObjectOutput out, HasJournalName citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getJournalName().getValue());
    }

    private void readJournalName(ObjectInput in, HasJournalName ea, UniProtEntry entry) throws ClassNotFoundException, IOException {
        String jn = (String)in.readObject();
        ea.setJournalName(DefaultCitationFactory.getInstance().buildJournalName(jn));
    }

    private void writeDOI(ObjectOutput out, HasDOI citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getDOI().getValue());
    }

    private void readDOI(ObjectInput in, HasDOI ea, UniProtEntry entry) throws ClassNotFoundException, IOException {
        String doi = (String)in.readObject();
        ea.setDOI(DefaultCitationFactory.getInstance().buildDOI(doi));
    }

    private void writeAgricola(ObjectOutput out, HasAgricolaId citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getAgricolaId().getValue());
    }

    private void readAgricola(ObjectInput in, HasAgricolaId ea, UniProtEntry entry) throws ClassNotFoundException, IOException {
        String doi = (String)in.readObject();
        ea.setAgricolaId(DefaultCitationFactory.getInstance().buildAgricolaId(doi));
    }

    private void writeVolume(ObjectOutput out, HasVolume citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getVolume().getValue());
    }

    private void readVolume(ObjectInput in, HasVolume citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String volume = (String)in.readObject();
        citation.setVolume(DefaultCitationFactory.getInstance().buildVolume(volume));
    }

    private void writeTitle(ObjectOutput out, HasTitle citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getTitle().getValue());
    }

    private void writeTitleNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getTitle().getValue());
    }

    private void readTitle(ObjectInput in, HasTitle citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String title = (String)in.readObject();
        citation.setTitle(DefaultCitationFactory.getInstance().buildTitle(title));
    }

    private void readTitleNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String title = (String)in.readObject();
        citation.setTitle(DefaultCitationNewFactory.getInstance().buildTitle(title));
    }

    private void writeSequencingExperiments(ObjectOutput out, Citation citation, UniProtEntry entry) throws IOException {
        out.writeByte(citation.getSequencingExperiments().size());
        for (SequencingExperiment experiment : citation.getSequencingExperiments()) {
            out.writeObject(experiment.getValue());
        }
    }

    private void writeCitationSummariesNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeByte(citation.getCitationSummary().size());
        for (CitationSummary citationSummary : citation.getCitationSummary()) {
            out.writeObject(citationSummary.getValue());
        }
    }

    private void readSequencingExperiments(ObjectInput in, Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            String exp = (String)in.readObject();
            citation.getSequencingExperiments().add(DefaultCitationFactory.getInstance().buildSequencingExperiment(exp));
        }
    }

    private void readCitationSummariesNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            String exp = (String)in.readObject();
            citation.getCitationSummary().add(DefaultCitationNewFactory.getInstance().buildCitationSummary(exp));
        }
    }

    private void writeSequenceSampleSources(ObjectOutput out, Citation citation, UniProtEntry entry) throws IOException {
        out.writeInt(citation.getSequenceSampleSources().size());
        for (SequenceSampleSource source : citation.getSequenceSampleSources()) {
            switch (source.getType()) {
                case PLASMID: {
                    out.writeByte(1);
                    break;
                }
                case STRAIN: {
                    out.writeByte(3);
                    break;
                }
                case TISSUE: {
                    out.writeByte(4);
                    break;
                }
                case TRANSPOSON: {
                    out.writeByte(5);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            out.writeObject(source.getValue());
        }
    }

    private void writeSampleSourcesNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeInt(citation.getSampleSources().size());
        for (SampleSource source : citation.getSampleSources()) {
            switch (source.getType()) {
                case PLASMID: {
                    out.writeByte(1);
                    break;
                }
                case STRAIN: {
                    out.writeByte(3);
                    break;
                }
                case TISSUE: {
                    out.writeByte(4);
                    break;
                }
                case TRANSPOSON: {
                    out.writeByte(5);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            out.writeObject(source.getValue());
        }
    }

    private void readSequenceSampleSources(ObjectInput in, Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            SequenceSampleSource source;
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    source = DefaultCitationFactory.getInstance().buildSequenceSampleSource(SequenceSampleSourceType.PLASMID);
                    break;
                }
                case 3: {
                    source = DefaultCitationFactory.getInstance().buildSequenceSampleSource(SequenceSampleSourceType.STRAIN);
                    break;
                }
                case 4: {
                    source = DefaultCitationFactory.getInstance().buildSequenceSampleSource(SequenceSampleSourceType.TISSUE);
                    break;
                }
                case 5: {
                    source = DefaultCitationFactory.getInstance().buildSequenceSampleSource(SequenceSampleSourceType.TRANSPOSON);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            String value = (String)in.readObject();
            source.setValue(value);
            citation.getSequenceSampleSources().add(source);
        }
    }

    private void readSampleSourcesNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            SampleSource source;
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    source = DefaultCitationNewFactory.getInstance().buildSampleSource(SampleSourceType.PLASMID);
                    break;
                }
                case 3: {
                    source = DefaultCitationNewFactory.getInstance().buildSampleSource(SampleSourceType.STRAIN);
                    break;
                }
                case 4: {
                    source = DefaultCitationNewFactory.getInstance().buildSampleSource(SampleSourceType.TISSUE);
                    break;
                }
                case 5: {
                    source = DefaultCitationNewFactory.getInstance().buildSampleSource(SampleSourceType.TRANSPOSON);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            String value = (String)in.readObject();
            source.setValue(value);
            citation.getSampleSources().add(source);
        }
    }

    private void writePublicationDate(ObjectOutput out, HasPublicationDate citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getPublicationDate().getValue());
    }

    private void readPublicationDate(ObjectInput in, HasPublicationDate citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        citation.setPublicationDate(DefaultCitationFactory.getInstance().buildPublicationDate((String)in.readObject()));
    }

    private void writePublicationDateNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getPublicationDate().getValue());
    }

    private void readPublicationDateNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        citation.setPublicationDate(DefaultCitationNewFactory.getInstance().buildPublicationDate((String)in.readObject()));
    }

    private void writePages(ObjectOutput out, HasPages citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getFirstPage().getValue());
        out.writeObject(citation.getLastPage().getValue());
    }

    private void readPages(ObjectInput in, HasPages citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String startPage = (String)in.readObject();
        String endPage = (String)in.readObject();
        citation.setFirstPage(DefaultCitationFactory.getInstance().buildPage(startPage));
        citation.setLastPage(DefaultCitationFactory.getInstance().buildPage(endPage));
    }

    private void writeAuthors(ObjectOutput out, HasAuthors citation, UniProtEntry entry) throws IOException {
        out.writeInt(citation.getAuthors().size());
        for (uk.ac.ebi.kraken.interfaces.uniprot.citations.Author author : citation.getAuthors()) {
            out.writeObject(author.getValue());
        }
    }

    private void writeAuthorsNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeInt(citation.getAuthors().size());
        for (Author author : citation.getAuthors()) {
            out.writeObject(author.getValue());
        }
    }

    private void readAuthors(ObjectInput in, HasAuthors citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String author = (String)in.readObject();
            citation.getAuthors().add(DefaultCitationFactory.getInstance().buildAuthor(author));
        }
    }

    private void readAuthorsNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String author = (String)in.readObject();
            citation.getAuthors().add(DefaultCitationNewFactory.getInstance().buildAuthor(author));
        }
    }

    private void writeAuthoringGroup(ObjectOutput out, HasAuthors citation, UniProtEntry entry) throws IOException {
        out.writeObject(citation.getAuthoringGroup().getValue());
    }

    private void writeAuthoringGroupNew(ObjectOutput out, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException {
        out.writeInt(citation.getAuthoringGroup().size());
        for (AuthoringGroup authoringGroup : citation.getAuthoringGroup()) {
            out.writeObject(authoringGroup.getValue());
        }
    }

    private void readAuthoringGroup(ObjectInput in, HasAuthors citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String authorGroup = (String)in.readObject();
        citation.setAuthoringGroup(DefaultCitationFactory.getInstance().buildAuthoringGroup(authorGroup));
    }

    private void readAuthoringGroupNew(ObjectInput in, uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.Citation citation, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String authorGroup = (String)in.readObject();
            citation.getAuthoringGroup().add(DefaultCitationNewFactory.getInstance().buildAuthoringGroup(authorGroup));
        }
    }

    private void writeOrganelles(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeByte(entry.getOrganelles().size());
        block13: for (Organelle organelle : entry.getOrganelles()) {
            switch (organelle.getType()) {
                case APICOPLAST_PLASTID: {
                    out.writeByte(1);
                    continue block13;
                }
                case CHLOROPLAST_PLASTID: {
                    out.writeByte(2);
                    continue block13;
                }
                case CYANELLE_PLASTID: {
                    out.writeByte(3);
                    continue block13;
                }
                case HYDROGENOSOME: {
                    out.writeByte(4);
                    continue block13;
                }
                case MITOCHONDRION: {
                    out.writeByte(5);
                    continue block13;
                }
                case NON_PHOTOSYNTHETIC_PLASTID: {
                    out.writeByte(6);
                    continue block13;
                }
                case NUCLEOMORPH: {
                    out.writeByte(7);
                    continue block13;
                }
                case PLASMID: {
                    out.writeByte(8);
                    out.writeObject(organelle.getValue());
                    continue block13;
                }
                case PLASTID: {
                    out.writeByte(9);
                    continue block13;
                }
                case CHROMATOPHORE_PLASTID: {
                    out.writeByte(10);
                    continue block13;
                }
                case UNKOWN: {
                    out.writeByte(11);
                    continue block13;
                }
            }
            throw new IOException();
        }
    }

    private void readOrganelles(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        block13: for (int iii = 0; iii < size; ++iii) {
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.APICOPLAST_PLASTID));
                    continue block13;
                }
                case 2: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CHLOROPLAST_PLASTID));
                    continue block13;
                }
                case 3: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CYANELLE_PLASTID));
                    continue block13;
                }
                case 4: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.HYDROGENOSOME));
                    continue block13;
                }
                case 5: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.MITOCHONDRION));
                    continue block13;
                }
                case 6: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.NON_PHOTOSYNTHETIC_PLASTID));
                    continue block13;
                }
                case 7: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.NUCLEOMORPH));
                    continue block13;
                }
                case 8: {
                    Organelle plasmid = DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASMID);
                    plasmid.setValue((String)in.readObject());
                    entry.getOrganelles().add(plasmid);
                    continue block13;
                }
                case 9: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.PLASTID));
                    continue block13;
                }
                case 10: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.CHROMATOPHORE_PLASTID));
                    continue block13;
                }
                case 11: {
                    entry.getOrganelles().add(DefaultUniProtFactory.getInstance().buildOrganelle(GeneEncodingType.UNKOWN));
                }
            }
        }
    }

    private void readOrganisms(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            Organism organism = DefaultUniProtFactory.getInstance().buildOrganism();
            entry.getOrganisms().add(organism);
            String sn = (String)in.readObject();
            organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(sn));
            String cn = (String)in.readObject();
            organism.setCommonName(DefaultUniProtFactory.getInstance().buildOrganismCommonName(cn));
            String syn = (String)in.readObject();
            organism.setSynonym(DefaultUniProtFactory.getInstance().buildOrganismSynonym(syn));
        }
        Organism organism = DefaultUniProtFactory.getInstance().buildOrganism();
        entry.setOrganism(organism);
        String sn = (String)in.readObject();
        organism.setScientificName(DefaultUniProtFactory.getInstance().buildOrganismScientificName(sn));
        String cn = (String)in.readObject();
        organism.setCommonName(DefaultUniProtFactory.getInstance().buildOrganismCommonName(cn));
        String syn = (String)in.readObject();
        organism.setSynonym(DefaultUniProtFactory.getInstance().buildOrganismSynonym(syn));
    }

    private void writeGenes(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getGenes().size());
        for (Gene gene : entry.getGenes()) {
            out.writeBoolean(gene.hasGeneName());
            if (gene.hasGeneName()) {
                out.writeObject(gene.getGeneName().getValue());
                this.writeEvidenceIds(out, gene.getGeneName().getEvidenceIds());
            }
            out.writeInt(gene.getGeneNameSynonyms().size());
            for (GeneNameSynonym geneNameSynonym : gene.getGeneNameSynonyms()) {
                out.writeObject(geneNameSynonym.getValue());
                this.writeEvidenceIds(out, geneNameSynonym.getEvidenceIds());
            }
            out.writeInt(gene.getOrderedLocusNames().size());
            for (OrderedLocusName orderedLocusName : gene.getOrderedLocusNames()) {
                out.writeObject(orderedLocusName.getValue());
                this.writeEvidenceIds(out, orderedLocusName.getEvidenceIds());
            }
            out.writeInt(gene.getORFNames().size());
            for (ORFName orfName : gene.getORFNames()) {
                out.writeObject(orfName.getValue());
                this.writeEvidenceIds(out, orfName.getEvidenceIds());
            }
        }
    }

    private void readGenes(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int n = in.readInt();
        for (int iii = 0; iii < n; ++iii) {
            Value name;
            int jjj;
            Gene gene = DefaultUniProtFactory.getInstance().buildGene();
            boolean hasname = in.readBoolean();
            if (hasname) {
                GeneName gname = DefaultUniProtFactory.getInstance().buildGeneName((String)in.readObject());
                this.readEvidenceIds(in, gname);
                gene.setGeneName(gname);
            }
            int m = in.readInt();
            for (jjj = 0; jjj < m; ++jjj) {
                GeneNameSynonym nim = DefaultUniProtFactory.getInstance().buildGeneNameSynonym((String)in.readObject());
                this.readEvidenceIds(in, nim);
                gene.getGeneNameSynonyms().add(nim);
            }
            m = in.readInt();
            for (jjj = 0; jjj < m; ++jjj) {
                name = DefaultUniProtFactory.getInstance().buildOrderedLocusName((String)in.readObject());
                this.readEvidenceIds(in, (HasEvidences)((Object)name));
                gene.getOrderedLocusNames().add((OrderedLocusName)name);
            }
            m = in.readInt();
            for (jjj = 0; jjj < m; ++jjj) {
                name = DefaultUniProtFactory.getInstance().buildORFName((String)in.readObject());
                this.readEvidenceIds(in, (HasEvidences)((Object)name));
                gene.getORFNames().add((ORFName)name);
            }
            entry.getGenes().add(gene);
        }
    }

    private void writeOrganisms(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeByte(entry.getOrganisms().size());
        for (Organism organism : entry.getOrganisms()) {
            out.writeObject(organism.getScientificName().getValue());
            out.writeObject(organism.getCommonName().getValue());
            out.writeObject(organism.getSynonym().getValue());
        }
        out.writeObject(entry.getOrganism().getScientificName().getValue());
        out.writeObject(entry.getOrganism().getCommonName().getValue());
        out.writeObject(entry.getOrganism().getSynonym().getValue());
    }

    private void writeKeywords(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeByte(entry.getKeywords().size());
        for (Keyword keyword : entry.getKeywords()) {
            out.writeObject(keyword.getValue());
            this.writeEvidenceIds(out, keyword.getEvidenceIds());
        }
    }

    private void readKeywords(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readByte();
        for (int iii = 0; iii < size; ++iii) {
            Keyword kw = DefaultUniProtFactory.getInstance().buildKeyword((String)in.readObject());
            this.readEvidenceIds(in, kw);
            entry.getKeywords().add(kw);
        }
    }

    private void writeFeatures(UniProtEntry entry, ObjectOutput out) throws IOException {
        out.writeInt(entry.getFeatures().size());
        for (Feature feature : entry.getFeatures()) {
            switch (feature.getType()) {
                case ACT_SITE: {
                    out.writeByte(1);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.ACT_SITE);
                    break;
                }
                case BINDING: {
                    out.writeByte(2);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.BINDING);
                    break;
                }
                case CA_BIND: {
                    out.writeByte(3);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.CA_BIND);
                    break;
                }
                case CARBOHYD: {
                    out.writeByte(4);
                    this.writeCarbohydFeature(entry, feature, out);
                    break;
                }
                case CHAIN: {
                    out.writeByte(5);
                    this.writeStatusAndDescriptionAndIdFeature(entry, feature, out, FeatureType.CHAIN);
                    break;
                }
                case COILED: {
                    out.writeByte(6);
                    this.writeStatusFeature(entry, feature, out, FeatureType.COILED);
                    break;
                }
                case COMPBIAS: {
                    out.writeByte(7);
                    this.writeDescriptionFeature(entry, feature, out, FeatureType.COMPBIAS);
                    break;
                }
                case CONFLICT: {
                    out.writeByte(8);
                    this.writeConflictFeature(entry, feature, out);
                    break;
                }
                case CROSSLNK: {
                    out.writeByte(9);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.CROSSLNK);
                    break;
                }
                case DISULFID: {
                    out.writeByte(10);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.DISULFID);
                    break;
                }
                case DNA_BIND: {
                    out.writeByte(11);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.DNA_BIND);
                    break;
                }
                case DOMAIN: {
                    out.writeByte(12);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.DOMAIN);
                    break;
                }
                case HELIX: {
                    out.writeByte(13);
                    this.writeSimpleFeature(entry, feature, out, FeatureType.HELIX);
                    break;
                }
                case INIT_MET: {
                    out.writeByte(14);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.INIT_MET);
                    break;
                }
                case LIPID: {
                    out.writeByte(15);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.LIPID);
                    break;
                }
                case METAL: {
                    out.writeByte(16);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.METAL);
                    break;
                }
                case MOD_RES: {
                    out.writeByte(17);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.MOD_RES);
                    break;
                }
                case MOTIF: {
                    out.writeByte(18);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.MOTIF);
                    break;
                }
                case MUTAGEN: {
                    out.writeByte(19);
                    this.writeMutagenFeature(entry, feature, out);
                    break;
                }
                case NON_CONS: {
                    out.writeByte(20);
                    this.writeSimpleFeature(entry, feature, out, FeatureType.NON_CONS);
                    break;
                }
                case NON_TER: {
                    out.writeByte(21);
                    this.writeSimpleFeature(entry, feature, out, FeatureType.NON_TER);
                    break;
                }
                case NP_BIND: {
                    out.writeByte(22);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.NP_BIND);
                    break;
                }
                case PEPTIDE: {
                    out.writeByte(23);
                    this.writeStatusAndDescriptionAndIdFeature(entry, feature, out, FeatureType.PEPTIDE);
                    break;
                }
                case PROPEP: {
                    out.writeByte(24);
                    this.writeStatusAndDescriptionAndIdFeature(entry, feature, out, FeatureType.PROPEP);
                    break;
                }
                case REGION: {
                    out.writeByte(25);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.REGION);
                    break;
                }
                case REPEAT: {
                    out.writeByte(26);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.REPEAT);
                    break;
                }
                case NON_STD: {
                    out.writeByte(27);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.NON_STD);
                    break;
                }
                case SIGNAL: {
                    out.writeByte(28);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.SIGNAL);
                    break;
                }
                case SITE: {
                    out.writeByte(29);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.SITE);
                    break;
                }
                case STRAND: {
                    out.writeByte(30);
                    this.writeSimpleFeature(entry, feature, out, FeatureType.STRAND);
                    break;
                }
                case TOPO_DOM: {
                    out.writeByte(31);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.TOPO_DOM);
                    break;
                }
                case TRANSIT: {
                    out.writeByte(32);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.TRANSIT);
                    break;
                }
                case TRANSMEM: {
                    out.writeByte(33);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.TRANSMEM);
                    break;
                }
                case TURN: {
                    out.writeByte(34);
                    this.writeSimpleFeature(entry, feature, out, FeatureType.TURN);
                    break;
                }
                case UNSURE: {
                    out.writeByte(35);
                    this.writeDescriptionFeature(entry, feature, out, FeatureType.UNSURE);
                    break;
                }
                case VARIANT: {
                    out.writeByte(36);
                    this.writeVariantFeature(entry, feature, out);
                    break;
                }
                case VAR_SEQ: {
                    out.writeByte(37);
                    this.writeVarseqFeature(entry, feature, out);
                    break;
                }
                case ZN_FING: {
                    out.writeByte(38);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.ZN_FING);
                    break;
                }
                case INTRAMEM: {
                    out.writeByte(39);
                    this.writeStatusAndDescriptionFeature(entry, feature, out, FeatureType.INTRAMEM);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Feature type in serialization: " + (Object)((Object)feature.getType()));
                }
            }
            this.writeEvidenceIds(out, feature.getEvidenceIds());
        }
    }

    private void readFeatures(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        block41: for (int iii = 0; iii < size; ++iii) {
            byte type = in.readByte();
            switch (type) {
                case 1: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.ACT_SITE);
                    continue block41;
                }
                case 2: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.BINDING);
                    continue block41;
                }
                case 3: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.CA_BIND);
                    continue block41;
                }
                case 4: {
                    this.readCarbohydFeature(in, entry);
                    continue block41;
                }
                case 5: {
                    this.readStatusAndDescriptionAndIdFeature(in, entry, FeatureType.CHAIN);
                    continue block41;
                }
                case 6: {
                    this.readStatusFeature(in, entry, FeatureType.COILED);
                    continue block41;
                }
                case 7: {
                    this.readDescriptionFeature(in, entry, FeatureType.COMPBIAS);
                    continue block41;
                }
                case 8: {
                    this.readConflictFeature(in, entry);
                    continue block41;
                }
                case 9: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.CROSSLNK);
                    continue block41;
                }
                case 10: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.DISULFID);
                    continue block41;
                }
                case 11: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.DNA_BIND);
                    continue block41;
                }
                case 12: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.DOMAIN);
                    continue block41;
                }
                case 13: {
                    this.readSimpleFeature(in, entry, FeatureType.HELIX);
                    continue block41;
                }
                case 14: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.INIT_MET);
                    continue block41;
                }
                case 15: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.LIPID);
                    continue block41;
                }
                case 16: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.METAL);
                    continue block41;
                }
                case 17: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.MOD_RES);
                    continue block41;
                }
                case 18: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.MOTIF);
                    continue block41;
                }
                case 19: {
                    this.readMutagenFeature(in, entry);
                    continue block41;
                }
                case 20: {
                    this.readSimpleFeature(in, entry, FeatureType.NON_CONS);
                    continue block41;
                }
                case 21: {
                    this.readSimpleFeature(in, entry, FeatureType.NON_TER);
                    continue block41;
                }
                case 22: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.NP_BIND);
                    continue block41;
                }
                case 23: {
                    this.readStatusAndDescriptionAndIdFeature(in, entry, FeatureType.PEPTIDE);
                    continue block41;
                }
                case 24: {
                    this.readStatusAndDescriptionAndIdFeature(in, entry, FeatureType.PROPEP);
                    continue block41;
                }
                case 25: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.REGION);
                    continue block41;
                }
                case 26: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.REPEAT);
                    continue block41;
                }
                case 27: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.NON_STD);
                    continue block41;
                }
                case 28: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.SIGNAL);
                    continue block41;
                }
                case 29: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.SITE);
                    continue block41;
                }
                case 30: {
                    this.readSimpleFeature(in, entry, FeatureType.STRAND);
                    continue block41;
                }
                case 31: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.TOPO_DOM);
                    continue block41;
                }
                case 32: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.TRANSIT);
                    continue block41;
                }
                case 33: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.TRANSMEM);
                    continue block41;
                }
                case 34: {
                    this.readSimpleFeature(in, entry, FeatureType.TURN);
                    continue block41;
                }
                case 35: {
                    this.readDescriptionFeature(in, entry, FeatureType.UNSURE);
                    continue block41;
                }
                case 36: {
                    this.readVariantFeature(in, entry);
                    continue block41;
                }
                case 37: {
                    this.readVarsplicFeature(in, entry);
                    continue block41;
                }
                case 38: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.ZN_FING);
                    continue block41;
                }
                case 39: {
                    this.readStatusAndDescriptionFeature(in, entry, FeatureType.INTRAMEM);
                    continue block41;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Feature type in serialization read: " + type);
                }
            }
        }
    }

    private void writeVarseqFeature(UniProtEntry entry, Feature f, ObjectOutput out) throws IOException {
        VarSeqFeature feature = (VarSeqFeature)f;
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureId(feature, out, entry);
        this.writeAlternativeSequence(out, feature, entry);
        out.writeByte(feature.getVarsplicIsoforms().size());
        for (VarsplicIsoform isoform : feature.getVarsplicIsoforms()) {
            out.writeObject(isoform.getValue());
        }
    }

    private void readVarsplicFeature(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        VarSeqFeature feature = (VarSeqFeature)DefaultFeatureFactory.getInstance().buildFeature(FeatureType.VAR_SEQ);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureId(in, feature, entry);
        this.readAlternativeSequence(in, feature, entry);
        int reportsize = in.readByte();
        for (int jjj = 0; jjj < reportsize; ++jjj) {
            String report = (String)in.readObject();
            feature.getVarsplicIsoforms().add(DefaultFeatureFactory.getInstance().buildVarsplicIsoform(report));
        }
        this.readEvidenceIds(in, feature);
        entry.getFeatures().add(feature);
    }

    private void writeConflictFeature(UniProtEntry entry, Feature f, ObjectOutput out) throws IOException {
        ConflictFeature feature = (ConflictFeature)f;
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureDescription(out, feature, entry);
        this.writeAlternativeSequence(out, feature, entry);
        out.writeByte(feature.getConflictReports().size());
        for (ConflictReport conflictReport : feature.getConflictReports()) {
            out.writeObject(conflictReport.getValue());
        }
    }

    private void readConflictFeature(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        ConflictFeature feature = (ConflictFeature)DefaultFeatureFactory.getInstance().buildFeature(FeatureType.CONFLICT);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureDescription(in, feature, entry);
        this.readAlternativeSequence(in, feature, entry);
        int reportsize = in.readByte();
        for (int jjj = 0; jjj < reportsize; ++jjj) {
            String report = (String)in.readObject();
            feature.getConflictReports().add(DefaultFeatureFactory.getInstance().buildConflictReport(report));
        }
        this.readEvidenceIds(in, feature);
        entry.getFeatures().add(feature);
    }

    private void writeVariantFeature(UniProtEntry entry, Feature f, ObjectOutput out) throws IOException {
        VariantFeature feature = (VariantFeature)f;
        this.writeFeatureLocation(feature, out, entry);
        this.writeAlternativeSequence(out, feature, entry);
        this.writeFeatureId(feature, out, entry);
        out.writeInt(feature.getVariantReports().size());
        for (VariantReport variantReport : feature.getVariantReports()) {
            out.writeObject(variantReport.getValue());
        }
    }

    private void readVariantFeature(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        VariantFeature feature = (VariantFeature)DefaultFeatureFactory.getInstance().buildFeature(FeatureType.VARIANT);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readAlternativeSequence(in, feature, entry);
        this.readFeatureId(in, feature, entry);
        int reportsize = in.readInt();
        for (int jjj = 0; jjj < reportsize; ++jjj) {
            String report = (String)in.readObject();
            feature.getVariantReports().add(DefaultFeatureFactory.getInstance().buildVariantReport(report));
        }
        this.readEvidenceIds(in, feature);
        entry.getFeatures().add(feature);
    }

    private void writeMutagenFeature(UniProtEntry entry, Feature f, ObjectOutput out) throws IOException {
        MutagenFeature feature = (MutagenFeature)f;
        this.writeFeatureLocation(feature, out, entry);
        this.writeAlternativeSequence(out, feature, entry);
        out.writeObject(feature.getMutagenReport().getValue());
    }

    private void readMutagenFeature(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        MutagenFeature feature = (MutagenFeature)DefaultFeatureFactory.getInstance().buildFeature(FeatureType.MUTAGEN);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readAlternativeSequence(in, feature, entry);
        String report = (String)in.readObject();
        feature.setMutagenReport(DefaultFeatureFactory.getInstance().buildMutagenReport(report));
        this.readEvidenceIds(in, feature);
        entry.getFeatures().add(feature);
    }

    private void writeAlternativeSequence(ObjectOutput out, HasAlternativeSequence feature, UniProtEntry entry) throws IOException {
        out.writeObject(feature.getOriginalSequence().getValue());
        out.writeInt(feature.getAlternativeSequences().size());
        for (FeatureSequence featureSequence : feature.getAlternativeSequences()) {
            out.writeObject(featureSequence.getValue());
        }
    }

    private void readAlternativeSequence(ObjectInput in, HasAlternativeSequence feature, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String orig = (String)in.readObject();
        feature.setOriginalSequence(DefaultFeatureFactory.getInstance().buildFeatureSequence(orig));
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String as = (String)in.readObject();
            feature.getAlternativeSequences().add(DefaultFeatureFactory.getInstance().buildFeatureSequence(as));
        }
    }

    private void writeCarbohydFeature(UniProtEntry entry, Feature f, ObjectOutput out) throws IOException {
        CarbohydFeature feature = (CarbohydFeature)f;
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureStatus(feature, out, entry);
        this.writeFeatureDescription(out, feature, entry);
        this.writeFeatureId(feature, out, entry);
        switch (feature.getCarbohydLinkType()) {
            case CARBON: {
                out.writeInt(1);
                break;
            }
            case NITROGEN: {
                out.writeInt(2);
                break;
            }
            case OXYGEN: {
                out.writeInt(3);
                break;
            }
            case UNKNOWN: {
                out.writeInt(4);
                break;
            }
            case SULFUR: {
                out.writeInt(5);
            }
        }
        out.writeObject(feature.getLinkedSugar().getValue());
    }

    private void readCarbohydFeature(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        CarbohydFeature feature = (CarbohydFeature)DefaultFeatureFactory.getInstance().buildFeature(FeatureType.CARBOHYD);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureStatus(feature, in, entry);
        this.readFeatureDescription(in, feature, entry);
        this.readFeatureId(in, feature, entry);
        int linktype = in.readInt();
        switch (linktype) {
            case 1: {
                feature.setCarbohydLinkType(CarbohydLinkType.CARBON);
                break;
            }
            case 2: {
                feature.setCarbohydLinkType(CarbohydLinkType.NITROGEN);
                break;
            }
            case 3: {
                feature.setCarbohydLinkType(CarbohydLinkType.OXYGEN);
                break;
            }
            case 4: {
                feature.setCarbohydLinkType(CarbohydLinkType.UNKNOWN);
                break;
            }
            case 5: {
                feature.setCarbohydLinkType(CarbohydLinkType.SULFUR);
            }
        }
        String sugar = (String)in.readObject();
        feature.setLinkedSugar(DefaultFeatureFactory.getInstance().buildLinkedSugar(sugar));
        this.readEvidenceIds(in, feature);
        entry.getFeatures().add(feature);
    }

    private void writeFeatureId(HasFeatureId feature, ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeObject(feature.getFeatureId().getValue());
    }

    private void readFeatureId(ObjectInput in, HasFeatureId feature, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        feature.setFeatureId(DefaultFeatureFactory.getInstance().buildFeatureId(id));
    }

    private void writeStatusAndDescriptionFeature(UniProtEntry entry, Feature feature, ObjectOutput out, FeatureType type) throws IOException {
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureStatus(feature, out, entry);
        this.writeFeatureDescription(out, (HasFeatureDescription)feature, entry);
    }

    private void writeStatusAndDescriptionAndIdFeature(UniProtEntry entry, Feature feature, ObjectOutput out, FeatureType type) throws IOException {
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureStatus(feature, out, entry);
        this.writeFeatureDescription(out, (HasFeatureDescription)feature, entry);
        this.writeFeatureId((HasFeatureId)feature, out, entry);
    }

    private void writeSimpleFeature(UniProtEntry entry, Feature feature, ObjectOutput out, FeatureType type) throws IOException {
        this.writeFeatureLocation(feature, out, entry);
    }

    private void writeDescriptionFeature(UniProtEntry entry, Feature feature, ObjectOutput out, FeatureType type) throws IOException {
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureDescription(out, (HasFeatureDescription)feature, entry);
    }

    private void writeStatusFeature(UniProtEntry entry, Feature feature, ObjectOutput out, FeatureType type) throws IOException {
        this.writeFeatureLocation(feature, out, entry);
        this.writeFeatureStatus(feature, out, entry);
    }

    private void readStatusAndDescriptionFeature(ObjectInput in, UniProtEntry entry, FeatureType type) throws IOException, ClassNotFoundException {
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(type);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureStatus((HasFeatureStatus)feature, in, entry);
        this.readFeatureDescription(in, (HasFeatureDescription)feature, entry);
        this.readEvidenceIds(in, (HasEvidences)feature);
        entry.getFeatures().add((Feature)feature);
    }

    private void readStatusAndDescriptionAndIdFeature(ObjectInput in, UniProtEntry entry, FeatureType type) throws IOException, ClassNotFoundException {
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(type);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureStatus((HasFeatureStatus)feature, in, entry);
        this.readFeatureDescription(in, (HasFeatureDescription)feature, entry);
        this.readFeatureId(in, (HasFeatureId)feature, entry);
        this.readEvidenceIds(in, (HasEvidences)feature);
        entry.getFeatures().add((Feature)feature);
    }

    private void readSimpleFeature(ObjectInput in, UniProtEntry entry, FeatureType type) throws IOException, ClassNotFoundException {
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(type);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readEvidenceIds(in, (HasEvidences)feature);
        entry.getFeatures().add((Feature)feature);
    }

    private void readDescriptionFeature(ObjectInput in, UniProtEntry entry, FeatureType type) throws IOException, ClassNotFoundException {
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(type);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureDescription(in, (HasFeatureDescription)feature, entry);
        this.readEvidenceIds(in, (HasEvidences)feature);
        entry.getFeatures().add((Feature)feature);
    }

    private void readStatusFeature(ObjectInput in, UniProtEntry entry, FeatureType type) throws IOException, ClassNotFoundException {
        Object feature = DefaultFeatureFactory.getInstance().buildFeature(type);
        this.readFeatureLocation(in, feature.getFeatureLocation(), entry);
        this.readFeatureStatus((HasFeatureStatus)feature, in, entry);
        this.readEvidenceIds(in, (HasEvidences)feature);
        entry.getFeatures().add((Feature)feature);
    }

    private void writeFeatureDescription(ObjectOutput out, HasFeatureDescription feature, UniProtEntry entry) throws IOException {
        out.writeObject(feature.getFeatureDescription().getValue());
    }

    private void readFeatureDescription(ObjectInput in, HasFeatureDescription feature, UniProtEntry entry) throws IOException, ClassNotFoundException {
        String description = (String)in.readObject();
        feature.setFeatureDescription(DefaultFeatureFactory.getInstance().buildFeatureDescription(description));
    }

    private void writeFeatureLocation(Feature feature, ObjectOutput out, UniProtEntry entry) throws IOException {
        FeatureLocation location = feature.getFeatureLocation();
        this.writeFeatureLocationModifier(location.getStartModifier(), out, entry);
        out.writeInt(location.getStart());
        this.writeFeatureLocationModifier(location.getEndModifier(), out, entry);
        out.writeInt(location.getEnd());
    }

    private void readFeatureLocation(ObjectInput in, FeatureLocation location, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        switch (type) {
            case 1: {
                location.setStartModifier(FeatureLocationModifier.EXACT);
                break;
            }
            case 2: {
                location.setStartModifier(FeatureLocationModifier.OUTSIDE_KNOWN_SEQUENCE);
                break;
            }
            case 3: {
                location.setStartModifier(FeatureLocationModifier.UNKOWN);
                break;
            }
            case 4: {
                location.setStartModifier(FeatureLocationModifier.UNSURE);
            }
        }
        int start = in.readInt();
        location.setStart(start);
        type = in.readInt();
        switch (type) {
            case 1: {
                location.setEndModifier(FeatureLocationModifier.EXACT);
                break;
            }
            case 2: {
                location.setEndModifier(FeatureLocationModifier.OUTSIDE_KNOWN_SEQUENCE);
                break;
            }
            case 3: {
                location.setEndModifier(FeatureLocationModifier.UNKOWN);
                break;
            }
            case 4: {
                location.setEndModifier(FeatureLocationModifier.UNSURE);
            }
        }
        int end = in.readInt();
        location.setEnd(end);
    }

    private void writeFeatureStatus(HasFeatureStatus feature, ObjectOutput out, UniProtEntry entry) throws IOException {
        switch (feature.getFeatureStatus()) {
            case BY_SIMILARITY: {
                out.writeInt(1);
                break;
            }
            case EXPERIMENTAL: {
                out.writeInt(2);
                break;
            }
            case POTENTIAL: {
                out.writeInt(3);
                break;
            }
            case PROBABLE: {
                out.writeInt(4);
                break;
            }
            case OTHER: {
                out.writeInt(5);
                break;
            }
            case NONE: {
                out.writeInt(6);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void readFeatureStatus(HasFeatureStatus feature, ObjectInput in, UniProtEntry entry) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 1: {
                feature.setFeatureStatus(FeatureStatus.BY_SIMILARITY);
                break;
            }
            case 2: {
                feature.setFeatureStatus(FeatureStatus.EXPERIMENTAL);
                break;
            }
            case 3: {
                feature.setFeatureStatus(FeatureStatus.POTENTIAL);
                break;
            }
            case 4: {
                feature.setFeatureStatus(FeatureStatus.PROBABLE);
                break;
            }
            case 5: {
                feature.setFeatureStatus(FeatureStatus.OTHER);
                break;
            }
            case 6: {
                feature.setFeatureStatus(FeatureStatus.NONE);
            }
        }
    }

    private void writeFeatureLocationModifier(FeatureLocationModifier startModifier, ObjectOutput out, UniProtEntry entry) throws IOException {
        switch (startModifier) {
            case EXACT: {
                out.writeInt(1);
                break;
            }
            case OUTSIDE_KNOWN_SEQUENCE: {
                out.writeInt(2);
                break;
            }
            case UNKOWN: {
                out.writeInt(3);
                break;
            }
            case UNSURE: {
                out.writeInt(4);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void writeTaxonomy(UniProtEntry entry, ObjectOutput out) throws IOException {
        List<NcbiTaxon> taxonomy = entry.getTaxonomy();
        out.writeInt(taxonomy.size());
        for (NcbiTaxon taxon : taxonomy) {
            out.writeObject(taxon.getValue());
        }
    }

    private void readTaxonomy(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String taxon = (String)in.readObject();
            entry.getTaxonomy().add(DefaultUniProtFactory.getInstance().buildNcbiTaxon(taxon));
        }
    }

    private void writeUniProtId(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeObject(entry.getUniProtId().getValue());
    }

    private void readUniProtId(UniProtEntry entry, ObjectInput in) throws ClassNotFoundException, IOException {
        String id = (String)in.readObject();
        entry.setUniProtId(DefaultUniProtFactory.getInstance().buildUniProtId(id));
    }

    private void writeUniProtAccessions(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeObject(entry.getPrimaryUniProtAccession().getValue());
        out.writeInt(entry.getSecondaryUniProtAccessions().size());
        for (SecondaryUniProtAccession accession : entry.getSecondaryUniProtAccessions()) {
            out.writeObject(accession.getValue());
        }
    }

    private void readUniProtAccessions(UniProtEntry entry, ObjectInput in) throws ClassNotFoundException, IOException {
        String pac = (String)in.readObject();
        entry.setPrimaryUniProtAccession(DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(pac));
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            String sac = (String)in.readObject();
            entry.getSecondaryUniProtAccessions().add(DefaultUniProtFactory.getInstance().buildSecondaryUniProtAccession(sac));
        }
    }

    private void writeEntryAudit(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeLong(entry.getEntryAudit().getCreationDate().getTime());
        out.writeLong(entry.getEntryAudit().getLastAnnotationUpdateDate().getTime());
        out.writeLong(entry.getEntryAudit().getLastSequenceUpdateDate().getTime());
        out.writeLong(entry.getEntryAudit().getFirstPublicDate().getTime());
        out.writeInt(0);
        out.writeInt(entry.getEntryAudit().getEntryVersion());
        out.writeInt(entry.getEntryAudit().getSequenceVersion());
    }

    private void readEntryAudit(UniProtEntry entry, ObjectInput in) throws IOException {
        long time = in.readLong();
        entry.getEntryAudit().setCreationDate(new Date(time));
        time = in.readLong();
        entry.getEntryAudit().setLastAnnotationUpdateDate(new Date(time));
        time = in.readLong();
        entry.getEntryAudit().setLastSequenceUpdateDate(new Date(time));
        time = in.readLong();
        entry.getEntryAudit().setFirstPublicDate(new Date(time));
        int release = in.readInt();
        release = in.readInt();
        entry.getEntryAudit().setEntryVersion(release);
        release = in.readInt();
        entry.getEntryAudit().setSequenceVersion(release);
    }

    private void writeProteinDescription(UniProtEntry entry, ObjectOutput out) throws IOException {
        ProteinDescription description = entry.getProteinDescription();
        this.writeSection(description.getSection(), out);
        out.writeInt(description.getIncludes().size());
        for (Section section : description.getIncludes()) {
            this.writeSection(section, out);
        }
        out.writeInt(description.getContains().size());
        for (Section section : description.getContains()) {
            this.writeSection(section, out);
        }
        out.writeInt(description.getFlags().size());
        for (Flag type : description.getFlags()) {
            out.writeInt(type.getFlagType().ordinal());
            this.writeEvidenceIds(out, type.getEvidenceIds());
        }
        this.writeEvidenceIds(out, description.getEvidenceIds());
    }

    private void writeSection(Section section, ObjectOutput out) throws IOException {
        out.writeInt(section.getNames().size());
        for (Name name : section.getNames()) {
            this.writeName(name, out);
        }
        this.writeEvidenceIds(out, section.getEvidenceIds());
    }

    private void writeName(Name name, ObjectOutput out) throws IOException {
        out.writeInt(name.getNameType().ordinal());
        out.writeInt(name.getFields().size());
        for (Field field : name.getFields()) {
            this.writeField(field, out);
        }
        this.writeEvidenceIds(out, name.getEvidenceIds());
    }

    private void writeField(Field field, ObjectOutput out) throws IOException {
        out.writeInt(field.getType().ordinal());
        out.writeObject(field.getValue());
        this.writeEvidenceIds(out, field.getEvidenceIds());
    }

    private void writeDescription(UniProtEntry entry, ObjectOutput out) throws IOException {
        Description description = entry.getDescription();
        this.writeDescriptionModifier(description, out, entry);
        this.writeProteinNames(description.getProteinNames(), out, entry);
        this.writeIncludesSection(description, out, entry);
        this.writeContainsSection(description, out, entry);
        switch (description.getVersion()) {
            case NO_VERSION: {
                out.writeInt(1);
                break;
            }
            case VERSION_1: {
                out.writeInt(2);
                break;
            }
            case VERSION_2: {
                out.writeInt(3);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        switch (description.getFragmentationType()) {
            case FRAGMENT: {
                out.writeInt(1);
                break;
            }
            case FRAGMENTS: {
                out.writeInt(2);
                break;
            }
            case FULL_SEQUENCE: {
                out.writeInt(3);
                break;
            }
            default: {
                throw new IOException();
            }
        }
        this.writeEvidenceIds(out, description.getEvidenceIds());
    }

    private void readProteinDescription(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int iii;
        ProteinDescription description = entry.getProteinDescription();
        description.setSection(this.readSection(in));
        int size = in.readInt();
        for (iii = 0; iii < size; ++iii) {
            description.getIncludes().add(this.readSection(in));
        }
        size = in.readInt();
        for (iii = 0; iii < size; ++iii) {
            description.getContains().add(this.readSection(in));
        }
        size = in.readInt();
        for (iii = 0; iii < size; ++iii) {
            Flag flag = DefaultUniProtFactory.getInstance().buildFlag(FlagType.values()[in.readInt()]);
            this.readEvidenceIds(in, flag);
            description.getFlags().add(flag);
        }
        this.readEvidenceIds(in, description);
    }

    public Section readSection(ObjectInput in) throws IOException, ClassNotFoundException {
        Section s = DefaultUniProtFactory.getInstance().buildSection();
        int namesSize = in.readInt();
        for (int jjj = 0; jjj < namesSize; ++jjj) {
            s.getNames().add(this.readName(in));
        }
        this.readEvidenceIds(in, s);
        return s;
    }

    public Name readName(ObjectInput in) throws IOException, ClassNotFoundException {
        Name name = DefaultUniProtFactory.getInstance().buildName();
        name.setNameType(NameType.values()[in.readInt()]);
        int fieldSize = in.readInt();
        for (int jjj = 0; jjj < fieldSize; ++jjj) {
            name.getFields().add(this.readField(in));
        }
        this.readEvidenceIds(in, name);
        return name;
    }

    public Field readField(ObjectInput in) throws IOException, ClassNotFoundException {
        Field field = DefaultUniProtFactory.getInstance().buildField();
        field.setType(FieldType.values()[in.readInt()]);
        field.setValue((String)in.readObject());
        this.readEvidenceIds(in, field);
        return field;
    }

    @Deprecated
    private void readDescription(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        Description description = entry.getDescription();
        this.readDescriptionModifier(in, description, entry);
        List<ProteinName> proteinNames = description.getProteinNames();
        this.readProteinNames(in, proteinNames, entry);
        this.readIncludesSection(in, description, entry);
        this.readContainsSection(in, description, entry);
        int type = in.readInt();
        switch (type) {
            case 1: {
                description.setVersion(DescriptionVersion.NO_VERSION);
                break;
            }
            case 2: {
                description.setVersion(DescriptionVersion.VERSION_1);
                break;
            }
            case 3: {
                description.setVersion(DescriptionVersion.VERSION_2);
            }
        }
        type = in.readInt();
        switch (type) {
            case 1: {
                description.setFragmentationType(FragmentationType.FRAGMENT);
                break;
            }
            case 2: {
                description.setFragmentationType(FragmentationType.FRAGMENTS);
                break;
            }
            case 3: {
                description.setFragmentationType(FragmentationType.FULL_SEQUENCE);
            }
        }
        this.readEvidenceIds(in, description);
    }

    private void writeDescriptionModifier(Description description, ObjectOutput out, UniProtEntry entry) throws IOException {
        switch (description.getDescriptionModifier()) {
            case HYPOTHETICAL: {
                out.writeInt(1);
                break;
            }
            case POSSIBLE: {
                out.writeInt(2);
                break;
            }
            case PROBABLE: {
                out.writeInt(3);
                break;
            }
            case PUTATIVE: {
                out.writeInt(4);
                break;
            }
            case VERIFIED: {
                out.writeInt(5);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void readDescriptionModifier(ObjectInput in, Description description, UniProtEntry entry) throws IOException {
        int type = in.readInt();
        switch (type) {
            case 1: {
                description.setDescriptionModifier(DescriptionModifier.HYPOTHETICAL);
                break;
            }
            case 2: {
                description.setDescriptionModifier(DescriptionModifier.POSSIBLE);
                break;
            }
            case 3: {
                description.setDescriptionModifier(DescriptionModifier.PROBABLE);
                break;
            }
            case 4: {
                description.setDescriptionModifier(DescriptionModifier.PUTATIVE);
                break;
            }
            case 5: {
                description.setDescriptionModifier(DescriptionModifier.VERIFIED);
            }
        }
    }

    private void readContainsSection(ObjectInput in, Description description, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            FunctionalSection fs = DefaultUniProtFactory.getInstance().buildMultifunctionalSection();
            description.getContainsSection().add(fs);
            this.readProteinNames(in, fs.getProteinNames(), entry);
        }
    }

    private void readIncludesSection(ObjectInput in, Description description, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            FunctionalSection fs = DefaultUniProtFactory.getInstance().buildMultifunctionalSection();
            description.getIncludesSection().add(fs);
            this.readProteinNames(in, fs.getProteinNames(), entry);
        }
    }

    private void readProteinNames(ObjectInput in, List<ProteinName> proteinNames, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            proteinNames.add(this.readProteinName(in));
        }
    }

    public ProteinName readProteinName(ObjectInput in) throws IOException, ClassNotFoundException {
        int type = in.readInt();
        switch (type) {
            case 1: {
                return DefaultUniProtFactory.getInstance().buildProteinName((String)in.readObject(), ProteinNameType.EC);
            }
            case 2: {
                return DefaultUniProtFactory.getInstance().buildProteinName((String)in.readObject(), ProteinNameType.RECOMENDED);
            }
            case 3: {
                return DefaultUniProtFactory.getInstance().buildProteinName((String)in.readObject(), ProteinNameType.SYNONYM);
            }
        }
        throw new IllegalArgumentException("Unknown case error " + type);
    }

    private void writeContainsSection(Description description, ObjectOutput out, UniProtEntry entry) throws IOException {
        List<FunctionalSection> contains = description.getContainsSection();
        out.writeInt(contains.size());
        for (FunctionalSection functionalSection : contains) {
            this.writeProteinNames(functionalSection.getProteinNames(), out, entry);
        }
    }

    private void writeIncludesSection(Description description, ObjectOutput out, UniProtEntry entry) throws IOException {
        List<FunctionalSection> includes = description.getIncludesSection();
        out.writeInt(includes.size());
        for (FunctionalSection functionalSection : includes) {
            this.writeProteinNames(functionalSection.getProteinNames(), out, entry);
        }
    }

    private void writeProteinNames(List<ProteinName> proteinNames, ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(proteinNames.size());
        for (ProteinName proteinName : proteinNames) {
            this.writeProteinName(proteinName, out);
        }
    }

    public void writeProteinName(ProteinName proteinName, ObjectOutput out) throws IOException {
        switch (proteinName.getProteinNameType()) {
            case EC: {
                out.writeInt(1);
                break;
            }
            case RECOMENDED: {
                out.writeInt(2);
                break;
            }
            case SYNONYM: {
                out.writeInt(3);
            }
        }
        out.writeObject(proteinName.getValue());
    }

    private void readIntenalSection(ObjectInput in, UniProtEntry entry) throws ClassNotFoundException {
        try {
            int size = 0;
            size = in.readInt();
            for (int iii = 0; iii < size; ++iii) {
                int type = in.readInt();
                InternalLine internalLine = DefaultUniProtFactory.getInstance().buildInternalLine();
                internalLine.setInternalLineType(InternalLineType.getTypeByPosition(type));
                String value = (String)in.readObject();
                internalLine.setValue(value);
                entry.getInternalSection().getInternalLines().add(internalLine);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeInternalSection(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getInternalSection().getInternalLines().size());
        for (InternalLine line : entry.getInternalSection().getInternalLines()) {
            out.writeInt(line.getInternalLineType().getPosition());
            out.writeObject(line.getValue());
        }
    }

    private void writeEvidences(ObjectOutput out, UniProtEntry entry) throws IOException {
        out.writeInt(entry.getEvidences().size());
        for (Evidence ev : entry.getEvidences()) {
            this.writeEvidence(out, ev);
        }
    }

    private void readEvidences(ObjectInput in, UniProtEntry entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            Evidence ev = DefaultUniProtFactory.getInstance().buildEvidenceFactory().buildEvidence();
            this.readEvidence(ev, in);
            entry.getEvidences().add(ev);
        }
    }

    private void writeEvidence(ObjectOutput out, Evidence ev) throws IOException {
        out.writeObject(ev.getAttribute().getValue());
        switch (ev.getCategory()) {
            case AA: {
                out.writeByte(1);
                break;
            }
            case CURATION: {
                out.writeByte(2);
                break;
            }
            case IMPORT: {
                out.writeByte(3);
                break;
            }
            case NOT_SPECIFIED: {
                out.writeByte(4);
                break;
            }
            case PROGRAMME: {
                out.writeByte(5);
                break;
            }
        }
        out.writeLong(ev.getDate().getTime());
        out.writeObject(ev.getEvidenceId().getValue());
        out.writeObject(ev.getOriginName().getValue());
        out.writeObject(ev.getType().getValue());
        out.writeObject(ev.getEvidenceCode().getCodeValue());
    }

    private void readEvidence(Evidence ev, ObjectInput stream) throws IOException, ClassNotFoundException {
        ev.getAttribute().setValue((String)stream.readObject());
        switch (stream.readByte()) {
            case 1: {
                ev.setCategory(EvidenceCategory.AA);
                break;
            }
            case 2: {
                ev.setCategory(EvidenceCategory.CURATION);
                break;
            }
            case 3: {
                ev.setCategory(EvidenceCategory.IMPORT);
                break;
            }
            case 4: {
                ev.setCategory(EvidenceCategory.NOT_SPECIFIED);
                break;
            }
            case 5: {
                ev.setCategory(EvidenceCategory.PROGRAMME);
                break;
            }
        }
        ev.setDate(new Date(stream.readLong()));
        ev.getEvidenceId().setValue((String)stream.readObject());
        ev.getOriginName().setValue((String)stream.readObject());
        ev.setType(EvidenceType.typeOf((String)stream.readObject()));
        ev.setEvidenceCode(EvidenceCode.typeOf((String)stream.readObject()));
    }

    public void writeEvidenceIds(ObjectOutput out, List<EvidenceId> evidenceIds) throws IOException {
        out.writeInt(evidenceIds.size());
        for (EvidenceId evId : evidenceIds) {
            out.writeObject(evId.getValue());
        }
    }

    private void readEvidenceIds(ObjectInput in, HasEvidences object) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            EvidenceId evId = DefaultUniProtFactory.getInstance().buildEvidenceFactory().buildEvidenceId((String)in.readObject());
            object.getEvidenceIds().add(evId);
        }
    }
}

