/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.serialize;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import uk.ac.ebi.kraken.interfaces.ProteinData;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotation;
import uk.ac.ebi.kraken.interfaces.interpro.InterProGroup;
import uk.ac.ebi.kraken.interfaces.interpro.InterProMatch;
import uk.ac.ebi.kraken.interfaces.prediction.DefaultPrediction;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.model.ProteinDataImpl;
import uk.ac.ebi.kraken.model.serialize.DefaultInterProGroupSerializer;
import uk.ac.ebi.kraken.model.serialize.DefaultUniProtEntryImplSerializer;

public class DefaultProteinDataImplSerializer {
    public void writeObject(ProteinDataImpl entry, ObjectOutput out) throws IOException {
        out.writeObject(entry.getUniParcEntry());
        this.writeUniRefEntries(out, entry);
        this.writeInterProMatches(out, entry);
        this.writeInterProGroups(out, entry);
        this.writeGoStuff(out, entry);
        this.writePredictionStuff(out, entry);
        new DefaultUniProtEntryImplSerializer().writeObject(entry.getUniProtEntry(), out);
    }

    public void readObject(ProteinDataImpl entry, ObjectInput in) throws IOException, ClassNotFoundException {
        entry.setUniParcEntry((UniParcEntry)in.readObject());
        this.readUniRefEntries(in, entry);
        this.readInterProMatches(in, entry);
        this.readInterProGroups(in, entry);
        this.readGoStuff(in, entry);
        this.readPredictionStuff(in, entry);
        new DefaultUniProtEntryImplSerializer().readObject(entry.getUniProtEntry(), in);
    }

    private void writeUniRefEntries(ObjectOutput out, ProteinDataImpl entry) throws IOException {
        Collection<UniRefEntry> entries = entry.getUniRefEntries();
        out.writeInt(entries.size());
        for (UniRefEntry e : entries) {
            out.writeObject(e);
        }
    }

    private void readUniRefEntries(ObjectInput in, ProteinDataImpl entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            UniRefEntry ur = (UniRefEntry)in.readObject();
            entry.setUniRefEntry(ur);
        }
    }

    private void readInterProMatches(ObjectInput in, ProteinData entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            InterProMatch match = (InterProMatch)in.readObject();
            entry.getInterProMatches().add(match);
        }
    }

    private void writeInterProMatches(ObjectOutput out, ProteinData entry) throws IOException {
        List<InterProMatch> matches = entry.getInterProMatches();
        out.writeInt(matches.size());
        for (InterProMatch match : matches) {
            out.writeObject(match);
        }
    }

    private void readPredictionStuff(ObjectInput in, ProteinData entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            DefaultPrediction match = (DefaultPrediction)in.readObject();
            entry.getPredictions().add(match);
        }
    }

    private void writePredictionStuff(ObjectOutput out, ProteinData entry) throws IOException {
        Set<DefaultPrediction> matches = entry.getPredictions();
        out.writeInt(matches.size());
        for (DefaultPrediction match : matches) {
            out.writeObject(match);
        }
    }

    private void readGoStuff(ObjectInput in, ProteinData entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            GoAnnotation match = (GoAnnotation)in.readObject();
            entry.getGoAnnotations().add(match);
        }
    }

    private void writeGoStuff(ObjectOutput out, ProteinData entry) throws IOException {
        List<GoAnnotation> matches = entry.getGoAnnotations();
        out.writeInt(matches.size());
        for (GoAnnotation match : matches) {
            out.writeObject(match);
        }
    }

    private void writeInterProGroups(ObjectOutput out, ProteinData entry) throws IOException {
        List<InterProGroup> groups = entry.getInterProGroups();
        out.writeInt(groups.size());
        DefaultInterProGroupSerializer ser = new DefaultInterProGroupSerializer();
        for (InterProGroup group : groups) {
            out.writeObject(group);
        }
    }

    private void readInterProGroups(ObjectInput in, ProteinData entry) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int iii = 0; iii < size; ++iii) {
            InterProGroup group = (InterProGroup)in.readObject();
            entry.getInterProGroups().add(group);
        }
    }
}

