/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionType;
import uk.ac.ebi.kraken.interfaces.prediction.web.PredictedEntry;
import uk.ac.ebi.kraken.interfaces.prediction.web.WebPrediction;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class PredictedEntryImpl
implements Serializable,
PredictedEntry {
    private PrimaryUniProtAccession primaryUniProtAccession;
    private UniProtId uniProtId;
    private List<WebPrediction> predictions = new ArrayList<WebPrediction>();

    public PredictedEntryImpl() {
        this.primaryUniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession();
    }

    public PredictedEntryImpl(String primaryUniProtAccession) {
        this.primaryUniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(primaryUniProtAccession);
    }

    public PredictedEntryImpl(PrimaryUniProtAccession primaryUniProtAccession) {
        this.primaryUniProtAccession = primaryUniProtAccession;
    }

    @Override
    public UniProtId getUniProtId() {
        return this.uniProtId;
    }

    @Override
    public void setUniProtId(UniProtId uniProtId) {
        this.uniProtId = uniProtId;
    }

    @Override
    public PrimaryUniProtAccession getPrimaryUniProtAccession() {
        return this.primaryUniProtAccession;
    }

    @Override
    public void setPrimaryUniProtAccession(PrimaryUniProtAccession primaryUniProtAccession) {
        this.primaryUniProtAccession = primaryUniProtAccession;
    }

    @Override
    public List<WebPrediction> getKeywordPredictions() {
        ArrayList<WebPrediction> result = new ArrayList<WebPrediction>();
        for (WebPrediction prediction : this.predictions) {
            if (!PredictionType.isKeywordPrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<WebPrediction> getProteinNamePredictions() {
        ArrayList<WebPrediction> result = new ArrayList<WebPrediction>();
        for (WebPrediction prediction : this.predictions) {
            if (!PredictionType.isProteinNamePrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<WebPrediction> getCommentPredictions() {
        ArrayList<WebPrediction> result = new ArrayList<WebPrediction>();
        for (WebPrediction prediction : this.predictions) {
            if (!PredictionType.isCommentPrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<WebPrediction> getEcNumberPredictions() {
        throw new UnsupportedOperationException("EC-Numbers not supported yet");
    }

    @Override
    public boolean containsEvidenceTag(String evidenceTag) {
        return this.getPredictionByEvidenceTag(evidenceTag) != null;
    }

    @Override
    public boolean add(WebPrediction prediction) {
        return this.predictions.add(prediction);
    }

    @Override
    public boolean isEmpty() {
        return this.predictions.isEmpty();
    }

    @Override
    public WebPrediction getPredictionByEvidenceTag(String evidenceTag) {
        for (WebPrediction prediction : this.predictions) {
            if (!prediction.containsEvidenceTag(evidenceTag)) continue;
            return prediction;
        }
        return null;
    }

    public String toString() {
        return "PredictedEntryImpl{primaryUniProtAccession=" + this.primaryUniProtAccession + ", uniProtId=" + this.uniProtId + ", predictions=" + this.predictions + '}';
    }
}

