/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;

public class SequenceLengthCondition
implements Condition,
Externalizable {
    private int length;
    private boolean isNegative = false;
    private boolean isEqual = false;

    public SequenceLengthCondition(SequenceLengthCondition copy) {
        this.length = copy.length;
        this.isNegative = copy.isNegative;
        this.isEqual = copy.isEqual;
    }

    public SequenceLengthCondition() {
        this.length = 0;
    }

    public SequenceLengthCondition(int length) {
        this.length = length;
    }

    public SequenceLengthCondition(int length, boolean negative) {
        this.length = length;
        this.isNegative = negative;
    }

    public boolean isEqual() {
        return this.isEqual;
    }

    public void setEqual(boolean equal) {
        this.isEqual = equal;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    @Override
    public String getValue() {
        return "Sequence Length greater than " + this.length;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.SEQUENCE_LENGTH;
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("SLEN:");
        if (this.isNegative) {
            sb.append("<:");
        } else {
            sb.append(">:");
        }
        sb.append(this.length);
        return sb.toString();
    }

    public String toString() {
        return "SequenceLengthCondition[length=" + this.length + ", isNegative=" + this.isNegative + ", isEqual=" + this.isEqual + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceLengthCondition that = (SequenceLengthCondition)o;
        if (this.isNegative != that.isNegative) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + (this.isNegative ? 1 : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.length);
        objectOutput.writeBoolean(this.isNegative);
        objectOutput.writeBoolean(this.isEqual);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.length = objectInput.readInt();
        this.isNegative = objectInput.readBoolean();
        this.isEqual = objectInput.readBoolean();
    }
}

