/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import java.io.Serializable;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismCommonName;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class OrganismCondition
implements Condition,
Serializable {
    private OrganismCommonName organism;
    private boolean isNegative = false;

    public OrganismCondition(OrganismCondition copy) {
        this.organism = DefaultUniProtFactory.getInstance().buildOrganismCommonName(copy.organism);
        this.isNegative = copy.isNegative;
    }

    public OrganismCondition() {
        this.organism = DefaultUniProtFactory.getInstance().buildOrganismCommonName(this.organism);
    }

    public OrganismCondition(OrganismCommonName organism) {
        this.organism = organism;
    }

    public OrganismCondition(String organism) {
        this.organism = DefaultUniProtFactory.getInstance().buildOrganismCommonName(organism);
    }

    public OrganismCondition(String organism, boolean isNegative) {
        this.isNegative = isNegative;
        this.organism = DefaultUniProtFactory.getInstance().buildOrganismCommonName(organism);
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    @Override
    public String getValue() {
        return "Organism: " + this.organism.getValue();
    }

    @Override
    public ConditionType getType() {
        return ConditionType.ORGANISM;
    }

    public String toString() {
        return "OrganismCondition[organism=" + this.organism + ", isNegative=" + this.isNegative + ']';
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("OS:");
        if (this.isNegative) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(":" + this.organism.getValue());
        return sb.toString();
    }
}

