/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;

public class OrganelleTypeCondition
implements Condition {
    private GeneEncodingType organelle;
    private boolean isNegative = false;

    public OrganelleTypeCondition(OrganelleTypeCondition copy) {
        this.organelle = copy.organelle;
        this.isNegative = copy.isNegative;
    }

    public OrganelleTypeCondition() {
    }

    public OrganelleTypeCondition(GeneEncodingType ogCondition) {
        this.organelle = ogCondition;
    }

    public OrganelleTypeCondition(String gType, boolean isNegative) {
        this.organelle = GeneEncodingType.valueOf(gType);
        this.isNegative = isNegative;
    }

    public OrganelleTypeCondition(GeneEncodingType ncbiTaxon, boolean isNegative) {
        this.organelle = ncbiTaxon;
        this.isNegative = isNegative;
    }

    public GeneEncodingType getGeneEncodingType() {
        return this.organelle;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.ORGANELLE;
    }

    @Override
    public String getValue() {
        return "Organelle (GeneEncodingType): " + this.organelle.getValue();
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("OG:");
        if (this.isNegative) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(":" + this.organelle.toString());
        return sb.toString();
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }
}

