/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class NcbiTaxonCondition
implements Condition,
Externalizable {
    private NcbiTaxon ncbiTaxon;
    private boolean isNegative = false;

    public NcbiTaxonCondition(NcbiTaxonCondition copy) {
        this.ncbiTaxon = DefaultUniProtFactory.getInstance().buildNcbiTaxon(copy.getNcbiTaxon());
        this.isNegative = copy.isNegative;
    }

    public NcbiTaxonCondition() {
        this.ncbiTaxon = DefaultUniProtFactory.getInstance().buildNcbiTaxon();
    }

    public NcbiTaxonCondition(NcbiTaxon ncbiTaxon) {
        this.ncbiTaxon = ncbiTaxon;
    }

    public NcbiTaxonCondition(String ncbiTaxon, boolean isNegative) {
        this.ncbiTaxon = DefaultUniProtFactory.getInstance().buildNcbiTaxon(ncbiTaxon);
        this.isNegative = isNegative;
    }

    public NcbiTaxonCondition(NcbiTaxon ncbiTaxon, boolean isNegative) {
        this.ncbiTaxon = ncbiTaxon;
        this.isNegative = isNegative;
    }

    public NcbiTaxon getNcbiTaxon() {
        return this.ncbiTaxon;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public String getValue() {
        return "Taxonomy: " + this.ncbiTaxon.getValue();
    }

    @Override
    public ConditionType getType() {
        return ConditionType.NCBI_TAXON;
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("OC:");
        if (this.isNegative) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(":" + this.ncbiTaxon);
        return sb.toString();
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    public String toString() {
        return "NcbiTaxonCondition[ncbiTaxon=" + this.ncbiTaxon + ", isNegative=" + this.isNegative + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NcbiTaxonCondition that = (NcbiTaxonCondition)o;
        if (this.isNegative != that.isNegative) {
            return false;
        }
        return !(this.ncbiTaxon != null ? !this.ncbiTaxon.equals(that.ncbiTaxon) : that.ncbiTaxon != null);
    }

    public int hashCode() {
        int result = this.ncbiTaxon != null ? this.ncbiTaxon.hashCode() : 0;
        result = 31 * result + (this.isNegative ? 1 : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isNegative);
        objectOutput.writeObject(this.ncbiTaxon);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isNegative = objectInput.readBoolean();
        this.ncbiTaxon = (NcbiTaxon)objectInput.readObject();
    }
}

