/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import uk.ac.ebi.kraken.interfaces.interpro.MethodAccession;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;

public class InterProMatchScoreCondition
implements Condition {
    private MethodAccession methodAccession;
    private double score;
    private boolean isNegative = false;

    public InterProMatchScoreCondition(InterProMatchScoreCondition copy) {
        this.methodAccession = DefaultInterProFactory.getInstance().buildMethodAccession(copy.methodAccession);
        this.score = copy.score;
        this.isNegative = copy.isNegative;
    }

    public InterProMatchScoreCondition() {
    }

    public InterProMatchScoreCondition(MethodAccession methodAccession, double score) {
        this.methodAccession = methodAccession;
        this.score = score;
    }

    public InterProMatchScoreCondition(String methodAccession, double score, boolean negative) {
        this.methodAccession = DefaultInterProFactory.getInstance().buildMethodAccession(methodAccession);
        this.score = score;
        this.isNegative = negative;
    }

    public InterProMatchScoreCondition(MethodAccession methodAccession, double score, boolean negative) {
        this.methodAccession = methodAccession;
        this.score = score;
        this.isNegative = negative;
    }

    public MethodAccession getMethodAccession() {
        return this.methodAccession;
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    @Override
    public String getValue() {
        return this.methodAccession.getValue() + "is greater than" + this.score;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.INTERPRO_MATCH_SCORE;
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("MATCH_SCORE:");
        if (this.isNegative) {
            sb.append("<:");
        } else {
            sb.append(">:");
        }
        sb.append(this.methodAccession.getValue());
        sb.append(":");
        sb.append(this.score);
        return sb.toString();
    }

    public String toString() {
        return "InterProMatchScoreCondition[methodAccession=" + this.methodAccession + ", score=" + this.score + ", isNegative=" + this.isNegative + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterProMatchScoreCondition that = (InterProMatchScoreCondition)o;
        if (this.isNegative != that.isNegative) {
            return false;
        }
        if (Double.compare(that.score, this.score) != 0) {
            return false;
        }
        return !(this.methodAccession != null ? !this.methodAccession.equals(that.methodAccession) : that.methodAccession != null);
    }

    public int hashCode() {
        int result = this.methodAccession != null ? this.methodAccession.hashCode() : 0;
        long temp = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isNegative ? 1 : 0);
        return result;
    }
}

