/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import uk.ac.ebi.kraken.interfaces.interpro.InterProMatch;
import uk.ac.ebi.kraken.interfaces.interpro.MethodType;
import uk.ac.ebi.kraken.interfaces.interpro.Status;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;

public class InterProMatchCondition
implements Condition {
    private InterProMatch interProMatch;
    private boolean isNegative = false;

    public InterProMatchCondition(InterProMatchCondition copy) {
        this.interProMatch = DefaultInterProFactory.getInstance().buildInterProMatch(copy.getInterProMatch());
        this.isNegative = copy.isNegative;
    }

    public InterProMatchCondition() {
    }

    public InterProMatchCondition(InterProMatch interProMatch) {
        this.interProMatch = interProMatch;
    }

    public InterProMatchCondition(String match, boolean negative) {
        this.interProMatch = DefaultInterProFactory.getInstance().buildInterProMatch();
        this.interProMatch.setMethodAccession(DefaultInterProFactory.getInstance().buildMethodAccession(match));
        this.interProMatch.setType(this.getType(match));
        this.isNegative = negative;
    }

    private MethodType getType(String match) {
        MethodType type = null;
        if (match.startsWith("PF")) {
            type = MethodType.PFAM;
        } else if (match.startsWith("PS")) {
            type = MethodType.PROSITE;
        } else if (match.startsWith("SSF")) {
            type = MethodType.SSF;
        } else if (match.startsWith("G")) {
            type = MethodType.GENE3D;
        } else if (match.startsWith("PTHR")) {
            type = MethodType.PANTHER;
        } else if (match.startsWith("PIR")) {
            type = MethodType.PIRSF;
        } else if (match.startsWith("PR")) {
            type = MethodType.PRINTS;
        } else if (match.startsWith("PD")) {
            type = MethodType.PRODOM;
        } else if (match.startsWith("SM")) {
            type = MethodType.SMART;
        } else if (match.startsWith("TIGR")) {
            type = MethodType.TIGRFAMs;
        } else if (match.startsWith("MF")) {
            type = MethodType.HAMAP;
        } else {
            try {
                throw new IllegalArgumentException("Match " + match + " is not supported");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return type;
    }

    public InterProMatchCondition(String match) {
        this.interProMatch = DefaultInterProFactory.getInstance().buildInterProMatch();
        this.interProMatch.setMethodAccession(DefaultInterProFactory.getInstance().buildMethodAccession(match));
        this.interProMatch.setType(this.getType(match));
    }

    public InterProMatchCondition(String match, String status, boolean negative) {
        this.interProMatch = DefaultInterProFactory.getInstance().buildInterProMatch();
        this.interProMatch.setMethodAccession(DefaultInterProFactory.getInstance().buildMethodAccession(match));
        this.interProMatch.setType(this.getType(match));
        Status stat = Status.valueOf(status);
        this.interProMatch.setStatus(stat);
        this.isNegative = negative;
    }

    public InterProMatchCondition(InterProMatch interProMatch, boolean negative) {
        this.interProMatch = interProMatch;
        this.isNegative = negative;
    }

    public InterProMatch getInterProMatch() {
        return this.interProMatch;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    @Override
    public String getValue() {
        return this.interProMatch.getType().getValue() + " " + this.interProMatch.getMethodAccession().getValue();
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("MATCH:");
        if (this.isNegative) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(":" + this.interProMatch.getMethodAccession());
        return sb.toString();
    }

    public String toString() {
        return "InterProMatchCondition[interProMatch=" + this.interProMatch + ", isNegative=" + this.isNegative + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterProMatchCondition that = (InterProMatchCondition)o;
        if (this.isNegative != that.isNegative) {
            return false;
        }
        return !(this.interProMatch != null ? !this.interProMatch.equals(that.interProMatch) : that.interProMatch != null);
    }

    public int hashCode() {
        int result = this.interProMatch != null ? this.interProMatch.hashCode() : 0;
        result = 31 * result + (this.isNegative ? 1 : 0);
        return result;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.INTERPRO_MATCH;
    }
}

