/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import uk.ac.ebi.kraken.interfaces.interpro.InterProAc;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;

public class InterProAccCondition
implements Condition,
Externalizable {
    private InterProAc interProAcc;
    private boolean isNegative = false;

    public InterProAccCondition(InterProAccCondition copy) {
        this.interProAcc = DefaultInterProFactory.getInstance().buildInterProAc(copy.getInterProAcc());
        this.isNegative = copy.isNegative;
    }

    public InterProAccCondition() {
        this(DefaultInterProFactory.getInstance().buildInterProAc());
    }

    public InterProAccCondition(String interProAcc) {
        this(DefaultInterProFactory.getInstance().buildInterProAc(interProAcc));
    }

    public InterProAccCondition(InterProAc interProAcc) {
        this.interProAcc = interProAcc;
    }

    public InterProAccCondition(String interProAcc, boolean negative) {
        this(DefaultInterProFactory.getInstance().buildInterProAc(interProAcc), negative);
    }

    public InterProAccCondition(InterProAc interProAcc, boolean negative) {
        this.interProAcc = interProAcc;
        this.isNegative = negative;
    }

    public InterProAc getInterProAcc() {
        return this.interProAcc;
    }

    @Override
    public boolean isNegative() {
        return this.isNegative;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.INTERPRO_ACC;
    }

    @Override
    public void setIsNegative(boolean isNegative) {
        this.isNegative = isNegative;
    }

    @Override
    public String getValue() {
        return "InterProGroup " + this.interProAcc.getValue();
    }

    public String toString() {
        return "InterProAccCondition[interProAcc=" + this.interProAcc + ", isNegative=" + this.isNegative + ']';
    }

    @Override
    public String toDisplayName() {
        StringBuffer sb = new StringBuffer();
        sb.append("IPRO:");
        if (this.isNegative) {
            sb.append("-");
        } else {
            sb.append("+");
        }
        sb.append(":" + this.interProAcc.getValue());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterProAccCondition that = (InterProAccCondition)o;
        if (this.isNegative != that.isNegative) {
            return false;
        }
        return !(this.interProAcc != null ? !this.interProAcc.equals(that.interProAcc) : that.interProAcc != null);
    }

    public int hashCode() {
        int result = this.interProAcc != null ? this.interProAcc.hashCode() : 0;
        result = 31 * result + (this.isNegative ? 1 : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isNegative);
        objectOutput.writeObject(this.interProAcc);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isNegative = objectInput.readBoolean();
        this.interProAcc = (InterProAc)objectInput.readObject();
    }
}

