/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction.conditions;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.model.prediction.conditions.FragmentCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProAccCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchNumberCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchScoreCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.NcbiTaxonCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.OrganelleTypeCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.OrganismCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.SequenceLengthCondition;

@Deprecated
public class ConditionConverter {
    public static String export(List<Condition> data, boolean includeFlatFileMarkings) {
        return ConditionConverter.condition2String(data);
    }

    public static List<Condition> string2Conditions(String data) {
        ArrayList<Condition> result = new ArrayList<Condition>();
        if (!data.contains(";")) {
            throw new IllegalArgumentException("Data: '" + data + " 'not convertable");
        }
        String[] strings = data.split(";");
        boolean isNegative = false;
        boolean isEqual = false;
        for (String cond : strings) {
            String condition = cond.contains(";") ? cond.substring(0, cond.lastIndexOf(";")) : cond;
            Condition new_condition = null;
            String[] conditionString = condition.split(":");
            if (cond.contains("G3D")) {
                conditionString = ConditionConverter.gene3DCondtion(conditionString);
            }
            if (cond.contains("PTHR") && cond.contains("SF")) {
                conditionString = ConditionConverter.pantherCondtion(conditionString);
            }
            String proAcc = "";
            double number = 0.0;
            if (conditionString.length > 2) {
                proAcc = conditionString[2];
            }
            if (conditionString.length > 3) {
                try {
                    number = new Double(conditionString[3]);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (conditionString.length > 1) {
                if (conditionString[1].equals("-")) {
                    isNegative = true;
                } else if (conditionString[1].equals("+")) {
                    isNegative = false;
                } else if (conditionString[1].equals("<")) {
                    isNegative = true;
                } else if (conditionString[1].equals(">")) {
                    isNegative = false;
                } else if (conditionString[1].equals("=")) {
                    isEqual = true;
                }
            }
            if (condition.startsWith("IPRO:")) {
                new_condition = new InterProAccCondition(proAcc, isNegative);
            } else if (condition.startsWith("MATCH:")) {
                if (proAcc.contains(" ")) {
                    String[] matchInfo = proAcc.split(" ");
                    String acc = matchInfo[0];
                    String status = matchInfo[1];
                    new_condition = new InterProMatchCondition(acc, status, isNegative);
                } else {
                    new_condition = new InterProMatchCondition(proAcc, isNegative);
                }
            } else if (condition.startsWith("OC:")) {
                new_condition = new NcbiTaxonCondition(proAcc, isNegative);
            } else if (condition.startsWith("FRAGMENT:")) {
                new_condition = new FragmentCondition(isNegative);
            } else if (condition.startsWith("MATCH_SCORE:")) {
                new_condition = new InterProMatchScoreCondition(proAcc, number, isNegative);
            } else if (condition.startsWith("SLEN:")) {
                new_condition = new SequenceLengthCondition(new Integer(proAcc), isNegative);
            } else if (condition.startsWith("OG")) {
                new_condition = new OrganelleTypeCondition(proAcc, isNegative);
            } else if (condition.startsWith("OS")) {
                new_condition = new OrganismCondition(proAcc, isNegative);
            } else {
                if (!condition.startsWith("NUMBER_MATCHES")) continue;
                Double doub = new Double(number);
                boolean param = isNegative;
                if (isEqual) {
                    param = true;
                }
                new_condition = new InterProMatchNumberCondition(proAcc, doub.intValue(), param);
            }
            result.add(new_condition);
        }
        return result;
    }

    private static String[] pantherCondtion(String[] conditionString) {
        if (conditionString.length < 4 || conditionString.length > 5) {
            throw new IllegalArgumentException();
        }
        String[] newConditionString = new String[conditionString.length - 1];
        for (int iii = 0; iii < conditionString.length; ++iii) {
            newConditionString[0] = conditionString[0];
            newConditionString[1] = conditionString[1];
            newConditionString[2] = conditionString[2] + ":" + conditionString[3];
            if (conditionString.length != 5) continue;
            newConditionString[3] = conditionString[4];
        }
        conditionString = newConditionString;
        return conditionString;
    }

    private static String[] gene3DCondtion(String[] conditionString) {
        if (conditionString.length < 4 || conditionString.length > 5) {
            throw new IllegalArgumentException();
        }
        String[] newConditionString = new String[conditionString.length - 1];
        for (int iii = 0; iii < conditionString.length; ++iii) {
            newConditionString[0] = conditionString[0];
            newConditionString[1] = conditionString[1];
            newConditionString[2] = conditionString[2] + ":" + conditionString[3];
            if (conditionString.length != 5) continue;
            newConditionString[3] = conditionString[4];
        }
        conditionString = newConditionString;
        return conditionString;
    }

    public static String condition2String(List<Condition> conditions) {
        StringBuilder sb = new StringBuilder();
        for (Condition condition : conditions) {
            if (condition.toDisplayName().equals("")) continue;
            sb.append(condition.toDisplayName());
            sb.append(";");
        }
        return sb.toString();
    }
}

