/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.prediction.DefaultPrediction;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionContainer;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionType;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;

public class PredictionContainerImpl
implements PredictionContainer {
    private PrimaryUniProtAccession primaryUniProtAccession;
    private UniProtId uniProtId;
    private List<DefaultPrediction> predictions = new ArrayList<DefaultPrediction>();

    @Override
    public PrimaryUniProtAccession getPrimaryUniProtAccession() {
        return this.primaryUniProtAccession;
    }

    @Override
    public void setPrimaryUniProtAccession(PrimaryUniProtAccession primaryUniProtAccession) {
        this.primaryUniProtAccession = primaryUniProtAccession;
    }

    @Override
    public UniProtId getUniProtId() {
        return this.uniProtId;
    }

    @Override
    public void setUniProtId(UniProtId uniProtId) {
        this.uniProtId = uniProtId;
    }

    @Override
    public List<DefaultPrediction> getPredictions() {
        return this.predictions;
    }

    @Override
    public List<DefaultPrediction> getCommentPredictions() {
        ArrayList<DefaultPrediction> result = new ArrayList<DefaultPrediction>();
        for (DefaultPrediction prediction : this.predictions) {
            if (!PredictionType.isCommentPrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<DefaultPrediction> getKeywordPredictions() {
        ArrayList<DefaultPrediction> result = new ArrayList<DefaultPrediction>();
        for (DefaultPrediction prediction : this.predictions) {
            if (!PredictionType.isKeywordPrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<DefaultPrediction> getProteinNamePredictions() {
        ArrayList<DefaultPrediction> result = new ArrayList<DefaultPrediction>();
        for (DefaultPrediction prediction : this.predictions) {
            if (!PredictionType.isProteinNamePrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public List<DefaultPrediction> getEcNamePredictions() {
        ArrayList<DefaultPrediction> result = new ArrayList<DefaultPrediction>();
        for (DefaultPrediction prediction : this.predictions) {
            if (!PredictionType.isEcNamePrediction(prediction.getPredictionType())) continue;
            result.add(prediction);
        }
        return result;
    }

    @Override
    public void setPredictions(List<DefaultPrediction> predictions) {
        this.predictions = predictions;
    }

    @Override
    public boolean isEmpty() {
        return this.predictions.isEmpty();
    }

    @Override
    public boolean add(DefaultPrediction prediction) {
        return this.predictions.add(prediction);
    }

    @Override
    public boolean containsEvidenceTag(String evidenceTag) {
        for (DefaultPrediction prediction : this.predictions) {
            if (!prediction.getRuleId().equals(evidenceTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DefaultPrediction getPredictionByEvidenceTag(String evidenceTag) {
        for (DefaultPrediction prediction : this.predictions) {
            if (!prediction.getRuleId().equals(evidenceTag)) continue;
            return prediction;
        }
        return null;
    }
}

