/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.prediction;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.EntryId;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.DefaultPrediction;
import uk.ac.ebi.kraken.interfaces.prediction.EvaluationResult;
import uk.ac.ebi.kraken.interfaces.prediction.Position;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionType;
import uk.ac.ebi.kraken.interfaces.prediction.PredictiveModelType;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultPredictionFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.prediction.conditions.ConditionConverter;
import uk.ac.ebi.kraken.util.IndexField;

public final class DefaultPredictionImpl
implements DefaultPrediction,
PersistentObject {
    private EntryId entryId;
    private long id;
    private PredictiveModelType predictiveModelType;
    private EvaluationResult evaluationResult;
    private PredictionType type;
    private double score;
    private double confidence;
    private boolean isimportedToTrembl;
    private List<Condition> conditions;
    private String value;
    private String ruleId;
    private String interProGroup;
    private Position startPosition;
    private Position endPosition;
    private static final char SEPERATOR = '\t';

    public DefaultPredictionImpl(DefaultPrediction copy) {
        this.entryId = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(copy.getEntryId().getValue());
        this.id = copy.getId();
        this.predictiveModelType = copy.getPredictiveModelType();
        this.evaluationResult = copy.getEvaluationResult();
        this.type = copy.getType();
        this.score = copy.getScore();
        this.confidence = copy.getConfidence();
        this.isimportedToTrembl = false;
        this.conditions = new ArrayList<Condition>();
        this.value = copy.getValue();
        this.ruleId = copy.getRuleId();
        this.interProGroup = copy.getInterProGroup();
        this.startPosition = copy.getStartPosition();
        this.endPosition = copy.getEndPosition();
        for (Condition condition : copy.getConditions()) {
            this.conditions.add(condition);
        }
    }

    public DefaultPredictionImpl() {
        this.value = "";
        this.entryId = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession();
        this.conditions = new ArrayList<Condition>();
        this.id = 0L;
        this.predictiveModelType = PredictiveModelType.UNKNOWN;
        this.evaluationResult = EvaluationResult.UNKNOWN;
        this.type = PredictionType.UNKNOWN;
        this.score = 0.0;
        this.confidence = 0.0;
        this.isimportedToTrembl = false;
        this.ruleId = "";
        this.interProGroup = "";
        this.startPosition = DefaultPredictionFactory.getInstance().buildPosition();
        this.endPosition = DefaultPredictionFactory.getInstance().buildPosition();
    }

    public DefaultPredictionImpl(PredictionType type) {
        this();
        this.type = type;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @IndexThisField(fieldName={IndexField.PREDICTION_CONDITION})
    public String getConditionAsString() {
        return ConditionConverter.condition2String(this.conditions);
    }

    public void setConditions(List conditions) {
        this.conditions = conditions;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_ENTRY}, includeInContent=true)
    public EntryId getEntryId() {
        return this.entryId;
    }

    @Override
    public void setEntryId(EntryId entryId) {
        this.entryId = entryId;
    }

    @Override
    public Position getStartPosition() {
        return this.startPosition;
    }

    @Override
    public void setStartPosition(Position startPosition) {
        this.startPosition = startPosition;
    }

    @Override
    public Position getEndPosition() {
        return this.endPosition;
    }

    @Override
    public void setEndPosition(Position endPosition) {
        this.endPosition = endPosition;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_MODEL}, includeInContent=true)
    public PredictiveModelType getPredictiveModelType() {
        return this.predictiveModelType;
    }

    @Override
    public void setPredictiveModelType(PredictiveModelType predictiveModelType) {
        this.predictiveModelType = predictiveModelType;
    }

    @Override
    public EvaluationResult getEvaluationResult() {
        return this.evaluationResult;
    }

    @Override
    public void setEvaluationResult(EvaluationResult evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_TYPE})
    public PredictionType getType() {
        return this.type;
    }

    @Override
    public void setType(PredictionType type) {
        this.type = type;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_SCORE}, includeInContent=true)
    public double getScore() {
        return this.score;
    }

    @Override
    public void setScore(double score) {
        this.score = score;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_VALUE}, includeInContent=true)
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_CONFIDENCE}, includeInContent=true)
    public double getConfidence() {
        return this.confidence;
    }

    @Override
    public void setConfidence(double confidence) {
        this.confidence = confidence;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_IMPORTED})
    public boolean isIsImportedToTrEMBL() {
        return this.isimportedToTrembl;
    }

    @Override
    public void setIsImportedToTrEMBL(boolean isimportedToTrembl) {
        this.isimportedToTrembl = isimportedToTrembl;
    }

    @Override
    @IndexThisField(fieldName={IndexField.HID})
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @IndexThisField(fieldName={IndexField.PREDICTION_CLASSIFIER}, includeInContent=true)
    public String getRuleId() {
        return this.ruleId;
    }

    @Override
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    @Override
    public void setInterProGroup(String interProGroup) {
        this.interProGroup = interProGroup;
    }

    @Override
    public String getInterProGroup() {
        return this.interProGroup;
    }

    public String toString() {
        return "DefaultPredictionImpl[entryId=" + this.entryId + ", conditions=" + this.conditions + ", id=" + this.id + ", predictiveModelType=" + (Object)((Object)this.predictiveModelType) + ", evaluationResult=" + (Object)((Object)this.evaluationResult) + ", type=" + (Object)((Object)this.type) + ", score=" + this.score + ", confidence=" + this.confidence + ", isimportedToTrembl=" + this.isimportedToTrembl + ", ruleId=" + this.ruleId + ", value=" + this.value + ", interProGroup= " + this.interProGroup + ", startPosition= " + this.startPosition + ", endPosition= " + this.endPosition + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPredictionImpl that = (DefaultPredictionImpl)o;
        if (Double.compare(that.confidence, this.confidence) != 0) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.isimportedToTrembl != that.isimportedToTrembl) {
            return false;
        }
        if (Double.compare(that.score, this.score) != 0) {
            return false;
        }
        if (!((Object)this.conditions).equals(that.conditions)) {
            return false;
        }
        if (!this.endPosition.equals(that.endPosition)) {
            return false;
        }
        if (!this.entryId.equals(that.entryId)) {
            return false;
        }
        if (this.evaluationResult != that.evaluationResult) {
            return false;
        }
        if (!this.interProGroup.equals(that.interProGroup)) {
            return false;
        }
        if (this.predictiveModelType != that.predictiveModelType) {
            return false;
        }
        if (!this.ruleId.equals(that.ruleId)) {
            return false;
        }
        if (!this.startPosition.equals(that.startPosition)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.entryId.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.predictiveModelType.hashCode();
        result = 31 * result + this.evaluationResult.hashCode();
        result = 31 * result + this.type.hashCode();
        long temp = this.score != 0.0 ? Double.doubleToLongBits(this.score) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.confidence != 0.0 ? Double.doubleToLongBits(this.confidence) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isimportedToTrembl ? 1 : 0);
        result = 31 * result + ((Object)this.conditions).hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.ruleId.hashCode();
        result = 31 * result + this.interProGroup.hashCode();
        result = 31 * result + this.startPosition.hashCode();
        result = 31 * result + this.endPosition.hashCode();
        return result;
    }

    @Override
    public String writeOut() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ruleId);
        sb.append('\t');
        sb.append(this.type.getDisplayName());
        sb.append('\t');
        sb.append(this.value);
        sb.append('\t');
        sb.append(this.entryId);
        sb.append('\t');
        sb.append(this.score);
        sb.append('\t');
        sb.append(this.confidence);
        sb.append('\t');
        sb.append(this.predictiveModelType.getDbCode());
        sb.append('\t');
        sb.append((Object)this.evaluationResult);
        sb.append('\t');
        sb.append(ConditionConverter.condition2String(this.conditions));
        return sb.toString();
    }

    @Override
    public PredictionType getPredictionType() {
        return this.type;
    }

    @Override
    public Boolean getIsImportedToTrEMBL() {
        throw new UnsupportedOperationException("Method getIsImportedToTrEMBL is not supported");
    }

    @Override
    public UniProtId getUniProtId() {
        throw new UnsupportedOperationException("Method getUniProtId is not supported");
    }

    @Override
    public void setUniProtId(UniProtId uniProtId) {
        throw new UnsupportedOperationException("Method setUniProtId is not supported");
    }

    public void setIsImportedToTrEMBL(Boolean isImported) {
        throw new UnsupportedOperationException("Method setIsImportedToTrEMBL is not supported");
    }

    public CommentType getCommentType() {
        throw new UnsupportedOperationException("Method getCommentType is not supported");
    }

    public void setCommentType(CommentType type) {
        throw new UnsupportedOperationException("Method setCommentType is not supported");
    }

    @Override
    public String getTrainingSetId() {
        throw new UnsupportedOperationException("Method getTrainingSetId is not supported");
    }

    @Override
    public void setTrainingSetId(String trainingSetId) {
        throw new UnsupportedOperationException("Method setTrainingSetId is not supported");
    }

    public Object getOriginalValue() {
        throw new UnsupportedOperationException("Method getOriginalValue is not supported");
    }
}

