/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.interpro;

import java.util.HashSet;
import java.util.Set;
import uk.ac.ebi.kraken.interfaces.interpro.Abstract;
import uk.ac.ebi.kraken.interfaces.interpro.InterProAc;
import uk.ac.ebi.kraken.interfaces.interpro.InterProEntry;
import uk.ac.ebi.kraken.interfaces.interpro.Name;
import uk.ac.ebi.kraken.interfaces.interpro.Protein;
import uk.ac.ebi.kraken.interfaces.interpro.ShortName;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.interpro.InterProAcImpl;
import uk.ac.ebi.kraken.util.IndexField;
import uk.ac.ebi.kraken.util.NoNullElementsSet;
import uk.ac.ebi.kraken.util.test.NullAble;

public class InterProEntryImpl
implements InterProEntry,
PersistentObject {
    private InterProAc interProAc;
    private Name name;
    private ShortName shortName;
    private Abstract theAbstract;
    private Set<UniProtAccession> swissprotAccessions;
    private Set<UniProtAccession> tremblAccessions;
    private boolean checked;
    private long id;

    public InterProEntryImpl() {
        this.interProAc = new InterProAcImpl();
        this.name = DefaultInterProFactory.getInstance().buildName();
        this.shortName = DefaultInterProFactory.getInstance().buildShortName();
        this.theAbstract = DefaultInterProFactory.getInstance().buildAbstract();
        this.swissprotAccessions = new NoNullElementsSet<UniProtAccession>(new HashSet());
        this.tremblAccessions = new NoNullElementsSet<UniProtAccession>(new HashSet());
        this.checked = false;
    }

    public InterProEntryImpl(InterProEntry copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.interProAc = DefaultInterProFactory.getInstance().buildInterProAc(copy.getInterProAc());
        this.name = DefaultInterProFactory.getInstance().buildName(copy.getName());
        this.shortName = DefaultInterProFactory.getInstance().buildShortName(copy.getShortName());
        this.theAbstract = DefaultInterProFactory.getInstance().buildAbstract(copy.getTheAbstract());
        this.swissprotAccessions = new NoNullElementsSet<UniProtAccession>(new HashSet());
        for (UniProtAccession protein : copy.getSwissProtAccessions()) {
            this.swissprotAccessions.add(DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(protein.getValue()));
        }
        this.tremblAccessions = new NoNullElementsSet<UniProtAccession>(new HashSet());
        for (UniProtAccession protein : copy.getSwissProtAccessions()) {
            this.tremblAccessions.add(DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(protein.getValue()));
        }
        this.checked = copy.isChecked();
    }

    @Override
    @IndexThisField(fieldName={IndexField.HID})
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public InterProAc getInterProAc() {
        return this.interProAc;
    }

    @Override
    @NullAble
    public void setInterProAc(InterProAc ac) {
        this.interProAc = ac;
    }

    @Override
    public boolean isChecked() {
        return this.checked;
    }

    @Override
    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    @Override
    public Name getName() {
        return DefaultInterProFactory.getInstance().buildName(this.name);
    }

    @Override
    @NullAble
    public void setName(Name name) {
        this.name = name;
    }

    @Override
    public ShortName getShortName() {
        return DefaultInterProFactory.getInstance().buildShortName(this.shortName);
    }

    @Override
    @NullAble
    public void setShortName(ShortName shortName) {
        this.shortName = shortName;
    }

    @Override
    @NullAble
    public void setTheAbstract(Abstract theAbstract) {
        this.theAbstract = theAbstract;
    }

    @Override
    public Abstract getTheAbstract() {
        return DefaultInterProFactory.getInstance().buildAbstract(this.theAbstract);
    }

    @Override
    public Set<Protein> getProteins() {
        throw new UnsupportedOperationException("Use the swissprot or trembl accession sets");
    }

    @Override
    public void setProteins(Set<Protein> proteins) {
        throw new UnsupportedOperationException("Use the swissprot or trembl accession sets");
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_ENTRY_SP})
    public Set<UniProtAccession> getSwissProtAccessions() {
        return this.swissprotAccessions;
    }

    @Override
    public void setSwissProtAccessions(Set<UniProtAccession> swissprotAccessions) {
        this.swissprotAccessions = swissprotAccessions;
    }

    @Override
    @IndexThisField(fieldName={IndexField.INTERPRO_ENTRY_TR})
    public Set<UniProtAccession> getTremblAccessions() {
        return this.tremblAccessions;
    }

    @Override
    public void setTremblAccessions(Set<UniProtAccession> tremblAccessions) {
        this.tremblAccessions = tremblAccessions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterProEntryImpl that = (InterProEntryImpl)o;
        if (this.checked != that.checked) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.interProAc != null ? !this.interProAc.equals(that.interProAc) : that.interProAc != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.shortName != null ? !this.shortName.equals(that.shortName) : that.shortName != null) {
            return false;
        }
        if (this.swissprotAccessions != null ? !((Object)this.swissprotAccessions).equals(that.swissprotAccessions) : that.swissprotAccessions != null) {
            return false;
        }
        if (this.theAbstract != null ? !this.theAbstract.equals(that.theAbstract) : that.theAbstract != null) {
            return false;
        }
        return !(this.tremblAccessions != null ? !((Object)this.tremblAccessions).equals(that.tremblAccessions) : that.tremblAccessions != null);
    }

    public int hashCode() {
        int result = this.interProAc != null ? this.interProAc.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
        result = 31 * result + (this.theAbstract != null ? this.theAbstract.hashCode() : 0);
        result = 31 * result + (this.swissprotAccessions != null ? ((Object)this.swissprotAccessions).hashCode() : 0);
        result = 31 * result + (this.tremblAccessions != null ? ((Object)this.tremblAccessions).hashCode() : 0);
        result = 31 * result + (this.checked ? 1 : 0);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "InterProEntry {\nid=" + this.interProAc.getValue() + ";\n" + "name=" + this.name + ";\n" + "}";
    }
}

