/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.common.Value;
import uk.ac.ebi.kraken.interfaces.factories.CitationFactory;
import uk.ac.ebi.kraken.interfaces.factories.CitationNewFactory;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.factories.FeatureFactory;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.factories.UtilitiesFactory;
import uk.ac.ebi.kraken.interfaces.factories.XRefFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseType;
import uk.ac.ebi.kraken.interfaces.uniprot.Description;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.interfaces.uniprot.Gene;
import uk.ac.ebi.kraken.interfaces.uniprot.GeneEncodingType;
import uk.ac.ebi.kraken.interfaces.uniprot.Keyword;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxonomyId;
import uk.ac.ebi.kraken.interfaces.uniprot.Organelle;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;
import uk.ac.ebi.kraken.interfaces.uniprot.OrganismHost;
import uk.ac.ebi.kraken.interfaces.uniprot.PrimaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.ProteinDescription;
import uk.ac.ebi.kraken.interfaces.uniprot.SecondaryUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ECNumber;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Flag;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FlagType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FunctionalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinName;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.description.ProteinNameType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.RecomendedProteinName;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Section;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.GeneNameSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.ORFName;
import uk.ac.ebi.kraken.interfaces.uniprot.genename.OrderedLocusName;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLine;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalLineType;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.InternalSection;
import uk.ac.ebi.kraken.interfaces.uniprot.internalsection.SourceLine;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismCommonName;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismScientificName;
import uk.ac.ebi.kraken.interfaces.uniprot.organism.OrganismSynonym;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.common.ValueImpl;
import uk.ac.ebi.kraken.model.factories.DefaultCitationFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCitationNewFactory;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEntryFactory;
import uk.ac.ebi.kraken.model.factories.DefaultEvidenceFactory;
import uk.ac.ebi.kraken.model.factories.DefaultFeatureFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUtilitiesFactory;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.DescriptionImpl;
import uk.ac.ebi.kraken.model.uniprot.EntryAuditImpl;
import uk.ac.ebi.kraken.model.uniprot.NcbiTaxonomyIdImpl;
import uk.ac.ebi.kraken.model.uniprot.OrganismHostImpl;
import uk.ac.ebi.kraken.model.uniprot.ProteinDescriptionImpl;
import uk.ac.ebi.kraken.model.uniprot.UniProtDatabaseImpl;
import uk.ac.ebi.kraken.model.uniprot.UniProtEntryImpl;
import uk.ac.ebi.kraken.model.uniprot.UniProtIdImpl;
import uk.ac.ebi.kraken.model.uniprot.accessions.PrimaryUniProtAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.accessions.SecondaryUniProtAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.description.ECNumberImpl;
import uk.ac.ebi.kraken.model.uniprot.description.FieldImpl;
import uk.ac.ebi.kraken.model.uniprot.description.FlagImpl;
import uk.ac.ebi.kraken.model.uniprot.description.FunctionalSectionImpl;
import uk.ac.ebi.kraken.model.uniprot.description.NameImpl;
import uk.ac.ebi.kraken.model.uniprot.description.ProteinNameImpl;
import uk.ac.ebi.kraken.model.uniprot.description.ProteinNameSynonymImpl;
import uk.ac.ebi.kraken.model.uniprot.description.RecomendedProteinNameImpl;
import uk.ac.ebi.kraken.model.uniprot.description.SectionImpl;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceIdImpl;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceImpl;
import uk.ac.ebi.kraken.model.uniprot.genename.GeneImpl;
import uk.ac.ebi.kraken.model.uniprot.genename.GeneNameImpl;
import uk.ac.ebi.kraken.model.uniprot.genename.GeneNameSynonymImpl;
import uk.ac.ebi.kraken.model.uniprot.genename.ORFNameImpl;
import uk.ac.ebi.kraken.model.uniprot.genename.OrderedLocusNameImpl;
import uk.ac.ebi.kraken.model.uniprot.internalsection.InternalLineImpl;
import uk.ac.ebi.kraken.model.uniprot.internalsection.InternalSectionImpl;
import uk.ac.ebi.kraken.model.uniprot.internalsection.SourceLineImpl;
import uk.ac.ebi.kraken.model.uniprot.keywords.KeywordImpl;
import uk.ac.ebi.kraken.model.uniprot.organelles.OrganelleImpl;
import uk.ac.ebi.kraken.model.uniprot.organism.OrganismCommonNameImpl;
import uk.ac.ebi.kraken.model.uniprot.organism.OrganismImpl;
import uk.ac.ebi.kraken.model.uniprot.organism.OrganismScientificNameImpl;
import uk.ac.ebi.kraken.model.uniprot.organism.OrganismSynonymImpl;
import uk.ac.ebi.kraken.model.uniprot.taxons.NcbiTaxonImpl;

public class DefaultUniProtFactory
extends DefaultEntryFactory
implements UniProtFactory {
    private static DefaultUniProtFactory singletonInstance;
    private XRefFactory xRefFactory;

    protected DefaultUniProtFactory() {
    }

    public static DefaultUniProtFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultUniProtFactory();
            DefaultUniProtFactory.singletonInstance.xRefFactory = DefaultXRefFactory.getInstance();
        }
        return singletonInstance;
    }

    public static FeatureFactory getFeatureFactory() {
        return DefaultFeatureFactory.getInstance();
    }

    public static XRefFactory getXRefFactory() {
        if (singletonInstance != null) {
            return DefaultUniProtFactory.singletonInstance.xRefFactory;
        }
        return DefaultXRefFactory.getInstance();
    }

    public static CommentFactory getCommentFactory() {
        return DefaultCommentFactory.getInstance();
    }

    public static CitationFactory getCitationFactory() {
        return DefaultCitationFactory.getInstance();
    }

    public static CitationNewFactory getNewCitationFactory() {
        return DefaultCitationNewFactory.getInstance();
    }

    public static EvidenceFactory getEvidenceFactory() {
        return DefaultEvidenceFactory.getInstance();
    }

    @Override
    public UniProtEntry buildEntry() {
        return new UniProtEntryImpl();
    }

    @Override
    public UniProtEntry buildEntry(UniProtEntry copy) {
        return new UniProtEntryImpl(copy);
    }

    @Override
    public UniProtId buildUniProtId(String value) {
        UniProtIdImpl id = new UniProtIdImpl();
        id.setValue(value);
        return id;
    }

    @Override
    public UniProtId buildUniProtId() {
        return this.buildUniProtId("");
    }

    @Override
    public UniProtId buildUniProtId(UniProtId copy) {
        return new UniProtIdImpl(copy);
    }

    @Override
    public OrganismHost buildOrganismHost() {
        return new OrganismHostImpl();
    }

    @Override
    public OrganismHost buildOrganismHost(OrganismHost copy) {
        return new OrganismHostImpl(copy);
    }

    @Override
    public SecondaryUniProtAccession buildSecondaryUniProtAccession(String accession) {
        if (accession == null) {
            throw new IllegalArgumentException();
        }
        SecondaryUniProtAccessionImpl ac = new SecondaryUniProtAccessionImpl();
        ac.setValue(accession);
        return ac;
    }

    @Override
    public SecondaryUniProtAccession buildSecondaryUniProtAccession(SecondaryUniProtAccession copy) {
        SecondaryUniProtAccessionImpl ac = new SecondaryUniProtAccessionImpl(copy);
        return ac;
    }

    @Override
    public SecondaryUniProtAccession buildSecondaryUniProtAccession() {
        return this.buildSecondaryUniProtAccession("");
    }

    @Override
    public PrimaryUniProtAccession buildPrimaryUniProtAccession(String accession) {
        PrimaryUniProtAccessionImpl ac = new PrimaryUniProtAccessionImpl();
        ac.setValue(accession);
        return ac;
    }

    @Override
    public PrimaryUniProtAccession buildPrimaryUniProtAccession(PrimaryUniProtAccession copy) {
        PrimaryUniProtAccessionImpl ac = new PrimaryUniProtAccessionImpl(copy);
        return ac;
    }

    @Override
    public PrimaryUniProtAccession buildPrimaryUniProtAccession() {
        return this.buildPrimaryUniProtAccession("");
    }

    @Override
    public EntryAudit buildEntryAudit() {
        return new EntryAuditImpl();
    }

    @Override
    public EntryAudit buildEntryAudit(EntryAudit copy) {
        return new EntryAuditImpl(copy);
    }

    @Override
    public Keyword buildKeyword(String keyword) {
        KeywordImpl kw = new KeywordImpl();
        kw.setValue(keyword);
        return kw;
    }

    @Override
    public Keyword buildKeyword() {
        return this.buildKeyword("");
    }

    @Override
    public Keyword buildKeyword(Keyword copy) {
        return new KeywordImpl(copy);
    }

    @Override
    public NcbiTaxon buildNcbiTaxon(String value) {
        NcbiTaxonImpl taxon = new NcbiTaxonImpl();
        taxon.setValue(value);
        return taxon;
    }

    @Override
    public NcbiTaxon buildNcbiTaxon() {
        return this.buildNcbiTaxon("");
    }

    @Override
    public NcbiTaxon buildNcbiTaxon(NcbiTaxon copy) {
        return new NcbiTaxonImpl(copy);
    }

    @Override
    public EvidenceId buildEvidenceId(String evidenceId) {
        EvidenceIdImpl id = new EvidenceIdImpl();
        id.setValue(evidenceId);
        return id;
    }

    @Override
    public EvidenceId buildEvidenceId(EvidenceId evidenceId) {
        EvidenceIdImpl id = new EvidenceIdImpl();
        id.setValue(evidenceId.getValue());
        return id;
    }

    @Override
    public DatabaseCrossReference buildDatabaseCrossReference(DatabaseType databaseType) {
        XRefFactory myXRefFactory = DefaultUniProtFactory.getXRefFactory();
        Object dbc = myXRefFactory.buildDatabaseCrossReference(databaseType);
        return dbc;
    }

    @Override
    public Value buildValue(String value) {
        ValueImpl v = new ValueImpl();
        v.setValue(value);
        return v;
    }

    @Override
    public Sequence buildSequence(String value) {
        SequenceImpl sequence = new SequenceImpl();
        sequence.setValue(value);
        return sequence;
    }

    @Override
    public Sequence buildSequence(Sequence copy) {
        return new SequenceImpl(copy);
    }

    @Override
    public Database buildDatabase() {
        return new UniProtDatabaseImpl();
    }

    @Override
    public Evidence buildEvidence(EvidenceId evidenceId) {
        EvidenceImpl ev = new EvidenceImpl();
        ev.setEvidenceId(evidenceId);
        return ev;
    }

    public Evidence buildEvidence(String evidenceId) {
        EvidenceImpl ev = new EvidenceImpl();
        ev.setEvidenceId(this.buildEvidenceId(evidenceId));
        return ev;
    }

    @Override
    public FeatureFactory buildFeatureFactory() {
        return DefaultFeatureFactory.getInstance();
    }

    @Override
    public CommentFactory buildCommentFactory() {
        return DefaultCommentFactory.getInstance();
    }

    @Override
    public CitationFactory buildCitationFactory() {
        return DefaultCitationFactory.getInstance();
    }

    @Override
    public CitationNewFactory buildCitationNewFactory() {
        return DefaultCitationNewFactory.getInstance();
    }

    @Override
    public UtilitiesFactory buildUtilitiesFactory() {
        return DefaultUtilitiesFactory.getInstance();
    }

    @Override
    public ProteinDescription buildProteinDescription() {
        return new ProteinDescriptionImpl();
    }

    @Override
    public ProteinDescription buildProteinDescription(ProteinDescription copy) {
        return new ProteinDescriptionImpl(copy);
    }

    @Override
    @Deprecated
    public Description buildDescription() {
        return new DescriptionImpl();
    }

    @Override
    @Deprecated
    public Description buildDescription(Description copy) {
        return new DescriptionImpl(copy);
    }

    @Override
    @Deprecated
    public ProteinName buildProteinName(ProteinNameType type) {
        return new ProteinNameImpl(type);
    }

    @Override
    @Deprecated
    public ProteinName buildProteinName(ProteinName copy) {
        return new ProteinNameImpl(copy);
    }

    @Override
    @Deprecated
    public ProteinName buildProteinName(String name, ProteinNameType type) {
        ProteinNameImpl result = new ProteinNameImpl(type);
        result.setValue(name);
        return result;
    }

    @Override
    @Deprecated
    public ECNumber buildECNumber(String name) {
        ECNumberImpl result = new ECNumberImpl();
        result.setValue(name);
        return result;
    }

    @Override
    @Deprecated
    public ECNumber buildECNumber(ECNumber copy) {
        return new ECNumberImpl(copy);
    }

    @Override
    @Deprecated
    public ProteinNameSynonym buildProteinNameSynonym(String name) {
        ProteinNameSynonymImpl result = new ProteinNameSynonymImpl();
        result.setValue(name);
        return result;
    }

    @Override
    @Deprecated
    public ProteinNameSynonym buildProteinNameSynonym(ProteinNameSynonym copy) {
        return new ProteinNameSynonymImpl(copy);
    }

    @Override
    @Deprecated
    public RecomendedProteinName buildRecomendedProteinName(String name) {
        RecomendedProteinNameImpl result = new RecomendedProteinNameImpl();
        result.setValue(name);
        return result;
    }

    @Override
    @Deprecated
    public RecomendedProteinName buildRecomendedProteinName(RecomendedProteinName copy) {
        return new RecomendedProteinNameImpl(copy);
    }

    @Override
    public Field buildField() {
        return new FieldImpl();
    }

    @Override
    public Field buildField(Field field) {
        return new FieldImpl(field);
    }

    @Override
    public Name buildName(Name name) {
        return new NameImpl(name);
    }

    @Override
    public Name buildName() {
        return new NameImpl();
    }

    @Override
    public Section buildSection() {
        return new SectionImpl();
    }

    @Override
    public Section buildSection(Section section) {
        return new SectionImpl(section);
    }

    @Override
    public NcbiTaxonomyId buildNcbiTaxonomyId() {
        return new NcbiTaxonomyIdImpl();
    }

    @Override
    public NcbiTaxonomyId buildNcbiTaxonomyId(String id) {
        NcbiTaxonomyId result = this.buildNcbiTaxonomyId();
        result.setValue(id);
        return result;
    }

    @Override
    public NcbiTaxonomyId buildNcbiTaxonomyId(NcbiTaxonomyId copy) {
        return new NcbiTaxonomyIdImpl(copy);
    }

    @Override
    public FunctionalSection buildMultifunctionalSection() {
        return new FunctionalSectionImpl();
    }

    @Override
    public Gene buildGene() {
        return new GeneImpl();
    }

    @Override
    public Gene buildGene(Gene copy) {
        GeneImpl ret = new GeneImpl();
        ret.setGeneName(this.buildGeneName(copy.getGeneName().getValue()));
        for (GeneNameSynonym geneNameSynonym : copy.getGeneNameSynonyms()) {
            ret.getGeneNameSynonyms().add(this.buildGeneNameSynonym(geneNameSynonym.getValue()));
        }
        for (OrderedLocusName orderedLocusName : copy.getOrderedLocusNames()) {
            ret.getOrderedLocusNames().add(this.buildOrderedLocusName(orderedLocusName.getValue()));
        }
        for (ORFName oRFName : copy.getORFNames()) {
            ret.getORFNames().add(this.buildORFName(oRFName.getValue()));
        }
        return ret;
    }

    @Override
    public GeneName buildGeneName() {
        return new GeneNameImpl();
    }

    @Override
    public GeneName buildGeneName(String value) {
        GeneName result = this.buildGeneName();
        result.setValue(value);
        return result;
    }

    @Override
    public GeneNameSynonym buildGeneNameSynonym() {
        return new GeneNameSynonymImpl();
    }

    @Override
    public GeneNameSynonym buildGeneNameSynonym(String value) {
        GeneNameSynonym result = this.buildGeneNameSynonym();
        result.setValue(value);
        return result;
    }

    @Override
    public OrderedLocusName buildOrderedLocusName() {
        return new OrderedLocusNameImpl();
    }

    @Override
    public OrderedLocusName buildOrderedLocusName(String value) {
        OrderedLocusName result = this.buildOrderedLocusName();
        result.setValue(value);
        return result;
    }

    @Override
    public ORFName buildORFName() {
        return new ORFNameImpl();
    }

    @Override
    public ORFName buildORFName(String value) {
        ORFName result = this.buildORFName();
        result.setValue(value);
        return result;
    }

    @Override
    public Organism buildOrganism() {
        return new OrganismImpl();
    }

    @Override
    public Organism buildOrganism(Organism copy) {
        return new OrganismImpl(copy);
    }

    @Override
    public OrganismScientificName buildOrganismScientificName() {
        return new OrganismScientificNameImpl();
    }

    @Override
    public OrganismScientificName buildOrganismScientificName(String name) {
        OrganismScientificName result = this.buildOrganismScientificName();
        result.setValue(name);
        return result;
    }

    @Override
    public OrganismScientificName buildOrganismScientificName(OrganismScientificName copy) {
        return new OrganismScientificNameImpl(copy);
    }

    @Override
    public OrganismSynonym buildOrganismSynonym() {
        return new OrganismSynonymImpl();
    }

    @Override
    public OrganismSynonym buildOrganismSynonym(String name) {
        OrganismSynonym result = this.buildOrganismSynonym();
        result.setValue(name);
        return result;
    }

    @Override
    public OrganismSynonym buildOrganismSynonym(OrganismSynonym copy) {
        return new OrganismSynonymImpl(copy);
    }

    @Override
    public OrganismCommonName buildOrganismCommonName() {
        return new OrganismCommonNameImpl();
    }

    @Override
    public OrganismCommonName buildOrganismCommonName(String name) {
        OrganismCommonName result = this.buildOrganismCommonName();
        result.setValue(name);
        return result;
    }

    @Override
    public OrganismCommonName buildOrganismCommonName(OrganismCommonName copy) {
        return new OrganismCommonNameImpl(copy);
    }

    @Override
    public Organelle buildOrganelle(GeneEncodingType type) {
        OrganelleImpl retVal = new OrganelleImpl();
        retVal.setType(type);
        return retVal;
    }

    @Override
    public Organelle buildOrganelle(GeneEncodingType type, String value) {
        Organelle retVal = this.buildOrganelle(type);
        retVal.setValue(value);
        return retVal;
    }

    @Override
    public Organelle buildOrganelle(Organelle copy) {
        return new OrganelleImpl(copy);
    }

    @Override
    public EvidenceFactory buildEvidenceFactory() {
        return DefaultEvidenceFactory.getInstance();
    }

    @Override
    public InternalSection buildInternalSection() {
        return new InternalSectionImpl();
    }

    @Override
    public InternalLine buildInternalLine() {
        return new InternalLineImpl();
    }

    @Override
    public InternalSection buildInternalSection(InternalSection internalSection) {
        return new InternalSectionImpl(internalSection);
    }

    public SourceLine buildSourceLine() {
        return new SourceLineImpl();
    }

    public SourceLine buildSourceLine(String value) {
        SourceLineImpl line = new SourceLineImpl();
        line.setValue(value);
        return line;
    }

    @Override
    public InternalLine buildInternalLine(String type, String value) {
        InternalLine ret = this.buildInternalLine();
        ret.setInternalLineType(InternalLineType.valueOf(type));
        ret.setValue(value);
        return ret;
    }

    public Flag buildFlag(FlagType type) {
        FlagImpl retVal = new FlagImpl();
        retVal.setFlagType(type);
        return retVal;
    }

    public Flag buildFlag(Flag oldFlag) {
        return new FlagImpl(oldFlag);
    }

    public Flag buildFlag() {
        return new FlagImpl();
    }
}

