/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.common.Database;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.factories.UniParcFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.DatabaseCrossReference;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcId;
import uk.ac.ebi.kraken.model.common.SequenceImpl;
import uk.ac.ebi.kraken.model.factories.DefaultEntryFactory;
import uk.ac.ebi.kraken.model.uniparc.UniParcDatabaseCrossReferenceImpl;
import uk.ac.ebi.kraken.model.uniparc.UniParcDatabaseImpl;
import uk.ac.ebi.kraken.model.uniparc.UniParcEntryImpl;
import uk.ac.ebi.kraken.model.uniparc.UniParcIdImpl;

public class DefaultUniParcFactory
extends DefaultEntryFactory
implements UniParcFactory {
    private static DefaultUniParcFactory singletonInstance;

    protected DefaultUniParcFactory() {
    }

    public static DefaultUniParcFactory getInstance() {
        if (singletonInstance == null) {
            // empty if block
        }
        singletonInstance = new DefaultUniParcFactory();
        return singletonInstance;
    }

    @Override
    public UniParcEntry buildEntry() {
        return new UniParcEntryImpl();
    }

    public UniParcEntry buildEntry(UniParcEntry copy) {
        return new UniParcEntryImpl(copy);
    }

    @Override
    public Sequence buildSequence() {
        return new SequenceImpl();
    }

    @Override
    public Sequence buildSequence(String value) {
        SequenceImpl sequence = new SequenceImpl();
        sequence.setValue(value);
        return sequence;
    }

    @Override
    public Database buildDatabase() {
        UniParcDatabaseImpl result = new UniParcDatabaseImpl();
        return result;
    }

    public Database buildDatabase(Database copy) {
        UniParcDatabaseImpl result = new UniParcDatabaseImpl(copy);
        return result;
    }

    @Override
    public DatabaseCrossReference buildDatabaseCrossReference() {
        UniParcDatabaseCrossReferenceImpl result = new UniParcDatabaseCrossReferenceImpl();
        return result;
    }

    public DatabaseCrossReference buildDatabaseCrossReference(DatabaseCrossReference xref) {
        UniParcDatabaseCrossReferenceImpl result = new UniParcDatabaseCrossReferenceImpl(xref);
        return result;
    }

    @Override
    public UniParcId buildUniParcId(String id) {
        UniParcIdImpl idImpl = new UniParcIdImpl();
        idImpl.setValue(id);
        return idImpl;
    }

    @Override
    public UniParcId buildUniParcId(UniParcId id) {
        UniParcIdImpl idImpl = new UniParcIdImpl();
        idImpl.setValue(id.getValue());
        return idImpl;
    }

    @Override
    public UniParcId buildUniParcId(Integer id) {
        UniParcIdImpl idImpl = new UniParcIdImpl();
        idImpl.setHexadecimalValue(id);
        return idImpl;
    }
}

