/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.PredictionFactory;
import uk.ac.ebi.kraken.interfaces.prediction.Condition;
import uk.ac.ebi.kraken.interfaces.prediction.ConditionType;
import uk.ac.ebi.kraken.interfaces.prediction.DefaultPrediction;
import uk.ac.ebi.kraken.interfaces.prediction.Position;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionContainer;
import uk.ac.ebi.kraken.interfaces.prediction.PredictionType;
import uk.ac.ebi.kraken.interfaces.prediction.web.PredictedEntry;
import uk.ac.ebi.kraken.interfaces.prediction.web.WebPrediction;
import uk.ac.ebi.kraken.interfaces.prediction.web.WebRule;
import uk.ac.ebi.kraken.model.prediction.DefaultPredictionImpl;
import uk.ac.ebi.kraken.model.prediction.PositionImpl;
import uk.ac.ebi.kraken.model.prediction.PredictionContainerImpl;
import uk.ac.ebi.kraken.model.prediction.conditions.FragmentCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProAccCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchNumberCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.InterProMatchScoreCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.NcbiTaxonCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.OrganelleTypeCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.OrganismCondition;
import uk.ac.ebi.kraken.model.prediction.conditions.SequenceLengthCondition;
import uk.ac.ebi.kraken.model.prediction.web.PredictedEntryImpl;
import uk.ac.ebi.kraken.model.prediction.web.WebPredictionImpl;
import uk.ac.ebi.kraken.model.prediction.web.WebRuleImpl;

public class DefaultPredictionFactory
implements PredictionFactory {
    private static DefaultPredictionFactory singletonInstance = new DefaultPredictionFactory();

    private DefaultPredictionFactory() {
    }

    public static DefaultPredictionFactory getInstance() {
        return singletonInstance;
    }

    public PredictionContainer buildPredictionContainer() {
        return new PredictionContainerImpl();
    }

    @Override
    @Deprecated
    public PredictedEntry buildPredictedEntry() {
        return new PredictedEntryImpl();
    }

    @Override
    @Deprecated
    public WebRule buildWebRule() {
        return new WebRuleImpl();
    }

    @Override
    @Deprecated
    public WebPrediction buildWebPrediction() {
        return new WebPredictionImpl();
    }

    @Override
    public DefaultPrediction buildDefaultPrediction() {
        return new DefaultPredictionImpl();
    }

    @Override
    public DefaultPrediction buildDefaultPrediction(PredictionType type) {
        return new DefaultPredictionImpl(type);
    }

    @Override
    public DefaultPrediction buildDefaultPrediction(DefaultPrediction copy) {
        return new DefaultPredictionImpl(copy);
    }

    @Override
    public Position buildPosition() {
        return new PositionImpl();
    }

    @Override
    public Position buildPosition(Position position) {
        return new PositionImpl(position);
    }

    @Override
    public Condition buildCondition(ConditionType type) {
        switch (type) {
            case FRAGMENT: {
                return new FragmentCondition();
            }
            case INTERPRO_ACC: {
                return new InterProAccCondition();
            }
            case INTERPRO_MATCH: {
                return new InterProMatchCondition();
            }
            case INTERPRO_MATCH_NUMBER: {
                return new InterProMatchNumberCondition();
            }
            case INTERPRO_MATCH_SCORE: {
                return new InterProMatchScoreCondition();
            }
            case NCBI_TAXON: {
                return new NcbiTaxonCondition();
            }
            case ORGANELLE: {
                return new OrganelleTypeCondition();
            }
            case ORGANISM: {
                return new OrganismCondition();
            }
            case SEQUENCE_LENGTH: {
                return new SequenceLengthCondition();
            }
        }
        throw new IllegalArgumentException("ConditionType " + (Object)((Object)type) + " is not supported");
    }

    @Override
    public Condition buildCondition(Condition condition) {
        switch (condition.getType()) {
            case FRAGMENT: {
                return new FragmentCondition((FragmentCondition)condition);
            }
            case INTERPRO_ACC: {
                return new InterProAccCondition((InterProAccCondition)condition);
            }
            case INTERPRO_MATCH: {
                return new InterProMatchCondition((InterProMatchCondition)condition);
            }
            case INTERPRO_MATCH_SCORE: {
                return new InterProMatchScoreCondition((InterProMatchScoreCondition)condition);
            }
            case NCBI_TAXON: {
                return new NcbiTaxonCondition((NcbiTaxonCondition)condition);
            }
            case ORGANELLE: {
                return new OrganelleTypeCondition((OrganelleTypeCondition)condition);
            }
            case ORGANISM: {
                return new OrganismCondition((OrganismCondition)condition);
            }
            case SEQUENCE_LENGTH: {
                return new SequenceLengthCondition((SequenceLengthCondition)condition);
            }
        }
        throw new IllegalArgumentException("ConditionType " + (Object)((Object)condition.getType()) + " is not supported");
    }
}

