/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.GoFactory;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotation;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotationEvidence;
import uk.ac.ebi.kraken.interfaces.go.GoId;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.interfaces.go.GoTermName;
import uk.ac.ebi.kraken.model.go.GoAnnotationImpl;
import uk.ac.ebi.kraken.model.go.GoIdImpl;
import uk.ac.ebi.kraken.model.go.GoTermImpl;
import uk.ac.ebi.kraken.model.go.GoTermNameImpl;

public class DefaultGoFactoryImpl
implements GoFactory {
    private static DefaultGoFactoryImpl instance = null;

    private DefaultGoFactoryImpl() {
    }

    public static DefaultGoFactoryImpl getInstance() {
        if (instance == null) {
            instance = new DefaultGoFactoryImpl();
        }
        return instance;
    }

    @Override
    public GoTerm buildGoTerm() {
        return new GoTermImpl();
    }

    @Override
    public GoTerm buildGoTerm(GoTerm copy) {
        return new GoTermImpl(copy);
    }

    @Override
    public GoTerm buildGoTerm(String termName, String id) {
        GoTermImpl term = new GoTermImpl();
        term.setGoTermName(this.buildGoTermName(termName));
        GoId goId = this.buildGoId(id);
        term.setGoId(goId);
        return term;
    }

    @Override
    public GoId buildGoId(String id) {
        GoIdImpl goId = new GoIdImpl();
        goId.setValue(id);
        return goId;
    }

    @Override
    public GoTermName buildGoTermName(String name) {
        GoTermNameImpl termName = new GoTermNameImpl();
        termName.setValue(name);
        return termName;
    }

    @Override
    public GoAnnotation buildGoAnnotation(String termName, String id, GoAnnotationEvidence evidence) {
        GoTermImpl term = new GoTermImpl();
        term.setGoTermName(this.buildGoTermName(termName));
        GoId goId = this.buildGoId(id);
        term.setGoId(goId);
        GoAnnotationImpl annotation = new GoAnnotationImpl();
        annotation.setGoTerm(term);
        annotation.setEvidence(evidence);
        return annotation;
    }
}

