/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Absorption;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AbsorptionNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AllergenComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsCommentComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsEvent;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoformComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BioPhysicoChemicalPropertiesComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.BiotechnologyComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CofactorComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Comment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseFTP;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DatabaseURL;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DevelopmentalStageComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DiseaseComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DisruptionPhenotypeComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.DomainComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Enzyme;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.EnzymeRegulationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.FunctionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InductionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionGeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorUniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameterNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.KineticParameters;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryIsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRange;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryRangeNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocityUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstant;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MichaelisConstantUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MiscellaneousComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataMolecularWeight;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PAGEDataPl;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PHDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PathwayComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PharmaceuticalComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PolymorphismComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PtmComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RedoxPotential;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SequenceCautionPosition;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SimilarityComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocation;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularLocationValue;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubcellularMolecule;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Substrate;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.SubunitComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TemperatureDependence;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.TissueSpecificityComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ToxicDoseComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.WebResourceComment;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AbsorptionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AbsorptionNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AllergenCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsCommentCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsEventImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsIsoformCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.AlternativeProductsIsoformImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.BioPhysicoChemicalPropertiesCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.BiotechnologyCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CatalyticActivityCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CautionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.CofactorCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseFTPImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DatabaseURLImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DevelopmentalStageCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DiseaseCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DisruptionPhenotypeCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.DomainCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.EnzymeImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.EnzymeRegulationCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.FunctionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InductionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionGeneNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorUniProtAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformSequenceIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.IsoformSynonymImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.KineticParameterNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.KineticParametersImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryCommentSourceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryIsoformIdImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryRangeImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MassSpectrometryRangeNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MaximumVelocityImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MichaelisConstantImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.MiscellaneousCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataMolecularWeightImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PAGEDataPlImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PHDependenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PathwayCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PharmaceuticalCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PolymorphismCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PositionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.PtmCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RedoxPotentialImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.RnaEditingNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SequenceCautionCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SequenceCautionCommentNoteImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SequenceCautionPositionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SimilarityCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularLocationValueImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubcellularMoleculeImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubstrateImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.SubunitCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.TemperatureDependenceImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.TissueSpecificityCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.ToxicDoseCommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.WebResourceCommentImpl;

public class DefaultCommentFactory
implements CommentFactory {
    private static DefaultCommentFactory singletonInstance;

    protected DefaultCommentFactory() {
    }

    public static DefaultCommentFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultCommentFactory();
        }
        return singletonInstance;
    }

    @Override
    public <T extends Comment> T buildComment(CommentType commentType) {
        CommentImpl result = null;
        switch (commentType) {
            case ALLERGEN: {
                result = new AllergenCommentImpl();
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                result = new AlternativeProductsCommentImpl();
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                result = new BioPhysicoChemicalPropertiesCommentImpl();
                break;
            }
            case BIOTECHNOLOGY: {
                result = new BiotechnologyCommentImpl();
                break;
            }
            case CATALYTIC_ACTIVITY: {
                result = new CatalyticActivityCommentImpl();
                break;
            }
            case SEQUENCE_CAUTION: {
                result = new SequenceCautionCommentImpl();
                break;
            }
            case COFACTOR: {
                result = new CofactorCommentImpl();
                break;
            }
            case WEBRESOURCE: {
                result = new WebResourceCommentImpl();
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                result = new DevelopmentalStageCommentImpl();
                break;
            }
            case DISEASE: {
                result = new DiseaseCommentImpl();
                break;
            }
            case DOMAIN: {
                result = new DomainCommentImpl();
                break;
            }
            case ENZYME_REGULATION: {
                result = new EnzymeRegulationCommentImpl();
                break;
            }
            case FUNCTION: {
                result = new FunctionCommentImpl();
                break;
            }
            case INDUCTION: {
                result = new InductionCommentImpl();
                break;
            }
            case INTERACTION: {
                result = new InteractionCommentImpl();
                break;
            }
            case MASS_SPECTROMETRY: {
                result = new MassSpectrometryCommentImpl();
                break;
            }
            case MISCELLANEOUS: {
                result = new MiscellaneousCommentImpl();
                break;
            }
            case PATHWAY: {
                result = new PathwayCommentImpl();
                break;
            }
            case PHARMACEUTICAL: {
                result = new PharmaceuticalCommentImpl();
                break;
            }
            case POLYMORPHISM: {
                result = new PolymorphismCommentImpl();
                break;
            }
            case PTM: {
                result = new PtmCommentImpl();
                break;
            }
            case RNA_EDITING: {
                result = new RnaEditingCommentImpl();
                break;
            }
            case SIMILARITY: {
                result = new SimilarityCommentImpl();
                break;
            }
            case SUBCELLULAR_LOCATION: {
                result = new SubcellularLocationCommentImpl();
                break;
            }
            case SUBUNIT: {
                result = new SubunitCommentImpl();
                break;
            }
            case TISSUE_SPECIFICITY: {
                result = new TissueSpecificityCommentImpl();
                break;
            }
            case TOXIC_DOSE: {
                result = new ToxicDoseCommentImpl();
                break;
            }
            case PAGE: {
                result = new PAGEDataCommentImpl();
                break;
            }
            case CAUTION: {
                result = new CautionCommentImpl();
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                result = new DisruptionPhenotypeCommentImpl();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (T)result;
    }

    @Override
    public <T extends Comment> T buildComment(Comment comment) {
        CommentImpl result = null;
        switch (comment.getCommentType()) {
            case ALLERGEN: {
                result = new AllergenCommentImpl((AllergenComment)comment);
                break;
            }
            case ALTERNATIVE_PRODUCTS: {
                result = new AlternativeProductsCommentImpl((AlternativeProductsComment)comment);
                break;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                result = new BioPhysicoChemicalPropertiesCommentImpl((BioPhysicoChemicalPropertiesComment)comment);
                break;
            }
            case BIOTECHNOLOGY: {
                result = new BiotechnologyCommentImpl((BiotechnologyComment)comment);
                break;
            }
            case CATALYTIC_ACTIVITY: {
                result = new CatalyticActivityCommentImpl((CatalyticActivityComment)comment);
                break;
            }
            case SEQUENCE_CAUTION: {
                result = new SequenceCautionCommentImpl((SequenceCautionComment)comment);
                break;
            }
            case COFACTOR: {
                result = new CofactorCommentImpl((CofactorComment)comment);
                break;
            }
            case WEBRESOURCE: {
                result = new WebResourceCommentImpl((WebResourceComment)comment);
                break;
            }
            case DEVELOPMENTAL_STAGE: {
                result = new DevelopmentalStageCommentImpl((DevelopmentalStageComment)comment);
                break;
            }
            case DISEASE: {
                result = new DiseaseCommentImpl((DiseaseComment)comment);
                break;
            }
            case DOMAIN: {
                result = new DomainCommentImpl((DomainComment)comment);
                break;
            }
            case ENZYME_REGULATION: {
                result = new EnzymeRegulationCommentImpl((EnzymeRegulationComment)comment);
                break;
            }
            case FUNCTION: {
                result = new FunctionCommentImpl((FunctionComment)comment);
                break;
            }
            case INDUCTION: {
                result = new InductionCommentImpl((InductionComment)comment);
                break;
            }
            case INTERACTION: {
                result = new InteractionCommentImpl((InteractionComment)comment);
                break;
            }
            case MASS_SPECTROMETRY: {
                result = new MassSpectrometryCommentImpl((MassSpectrometryComment)comment);
                break;
            }
            case MISCELLANEOUS: {
                result = new MiscellaneousCommentImpl((MiscellaneousComment)comment);
                break;
            }
            case PATHWAY: {
                result = new PathwayCommentImpl((PathwayComment)comment);
                break;
            }
            case PHARMACEUTICAL: {
                result = new PharmaceuticalCommentImpl((PharmaceuticalComment)comment);
                break;
            }
            case POLYMORPHISM: {
                result = new PolymorphismCommentImpl((PolymorphismComment)comment);
                break;
            }
            case PTM: {
                result = new PtmCommentImpl((PtmComment)comment);
                break;
            }
            case RNA_EDITING: {
                result = new RnaEditingCommentImpl((RnaEditingComment)comment);
                break;
            }
            case SIMILARITY: {
                result = new SimilarityCommentImpl((SimilarityComment)comment);
                break;
            }
            case SUBCELLULAR_LOCATION: {
                result = new SubcellularLocationCommentImpl((SubcellularLocationComment)comment);
                break;
            }
            case SUBUNIT: {
                result = new SubunitCommentImpl((SubunitComment)comment);
                break;
            }
            case TISSUE_SPECIFICITY: {
                result = new TissueSpecificityCommentImpl((TissueSpecificityComment)comment);
                break;
            }
            case TOXIC_DOSE: {
                result = new ToxicDoseCommentImpl((ToxicDoseComment)comment);
                break;
            }
            case PAGE: {
                result = new PAGEDataCommentImpl((PAGEDataComment)comment);
                break;
            }
            case CAUTION: {
                result = new CautionCommentImpl((CautionComment)comment);
                break;
            }
            case DISRUPTION_PHENOTYPE: {
                result = new DisruptionPhenotypeCommentImpl((DisruptionPhenotypeComment)comment);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return (T)result;
    }

    @Override
    public PAGEDataPl buildPAGEDataPl() {
        return new PAGEDataPlImpl();
    }

    @Override
    public PAGEDataPl buildPAGEDataPl(String value) {
        return new PAGEDataPlImpl(value);
    }

    @Override
    public PAGEDataMolecularWeight buildPAGEDataMolecularWeight() {
        return new PAGEDataMolecularWeightImpl();
    }

    @Override
    public PAGEDataMolecularWeight buildPAGEDataMolecularWeight(String value) {
        return new PAGEDataMolecularWeightImpl(value);
    }

    @Override
    public AlternativeProductsCommentComment buildAlternativeProductsCommentComment() {
        return new AlternativeProductsCommentCommentImpl();
    }

    @Override
    public AlternativeProductsCommentComment buildAlternativeProductsCommentComment(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        AlternativeProductsCommentCommentImpl retVal = new AlternativeProductsCommentCommentImpl();
        retVal.setValue(value);
        return retVal;
    }

    @Override
    public AlternativeProductsCommentComment buildAlternativeProductsCommentComment(AlternativeProductsCommentComment copy) {
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        return new AlternativeProductsCommentCommentImpl(copy);
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent() {
        return new AlternativeProductsEventImpl();
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent(String event) {
        return new AlternativeProductsEventImpl(event);
    }

    @Override
    public AlternativeProductsEvent buildAlternativeProductsEvent(AlternativeProductsEvent copy) {
        return new AlternativeProductsEventImpl(copy);
    }

    @Override
    public AlternativeProductsIsoform buildAlternativeProductsIsoform() {
        return new AlternativeProductsIsoformImpl();
    }

    @Override
    public AlternativeProductsIsoform buildAlternativeProductsIsoform(AlternativeProductsIsoform copy) {
        return new AlternativeProductsIsoformImpl(copy);
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeProductsIsoformComment() {
        return new AlternativeProductsIsoformCommentImpl();
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeProductsIsoformComment(String value) {
        return new AlternativeProductsIsoformCommentImpl(value);
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeProductsIsoformComment(AlternativeProductsIsoformComment copy) {
        return new AlternativeProductsIsoformCommentImpl(copy);
    }

    @Override
    public InteractorAccession buildIntActAccession(String acc) {
        InteractorAccessionImpl result = new InteractorAccessionImpl();
        result.setValue(acc);
        return result;
    }

    @Override
    public InteractorAccession buildIntActAccession() {
        return this.buildIntActAccession("");
    }

    @Override
    public InteractorAccession buildIntActAccession(InteractorAccession copy) {
        return new InteractorAccessionImpl(copy);
    }

    @Override
    public InteractionGeneName buildInteractionGeneName(String geneName) {
        InteractionGeneNameImpl result = new InteractionGeneNameImpl();
        result.setValue(geneName);
        return result;
    }

    @Override
    public InteractionGeneName buildInteractionGeneName() {
        return this.buildInteractionGeneName("");
    }

    @Override
    public InteractionGeneName buildInteractionGeneName(InteractionGeneName copy) {
        return new InteractionGeneNameImpl(copy);
    }

    @Override
    public Interaction buildInteraction() {
        return new InteractionImpl();
    }

    @Override
    public Interaction buildInteraction(Interaction copy) {
        return new InteractionImpl(copy);
    }

    @Override
    public InteractorUniProtAccession buildInteractorUniProtAccession(String acc) {
        InteractorUniProtAccessionImpl result = new InteractorUniProtAccessionImpl();
        result.setValue(acc);
        return result;
    }

    @Override
    public InteractorUniProtAccession buildInteractorUniProtAccession() {
        return this.buildInteractorUniProtAccession("");
    }

    @Override
    public InteractorUniProtAccession buildInteractorUniProtAccession(InteractorUniProtAccession copy) {
        return new InteractorUniProtAccessionImpl(copy);
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote(String note) {
        MassSpectrometryCommentNoteImpl result = new MassSpectrometryCommentNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote() {
        return this.buildMassSpectrometryCommentNote("");
    }

    @Override
    public MassSpectrometryCommentNote buildMassSpectrometryCommentNote(MassSpectrometryCommentNote copy) {
        return new MassSpectrometryCommentNoteImpl(copy);
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote(String note) {
        MassSpectrometryRangeNoteImpl result = new MassSpectrometryRangeNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote() {
        return this.buildMassSpectrometryRangeNote("");
    }

    @Override
    public MassSpectrometryRangeNote buildMassSpectrometryRangeNote(MassSpectrometryRangeNote copy) {
        return new MassSpectrometryRangeNoteImpl(copy);
    }

    @Override
    public MassSpectrometryRange buildMassSpectrometryRange() {
        return new MassSpectrometryRangeImpl();
    }

    @Override
    public MassSpectrometryRange buildMassSpectrometryRange(MassSpectrometryRange copy) {
        return new MassSpectrometryRangeImpl(copy);
    }

    @Override
    public Absorption buildAbsorption() {
        return new AbsorptionImpl();
    }

    @Override
    public Absorption buildAbsorption(boolean isApproximate, int max, String note) {
        AbsorptionImpl result = new AbsorptionImpl();
        result.setApproximation(isApproximate);
        result.setMax(max);
        result.setNote(this.buildAbsorptionNote(note));
        return result;
    }

    @Override
    public Absorption buildAbsorption(Absorption copy) {
        return new AbsorptionImpl(copy);
    }

    @Override
    public AbsorptionNote buildAbsorptionNote(String value) {
        AbsorptionNoteImpl result = new AbsorptionNoteImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public AbsorptionNote buildAbsorptionNote() {
        return this.buildAbsorptionNote("");
    }

    @Override
    public AbsorptionNote buildAbsorptionNote(AbsorptionNote copy) {
        return new AbsorptionNoteImpl(copy);
    }

    @Override
    public PHDependence buildPHDependence(String value) {
        PHDependenceImpl result = new PHDependenceImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public PHDependence buildPHDependence() {
        return this.buildPHDependence("");
    }

    @Override
    public PHDependence buildPHDependence(PHDependence copy) {
        return new PHDependenceImpl(copy);
    }

    @Override
    public RedoxPotential buildRedoxPotential(String value) {
        RedoxPotentialImpl result = new RedoxPotentialImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public RedoxPotential buildRedoxPotential() {
        return this.buildRedoxPotential("");
    }

    @Override
    public RedoxPotential buildRedoxPotential(RedoxPotential copy) {
        return new RedoxPotentialImpl(copy);
    }

    @Override
    public TemperatureDependence buildTemperatureDependence(String value) {
        TemperatureDependenceImpl result = new TemperatureDependenceImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public TemperatureDependence buildTemperatureDependence() {
        return this.buildTemperatureDependence("");
    }

    @Override
    public TemperatureDependence buildTemperatureDependence(TemperatureDependence copy) {
        return new TemperatureDependenceImpl(copy);
    }

    @Override
    public Substrate buildSubstrate(String value) {
        SubstrateImpl result = new SubstrateImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Substrate buildSubstrate() {
        return this.buildSubstrate("");
    }

    @Override
    public Substrate buildSubstrate(Substrate copy) {
        return new SubstrateImpl(copy);
    }

    @Override
    public Enzyme buildEnzyme(String value) {
        EnzymeImpl result = new EnzymeImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public Enzyme buildEnzyme() {
        return this.buildEnzyme("");
    }

    @Override
    public Enzyme buildEnzyme(Enzyme copy) {
        return new EnzymeImpl(copy);
    }

    @Override
    public MaximumVelocity buildMaximumVelocity() {
        return new MaximumVelocityImpl();
    }

    @Override
    public MaximumVelocity buildmMaximumVelocity(float velocity, MaximumVelocityUnit unit, String enzyme) {
        MaximumVelocityImpl result = new MaximumVelocityImpl();
        result.setVelocity(velocity);
        result.setUnit(unit);
        result.setEnzyme(this.buildEnzyme(enzyme));
        return result;
    }

    @Override
    public MaximumVelocity buildMaximumVelocity(MaximumVelocity copy) {
        return new MaximumVelocityImpl(copy);
    }

    @Override
    public KineticParameterNote buildKineticParameterNote(String value) {
        KineticParameterNoteImpl result = new KineticParameterNoteImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public KineticParameterNote buildKineticParameterNote() {
        return this.buildKineticParameterNote("");
    }

    @Override
    public KineticParameterNote buildKineticParameterNote(KineticParameterNote copy) {
        return new KineticParameterNoteImpl(copy);
    }

    @Override
    public KineticParameters buildKineticParameters() {
        return new KineticParametersImpl();
    }

    @Override
    public KineticParameters buildKineticParameters(String note) {
        KineticParametersImpl result = new KineticParametersImpl();
        result.setNote(this.buildKineticParameterNote(note));
        return result;
    }

    @Override
    public KineticParameters buildKineticParameters(KineticParameters copy) {
        return new KineticParametersImpl(copy);
    }

    @Override
    public MichaelisConstant buildMichaelisConstant() {
        return new MichaelisConstantImpl();
    }

    @Override
    public MichaelisConstant buildMichaelisConstant(float constant, MichaelisConstantUnit unit, String substrate) {
        MichaelisConstantImpl result = new MichaelisConstantImpl();
        result.setConstant(constant);
        result.setUnit(unit);
        result.setSubstrate(this.buildSubstrate(substrate));
        return result;
    }

    @Override
    public MichaelisConstant buildMichaelisConstant(MichaelisConstant copy) {
        return new MichaelisConstantImpl(copy);
    }

    @Override
    public DatabaseName buildDatabaseName() {
        return new DatabaseNameImpl();
    }

    @Override
    public DatabaseName buildDatabaseName(String name) {
        DatabaseNameImpl result = new DatabaseNameImpl();
        result.setValue(name);
        return result;
    }

    @Override
    public DatabaseName buildDatabaseName(DatabaseName copy) {
        return new DatabaseNameImpl(copy);
    }

    @Override
    public DatabaseNote buildDatabaseNote() {
        return new DatabaseNoteImpl();
    }

    @Override
    public DatabaseNote buildDatabaseNote(String note) {
        DatabaseNoteImpl result = new DatabaseNoteImpl();
        result.setValue(note);
        return result;
    }

    @Override
    public DatabaseNote buildDatabaseNote(DatabaseNote copy) {
        return new DatabaseNoteImpl(copy);
    }

    @Override
    public DatabaseURL buildDatabaseURL() {
        return new DatabaseURLImpl();
    }

    @Override
    public DatabaseURL buildDatabaseURL(String www) {
        DatabaseURLImpl result = new DatabaseURLImpl();
        result.setValue(www);
        return result;
    }

    @Override
    public DatabaseURL buildDatabaseURL(DatabaseURL copy) {
        return new DatabaseURLImpl(copy);
    }

    @Override
    public DatabaseFTP buildDatabaseFTP() {
        return new DatabaseFTPImpl();
    }

    @Override
    public DatabaseFTP buildDatabaseFTP(String ftp) {
        DatabaseFTPImpl result = new DatabaseFTPImpl();
        result.setValue(ftp);
        return result;
    }

    @Override
    public DatabaseFTP buildDatabaseFTP(DatabaseFTP copy) {
        return new DatabaseFTPImpl(copy);
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeSplicingComment() {
        return new AlternativeProductsIsoformCommentImpl();
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeSplicingComment(String value) {
        AlternativeProductsIsoformCommentImpl result = new AlternativeProductsIsoformCommentImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public AlternativeProductsIsoformComment buildAlternativeSplicingComment(AlternativeProductsIsoformComment copy) {
        return new AlternativeProductsIsoformCommentImpl(copy);
    }

    @Override
    public IsoformId buildIsoformId() {
        return new IsoformIdImpl();
    }

    @Override
    public IsoformId buildIsoformId(String value) {
        IsoformIdImpl result = new IsoformIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformId buildIsoformId(IsoformId copy) {
        return new IsoformIdImpl(copy);
    }

    @Override
    public IsoformName buildIsoformName() {
        return new IsoformNameImpl();
    }

    @Override
    public IsoformName buildIsoformName(String value) {
        IsoformNameImpl result = new IsoformNameImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformName buildIsoformName(IsoformName copy) {
        return new IsoformNameImpl(copy);
    }

    @Override
    public IsoformNote buildIsoformNote() {
        return new IsoformNoteImpl();
    }

    @Override
    public IsoformNote buildIsoformNote(String value) {
        IsoformNoteImpl result = new IsoformNoteImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformNote buildIsoformNote(IsoformNote copy) {
        return new IsoformNoteImpl(copy);
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId() {
        return new IsoformSequenceIdImpl();
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId(String value) {
        IsoformSequenceIdImpl result = new IsoformSequenceIdImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformSequenceId buildIsoformSequenceId(IsoformSequenceId copy) {
        return new IsoformSequenceIdImpl(copy);
    }

    @Override
    public IsoformSynonym buildIsoformSynonym() {
        return new IsoformSynonymImpl();
    }

    @Override
    public IsoformSynonym buildIsoformSynonym(String value) {
        IsoformSynonymImpl result = new IsoformSynonymImpl();
        result.setValue(value);
        return result;
    }

    @Override
    public IsoformSynonym buildIsoformSynonym(IsoformSynonym copy) {
        return new IsoformSynonymImpl(copy);
    }

    @Override
    public SequenceCautionCommentNote buildSequenceCautionCommentNote() {
        return new SequenceCautionCommentNoteImpl();
    }

    @Override
    public SequenceCautionCommentNote buildSequenceCautionCommentNote(String note) {
        return new SequenceCautionCommentNoteImpl(note);
    }

    @Override
    public SequenceCautionPosition buildSequenceCautionPosition() {
        return new SequenceCautionPositionImpl();
    }

    @Override
    public SequenceCautionPosition buildSequenceCautionPosition(String position) {
        return new SequenceCautionPositionImpl(position);
    }

    @Override
    public SubcellularLocationValue buildSubcellularLocationNote() {
        return new SubcellularLocationValueImpl();
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource() {
        return new MassSpectrometryCommentSourceImpl();
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId() {
        return new MassSpectrometryIsoformIdImpl();
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource(String value) {
        return new MassSpectrometryCommentSourceImpl(value);
    }

    @Override
    public RnaEditingNote buildRnaEditingNote() {
        return new RnaEditingNoteImpl();
    }

    @Override
    public RnaEditingComment buildRnaEditingComment() {
        return new RnaEditingCommentImpl();
    }

    @Override
    public MassSpectrometryCommentSource buildMassSpectrometryCommentSource(MassSpectrometryCommentSource value) {
        return new MassSpectrometryCommentSourceImpl(value);
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId(String value) {
        return new MassSpectrometryIsoformIdImpl(value);
    }

    @Override
    public MassSpectrometryIsoformId buildMassSpectrometryIsoformId(MassSpectrometryIsoformId value) {
        return new MassSpectrometryIsoformIdImpl(value);
    }

    @Override
    public SubcellularMolecule buildSubcellularMolecule() {
        return new SubcellularMoleculeImpl();
    }

    @Override
    public SubcellularLocation buildSubcellularLocation() {
        return new SubcellularLocationImpl();
    }

    @Override
    public SubcellularLocationValue buildSubcellularLocationValue() {
        return new SubcellularLocationValueImpl();
    }

    @Override
    public Position buildRnaEditingPosition() {
        return new PositionImpl();
    }
}

