/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import java.util.HashSet;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrEntry;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrGroupName;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrId;
import uk.ac.ebi.kraken.interfaces.factories.ClustrFactory;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.model.clustr.ClustrEntryImpl;
import uk.ac.ebi.kraken.model.clustr.ClustrGroupNameImpl;
import uk.ac.ebi.kraken.model.clustr.ClustrIdImpl;
import uk.ac.ebi.kraken.util.NoNullElementsSet;

public class DefaultClustrFactory
implements ClustrFactory {
    private static DefaultClustrFactory singletonInstance;

    protected DefaultClustrFactory() {
    }

    public static ClustrFactory getInstance() {
        if (singletonInstance == null) {
            // empty if block
        }
        singletonInstance = new DefaultClustrFactory();
        return singletonInstance;
    }

    @Override
    public ClustrEntry buildClustrEntry() {
        ClustrEntryImpl clustrEntry = new ClustrEntryImpl();
        clustrEntry.setClustrId(this.buildClustrId(""));
        clustrEntry.setGroupName(this.buildClustrGroupName(""));
        clustrEntry.setUniParcEntries(new NoNullElementsSet<UniParcEntry>(new HashSet()));
        return clustrEntry;
    }

    @Override
    public ClustrEntry buildClustrEntry(String newClusterId) {
        ClustrEntryImpl clustrEntry = new ClustrEntryImpl();
        clustrEntry.setClustrId(this.buildClustrId(newClusterId));
        clustrEntry.setGroupName(this.buildClustrGroupName(""));
        clustrEntry.setUniParcEntries(new NoNullElementsSet<UniParcEntry>(new HashSet()));
        return clustrEntry;
    }

    @Override
    public ClustrEntry buildClustrEntry(String newClusterId, String clustrGroupName) {
        ClustrEntryImpl clustrEntry = new ClustrEntryImpl();
        clustrEntry.setClustrId(this.buildClustrId(newClusterId));
        clustrEntry.setGroupName(this.buildClustrGroupName(clustrGroupName));
        clustrEntry.setUniParcEntries(new NoNullElementsSet<UniParcEntry>(new HashSet()));
        return clustrEntry;
    }

    @Override
    public ClustrId buildClustrId(String newClusterId) {
        ClustrIdImpl clustrId = new ClustrIdImpl();
        clustrId.setValue(newClusterId);
        return clustrId;
    }

    @Override
    public ClustrId buildClustrId() {
        ClustrIdImpl clustrId = new ClustrIdImpl();
        return clustrId;
    }

    @Override
    public ClustrGroupName buildClustrGroupName(String s) {
        ClustrGroupNameImpl clustrGroupName = new ClustrGroupNameImpl();
        clustrGroupName.setValue(s);
        return clustrGroupName;
    }
}

